#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

vpath %.idl ../idl

EXPORT_TREE	= ..

INTERFACES	= Naming \
		  CosLifeCycle \
		  CosEventComm \
		  CosEventChannelAdmin \
		  EventChannelAdmin

CORBAOBJS	= $(INTERFACES:%=../idl/%SK.o)

CXXSRCS		= eventc.cc \
		  pushcons.cc \
		  pushsupp.cc \
		  pullsupp.cc \
		  pullcons.cc

EVENTCOBJS	= eventc.o 
PUSHSUPPOBJS	= pushsupp.o
PUSHCONSOBJS	= pushcons.o
PULLCONSOBJS	= pullcons.o
PULLSUPPOBJS	= pullsupp.o

COMMONOBJS	= ../util/args.o \
		  ../util/naming.o


#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

COMMONOBJS	+= ../util/getopt.o
DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################


ifdef AIX
DIR_CPPFLAGS    += -I../include $(CORBA_CPPFLAGS)
else
DIR_CPPFLAGS    += -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES
endif

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

#STL_INCLUDES	= /vob/tips/include/STL
#DIR_CPPFLAGS	+= -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

eventc    = $(patsubst %,$(BinPattern),eventc)
pushsupp  = $(patsubst %,$(BinPattern),pushsupp)
pushcons  = $(patsubst %,$(BinPattern),pushcons)
pullcons  = $(patsubst %,$(BinPattern),pullcons)
pullsupp  = $(patsubst %,$(BinPattern),pullsupp)

EXECS     = $(eventc) $(pushsupp) $(pushcons) $(pullcons) $(pullsupp)

all:: $(EXECS)

export:: $(EXECS)
	@$(ExportExecutable)

clean::
	$(RM) $(EXECS) *.d

$(eventc): $(EVENTCOBJS) $(COMMONOBJS) $(CORBAOBJS)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(pushsupp): $(PUSHSUPPOBJS) $(COMMONOBJS) $(CORBAOBJS)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(pushcons): $(PUSHCONSOBJS) $(COMMONOBJS) $(CORBAOBJS)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(pullcons): $(PULLCONSOBJS) $(COMMONOBJS) $(CORBAOBJS)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(pullsupp): $(PULLSUPPOBJS) $(COMMONOBJS) $(CORBAOBJS)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))
