// bufferedStream_inl.h -- some inlines for the bufferedStream.h file
// This file should be included by bufferedStream.h. Do not use it directly.

#ifndef __BUFFEREDSTREAM_INL_H__
#define __BUFFEREDSTREAM_INL_H__

//////////////////////////////////////////////////////////////////////
////////////////////////// NetBufferedStream /////////////////////////
//////////////////////////////////////////////////////////////////////

  inline void operator>>= (_CORBA_Char a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_Char,omni::ALIGN_1,a);
  }

  inline void operator<<= (_CORBA_Char& a, NetBufferedStream& s) {
    UMARSHAL(s,_CORBA_Char,omni::ALIGN_1,a);
  }

#ifdef HAS_Cplusplus_Bool

  inline void operator>>= (_CORBA_Boolean b, NetBufferedStream& s) {
    _CORBA_Char c = b ? 1 : 0;
    MARSHAL(s,_CORBA_Char,omni::ALIGN_1,c);
  }

  inline void operator<<= (_CORBA_Boolean& b, NetBufferedStream& s) {
    _CORBA_Char c;
    UMARSHAL(s,_CORBA_Char,omni::ALIGN_1,c);
    b = c ? true : false;
  }

#endif

  inline void operator>>= (_CORBA_Short a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_Short,omni::ALIGN_2,a);
  }

  inline void operator<<= (_CORBA_Short& a, NetBufferedStream& s) {
    if (s.RdMessageByteOrder() != omni::myByteOrder) {
      _CORBA_Short t;
      UMARSHAL(s,_CORBA_Short,omni::ALIGN_2,t);
      a = Swap16(t);
    }
    else {
      UMARSHAL(s,_CORBA_Short,omni::ALIGN_2,a);
    }
    return;
  }

  inline void operator>>= (_CORBA_UShort a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_UShort,omni::ALIGN_2,a);
  }

  inline void operator<<= (_CORBA_UShort& a, NetBufferedStream& s) {
    if (s.RdMessageByteOrder() != omni::myByteOrder) {
      _CORBA_UShort t;
      UMARSHAL(s,_CORBA_UShort,omni::ALIGN_2,t);
      a = Swap16(t);
    }
    else {
      UMARSHAL(s,_CORBA_UShort,omni::ALIGN_2,a);
    }
    return;
  }


  inline void operator>>= (_CORBA_Long a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_Long,omni::ALIGN_4,a);
  }

  inline void operator<<= (_CORBA_Long& a, NetBufferedStream& s) {
    if (s.RdMessageByteOrder() != omni::myByteOrder) {
      _CORBA_Long t;
      UMARSHAL(s,_CORBA_Long,omni::ALIGN_4,t);
      a = Swap32(t);
    }
    else {
      UMARSHAL(s,_CORBA_Long,omni::ALIGN_4,a);
    }
    return;
  }

  inline void operator>>= (_CORBA_ULong a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_ULong,omni::ALIGN_4,a);
  }

  inline void operator<<= (_CORBA_ULong& a, NetBufferedStream& s) {
    if (s.RdMessageByteOrder() != omni::myByteOrder) {
      _CORBA_ULong t;
      UMARSHAL(s,_CORBA_ULong,omni::ALIGN_4,t);
      a = Swap32(t);
    }
    else {
      UMARSHAL(s,_CORBA_ULong,omni::ALIGN_4,a);
    }
    return;
  }

#if !defined(NO_FLOAT)

  inline void operator>>= (_CORBA_Float a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_Float,omni::ALIGN_4,a);
  }

  inline void operator<<= (_CORBA_Float& a, NetBufferedStream& s) {
    if (s.RdMessageByteOrder() != omni::myByteOrder) {
      _CORBA_Float t;
      UMARSHAL(s,_CORBA_Float,omni::ALIGN_4,t);
      _CORBA_ULong tl1 = *((_CORBA_ULong *)&t);
      _CORBA_ULong tl2 = Swap32(tl1);
      a = *((_CORBA_Float *) &tl2);
    }
    else {
      UMARSHAL(s,_CORBA_Float,omni::ALIGN_4,a);
    }
    return;
  }

  inline void operator>>= (_CORBA_Double a, NetBufferedStream& s) {
    MARSHAL(s,_CORBA_Double,omni::ALIGN_8,a);
  }

  inline void operator<<= (_CORBA_Double& a, NetBufferedStream& s) {
    if (s.RdMessageByteOrder() != omni::myByteOrder) {
      _CORBA_Double t;
      UMARSHAL(s,_CORBA_Double,omni::ALIGN_8,t);
      _CORBA_ULong tl1 = ((_CORBA_ULong *)&t)[1];
      _CORBA_ULong tl2 = Swap32(tl1);
      ((_CORBA_ULong *)&a)[0] = tl2;
      tl1 = ((_CORBA_ULong *)&t)[0];
      tl2 = Swap32(tl1);
      ((_CORBA_ULong *)&a)[1] = tl2;
    }
    else {
      UMARSHAL(s,_CORBA_Double,omni::ALIGN_8,a);
    }
    return;
  }

#endif

//////////////////////////////////////////////////////////////////////
////////////////////////// MemBufferedStream /////////////////////////
//////////////////////////////////////////////////////////////////////

  inline void operator>>= (_CORBA_Char a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_Char,omni::ALIGN_1,a);
  }

  inline void operator<<= (_CORBA_Char& a, MemBufferedStream& s) {
    UMARSHAL(s,_CORBA_Char,omni::ALIGN_1,a);
  }

#ifdef HAS_Cplusplus_Bool

  inline void operator>>= (_CORBA_Boolean b, MemBufferedStream& s) {
    _CORBA_Char c = b ? 1 : 0;
    MARSHAL(s,_CORBA_Char,omni::ALIGN_1,c);
  }

  inline void operator<<= (_CORBA_Boolean& b, MemBufferedStream& s) {
    _CORBA_Char c;
    UMARSHAL(s,_CORBA_Char,omni::ALIGN_1,c);
    b = c ? true : false;
  }

#endif

  inline void operator>>= (_CORBA_Short a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_Short,omni::ALIGN_2,a);
  }

  inline void operator<<= (_CORBA_Short& a, MemBufferedStream& s) {
    if (s.byteOrder() != omni::myByteOrder) {
      _CORBA_Short t;
      UMARSHAL(s,_CORBA_Short,omni::ALIGN_2,t);
      a = Swap16(t);
    }
    else {
      UMARSHAL(s,_CORBA_Short,omni::ALIGN_2,a);
    }
    return;
  }

  inline void operator>>= (_CORBA_UShort a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_UShort,omni::ALIGN_2,a);
  }

  inline void operator<<= (_CORBA_UShort& a, MemBufferedStream& s) {
    if (s.byteOrder() != omni::myByteOrder) {
      _CORBA_UShort t;
      UMARSHAL(s,_CORBA_UShort,omni::ALIGN_2,t);
      a = Swap16(t);
    }
    else {
      UMARSHAL(s,_CORBA_UShort,omni::ALIGN_2,a);
    }
    return;
  }


  inline void operator>>= (_CORBA_Long a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_Long,omni::ALIGN_4,a);
  }

  inline void operator<<= (_CORBA_Long& a, MemBufferedStream& s) {
    if (s.byteOrder() != omni::myByteOrder) {
      _CORBA_Long t;
      UMARSHAL(s,_CORBA_Long,omni::ALIGN_4,t);
      a = Swap32(t);
    }
    else {
      UMARSHAL(s,_CORBA_Long,omni::ALIGN_4,a);
    }
    return;
  }

  inline void operator>>= (_CORBA_ULong a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_ULong,omni::ALIGN_4,a);
  }

  inline void operator<<= (_CORBA_ULong& a, MemBufferedStream& s) {
    if (s.byteOrder() != omni::myByteOrder) {
      _CORBA_ULong t;
      UMARSHAL(s,_CORBA_ULong,omni::ALIGN_4,t);
      a = Swap32(t);
    }
    else {
      UMARSHAL(s,_CORBA_ULong,omni::ALIGN_4,a);
    }
    return;
  }

#if !defined(NO_FLOAT)

  inline void operator>>= (_CORBA_Float a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_Float,omni::ALIGN_4,a);
  }

  inline void operator<<= (_CORBA_Float& a, MemBufferedStream& s) {
    if (s.byteOrder() != omni::myByteOrder) {
      _CORBA_Float t;
      UMARSHAL(s,_CORBA_Float,omni::ALIGN_4,t);
      _CORBA_ULong tl1 = *((_CORBA_ULong *)&t);
      _CORBA_ULong tl2 = Swap32(tl1);
      a = *((_CORBA_Float *) &tl2);
    }
    else {
      UMARSHAL(s,_CORBA_Float,omni::ALIGN_4,a);
    }
    return;
  }

  inline void operator>>= (_CORBA_Double a, MemBufferedStream& s) {
    MARSHAL(s,_CORBA_Double,omni::ALIGN_8,a);
  }

  inline void operator<<= (_CORBA_Double& a, MemBufferedStream& s) {
    if (s.byteOrder() != omni::myByteOrder) {
      _CORBA_Double t;
      UMARSHAL(s,_CORBA_Double,omni::ALIGN_8,t);
      _CORBA_ULong tl1 = ((_CORBA_ULong *)&t)[1];
      _CORBA_ULong tl2 = Swap32(tl1);
      ((_CORBA_ULong *)&a)[0] = tl2;
      tl1 = ((_CORBA_ULong *)&t)[0];
      tl2 = Swap32(tl1);
      ((_CORBA_ULong *)&a)[1] = tl2;
    }
    else {
      UMARSHAL(s,_CORBA_Double,omni::ALIGN_8,a);
    }
    return;
  }

#endif

#endif // __BUFFEREDSTREAM_INL_H__
