CORBA_INTERFACES = echolag

.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) lcserver .obj .cc
	@ $(CreateMms) lcclient .obj .cc
	@ $(CreateMms) lcremove .obj .cc

.else
CXXSRCS = lcserver.cc lcclient.cc lcremove.cc

DIR_IDLFLAGS = $(OMNIORB2_IDL_LC_FLAGS)

OBJ_LIBS = $(CORBA_LIB) $(OMNIORB2_LC_LIB)
OBJ_LIB_DEPEND = $(CORBA_LIB_DEPEND) $(OMNIORB2_LC_LIB)

lcserver = lcserver$(DebugSuffix).exe
lcclient = lcclient$(DebugSuffix).exe
lcremove = lcremove$(DebugSuffix).exe

all :: $(lcserver) $(lcclient) $(lcremove)

clean ::
	$(RM) $(lcserver) $(lcclient) $(lcremove)

omniIdls:echolag.idl : echolag.idl
	copy echolag.idl omniIdls:

export :: all
export :: $(lcserver)
	@ $(ExportExecutable)
export :: $(lcclient)
	@ $(ExportExecutable)
export :: $(lcremove)
	@ $(ExportExecutable)

$(lcserver) : lcserver.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(lcclient) : lcclient.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(lcremove) : lcremove.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

.include lcserver.mms
.include lcclient.mms
.include lcremove.mms

.endif
