#ifndef __ir_hh__
#define __ir_hh__

#ifndef USE_omniORB_logStream
#define USE_omniORB_logStream
#endif

#ifndef __CORBA_H_EXTERNAL_GUARD__
#define __CORBA_H_EXTERNAL_GUARD__
#include <omniORB2/CORBA.h>
#endif

#ifndef __corbaidl_hh_EXTERNAL_GUARD__
#define __corbaidl_hh_EXTERNAL_GUARD__
#include <corbaidl.hh>
#endif

#ifdef _LC_attr
# error "A local CPP macro _LC_attr has already been defined."
#else
# ifdef  USE_stub_in_nt_dll
#  define _LC_attr _OMNIORB_NTDLL_IMPORT
# else
#  define _LC_attr
# endif
#endif


_CORBA_MODULE CORBA

_CORBA_MODULE_BEG

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ScopedName;
  typedef char* ScopedName;
  typedef CORBA::String_var ScopedName_var;
  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_RepositoryId;
  typedef char* RepositoryId;
  typedef CORBA::String_var RepositoryId_var;
  enum DefinitionKind { dk_none, dk_all, dk_Attribute, dk_Constant, dk_Exception, dk_Interface, dk_Module, dk_Operation, dk_Typedef, dk_Alias, dk_Struct, dk_Union, dk_Enum, dk_Primitive, dk_String, dk_Sequence, dk_Array, dk_Repository, dk_Wstring, dk_Fixed };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_DefinitionKind;

#ifndef __CORBA_mIRObject__
#define __CORBA_mIRObject__
  class   IRObject;
  typedef IRObject* IRObject_ptr;
  typedef IRObject_ptr IRObjectRef;

  class IRObject_Helper {
    public:
    static IRObject_ptr _nil();
    static CORBA::Boolean is_nil(IRObject_ptr p);
    static void release(IRObject_ptr p);
    static void duplicate(IRObject_ptr p);
    static size_t NP_alignedSize(IRObject_ptr obj,size_t initialoffset);
    static void marshalObjRef(IRObject_ptr obj,NetBufferedStream &s);
    static IRObject_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(IRObject_ptr obj,MemBufferedStream &s);
    static IRObject_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<IRObject,IRObject_Helper> IRObject_var;

#endif
#define CORBA_IRObject_IntfRepoID "IDL:omg.org/CORBA/IRObject:1.0"

  class IRObject : public virtual omniObject, public virtual CORBA::Object {
  public:

    virtual DefinitionKind def_kind() = 0;
    virtual void destroy() = 0;
    static IRObject_ptr _duplicate(IRObject_ptr);
    static IRObject_ptr _narrow(CORBA::Object_ptr);
    static IRObject_ptr _nil();

    static inline size_t NP_alignedSize(IRObject_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_IRObject_IntfRepoID,31,initialoffset);
    }

    static inline void marshalObjRef(IRObject_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_IRObject_IntfRepoID,31,s);
    }

    static inline IRObject_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_IRObject_IntfRepoID,s);
      IRObject_ptr _result = CORBA::IRObject::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(IRObject_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_IRObject_IntfRepoID,31,s);
    }

    static inline IRObject_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_IRObject_IntfRepoID,s);
      IRObject_ptr _result = CORBA::IRObject::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    IRObject() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_IRObject_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~IRObject() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    IRObject(const IRObject&);
    IRObject &operator=(const IRObject&);
  };

  class _sk_IRObject :  public virtual IRObject {
  public:

    _sk_IRObject() {}
    _sk_IRObject(const omniORB::objectKey& k);
    virtual ~_sk_IRObject() {}
    IRObject_ptr _this() { return IRObject::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual DefinitionKind def_kind() = 0;
    virtual void destroy() = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return IRObject::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_IRObject (const _sk_IRObject&);
    _sk_IRObject &operator=(const _sk_IRObject&);
  };

  class _proxy_IRObject :  public virtual IRObject {
  public:

    _proxy_IRObject (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_IRObject_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_IRObject() {}
    virtual DefinitionKind def_kind();
    virtual void destroy();

  protected:

    _proxy_IRObject () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return IRObject::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_IRObject (const _proxy_IRObject&);
    _proxy_IRObject &operator=(const _proxy_IRObject&);
  };

  class _nil_IRObject :   public virtual IRObject {
  public:
    _nil_IRObject() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_IRObject() {}
    DefinitionKind def_kind() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      DefinitionKind _0RL_result = dk_none;
      return _0RL_result;
#endif
    }

    void destroy(){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return IRObject::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class IRObject_proxyObjectFactory : public proxyObjectFactory {
  public:
    IRObject_proxyObjectFactory () {}
    virtual ~IRObject_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static IRObject_ptr _nil() {
      if (!__nil_IRObject) {
        __nil_IRObject = new _nil_IRObject;
      }
      return __nil_IRObject;
    }
  private:
    static IRObject_ptr __nil_IRObject;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_IRObject;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_VersionSpec;
  typedef char* VersionSpec;
  typedef CORBA::String_var VersionSpec_var;
#ifndef __CORBA_mContained__
#define __CORBA_mContained__
  class   Contained;
  typedef Contained* Contained_ptr;
  typedef Contained_ptr ContainedRef;
  class _proxy_Contained;
  class _sk_Contained;
  class _nil_Contained;

  class Contained_Helper {
    public:
    static Contained_ptr _nil();
    static CORBA::Boolean is_nil(Contained_ptr p);
    static void release(Contained_ptr p);
    static void duplicate(Contained_ptr p);
    static size_t NP_alignedSize(Contained_ptr obj,size_t initialoffset);
    static void marshalObjRef(Contained_ptr obj,NetBufferedStream &s);
    static Contained_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(Contained_ptr obj,MemBufferedStream &s);
    static Contained_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<Contained,Contained_Helper> Contained_var;

#endif
#ifndef __CORBA_mRepository__
#define __CORBA_mRepository__
  class   Repository;
  typedef Repository* Repository_ptr;
  typedef Repository_ptr RepositoryRef;
  class _proxy_Repository;
  class _sk_Repository;
  class _nil_Repository;

  class Repository_Helper {
    public:
    static Repository_ptr _nil();
    static CORBA::Boolean is_nil(Repository_ptr p);
    static void release(Repository_ptr p);
    static void duplicate(Repository_ptr p);
    static size_t NP_alignedSize(Repository_ptr obj,size_t initialoffset);
    static void marshalObjRef(Repository_ptr obj,NetBufferedStream &s);
    static Repository_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(Repository_ptr obj,MemBufferedStream &s);
    static Repository_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<Repository,Repository_Helper> Repository_var;

#endif
#ifndef __CORBA_mContainer__
#define __CORBA_mContainer__
  class   Container;
  typedef Container* Container_ptr;
  typedef Container_ptr ContainerRef;
  class _proxy_Container;
  class _sk_Container;
  class _nil_Container;

  class Container_Helper {
    public:
    static Container_ptr _nil();
    static CORBA::Boolean is_nil(Container_ptr p);
    static void release(Container_ptr p);
    static void duplicate(Container_ptr p);
    static size_t NP_alignedSize(Container_ptr obj,size_t initialoffset);
    static void marshalObjRef(Container_ptr obj,NetBufferedStream &s);
    static Container_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(Container_ptr obj,MemBufferedStream &s);
    static Container_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<Container,Container_Helper> Container_var;

#endif
#ifndef __CORBA_mContained__
#define __CORBA_mContained__
  class   Contained;
  typedef Contained* Contained_ptr;
  typedef Contained_ptr ContainedRef;

  class Contained_Helper {
    public:
    static Contained_ptr _nil();
    static CORBA::Boolean is_nil(Contained_ptr p);
    static void release(Contained_ptr p);
    static void duplicate(Contained_ptr p);
    static size_t NP_alignedSize(Contained_ptr obj,size_t initialoffset);
    static void marshalObjRef(Contained_ptr obj,NetBufferedStream &s);
    static Contained_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(Contained_ptr obj,MemBufferedStream &s);
    static Contained_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<Contained,Contained_Helper> Contained_var;

#endif
#define CORBA_Contained_IntfRepoID "IDL:omg.org/CORBA/Contained:1.0"

  class Contained :  public virtual IRObject {
  public:

    struct Description {
      DefinitionKind kind;
      CORBA::Any value;
      
      size_t NP_alignedSize(size_t initialoffset) const;
      void operator>>= (NetBufferedStream &) const;
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &) const;
      void operator<<= (MemBufferedStream &);
    };

    typedef _CORBA_ConstrType_Variable_Var<Description> Description_var;

    static _LC_attr const CORBA::TypeCode_ptr _tc_Description;

    virtual char* id() = 0;
    virtual void id(const char*) = 0;
    virtual char* name() = 0;
    virtual void name(const char*) = 0;
    virtual char* version() = 0;
    virtual void version(const char*) = 0;
    virtual Container_ptr defined_in() = 0;
    virtual char* absolute_name() = 0;
    virtual Repository_ptr containing_repository() = 0;
    virtual Description * describe() = 0;
    virtual void move(Container_ptr  new_container, const char*  new_name, const char*  new_version) = 0;
    static Contained_ptr _duplicate(Contained_ptr);
    static Contained_ptr _narrow(CORBA::Object_ptr);
    static Contained_ptr _nil();

    static inline size_t NP_alignedSize(Contained_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_Contained_IntfRepoID,32,initialoffset);
    }

    static inline void marshalObjRef(Contained_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_Contained_IntfRepoID,32,s);
    }

    static inline Contained_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_Contained_IntfRepoID,s);
      Contained_ptr _result = CORBA::Contained::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(Contained_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_Contained_IntfRepoID,32,s);
    }

    static inline Contained_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_Contained_IntfRepoID,s);
      Contained_ptr _result = CORBA::Contained::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    Contained() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_Contained_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~Contained() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    Contained(const Contained&);
    Contained &operator=(const Contained&);
  };

  class _sk_Contained :  public virtual _sk_IRObject, public virtual Contained {
  public:

    _sk_Contained() {}
    _sk_Contained(const omniORB::objectKey& k);
    virtual ~_sk_Contained() {}
    Contained_ptr _this() { return Contained::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual char* id() = 0;
    virtual void id(const char*) = 0;
    virtual char* name() = 0;
    virtual void name(const char*) = 0;
    virtual char* version() = 0;
    virtual void version(const char*) = 0;
    virtual Container_ptr defined_in() = 0;
    virtual char* absolute_name() = 0;
    virtual Repository_ptr containing_repository() = 0;
    virtual Description * describe() = 0;
    virtual void move(Container_ptr  new_container, const char*  new_name, const char*  new_version) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return Contained::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_Contained (const _sk_Contained&);
    _sk_Contained &operator=(const _sk_Contained&);
  };

  class _proxy_Contained :  public virtual _proxy_IRObject, public virtual Contained {
  public:

    _proxy_Contained (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_Contained_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_Contained() {}
    virtual char* id();
    virtual void id(const char*);
    virtual char* name();
    virtual void name(const char*);
    virtual char* version();
    virtual void version(const char*);
    virtual Container_ptr defined_in();
    virtual char* absolute_name();
    virtual Repository_ptr containing_repository();
    virtual Description * describe();
    virtual void move(Container_ptr  new_container, const char*  new_name, const char*  new_version);

  protected:

    _proxy_Contained () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return Contained::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_Contained (const _proxy_Contained&);
    _proxy_Contained &operator=(const _proxy_Contained&);
  };

  class _nil_Contained :  public virtual _nil_IRObject,   public virtual Contained {
  public:
    _nil_Contained() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_Contained() {}
    char* id() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      char* _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void id(const char* _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    char* name() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      char* _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void name(const char* _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    char* version() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      char* _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void version(const char* _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    Container_ptr defined_in() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      Container_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    char* absolute_name() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      char* _0RL_result = 0;
      return _0RL_result;
#endif
    }

    Repository_ptr containing_repository() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      Repository_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    Description * describe(){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      Description * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void move(Container_ptr  new_container, const char*  new_name, const char*  new_version){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return Contained::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class Contained_proxyObjectFactory : public proxyObjectFactory {
  public:
    Contained_proxyObjectFactory () {}
    virtual ~Contained_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static Contained_ptr _nil() {
      if (!__nil_Contained) {
        __nil_Contained = new _nil_Contained;
      }
      return __nil_Contained;
    }
  private:
    static Contained_ptr __nil_Contained;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_Contained;

#ifndef __CORBA_mModuleDef__
#define __CORBA_mModuleDef__
  class   ModuleDef;
  typedef ModuleDef* ModuleDef_ptr;
  typedef ModuleDef_ptr ModuleDefRef;
  class _proxy_ModuleDef;
  class _sk_ModuleDef;
  class _nil_ModuleDef;

  class ModuleDef_Helper {
    public:
    static ModuleDef_ptr _nil();
    static CORBA::Boolean is_nil(ModuleDef_ptr p);
    static void release(ModuleDef_ptr p);
    static void duplicate(ModuleDef_ptr p);
    static size_t NP_alignedSize(ModuleDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ModuleDef_ptr obj,NetBufferedStream &s);
    static ModuleDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ModuleDef_ptr obj,MemBufferedStream &s);
    static ModuleDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ModuleDef,ModuleDef_Helper> ModuleDef_var;

#endif
#ifndef __CORBA_mConstantDef__
#define __CORBA_mConstantDef__
  class   ConstantDef;
  typedef ConstantDef* ConstantDef_ptr;
  typedef ConstantDef_ptr ConstantDefRef;
  class _proxy_ConstantDef;
  class _sk_ConstantDef;
  class _nil_ConstantDef;

  class ConstantDef_Helper {
    public:
    static ConstantDef_ptr _nil();
    static CORBA::Boolean is_nil(ConstantDef_ptr p);
    static void release(ConstantDef_ptr p);
    static void duplicate(ConstantDef_ptr p);
    static size_t NP_alignedSize(ConstantDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ConstantDef_ptr obj,NetBufferedStream &s);
    static ConstantDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ConstantDef_ptr obj,MemBufferedStream &s);
    static ConstantDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ConstantDef,ConstantDef_Helper> ConstantDef_var;

#endif
#ifndef __CORBA_mStructDef__
#define __CORBA_mStructDef__
  class   StructDef;
  typedef StructDef* StructDef_ptr;
  typedef StructDef_ptr StructDefRef;
  class _proxy_StructDef;
  class _sk_StructDef;
  class _nil_StructDef;

  class StructDef_Helper {
    public:
    static StructDef_ptr _nil();
    static CORBA::Boolean is_nil(StructDef_ptr p);
    static void release(StructDef_ptr p);
    static void duplicate(StructDef_ptr p);
    static size_t NP_alignedSize(StructDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(StructDef_ptr obj,NetBufferedStream &s);
    static StructDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(StructDef_ptr obj,MemBufferedStream &s);
    static StructDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<StructDef,StructDef_Helper> StructDef_var;

#endif
#ifndef __CORBA_mUnionDef__
#define __CORBA_mUnionDef__
  class   UnionDef;
  typedef UnionDef* UnionDef_ptr;
  typedef UnionDef_ptr UnionDefRef;
  class _proxy_UnionDef;
  class _sk_UnionDef;
  class _nil_UnionDef;

  class UnionDef_Helper {
    public:
    static UnionDef_ptr _nil();
    static CORBA::Boolean is_nil(UnionDef_ptr p);
    static void release(UnionDef_ptr p);
    static void duplicate(UnionDef_ptr p);
    static size_t NP_alignedSize(UnionDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(UnionDef_ptr obj,NetBufferedStream &s);
    static UnionDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(UnionDef_ptr obj,MemBufferedStream &s);
    static UnionDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<UnionDef,UnionDef_Helper> UnionDef_var;

#endif
#ifndef __CORBA_mEnumDef__
#define __CORBA_mEnumDef__
  class   EnumDef;
  typedef EnumDef* EnumDef_ptr;
  typedef EnumDef_ptr EnumDefRef;
  class _proxy_EnumDef;
  class _sk_EnumDef;
  class _nil_EnumDef;

  class EnumDef_Helper {
    public:
    static EnumDef_ptr _nil();
    static CORBA::Boolean is_nil(EnumDef_ptr p);
    static void release(EnumDef_ptr p);
    static void duplicate(EnumDef_ptr p);
    static size_t NP_alignedSize(EnumDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(EnumDef_ptr obj,NetBufferedStream &s);
    static EnumDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(EnumDef_ptr obj,MemBufferedStream &s);
    static EnumDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<EnumDef,EnumDef_Helper> EnumDef_var;

#endif
#ifndef __CORBA_mAliasDef__
#define __CORBA_mAliasDef__
  class   AliasDef;
  typedef AliasDef* AliasDef_ptr;
  typedef AliasDef_ptr AliasDefRef;
  class _proxy_AliasDef;
  class _sk_AliasDef;
  class _nil_AliasDef;

  class AliasDef_Helper {
    public:
    static AliasDef_ptr _nil();
    static CORBA::Boolean is_nil(AliasDef_ptr p);
    static void release(AliasDef_ptr p);
    static void duplicate(AliasDef_ptr p);
    static size_t NP_alignedSize(AliasDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(AliasDef_ptr obj,NetBufferedStream &s);
    static AliasDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(AliasDef_ptr obj,MemBufferedStream &s);
    static AliasDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<AliasDef,AliasDef_Helper> AliasDef_var;

#endif
#ifndef __CORBA_mExceptionDef__
#define __CORBA_mExceptionDef__
  class   ExceptionDef;
  typedef ExceptionDef* ExceptionDef_ptr;
  typedef ExceptionDef_ptr ExceptionDefRef;
  class _proxy_ExceptionDef;
  class _sk_ExceptionDef;
  class _nil_ExceptionDef;

  class ExceptionDef_Helper {
    public:
    static ExceptionDef_ptr _nil();
    static CORBA::Boolean is_nil(ExceptionDef_ptr p);
    static void release(ExceptionDef_ptr p);
    static void duplicate(ExceptionDef_ptr p);
    static size_t NP_alignedSize(ExceptionDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ExceptionDef_ptr obj,NetBufferedStream &s);
    static ExceptionDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ExceptionDef_ptr obj,MemBufferedStream &s);
    static ExceptionDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ExceptionDef,ExceptionDef_Helper> ExceptionDef_var;

#endif
#ifndef __CORBA_mWstringDef__
#define __CORBA_mWstringDef__
  class   WstringDef;
  typedef WstringDef* WstringDef_ptr;
  typedef WstringDef_ptr WstringDefRef;
  class _proxy_WstringDef;
  class _sk_WstringDef;
  class _nil_WstringDef;

  class WstringDef_Helper {
    public:
    static WstringDef_ptr _nil();
    static CORBA::Boolean is_nil(WstringDef_ptr p);
    static void release(WstringDef_ptr p);
    static void duplicate(WstringDef_ptr p);
    static size_t NP_alignedSize(WstringDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(WstringDef_ptr obj,NetBufferedStream &s);
    static WstringDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(WstringDef_ptr obj,MemBufferedStream &s);
    static WstringDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<WstringDef,WstringDef_Helper> WstringDef_var;

#endif
#ifndef __CORBA_mFixedDef__
#define __CORBA_mFixedDef__
  class   FixedDef;
  typedef FixedDef* FixedDef_ptr;
  typedef FixedDef_ptr FixedDefRef;
  class _proxy_FixedDef;
  class _sk_FixedDef;
  class _nil_FixedDef;

  class FixedDef_Helper {
    public:
    static FixedDef_ptr _nil();
    static CORBA::Boolean is_nil(FixedDef_ptr p);
    static void release(FixedDef_ptr p);
    static void duplicate(FixedDef_ptr p);
    static size_t NP_alignedSize(FixedDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(FixedDef_ptr obj,NetBufferedStream &s);
    static FixedDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(FixedDef_ptr obj,MemBufferedStream &s);
    static FixedDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<FixedDef,FixedDef_Helper> FixedDef_var;

#endif
  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_InterfaceDefSeq;
  typedef _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<InterfaceDef,InterfaceDef_Helper> > InterfaceDefSeq;
  typedef _CORBA_Sequence_Var<InterfaceDefSeq, _CORBA_ObjRef_Member<InterfaceDef,InterfaceDef_Helper> > InterfaceDefSeq_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ContainedSeq;
  typedef _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<Contained,Contained_Helper> > ContainedSeq;
  typedef _CORBA_Sequence_Var<ContainedSeq, _CORBA_ObjRef_Member<Contained,Contained_Helper> > ContainedSeq_var;

#ifndef __CORBA_mContainer__
#define __CORBA_mContainer__
  class   Container;
  typedef Container* Container_ptr;
  typedef Container_ptr ContainerRef;

  class Container_Helper {
    public:
    static Container_ptr _nil();
    static CORBA::Boolean is_nil(Container_ptr p);
    static void release(Container_ptr p);
    static void duplicate(Container_ptr p);
    static size_t NP_alignedSize(Container_ptr obj,size_t initialoffset);
    static void marshalObjRef(Container_ptr obj,NetBufferedStream &s);
    static Container_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(Container_ptr obj,MemBufferedStream &s);
    static Container_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<Container,Container_Helper> Container_var;

#endif
#define CORBA_Container_IntfRepoID "IDL:omg.org/CORBA/Container:1.0"

  class Container :  public virtual IRObject {
  public:

    struct Description {
      _CORBA_ObjRef_Member<Contained,Contained_Helper> contained_object;
      DefinitionKind kind;
      CORBA::Any value;
      
      size_t NP_alignedSize(size_t initialoffset) const;
      void operator>>= (NetBufferedStream &) const;
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &) const;
      void operator<<= (MemBufferedStream &);
    };

    typedef _CORBA_ConstrType_Variable_Var<Description> Description_var;

    static _LC_attr const CORBA::TypeCode_ptr _tc_Description;

    static _LC_attr const CORBA::TypeCode_ptr _tc_DescriptionSeq;
    typedef _CORBA_Unbounded_Sequence<Description > DescriptionSeq;
    typedef _CORBA_Sequence_Var<DescriptionSeq, Description > DescriptionSeq_var;

    virtual Contained_ptr  lookup(const char*  search_name) = 0;
    virtual ContainedSeq * contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited) = 0;
    virtual ContainedSeq * lookup_name(const char*  search_name, CORBA::Long  levels_to_search, DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited) = 0;
    virtual DescriptionSeq * describe_contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited, CORBA::Long  max_returned_objs) = 0;
    virtual ModuleDef_ptr  create_module(const char*  id, const char*  name, const char*  version) = 0;
    virtual ConstantDef_ptr  create_constant(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, const CORBA::Any & value) = 0;
    virtual StructDef_ptr  create_struct(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members) = 0;
    virtual UnionDef_ptr  create_union(const char*  id, const char*  name, const char*  version, IDLType_ptr  discriminator_type, const StructMemberSeq & members) = 0;
    virtual EnumDef_ptr  create_enum(const char*  id, const char*  name, const char*  version, const EnumMemberSeq & members) = 0;
    virtual AliasDef_ptr  create_alias(const char*  id, const char*  name, const char*  version, IDLType_ptr  original_type) = 0;
    virtual InterfaceDef_ptr  create_interface(const char*  id, const char*  name, const char*  version, const InterfaceDefSeq & base_interfaces) = 0;
    virtual ExceptionDef_ptr  create_exception(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members) = 0;
    static Container_ptr _duplicate(Container_ptr);
    static Container_ptr _narrow(CORBA::Object_ptr);
    static Container_ptr _nil();

    static inline size_t NP_alignedSize(Container_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_Container_IntfRepoID,32,initialoffset);
    }

    static inline void marshalObjRef(Container_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_Container_IntfRepoID,32,s);
    }

    static inline Container_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_Container_IntfRepoID,s);
      Container_ptr _result = CORBA::Container::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(Container_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_Container_IntfRepoID,32,s);
    }

    static inline Container_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_Container_IntfRepoID,s);
      Container_ptr _result = CORBA::Container::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    Container() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_Container_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~Container() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    Container(const Container&);
    Container &operator=(const Container&);
  };

  class _sk_Container :  public virtual _sk_IRObject, public virtual Container {
  public:

    _sk_Container() {}
    _sk_Container(const omniORB::objectKey& k);
    virtual ~_sk_Container() {}
    Container_ptr _this() { return Container::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual Contained_ptr  lookup(const char*  search_name) = 0;
    virtual ContainedSeq * contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited) = 0;
    virtual ContainedSeq * lookup_name(const char*  search_name, CORBA::Long  levels_to_search, DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited) = 0;
    virtual DescriptionSeq * describe_contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited, CORBA::Long  max_returned_objs) = 0;
    virtual ModuleDef_ptr  create_module(const char*  id, const char*  name, const char*  version) = 0;
    virtual ConstantDef_ptr  create_constant(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, const CORBA::Any & value) = 0;
    virtual StructDef_ptr  create_struct(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members) = 0;
    virtual UnionDef_ptr  create_union(const char*  id, const char*  name, const char*  version, IDLType_ptr  discriminator_type, const StructMemberSeq & members) = 0;
    virtual EnumDef_ptr  create_enum(const char*  id, const char*  name, const char*  version, const EnumMemberSeq & members) = 0;
    virtual AliasDef_ptr  create_alias(const char*  id, const char*  name, const char*  version, IDLType_ptr  original_type) = 0;
    virtual InterfaceDef_ptr  create_interface(const char*  id, const char*  name, const char*  version, const InterfaceDefSeq & base_interfaces) = 0;
    virtual ExceptionDef_ptr  create_exception(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return Container::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_Container (const _sk_Container&);
    _sk_Container &operator=(const _sk_Container&);
  };

  class _proxy_Container :  public virtual _proxy_IRObject, public virtual Container {
  public:

    _proxy_Container (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_Container_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_Container() {}
    virtual Contained_ptr  lookup(const char*  search_name);
    virtual ContainedSeq * contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited);
    virtual ContainedSeq * lookup_name(const char*  search_name, CORBA::Long  levels_to_search, DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited);
    virtual DescriptionSeq * describe_contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited, CORBA::Long  max_returned_objs);
    virtual ModuleDef_ptr  create_module(const char*  id, const char*  name, const char*  version);
    virtual ConstantDef_ptr  create_constant(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, const CORBA::Any & value);
    virtual StructDef_ptr  create_struct(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members);
    virtual UnionDef_ptr  create_union(const char*  id, const char*  name, const char*  version, IDLType_ptr  discriminator_type, const StructMemberSeq & members);
    virtual EnumDef_ptr  create_enum(const char*  id, const char*  name, const char*  version, const EnumMemberSeq & members);
    virtual AliasDef_ptr  create_alias(const char*  id, const char*  name, const char*  version, IDLType_ptr  original_type);
    virtual InterfaceDef_ptr  create_interface(const char*  id, const char*  name, const char*  version, const InterfaceDefSeq & base_interfaces);
    virtual ExceptionDef_ptr  create_exception(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members);

  protected:

    _proxy_Container () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return Container::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_Container (const _proxy_Container&);
    _proxy_Container &operator=(const _proxy_Container&);
  };

  class _nil_Container :  public virtual _nil_IRObject,   public virtual Container {
  public:
    _nil_Container() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_Container() {}
    Contained_ptr  lookup(const char*  search_name){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      Contained_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    ContainedSeq * contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ContainedSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    ContainedSeq * lookup_name(const char*  search_name, CORBA::Long  levels_to_search, DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ContainedSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    DescriptionSeq * describe_contents(DefinitionKind  limit_type, CORBA::Boolean  exclude_inherited, CORBA::Long  max_returned_objs){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      DescriptionSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    ModuleDef_ptr  create_module(const char*  id, const char*  name, const char*  version){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ModuleDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    ConstantDef_ptr  create_constant(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, const CORBA::Any & value){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ConstantDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    StructDef_ptr  create_struct(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      StructDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    UnionDef_ptr  create_union(const char*  id, const char*  name, const char*  version, IDLType_ptr  discriminator_type, const StructMemberSeq & members){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      UnionDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    EnumDef_ptr  create_enum(const char*  id, const char*  name, const char*  version, const EnumMemberSeq & members){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      EnumDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    AliasDef_ptr  create_alias(const char*  id, const char*  name, const char*  version, IDLType_ptr  original_type){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      AliasDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    InterfaceDef_ptr  create_interface(const char*  id, const char*  name, const char*  version, const InterfaceDefSeq & base_interfaces){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      InterfaceDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    ExceptionDef_ptr  create_exception(const char*  id, const char*  name, const char*  version, const StructMemberSeq & members){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ExceptionDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return Container::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class Container_proxyObjectFactory : public proxyObjectFactory {
  public:
    Container_proxyObjectFactory () {}
    virtual ~Container_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static Container_ptr _nil() {
      if (!__nil_Container) {
        __nil_Container = new _nil_Container;
      }
      return __nil_Container;
    }
  private:
    static Container_ptr __nil_Container;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_Container;

#ifndef __CORBA_mIDLType__
#define __CORBA_mIDLType__
  class   IDLType;
  typedef IDLType* IDLType_ptr;
  typedef IDLType_ptr IDLTypeRef;

  class IDLType_Helper {
    public:
    static IDLType_ptr _nil();
    static CORBA::Boolean is_nil(IDLType_ptr p);
    static void release(IDLType_ptr p);
    static void duplicate(IDLType_ptr p);
    static size_t NP_alignedSize(IDLType_ptr obj,size_t initialoffset);
    static void marshalObjRef(IDLType_ptr obj,NetBufferedStream &s);
    static IDLType_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(IDLType_ptr obj,MemBufferedStream &s);
    static IDLType_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<IDLType,IDLType_Helper> IDLType_var;

#endif
#define CORBA_IDLType_IntfRepoID "IDL:omg.org/CORBA/IDLType:1.0"

  class IDLType :  public virtual IRObject {
  public:

    virtual CORBA::TypeCode_ptr type() = 0;
    static IDLType_ptr _duplicate(IDLType_ptr);
    static IDLType_ptr _narrow(CORBA::Object_ptr);
    static IDLType_ptr _nil();

    static inline size_t NP_alignedSize(IDLType_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_IDLType_IntfRepoID,30,initialoffset);
    }

    static inline void marshalObjRef(IDLType_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_IDLType_IntfRepoID,30,s);
    }

    static inline IDLType_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_IDLType_IntfRepoID,s);
      IDLType_ptr _result = CORBA::IDLType::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(IDLType_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_IDLType_IntfRepoID,30,s);
    }

    static inline IDLType_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_IDLType_IntfRepoID,s);
      IDLType_ptr _result = CORBA::IDLType::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    IDLType() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_IDLType_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~IDLType() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    IDLType(const IDLType&);
    IDLType &operator=(const IDLType&);
  };

  class _sk_IDLType :  public virtual _sk_IRObject, public virtual IDLType {
  public:

    _sk_IDLType() {}
    _sk_IDLType(const omniORB::objectKey& k);
    virtual ~_sk_IDLType() {}
    IDLType_ptr _this() { return IDLType::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::TypeCode_ptr type() = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return IDLType::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_IDLType (const _sk_IDLType&);
    _sk_IDLType &operator=(const _sk_IDLType&);
  };

  class _proxy_IDLType :  public virtual _proxy_IRObject, public virtual IDLType {
  public:

    _proxy_IDLType (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_IDLType_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_IDLType() {}
    virtual CORBA::TypeCode_ptr type();

  protected:

    _proxy_IDLType () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return IDLType::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_IDLType (const _proxy_IDLType&);
    _proxy_IDLType &operator=(const _proxy_IDLType&);
  };

  class _nil_IDLType :  public virtual _nil_IRObject,   public virtual IDLType {
  public:
    _nil_IDLType() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_IDLType() {}
    CORBA::TypeCode_ptr type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return IDLType::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class IDLType_proxyObjectFactory : public proxyObjectFactory {
  public:
    IDLType_proxyObjectFactory () {}
    virtual ~IDLType_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static IDLType_ptr _nil() {
      if (!__nil_IDLType) {
        __nil_IDLType = new _nil_IDLType;
      }
      return __nil_IDLType;
    }
  private:
    static IDLType_ptr __nil_IDLType;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_IDLType;

#ifndef __CORBA_mPrimitiveDef__
#define __CORBA_mPrimitiveDef__
  class   PrimitiveDef;
  typedef PrimitiveDef* PrimitiveDef_ptr;
  typedef PrimitiveDef_ptr PrimitiveDefRef;
  class _proxy_PrimitiveDef;
  class _sk_PrimitiveDef;
  class _nil_PrimitiveDef;

  class PrimitiveDef_Helper {
    public:
    static PrimitiveDef_ptr _nil();
    static CORBA::Boolean is_nil(PrimitiveDef_ptr p);
    static void release(PrimitiveDef_ptr p);
    static void duplicate(PrimitiveDef_ptr p);
    static size_t NP_alignedSize(PrimitiveDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(PrimitiveDef_ptr obj,NetBufferedStream &s);
    static PrimitiveDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(PrimitiveDef_ptr obj,MemBufferedStream &s);
    static PrimitiveDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<PrimitiveDef,PrimitiveDef_Helper> PrimitiveDef_var;

#endif
#ifndef __CORBA_mStringDef__
#define __CORBA_mStringDef__
  class   StringDef;
  typedef StringDef* StringDef_ptr;
  typedef StringDef_ptr StringDefRef;
  class _proxy_StringDef;
  class _sk_StringDef;
  class _nil_StringDef;

  class StringDef_Helper {
    public:
    static StringDef_ptr _nil();
    static CORBA::Boolean is_nil(StringDef_ptr p);
    static void release(StringDef_ptr p);
    static void duplicate(StringDef_ptr p);
    static size_t NP_alignedSize(StringDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(StringDef_ptr obj,NetBufferedStream &s);
    static StringDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(StringDef_ptr obj,MemBufferedStream &s);
    static StringDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<StringDef,StringDef_Helper> StringDef_var;

#endif
#ifndef __CORBA_mSequenceDef__
#define __CORBA_mSequenceDef__
  class   SequenceDef;
  typedef SequenceDef* SequenceDef_ptr;
  typedef SequenceDef_ptr SequenceDefRef;
  class _proxy_SequenceDef;
  class _sk_SequenceDef;
  class _nil_SequenceDef;

  class SequenceDef_Helper {
    public:
    static SequenceDef_ptr _nil();
    static CORBA::Boolean is_nil(SequenceDef_ptr p);
    static void release(SequenceDef_ptr p);
    static void duplicate(SequenceDef_ptr p);
    static size_t NP_alignedSize(SequenceDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(SequenceDef_ptr obj,NetBufferedStream &s);
    static SequenceDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(SequenceDef_ptr obj,MemBufferedStream &s);
    static SequenceDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<SequenceDef,SequenceDef_Helper> SequenceDef_var;

#endif
#ifndef __CORBA_mArrayDef__
#define __CORBA_mArrayDef__
  class   ArrayDef;
  typedef ArrayDef* ArrayDef_ptr;
  typedef ArrayDef_ptr ArrayDefRef;
  class _proxy_ArrayDef;
  class _sk_ArrayDef;
  class _nil_ArrayDef;

  class ArrayDef_Helper {
    public:
    static ArrayDef_ptr _nil();
    static CORBA::Boolean is_nil(ArrayDef_ptr p);
    static void release(ArrayDef_ptr p);
    static void duplicate(ArrayDef_ptr p);
    static size_t NP_alignedSize(ArrayDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ArrayDef_ptr obj,NetBufferedStream &s);
    static ArrayDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ArrayDef_ptr obj,MemBufferedStream &s);
    static ArrayDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ArrayDef,ArrayDef_Helper> ArrayDef_var;

#endif
  enum PrimitiveKind { pk_null, pk_void, pk_short, pk_long, pk_ushort, pk_ulong, pk_float, pk_double, pk_boolean, pk_char, pk_octet, pk_any, pk_TypeCode, pk_Principal, pk_string, pk_objref, pk_longlong, pk_ulonglong, pk_longdouble, pk_wchar, pk_wstring };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_PrimitiveKind;

#ifndef __CORBA_mRepository__
#define __CORBA_mRepository__
  class   Repository;
  typedef Repository* Repository_ptr;
  typedef Repository_ptr RepositoryRef;

  class Repository_Helper {
    public:
    static Repository_ptr _nil();
    static CORBA::Boolean is_nil(Repository_ptr p);
    static void release(Repository_ptr p);
    static void duplicate(Repository_ptr p);
    static size_t NP_alignedSize(Repository_ptr obj,size_t initialoffset);
    static void marshalObjRef(Repository_ptr obj,NetBufferedStream &s);
    static Repository_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(Repository_ptr obj,MemBufferedStream &s);
    static Repository_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<Repository,Repository_Helper> Repository_var;

#endif
#define CORBA_Repository_IntfRepoID "IDL:omg.org/CORBA/Repository:1.0"

  class Repository :  public virtual Container {
  public:

    virtual Contained_ptr  lookup_id(const char*  search_id) = 0;
    virtual PrimitiveDef_ptr  get_primtive(PrimitiveKind  kind) = 0;
    virtual StringDef_ptr  create_string(CORBA::ULong  bound) = 0;
    virtual WstringDef_ptr  create_wstring(CORBA::ULong  bound) = 0;
    virtual SequenceDef_ptr  create_sequence(CORBA::ULong  bound, IDLType_ptr  element_type) = 0;
    virtual ArrayDef_ptr  create_array(CORBA::ULong  length, IDLType_ptr  element_type) = 0;
    virtual FixedDef_ptr  create_fixed(CORBA::UShort  digits, CORBA::Short  scale) = 0;
    static Repository_ptr _duplicate(Repository_ptr);
    static Repository_ptr _narrow(CORBA::Object_ptr);
    static Repository_ptr _nil();

    static inline size_t NP_alignedSize(Repository_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_Repository_IntfRepoID,33,initialoffset);
    }

    static inline void marshalObjRef(Repository_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_Repository_IntfRepoID,33,s);
    }

    static inline Repository_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_Repository_IntfRepoID,s);
      Repository_ptr _result = CORBA::Repository::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(Repository_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_Repository_IntfRepoID,33,s);
    }

    static inline Repository_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_Repository_IntfRepoID,s);
      Repository_ptr _result = CORBA::Repository::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    Repository() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_Repository_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~Repository() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    Repository(const Repository&);
    Repository &operator=(const Repository&);
  };

  class _sk_Repository :  public virtual _sk_Container, public virtual Repository {
  public:

    _sk_Repository() {}
    _sk_Repository(const omniORB::objectKey& k);
    virtual ~_sk_Repository() {}
    Repository_ptr _this() { return Repository::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual Contained_ptr  lookup_id(const char*  search_id) = 0;
    virtual PrimitiveDef_ptr  get_primtive(PrimitiveKind  kind) = 0;
    virtual StringDef_ptr  create_string(CORBA::ULong  bound) = 0;
    virtual WstringDef_ptr  create_wstring(CORBA::ULong  bound) = 0;
    virtual SequenceDef_ptr  create_sequence(CORBA::ULong  bound, IDLType_ptr  element_type) = 0;
    virtual ArrayDef_ptr  create_array(CORBA::ULong  length, IDLType_ptr  element_type) = 0;
    virtual FixedDef_ptr  create_fixed(CORBA::UShort  digits, CORBA::Short  scale) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return Repository::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_Repository (const _sk_Repository&);
    _sk_Repository &operator=(const _sk_Repository&);
  };

  class _proxy_Repository :  public virtual _proxy_Container, public virtual Repository {
  public:

    _proxy_Repository (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_Repository_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_Repository() {}
    virtual Contained_ptr  lookup_id(const char*  search_id);
    virtual PrimitiveDef_ptr  get_primtive(PrimitiveKind  kind);
    virtual StringDef_ptr  create_string(CORBA::ULong  bound);
    virtual WstringDef_ptr  create_wstring(CORBA::ULong  bound);
    virtual SequenceDef_ptr  create_sequence(CORBA::ULong  bound, IDLType_ptr  element_type);
    virtual ArrayDef_ptr  create_array(CORBA::ULong  length, IDLType_ptr  element_type);
    virtual FixedDef_ptr  create_fixed(CORBA::UShort  digits, CORBA::Short  scale);

  protected:

    _proxy_Repository () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return Repository::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_Repository (const _proxy_Repository&);
    _proxy_Repository &operator=(const _proxy_Repository&);
  };

  class _nil_Repository :  public virtual _nil_Container,   public virtual Repository {
  public:
    _nil_Repository() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_Repository() {}
    Contained_ptr  lookup_id(const char*  search_id){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      Contained_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    PrimitiveDef_ptr  get_primtive(PrimitiveKind  kind){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      PrimitiveDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    StringDef_ptr  create_string(CORBA::ULong  bound){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      StringDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    WstringDef_ptr  create_wstring(CORBA::ULong  bound){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      WstringDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    SequenceDef_ptr  create_sequence(CORBA::ULong  bound, IDLType_ptr  element_type){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      SequenceDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    ArrayDef_ptr  create_array(CORBA::ULong  length, IDLType_ptr  element_type){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ArrayDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    FixedDef_ptr  create_fixed(CORBA::UShort  digits, CORBA::Short  scale){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      FixedDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return Repository::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class Repository_proxyObjectFactory : public proxyObjectFactory {
  public:
    Repository_proxyObjectFactory () {}
    virtual ~Repository_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static Repository_ptr _nil() {
      if (!__nil_Repository) {
        __nil_Repository = new _nil_Repository;
      }
      return __nil_Repository;
    }
  private:
    static Repository_ptr __nil_Repository;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_Repository;

#ifndef __CORBA_mModuleDef__
#define __CORBA_mModuleDef__
  class   ModuleDef;
  typedef ModuleDef* ModuleDef_ptr;
  typedef ModuleDef_ptr ModuleDefRef;

  class ModuleDef_Helper {
    public:
    static ModuleDef_ptr _nil();
    static CORBA::Boolean is_nil(ModuleDef_ptr p);
    static void release(ModuleDef_ptr p);
    static void duplicate(ModuleDef_ptr p);
    static size_t NP_alignedSize(ModuleDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ModuleDef_ptr obj,NetBufferedStream &s);
    static ModuleDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ModuleDef_ptr obj,MemBufferedStream &s);
    static ModuleDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ModuleDef,ModuleDef_Helper> ModuleDef_var;

#endif
#define CORBA_ModuleDef_IntfRepoID "IDL:omg.org/CORBA/ModuleDef:1.0"

  class ModuleDef :  public virtual Container, public virtual Contained {
  public:

    static ModuleDef_ptr _duplicate(ModuleDef_ptr);
    static ModuleDef_ptr _narrow(CORBA::Object_ptr);
    static ModuleDef_ptr _nil();

    static inline size_t NP_alignedSize(ModuleDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_ModuleDef_IntfRepoID,32,initialoffset);
    }

    static inline void marshalObjRef(ModuleDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ModuleDef_IntfRepoID,32,s);
    }

    static inline ModuleDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ModuleDef_IntfRepoID,s);
      ModuleDef_ptr _result = CORBA::ModuleDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(ModuleDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ModuleDef_IntfRepoID,32,s);
    }

    static inline ModuleDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ModuleDef_IntfRepoID,s);
      ModuleDef_ptr _result = CORBA::ModuleDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    ModuleDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_ModuleDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~ModuleDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    ModuleDef(const ModuleDef&);
    ModuleDef &operator=(const ModuleDef&);
  };

  class _sk_ModuleDef :  public virtual _sk_Container, public virtual _sk_Contained, public virtual ModuleDef {
  public:

    _sk_ModuleDef() {}
    _sk_ModuleDef(const omniORB::objectKey& k);
    virtual ~_sk_ModuleDef() {}
    ModuleDef_ptr _this() { return ModuleDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ModuleDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_ModuleDef (const _sk_ModuleDef&);
    _sk_ModuleDef &operator=(const _sk_ModuleDef&);
  };

  class _proxy_ModuleDef :  public virtual _proxy_Container, public virtual _proxy_Contained, public virtual ModuleDef {
  public:

    _proxy_ModuleDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_ModuleDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_ModuleDef() {}

  protected:

    _proxy_ModuleDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return ModuleDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_ModuleDef (const _proxy_ModuleDef&);
    _proxy_ModuleDef &operator=(const _proxy_ModuleDef&);
  };

  class _nil_ModuleDef :  public virtual _nil_Container,  public virtual _nil_Contained,   public virtual ModuleDef {
  public:
    _nil_ModuleDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_ModuleDef() {}
  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ModuleDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class ModuleDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    ModuleDef_proxyObjectFactory () {}
    virtual ~ModuleDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static ModuleDef_ptr _nil() {
      if (!__nil_ModuleDef) {
        __nil_ModuleDef = new _nil_ModuleDef;
      }
      return __nil_ModuleDef;
    }
  private:
    static ModuleDef_ptr __nil_ModuleDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ModuleDef;

  struct ModuleDescription {
    CORBA::String_member name;
    CORBA::String_member id;
    CORBA::String_member defined_in;
    CORBA::String_member version;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<ModuleDescription> ModuleDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ModuleDescription;

#ifndef __CORBA_mConstantDef__
#define __CORBA_mConstantDef__
  class   ConstantDef;
  typedef ConstantDef* ConstantDef_ptr;
  typedef ConstantDef_ptr ConstantDefRef;

  class ConstantDef_Helper {
    public:
    static ConstantDef_ptr _nil();
    static CORBA::Boolean is_nil(ConstantDef_ptr p);
    static void release(ConstantDef_ptr p);
    static void duplicate(ConstantDef_ptr p);
    static size_t NP_alignedSize(ConstantDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ConstantDef_ptr obj,NetBufferedStream &s);
    static ConstantDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ConstantDef_ptr obj,MemBufferedStream &s);
    static ConstantDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ConstantDef,ConstantDef_Helper> ConstantDef_var;

#endif
#define CORBA_ConstantDef_IntfRepoID "IDL:omg.org/CORBA/ConstantDef:1.0"

  class ConstantDef :  public virtual Contained {
  public:

    virtual CORBA::TypeCode_ptr type() = 0;
    virtual IDLType_ptr type_def() = 0;
    virtual void type_def(IDLType_ptr) = 0;
    virtual CORBA::Any* value() = 0;
    virtual void value(const CORBA::Any&) = 0;
    static ConstantDef_ptr _duplicate(ConstantDef_ptr);
    static ConstantDef_ptr _narrow(CORBA::Object_ptr);
    static ConstantDef_ptr _nil();

    static inline size_t NP_alignedSize(ConstantDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_ConstantDef_IntfRepoID,34,initialoffset);
    }

    static inline void marshalObjRef(ConstantDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ConstantDef_IntfRepoID,34,s);
    }

    static inline ConstantDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ConstantDef_IntfRepoID,s);
      ConstantDef_ptr _result = CORBA::ConstantDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(ConstantDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ConstantDef_IntfRepoID,34,s);
    }

    static inline ConstantDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ConstantDef_IntfRepoID,s);
      ConstantDef_ptr _result = CORBA::ConstantDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    ConstantDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_ConstantDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~ConstantDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    ConstantDef(const ConstantDef&);
    ConstantDef &operator=(const ConstantDef&);
  };

  class _sk_ConstantDef :  public virtual _sk_Contained, public virtual ConstantDef {
  public:

    _sk_ConstantDef() {}
    _sk_ConstantDef(const omniORB::objectKey& k);
    virtual ~_sk_ConstantDef() {}
    ConstantDef_ptr _this() { return ConstantDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::TypeCode_ptr type() = 0;
    virtual IDLType_ptr type_def() = 0;
    virtual void type_def(IDLType_ptr) = 0;
    virtual CORBA::Any* value() = 0;
    virtual void value(const CORBA::Any&) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ConstantDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_ConstantDef (const _sk_ConstantDef&);
    _sk_ConstantDef &operator=(const _sk_ConstantDef&);
  };

  class _proxy_ConstantDef :  public virtual _proxy_Contained, public virtual ConstantDef {
  public:

    _proxy_ConstantDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_ConstantDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_ConstantDef() {}
    virtual CORBA::TypeCode_ptr type();
    virtual IDLType_ptr type_def();
    virtual void type_def(IDLType_ptr);
    virtual CORBA::Any* value();
    virtual void value(const CORBA::Any&);

  protected:

    _proxy_ConstantDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return ConstantDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_ConstantDef (const _proxy_ConstantDef&);
    _proxy_ConstantDef &operator=(const _proxy_ConstantDef&);
  };

  class _nil_ConstantDef :  public virtual _nil_Contained,   public virtual ConstantDef {
  public:
    _nil_ConstantDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_ConstantDef() {}
    CORBA::TypeCode_ptr type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    IDLType_ptr type_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void type_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    CORBA::Any* value() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::Any * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void value(const CORBA::Any& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ConstantDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class ConstantDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    ConstantDef_proxyObjectFactory () {}
    virtual ~ConstantDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static ConstantDef_ptr _nil() {
      if (!__nil_ConstantDef) {
        __nil_ConstantDef = new _nil_ConstantDef;
      }
      return __nil_ConstantDef;
    }
  private:
    static ConstantDef_ptr __nil_ConstantDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ConstantDef;

  struct ConstantDescription {
    CORBA::String_member name;
    CORBA::String_member id;
    CORBA::String_member defined_in;
    CORBA::String_member version;
    CORBA::TypeCode_member type;
    CORBA::Any value;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<ConstantDescription> ConstantDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ConstantDescription;

#ifndef __CORBA_mTypedefDef__
#define __CORBA_mTypedefDef__
  class   TypedefDef;
  typedef TypedefDef* TypedefDef_ptr;
  typedef TypedefDef_ptr TypedefDefRef;

  class TypedefDef_Helper {
    public:
    static TypedefDef_ptr _nil();
    static CORBA::Boolean is_nil(TypedefDef_ptr p);
    static void release(TypedefDef_ptr p);
    static void duplicate(TypedefDef_ptr p);
    static size_t NP_alignedSize(TypedefDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(TypedefDef_ptr obj,NetBufferedStream &s);
    static TypedefDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(TypedefDef_ptr obj,MemBufferedStream &s);
    static TypedefDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<TypedefDef,TypedefDef_Helper> TypedefDef_var;

#endif
#define CORBA_TypedefDef_IntfRepoID "IDL:omg.org/CORBA/TypedefDef:1.0"

  class TypedefDef :  public virtual Contained, public virtual IDLType {
  public:

    static TypedefDef_ptr _duplicate(TypedefDef_ptr);
    static TypedefDef_ptr _narrow(CORBA::Object_ptr);
    static TypedefDef_ptr _nil();

    static inline size_t NP_alignedSize(TypedefDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_TypedefDef_IntfRepoID,33,initialoffset);
    }

    static inline void marshalObjRef(TypedefDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_TypedefDef_IntfRepoID,33,s);
    }

    static inline TypedefDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_TypedefDef_IntfRepoID,s);
      TypedefDef_ptr _result = CORBA::TypedefDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(TypedefDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_TypedefDef_IntfRepoID,33,s);
    }

    static inline TypedefDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_TypedefDef_IntfRepoID,s);
      TypedefDef_ptr _result = CORBA::TypedefDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    TypedefDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_TypedefDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~TypedefDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    TypedefDef(const TypedefDef&);
    TypedefDef &operator=(const TypedefDef&);
  };

  class _sk_TypedefDef :  public virtual _sk_Contained, public virtual _sk_IDLType, public virtual TypedefDef {
  public:

    _sk_TypedefDef() {}
    _sk_TypedefDef(const omniORB::objectKey& k);
    virtual ~_sk_TypedefDef() {}
    TypedefDef_ptr _this() { return TypedefDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return TypedefDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_TypedefDef (const _sk_TypedefDef&);
    _sk_TypedefDef &operator=(const _sk_TypedefDef&);
  };

  class _proxy_TypedefDef :  public virtual _proxy_Contained, public virtual _proxy_IDLType, public virtual TypedefDef {
  public:

    _proxy_TypedefDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_TypedefDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_TypedefDef() {}

  protected:

    _proxy_TypedefDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return TypedefDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_TypedefDef (const _proxy_TypedefDef&);
    _proxy_TypedefDef &operator=(const _proxy_TypedefDef&);
  };

  class _nil_TypedefDef :  public virtual _nil_Contained,  public virtual _nil_IDLType,   public virtual TypedefDef {
  public:
    _nil_TypedefDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_TypedefDef() {}
  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return TypedefDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class TypedefDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    TypedefDef_proxyObjectFactory () {}
    virtual ~TypedefDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static TypedefDef_ptr _nil() {
      if (!__nil_TypedefDef) {
        __nil_TypedefDef = new _nil_TypedefDef;
      }
      return __nil_TypedefDef;
    }
  private:
    static TypedefDef_ptr __nil_TypedefDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_TypedefDef;

  struct TypeDescription {
    CORBA::String_member name;
    CORBA::String_member id;
    CORBA::String_member defined_in;
    CORBA::String_member version;
    CORBA::TypeCode_member type;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<TypeDescription> TypeDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_TypeDescription;

#ifndef __CORBA_mStructDef__
#define __CORBA_mStructDef__
  class   StructDef;
  typedef StructDef* StructDef_ptr;
  typedef StructDef_ptr StructDefRef;

  class StructDef_Helper {
    public:
    static StructDef_ptr _nil();
    static CORBA::Boolean is_nil(StructDef_ptr p);
    static void release(StructDef_ptr p);
    static void duplicate(StructDef_ptr p);
    static size_t NP_alignedSize(StructDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(StructDef_ptr obj,NetBufferedStream &s);
    static StructDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(StructDef_ptr obj,MemBufferedStream &s);
    static StructDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<StructDef,StructDef_Helper> StructDef_var;

#endif
#define CORBA_StructDef_IntfRepoID "IDL:omg.org/CORBA/StructDef:1.0"

  class StructDef :  public virtual TypedefDef, public virtual Container {
  public:

    virtual StructMemberSeq* members() = 0;
    virtual void members(const StructMemberSeq&) = 0;
    static StructDef_ptr _duplicate(StructDef_ptr);
    static StructDef_ptr _narrow(CORBA::Object_ptr);
    static StructDef_ptr _nil();

    static inline size_t NP_alignedSize(StructDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_StructDef_IntfRepoID,32,initialoffset);
    }

    static inline void marshalObjRef(StructDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_StructDef_IntfRepoID,32,s);
    }

    static inline StructDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_StructDef_IntfRepoID,s);
      StructDef_ptr _result = CORBA::StructDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(StructDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_StructDef_IntfRepoID,32,s);
    }

    static inline StructDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_StructDef_IntfRepoID,s);
      StructDef_ptr _result = CORBA::StructDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    StructDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_StructDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~StructDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    StructDef(const StructDef&);
    StructDef &operator=(const StructDef&);
  };

  class _sk_StructDef :  public virtual _sk_TypedefDef, public virtual _sk_Container, public virtual StructDef {
  public:

    _sk_StructDef() {}
    _sk_StructDef(const omniORB::objectKey& k);
    virtual ~_sk_StructDef() {}
    StructDef_ptr _this() { return StructDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual StructMemberSeq* members() = 0;
    virtual void members(const StructMemberSeq&) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return StructDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_StructDef (const _sk_StructDef&);
    _sk_StructDef &operator=(const _sk_StructDef&);
  };

  class _proxy_StructDef :  public virtual _proxy_TypedefDef, public virtual _proxy_Container, public virtual StructDef {
  public:

    _proxy_StructDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_StructDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_StructDef() {}
    virtual StructMemberSeq* members();
    virtual void members(const StructMemberSeq&);

  protected:

    _proxy_StructDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return StructDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_StructDef (const _proxy_StructDef&);
    _proxy_StructDef &operator=(const _proxy_StructDef&);
  };

  class _nil_StructDef :  public virtual _nil_TypedefDef,  public virtual _nil_Container,   public virtual StructDef {
  public:
    _nil_StructDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_StructDef() {}
    StructMemberSeq* members() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      StructMemberSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void members(const StructMemberSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return StructDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class StructDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    StructDef_proxyObjectFactory () {}
    virtual ~StructDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static StructDef_ptr _nil() {
      if (!__nil_StructDef) {
        __nil_StructDef = new _nil_StructDef;
      }
      return __nil_StructDef;
    }
  private:
    static StructDef_ptr __nil_StructDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_StructDef;

#ifndef __CORBA_mUnionDef__
#define __CORBA_mUnionDef__
  class   UnionDef;
  typedef UnionDef* UnionDef_ptr;
  typedef UnionDef_ptr UnionDefRef;

  class UnionDef_Helper {
    public:
    static UnionDef_ptr _nil();
    static CORBA::Boolean is_nil(UnionDef_ptr p);
    static void release(UnionDef_ptr p);
    static void duplicate(UnionDef_ptr p);
    static size_t NP_alignedSize(UnionDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(UnionDef_ptr obj,NetBufferedStream &s);
    static UnionDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(UnionDef_ptr obj,MemBufferedStream &s);
    static UnionDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<UnionDef,UnionDef_Helper> UnionDef_var;

#endif
#define CORBA_UnionDef_IntfRepoID "IDL:omg.org/CORBA/UnionDef:1.0"

  class UnionDef :  public virtual TypedefDef, public virtual Container {
  public:

    virtual CORBA::TypeCode_ptr discriminator_type() = 0;
    virtual IDLType_ptr discriminator_type_def() = 0;
    virtual void discriminator_type_def(IDLType_ptr) = 0;
    virtual UnionMemberSeq* members() = 0;
    virtual void members(const UnionMemberSeq&) = 0;
    static UnionDef_ptr _duplicate(UnionDef_ptr);
    static UnionDef_ptr _narrow(CORBA::Object_ptr);
    static UnionDef_ptr _nil();

    static inline size_t NP_alignedSize(UnionDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_UnionDef_IntfRepoID,31,initialoffset);
    }

    static inline void marshalObjRef(UnionDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_UnionDef_IntfRepoID,31,s);
    }

    static inline UnionDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_UnionDef_IntfRepoID,s);
      UnionDef_ptr _result = CORBA::UnionDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(UnionDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_UnionDef_IntfRepoID,31,s);
    }

    static inline UnionDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_UnionDef_IntfRepoID,s);
      UnionDef_ptr _result = CORBA::UnionDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    UnionDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_UnionDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~UnionDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    UnionDef(const UnionDef&);
    UnionDef &operator=(const UnionDef&);
  };

  class _sk_UnionDef :  public virtual _sk_TypedefDef, public virtual _sk_Container, public virtual UnionDef {
  public:

    _sk_UnionDef() {}
    _sk_UnionDef(const omniORB::objectKey& k);
    virtual ~_sk_UnionDef() {}
    UnionDef_ptr _this() { return UnionDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::TypeCode_ptr discriminator_type() = 0;
    virtual IDLType_ptr discriminator_type_def() = 0;
    virtual void discriminator_type_def(IDLType_ptr) = 0;
    virtual UnionMemberSeq* members() = 0;
    virtual void members(const UnionMemberSeq&) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return UnionDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_UnionDef (const _sk_UnionDef&);
    _sk_UnionDef &operator=(const _sk_UnionDef&);
  };

  class _proxy_UnionDef :  public virtual _proxy_TypedefDef, public virtual _proxy_Container, public virtual UnionDef {
  public:

    _proxy_UnionDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_UnionDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_UnionDef() {}
    virtual CORBA::TypeCode_ptr discriminator_type();
    virtual IDLType_ptr discriminator_type_def();
    virtual void discriminator_type_def(IDLType_ptr);
    virtual UnionMemberSeq* members();
    virtual void members(const UnionMemberSeq&);

  protected:

    _proxy_UnionDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return UnionDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_UnionDef (const _proxy_UnionDef&);
    _proxy_UnionDef &operator=(const _proxy_UnionDef&);
  };

  class _nil_UnionDef :  public virtual _nil_TypedefDef,  public virtual _nil_Container,   public virtual UnionDef {
  public:
    _nil_UnionDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_UnionDef() {}
    CORBA::TypeCode_ptr discriminator_type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    IDLType_ptr discriminator_type_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void discriminator_type_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    UnionMemberSeq* members() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      UnionMemberSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void members(const UnionMemberSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return UnionDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class UnionDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    UnionDef_proxyObjectFactory () {}
    virtual ~UnionDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static UnionDef_ptr _nil() {
      if (!__nil_UnionDef) {
        __nil_UnionDef = new _nil_UnionDef;
      }
      return __nil_UnionDef;
    }
  private:
    static UnionDef_ptr __nil_UnionDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_UnionDef;

#ifndef __CORBA_mEnumDef__
#define __CORBA_mEnumDef__
  class   EnumDef;
  typedef EnumDef* EnumDef_ptr;
  typedef EnumDef_ptr EnumDefRef;

  class EnumDef_Helper {
    public:
    static EnumDef_ptr _nil();
    static CORBA::Boolean is_nil(EnumDef_ptr p);
    static void release(EnumDef_ptr p);
    static void duplicate(EnumDef_ptr p);
    static size_t NP_alignedSize(EnumDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(EnumDef_ptr obj,NetBufferedStream &s);
    static EnumDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(EnumDef_ptr obj,MemBufferedStream &s);
    static EnumDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<EnumDef,EnumDef_Helper> EnumDef_var;

#endif
#define CORBA_EnumDef_IntfRepoID "IDL:omg.org/CORBA/EnumDef:1.0"

  class EnumDef :  public virtual TypedefDef {
  public:

    virtual EnumMemberSeq* members() = 0;
    virtual void members(const EnumMemberSeq&) = 0;
    static EnumDef_ptr _duplicate(EnumDef_ptr);
    static EnumDef_ptr _narrow(CORBA::Object_ptr);
    static EnumDef_ptr _nil();

    static inline size_t NP_alignedSize(EnumDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_EnumDef_IntfRepoID,30,initialoffset);
    }

    static inline void marshalObjRef(EnumDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_EnumDef_IntfRepoID,30,s);
    }

    static inline EnumDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_EnumDef_IntfRepoID,s);
      EnumDef_ptr _result = CORBA::EnumDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(EnumDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_EnumDef_IntfRepoID,30,s);
    }

    static inline EnumDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_EnumDef_IntfRepoID,s);
      EnumDef_ptr _result = CORBA::EnumDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    EnumDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_EnumDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~EnumDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    EnumDef(const EnumDef&);
    EnumDef &operator=(const EnumDef&);
  };

  class _sk_EnumDef :  public virtual _sk_TypedefDef, public virtual EnumDef {
  public:

    _sk_EnumDef() {}
    _sk_EnumDef(const omniORB::objectKey& k);
    virtual ~_sk_EnumDef() {}
    EnumDef_ptr _this() { return EnumDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual EnumMemberSeq* members() = 0;
    virtual void members(const EnumMemberSeq&) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return EnumDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_EnumDef (const _sk_EnumDef&);
    _sk_EnumDef &operator=(const _sk_EnumDef&);
  };

  class _proxy_EnumDef :  public virtual _proxy_TypedefDef, public virtual EnumDef {
  public:

    _proxy_EnumDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_EnumDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_EnumDef() {}
    virtual EnumMemberSeq* members();
    virtual void members(const EnumMemberSeq&);

  protected:

    _proxy_EnumDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return EnumDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_EnumDef (const _proxy_EnumDef&);
    _proxy_EnumDef &operator=(const _proxy_EnumDef&);
  };

  class _nil_EnumDef :  public virtual _nil_TypedefDef,   public virtual EnumDef {
  public:
    _nil_EnumDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_EnumDef() {}
    EnumMemberSeq* members() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      EnumMemberSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void members(const EnumMemberSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return EnumDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class EnumDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    EnumDef_proxyObjectFactory () {}
    virtual ~EnumDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static EnumDef_ptr _nil() {
      if (!__nil_EnumDef) {
        __nil_EnumDef = new _nil_EnumDef;
      }
      return __nil_EnumDef;
    }
  private:
    static EnumDef_ptr __nil_EnumDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_EnumDef;

#ifndef __CORBA_mAliasDef__
#define __CORBA_mAliasDef__
  class   AliasDef;
  typedef AliasDef* AliasDef_ptr;
  typedef AliasDef_ptr AliasDefRef;

  class AliasDef_Helper {
    public:
    static AliasDef_ptr _nil();
    static CORBA::Boolean is_nil(AliasDef_ptr p);
    static void release(AliasDef_ptr p);
    static void duplicate(AliasDef_ptr p);
    static size_t NP_alignedSize(AliasDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(AliasDef_ptr obj,NetBufferedStream &s);
    static AliasDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(AliasDef_ptr obj,MemBufferedStream &s);
    static AliasDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<AliasDef,AliasDef_Helper> AliasDef_var;

#endif
#define CORBA_AliasDef_IntfRepoID "IDL:omg.org/CORBA/AliasDef:1.0"

  class AliasDef :  public virtual TypedefDef {
  public:

    virtual IDLType_ptr original_type_def() = 0;
    virtual void original_type_def(IDLType_ptr) = 0;
    static AliasDef_ptr _duplicate(AliasDef_ptr);
    static AliasDef_ptr _narrow(CORBA::Object_ptr);
    static AliasDef_ptr _nil();

    static inline size_t NP_alignedSize(AliasDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_AliasDef_IntfRepoID,31,initialoffset);
    }

    static inline void marshalObjRef(AliasDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_AliasDef_IntfRepoID,31,s);
    }

    static inline AliasDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_AliasDef_IntfRepoID,s);
      AliasDef_ptr _result = CORBA::AliasDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(AliasDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_AliasDef_IntfRepoID,31,s);
    }

    static inline AliasDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_AliasDef_IntfRepoID,s);
      AliasDef_ptr _result = CORBA::AliasDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    AliasDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_AliasDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~AliasDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    AliasDef(const AliasDef&);
    AliasDef &operator=(const AliasDef&);
  };

  class _sk_AliasDef :  public virtual _sk_TypedefDef, public virtual AliasDef {
  public:

    _sk_AliasDef() {}
    _sk_AliasDef(const omniORB::objectKey& k);
    virtual ~_sk_AliasDef() {}
    AliasDef_ptr _this() { return AliasDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual IDLType_ptr original_type_def() = 0;
    virtual void original_type_def(IDLType_ptr) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return AliasDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_AliasDef (const _sk_AliasDef&);
    _sk_AliasDef &operator=(const _sk_AliasDef&);
  };

  class _proxy_AliasDef :  public virtual _proxy_TypedefDef, public virtual AliasDef {
  public:

    _proxy_AliasDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_AliasDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_AliasDef() {}
    virtual IDLType_ptr original_type_def();
    virtual void original_type_def(IDLType_ptr);

  protected:

    _proxy_AliasDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return AliasDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_AliasDef (const _proxy_AliasDef&);
    _proxy_AliasDef &operator=(const _proxy_AliasDef&);
  };

  class _nil_AliasDef :  public virtual _nil_TypedefDef,   public virtual AliasDef {
  public:
    _nil_AliasDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_AliasDef() {}
    IDLType_ptr original_type_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void original_type_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return AliasDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class AliasDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    AliasDef_proxyObjectFactory () {}
    virtual ~AliasDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static AliasDef_ptr _nil() {
      if (!__nil_AliasDef) {
        __nil_AliasDef = new _nil_AliasDef;
      }
      return __nil_AliasDef;
    }
  private:
    static AliasDef_ptr __nil_AliasDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_AliasDef;

#ifndef __CORBA_mPrimitiveDef__
#define __CORBA_mPrimitiveDef__
  class   PrimitiveDef;
  typedef PrimitiveDef* PrimitiveDef_ptr;
  typedef PrimitiveDef_ptr PrimitiveDefRef;

  class PrimitiveDef_Helper {
    public:
    static PrimitiveDef_ptr _nil();
    static CORBA::Boolean is_nil(PrimitiveDef_ptr p);
    static void release(PrimitiveDef_ptr p);
    static void duplicate(PrimitiveDef_ptr p);
    static size_t NP_alignedSize(PrimitiveDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(PrimitiveDef_ptr obj,NetBufferedStream &s);
    static PrimitiveDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(PrimitiveDef_ptr obj,MemBufferedStream &s);
    static PrimitiveDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<PrimitiveDef,PrimitiveDef_Helper> PrimitiveDef_var;

#endif
#define CORBA_PrimitiveDef_IntfRepoID "IDL:omg.org/CORBA/PrimitiveDef:1.0"

  class PrimitiveDef :  public virtual IDLType {
  public:

    virtual PrimitiveKind kind() = 0;
    static PrimitiveDef_ptr _duplicate(PrimitiveDef_ptr);
    static PrimitiveDef_ptr _narrow(CORBA::Object_ptr);
    static PrimitiveDef_ptr _nil();

    static inline size_t NP_alignedSize(PrimitiveDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_PrimitiveDef_IntfRepoID,35,initialoffset);
    }

    static inline void marshalObjRef(PrimitiveDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_PrimitiveDef_IntfRepoID,35,s);
    }

    static inline PrimitiveDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_PrimitiveDef_IntfRepoID,s);
      PrimitiveDef_ptr _result = CORBA::PrimitiveDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(PrimitiveDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_PrimitiveDef_IntfRepoID,35,s);
    }

    static inline PrimitiveDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_PrimitiveDef_IntfRepoID,s);
      PrimitiveDef_ptr _result = CORBA::PrimitiveDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    PrimitiveDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_PrimitiveDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~PrimitiveDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    PrimitiveDef(const PrimitiveDef&);
    PrimitiveDef &operator=(const PrimitiveDef&);
  };

  class _sk_PrimitiveDef :  public virtual _sk_IDLType, public virtual PrimitiveDef {
  public:

    _sk_PrimitiveDef() {}
    _sk_PrimitiveDef(const omniORB::objectKey& k);
    virtual ~_sk_PrimitiveDef() {}
    PrimitiveDef_ptr _this() { return PrimitiveDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual PrimitiveKind kind() = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return PrimitiveDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_PrimitiveDef (const _sk_PrimitiveDef&);
    _sk_PrimitiveDef &operator=(const _sk_PrimitiveDef&);
  };

  class _proxy_PrimitiveDef :  public virtual _proxy_IDLType, public virtual PrimitiveDef {
  public:

    _proxy_PrimitiveDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_PrimitiveDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_PrimitiveDef() {}
    virtual PrimitiveKind kind();

  protected:

    _proxy_PrimitiveDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return PrimitiveDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_PrimitiveDef (const _proxy_PrimitiveDef&);
    _proxy_PrimitiveDef &operator=(const _proxy_PrimitiveDef&);
  };

  class _nil_PrimitiveDef :  public virtual _nil_IDLType,   public virtual PrimitiveDef {
  public:
    _nil_PrimitiveDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_PrimitiveDef() {}
    PrimitiveKind kind() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      PrimitiveKind _0RL_result = pk_null;
      return _0RL_result;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return PrimitiveDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class PrimitiveDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    PrimitiveDef_proxyObjectFactory () {}
    virtual ~PrimitiveDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static PrimitiveDef_ptr _nil() {
      if (!__nil_PrimitiveDef) {
        __nil_PrimitiveDef = new _nil_PrimitiveDef;
      }
      return __nil_PrimitiveDef;
    }
  private:
    static PrimitiveDef_ptr __nil_PrimitiveDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_PrimitiveDef;

#ifndef __CORBA_mStringDef__
#define __CORBA_mStringDef__
  class   StringDef;
  typedef StringDef* StringDef_ptr;
  typedef StringDef_ptr StringDefRef;

  class StringDef_Helper {
    public:
    static StringDef_ptr _nil();
    static CORBA::Boolean is_nil(StringDef_ptr p);
    static void release(StringDef_ptr p);
    static void duplicate(StringDef_ptr p);
    static size_t NP_alignedSize(StringDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(StringDef_ptr obj,NetBufferedStream &s);
    static StringDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(StringDef_ptr obj,MemBufferedStream &s);
    static StringDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<StringDef,StringDef_Helper> StringDef_var;

#endif
#define CORBA_StringDef_IntfRepoID "IDL:omg.org/CORBA/StringDef:1.0"

  class StringDef :  public virtual IDLType {
  public:

    virtual CORBA::ULong bound() = 0;
    virtual void bound(CORBA::ULong) = 0;
    static StringDef_ptr _duplicate(StringDef_ptr);
    static StringDef_ptr _narrow(CORBA::Object_ptr);
    static StringDef_ptr _nil();

    static inline size_t NP_alignedSize(StringDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_StringDef_IntfRepoID,32,initialoffset);
    }

    static inline void marshalObjRef(StringDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_StringDef_IntfRepoID,32,s);
    }

    static inline StringDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_StringDef_IntfRepoID,s);
      StringDef_ptr _result = CORBA::StringDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(StringDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_StringDef_IntfRepoID,32,s);
    }

    static inline StringDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_StringDef_IntfRepoID,s);
      StringDef_ptr _result = CORBA::StringDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    StringDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_StringDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~StringDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    StringDef(const StringDef&);
    StringDef &operator=(const StringDef&);
  };

  class _sk_StringDef :  public virtual _sk_IDLType, public virtual StringDef {
  public:

    _sk_StringDef() {}
    _sk_StringDef(const omniORB::objectKey& k);
    virtual ~_sk_StringDef() {}
    StringDef_ptr _this() { return StringDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::ULong bound() = 0;
    virtual void bound(CORBA::ULong) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return StringDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_StringDef (const _sk_StringDef&);
    _sk_StringDef &operator=(const _sk_StringDef&);
  };

  class _proxy_StringDef :  public virtual _proxy_IDLType, public virtual StringDef {
  public:

    _proxy_StringDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_StringDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_StringDef() {}
    virtual CORBA::ULong bound();
    virtual void bound(CORBA::ULong);

  protected:

    _proxy_StringDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return StringDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_StringDef (const _proxy_StringDef&);
    _proxy_StringDef &operator=(const _proxy_StringDef&);
  };

  class _nil_StringDef :  public virtual _nil_IDLType,   public virtual StringDef {
  public:
    _nil_StringDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_StringDef() {}
    CORBA::ULong bound() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::ULong _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void bound(CORBA::ULong _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return StringDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class StringDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    StringDef_proxyObjectFactory () {}
    virtual ~StringDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static StringDef_ptr _nil() {
      if (!__nil_StringDef) {
        __nil_StringDef = new _nil_StringDef;
      }
      return __nil_StringDef;
    }
  private:
    static StringDef_ptr __nil_StringDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_StringDef;

#ifndef __CORBA_mWstringDef__
#define __CORBA_mWstringDef__
  class   WstringDef;
  typedef WstringDef* WstringDef_ptr;
  typedef WstringDef_ptr WstringDefRef;

  class WstringDef_Helper {
    public:
    static WstringDef_ptr _nil();
    static CORBA::Boolean is_nil(WstringDef_ptr p);
    static void release(WstringDef_ptr p);
    static void duplicate(WstringDef_ptr p);
    static size_t NP_alignedSize(WstringDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(WstringDef_ptr obj,NetBufferedStream &s);
    static WstringDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(WstringDef_ptr obj,MemBufferedStream &s);
    static WstringDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<WstringDef,WstringDef_Helper> WstringDef_var;

#endif
#define CORBA_WstringDef_IntfRepoID "IDL:omg.org/CORBA/WstringDef:1.0"

  class WstringDef :  public virtual IDLType {
  public:

    virtual CORBA::ULong bound() = 0;
    virtual void bound(CORBA::ULong) = 0;
    static WstringDef_ptr _duplicate(WstringDef_ptr);
    static WstringDef_ptr _narrow(CORBA::Object_ptr);
    static WstringDef_ptr _nil();

    static inline size_t NP_alignedSize(WstringDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_WstringDef_IntfRepoID,33,initialoffset);
    }

    static inline void marshalObjRef(WstringDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_WstringDef_IntfRepoID,33,s);
    }

    static inline WstringDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_WstringDef_IntfRepoID,s);
      WstringDef_ptr _result = CORBA::WstringDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(WstringDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_WstringDef_IntfRepoID,33,s);
    }

    static inline WstringDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_WstringDef_IntfRepoID,s);
      WstringDef_ptr _result = CORBA::WstringDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    WstringDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_WstringDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~WstringDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    WstringDef(const WstringDef&);
    WstringDef &operator=(const WstringDef&);
  };

  class _sk_WstringDef :  public virtual _sk_IDLType, public virtual WstringDef {
  public:

    _sk_WstringDef() {}
    _sk_WstringDef(const omniORB::objectKey& k);
    virtual ~_sk_WstringDef() {}
    WstringDef_ptr _this() { return WstringDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::ULong bound() = 0;
    virtual void bound(CORBA::ULong) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return WstringDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_WstringDef (const _sk_WstringDef&);
    _sk_WstringDef &operator=(const _sk_WstringDef&);
  };

  class _proxy_WstringDef :  public virtual _proxy_IDLType, public virtual WstringDef {
  public:

    _proxy_WstringDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_WstringDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_WstringDef() {}
    virtual CORBA::ULong bound();
    virtual void bound(CORBA::ULong);

  protected:

    _proxy_WstringDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return WstringDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_WstringDef (const _proxy_WstringDef&);
    _proxy_WstringDef &operator=(const _proxy_WstringDef&);
  };

  class _nil_WstringDef :  public virtual _nil_IDLType,   public virtual WstringDef {
  public:
    _nil_WstringDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_WstringDef() {}
    CORBA::ULong bound() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::ULong _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void bound(CORBA::ULong _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return WstringDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class WstringDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    WstringDef_proxyObjectFactory () {}
    virtual ~WstringDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static WstringDef_ptr _nil() {
      if (!__nil_WstringDef) {
        __nil_WstringDef = new _nil_WstringDef;
      }
      return __nil_WstringDef;
    }
  private:
    static WstringDef_ptr __nil_WstringDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_WstringDef;

#ifndef __CORBA_mFixedDef__
#define __CORBA_mFixedDef__
  class   FixedDef;
  typedef FixedDef* FixedDef_ptr;
  typedef FixedDef_ptr FixedDefRef;

  class FixedDef_Helper {
    public:
    static FixedDef_ptr _nil();
    static CORBA::Boolean is_nil(FixedDef_ptr p);
    static void release(FixedDef_ptr p);
    static void duplicate(FixedDef_ptr p);
    static size_t NP_alignedSize(FixedDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(FixedDef_ptr obj,NetBufferedStream &s);
    static FixedDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(FixedDef_ptr obj,MemBufferedStream &s);
    static FixedDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<FixedDef,FixedDef_Helper> FixedDef_var;

#endif
#define CORBA_FixedDef_IntfRepoID "IDL:omg.org/CORBA/FixedDef:1.0"

  class FixedDef :  public virtual IDLType {
  public:

    virtual CORBA::UShort digits() = 0;
    virtual void digits(CORBA::UShort) = 0;
    virtual CORBA::Short scale() = 0;
    virtual void scale(CORBA::Short) = 0;
    static FixedDef_ptr _duplicate(FixedDef_ptr);
    static FixedDef_ptr _narrow(CORBA::Object_ptr);
    static FixedDef_ptr _nil();

    static inline size_t NP_alignedSize(FixedDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_FixedDef_IntfRepoID,31,initialoffset);
    }

    static inline void marshalObjRef(FixedDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_FixedDef_IntfRepoID,31,s);
    }

    static inline FixedDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_FixedDef_IntfRepoID,s);
      FixedDef_ptr _result = CORBA::FixedDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(FixedDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_FixedDef_IntfRepoID,31,s);
    }

    static inline FixedDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_FixedDef_IntfRepoID,s);
      FixedDef_ptr _result = CORBA::FixedDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    FixedDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_FixedDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~FixedDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    FixedDef(const FixedDef&);
    FixedDef &operator=(const FixedDef&);
  };

  class _sk_FixedDef :  public virtual _sk_IDLType, public virtual FixedDef {
  public:

    _sk_FixedDef() {}
    _sk_FixedDef(const omniORB::objectKey& k);
    virtual ~_sk_FixedDef() {}
    FixedDef_ptr _this() { return FixedDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::UShort digits() = 0;
    virtual void digits(CORBA::UShort) = 0;
    virtual CORBA::Short scale() = 0;
    virtual void scale(CORBA::Short) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return FixedDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_FixedDef (const _sk_FixedDef&);
    _sk_FixedDef &operator=(const _sk_FixedDef&);
  };

  class _proxy_FixedDef :  public virtual _proxy_IDLType, public virtual FixedDef {
  public:

    _proxy_FixedDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_FixedDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_FixedDef() {}
    virtual CORBA::UShort digits();
    virtual void digits(CORBA::UShort);
    virtual CORBA::Short scale();
    virtual void scale(CORBA::Short);

  protected:

    _proxy_FixedDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return FixedDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_FixedDef (const _proxy_FixedDef&);
    _proxy_FixedDef &operator=(const _proxy_FixedDef&);
  };

  class _nil_FixedDef :  public virtual _nil_IDLType,   public virtual FixedDef {
  public:
    _nil_FixedDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_FixedDef() {}
    CORBA::UShort digits() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::UShort _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void digits(CORBA::UShort _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    CORBA::Short scale() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::Short _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void scale(CORBA::Short _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return FixedDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class FixedDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    FixedDef_proxyObjectFactory () {}
    virtual ~FixedDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static FixedDef_ptr _nil() {
      if (!__nil_FixedDef) {
        __nil_FixedDef = new _nil_FixedDef;
      }
      return __nil_FixedDef;
    }
  private:
    static FixedDef_ptr __nil_FixedDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_FixedDef;

#ifndef __CORBA_mSequenceDef__
#define __CORBA_mSequenceDef__
  class   SequenceDef;
  typedef SequenceDef* SequenceDef_ptr;
  typedef SequenceDef_ptr SequenceDefRef;

  class SequenceDef_Helper {
    public:
    static SequenceDef_ptr _nil();
    static CORBA::Boolean is_nil(SequenceDef_ptr p);
    static void release(SequenceDef_ptr p);
    static void duplicate(SequenceDef_ptr p);
    static size_t NP_alignedSize(SequenceDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(SequenceDef_ptr obj,NetBufferedStream &s);
    static SequenceDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(SequenceDef_ptr obj,MemBufferedStream &s);
    static SequenceDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<SequenceDef,SequenceDef_Helper> SequenceDef_var;

#endif
#define CORBA_SequenceDef_IntfRepoID "IDL:omg.org/CORBA/SequenceDef:1.0"

  class SequenceDef :  public virtual IDLType {
  public:

    virtual CORBA::ULong bound() = 0;
    virtual void bound(CORBA::ULong) = 0;
    virtual CORBA::TypeCode_ptr element_type() = 0;
    virtual IDLType_ptr element_type_def() = 0;
    virtual void element_type_def(IDLType_ptr) = 0;
    static SequenceDef_ptr _duplicate(SequenceDef_ptr);
    static SequenceDef_ptr _narrow(CORBA::Object_ptr);
    static SequenceDef_ptr _nil();

    static inline size_t NP_alignedSize(SequenceDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_SequenceDef_IntfRepoID,34,initialoffset);
    }

    static inline void marshalObjRef(SequenceDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_SequenceDef_IntfRepoID,34,s);
    }

    static inline SequenceDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_SequenceDef_IntfRepoID,s);
      SequenceDef_ptr _result = CORBA::SequenceDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(SequenceDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_SequenceDef_IntfRepoID,34,s);
    }

    static inline SequenceDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_SequenceDef_IntfRepoID,s);
      SequenceDef_ptr _result = CORBA::SequenceDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    SequenceDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_SequenceDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~SequenceDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    SequenceDef(const SequenceDef&);
    SequenceDef &operator=(const SequenceDef&);
  };

  class _sk_SequenceDef :  public virtual _sk_IDLType, public virtual SequenceDef {
  public:

    _sk_SequenceDef() {}
    _sk_SequenceDef(const omniORB::objectKey& k);
    virtual ~_sk_SequenceDef() {}
    SequenceDef_ptr _this() { return SequenceDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::ULong bound() = 0;
    virtual void bound(CORBA::ULong) = 0;
    virtual CORBA::TypeCode_ptr element_type() = 0;
    virtual IDLType_ptr element_type_def() = 0;
    virtual void element_type_def(IDLType_ptr) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return SequenceDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_SequenceDef (const _sk_SequenceDef&);
    _sk_SequenceDef &operator=(const _sk_SequenceDef&);
  };

  class _proxy_SequenceDef :  public virtual _proxy_IDLType, public virtual SequenceDef {
  public:

    _proxy_SequenceDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_SequenceDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_SequenceDef() {}
    virtual CORBA::ULong bound();
    virtual void bound(CORBA::ULong);
    virtual CORBA::TypeCode_ptr element_type();
    virtual IDLType_ptr element_type_def();
    virtual void element_type_def(IDLType_ptr);

  protected:

    _proxy_SequenceDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return SequenceDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_SequenceDef (const _proxy_SequenceDef&);
    _proxy_SequenceDef &operator=(const _proxy_SequenceDef&);
  };

  class _nil_SequenceDef :  public virtual _nil_IDLType,   public virtual SequenceDef {
  public:
    _nil_SequenceDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_SequenceDef() {}
    CORBA::ULong bound() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::ULong _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void bound(CORBA::ULong _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    CORBA::TypeCode_ptr element_type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    IDLType_ptr element_type_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void element_type_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return SequenceDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class SequenceDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    SequenceDef_proxyObjectFactory () {}
    virtual ~SequenceDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static SequenceDef_ptr _nil() {
      if (!__nil_SequenceDef) {
        __nil_SequenceDef = new _nil_SequenceDef;
      }
      return __nil_SequenceDef;
    }
  private:
    static SequenceDef_ptr __nil_SequenceDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_SequenceDef;

#ifndef __CORBA_mArrayDef__
#define __CORBA_mArrayDef__
  class   ArrayDef;
  typedef ArrayDef* ArrayDef_ptr;
  typedef ArrayDef_ptr ArrayDefRef;

  class ArrayDef_Helper {
    public:
    static ArrayDef_ptr _nil();
    static CORBA::Boolean is_nil(ArrayDef_ptr p);
    static void release(ArrayDef_ptr p);
    static void duplicate(ArrayDef_ptr p);
    static size_t NP_alignedSize(ArrayDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ArrayDef_ptr obj,NetBufferedStream &s);
    static ArrayDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ArrayDef_ptr obj,MemBufferedStream &s);
    static ArrayDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ArrayDef,ArrayDef_Helper> ArrayDef_var;

#endif
#define CORBA_ArrayDef_IntfRepoID "IDL:omg.org/CORBA/ArrayDef:1.0"

  class ArrayDef :  public virtual IDLType {
  public:

    virtual CORBA::ULong length() = 0;
    virtual void length(CORBA::ULong) = 0;
    virtual CORBA::TypeCode_ptr element_type() = 0;
    virtual IDLType_ptr element_type_def() = 0;
    virtual void element_type_def(IDLType_ptr) = 0;
    static ArrayDef_ptr _duplicate(ArrayDef_ptr);
    static ArrayDef_ptr _narrow(CORBA::Object_ptr);
    static ArrayDef_ptr _nil();

    static inline size_t NP_alignedSize(ArrayDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_ArrayDef_IntfRepoID,31,initialoffset);
    }

    static inline void marshalObjRef(ArrayDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ArrayDef_IntfRepoID,31,s);
    }

    static inline ArrayDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ArrayDef_IntfRepoID,s);
      ArrayDef_ptr _result = CORBA::ArrayDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(ArrayDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ArrayDef_IntfRepoID,31,s);
    }

    static inline ArrayDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ArrayDef_IntfRepoID,s);
      ArrayDef_ptr _result = CORBA::ArrayDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    ArrayDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_ArrayDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~ArrayDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    ArrayDef(const ArrayDef&);
    ArrayDef &operator=(const ArrayDef&);
  };

  class _sk_ArrayDef :  public virtual _sk_IDLType, public virtual ArrayDef {
  public:

    _sk_ArrayDef() {}
    _sk_ArrayDef(const omniORB::objectKey& k);
    virtual ~_sk_ArrayDef() {}
    ArrayDef_ptr _this() { return ArrayDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::ULong length() = 0;
    virtual void length(CORBA::ULong) = 0;
    virtual CORBA::TypeCode_ptr element_type() = 0;
    virtual IDLType_ptr element_type_def() = 0;
    virtual void element_type_def(IDLType_ptr) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ArrayDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_ArrayDef (const _sk_ArrayDef&);
    _sk_ArrayDef &operator=(const _sk_ArrayDef&);
  };

  class _proxy_ArrayDef :  public virtual _proxy_IDLType, public virtual ArrayDef {
  public:

    _proxy_ArrayDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_ArrayDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_ArrayDef() {}
    virtual CORBA::ULong length();
    virtual void length(CORBA::ULong);
    virtual CORBA::TypeCode_ptr element_type();
    virtual IDLType_ptr element_type_def();
    virtual void element_type_def(IDLType_ptr);

  protected:

    _proxy_ArrayDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return ArrayDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_ArrayDef (const _proxy_ArrayDef&);
    _proxy_ArrayDef &operator=(const _proxy_ArrayDef&);
  };

  class _nil_ArrayDef :  public virtual _nil_IDLType,   public virtual ArrayDef {
  public:
    _nil_ArrayDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_ArrayDef() {}
    CORBA::ULong length() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::ULong _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void length(CORBA::ULong _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    CORBA::TypeCode_ptr element_type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    IDLType_ptr element_type_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void element_type_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ArrayDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class ArrayDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    ArrayDef_proxyObjectFactory () {}
    virtual ~ArrayDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static ArrayDef_ptr _nil() {
      if (!__nil_ArrayDef) {
        __nil_ArrayDef = new _nil_ArrayDef;
      }
      return __nil_ArrayDef;
    }
  private:
    static ArrayDef_ptr __nil_ArrayDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ArrayDef;

#ifndef __CORBA_mExceptionDef__
#define __CORBA_mExceptionDef__
  class   ExceptionDef;
  typedef ExceptionDef* ExceptionDef_ptr;
  typedef ExceptionDef_ptr ExceptionDefRef;

  class ExceptionDef_Helper {
    public:
    static ExceptionDef_ptr _nil();
    static CORBA::Boolean is_nil(ExceptionDef_ptr p);
    static void release(ExceptionDef_ptr p);
    static void duplicate(ExceptionDef_ptr p);
    static size_t NP_alignedSize(ExceptionDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(ExceptionDef_ptr obj,NetBufferedStream &s);
    static ExceptionDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(ExceptionDef_ptr obj,MemBufferedStream &s);
    static ExceptionDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<ExceptionDef,ExceptionDef_Helper> ExceptionDef_var;

#endif
#define CORBA_ExceptionDef_IntfRepoID "IDL:omg.org/CORBA/ExceptionDef:1.0"

  class ExceptionDef :  public virtual Contained, public virtual Container {
  public:

    virtual CORBA::TypeCode_ptr type() = 0;
    virtual StructMemberSeq* members() = 0;
    virtual void members(const StructMemberSeq&) = 0;
    static ExceptionDef_ptr _duplicate(ExceptionDef_ptr);
    static ExceptionDef_ptr _narrow(CORBA::Object_ptr);
    static ExceptionDef_ptr _nil();

    static inline size_t NP_alignedSize(ExceptionDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_ExceptionDef_IntfRepoID,35,initialoffset);
    }

    static inline void marshalObjRef(ExceptionDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ExceptionDef_IntfRepoID,35,s);
    }

    static inline ExceptionDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ExceptionDef_IntfRepoID,s);
      ExceptionDef_ptr _result = CORBA::ExceptionDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(ExceptionDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_ExceptionDef_IntfRepoID,35,s);
    }

    static inline ExceptionDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_ExceptionDef_IntfRepoID,s);
      ExceptionDef_ptr _result = CORBA::ExceptionDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    ExceptionDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_ExceptionDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~ExceptionDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    ExceptionDef(const ExceptionDef&);
    ExceptionDef &operator=(const ExceptionDef&);
  };

  class _sk_ExceptionDef :  public virtual _sk_Contained, public virtual _sk_Container, public virtual ExceptionDef {
  public:

    _sk_ExceptionDef() {}
    _sk_ExceptionDef(const omniORB::objectKey& k);
    virtual ~_sk_ExceptionDef() {}
    ExceptionDef_ptr _this() { return ExceptionDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::TypeCode_ptr type() = 0;
    virtual StructMemberSeq* members() = 0;
    virtual void members(const StructMemberSeq&) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ExceptionDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_ExceptionDef (const _sk_ExceptionDef&);
    _sk_ExceptionDef &operator=(const _sk_ExceptionDef&);
  };

  class _proxy_ExceptionDef :  public virtual _proxy_Contained, public virtual _proxy_Container, public virtual ExceptionDef {
  public:

    _proxy_ExceptionDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_ExceptionDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_ExceptionDef() {}
    virtual CORBA::TypeCode_ptr type();
    virtual StructMemberSeq* members();
    virtual void members(const StructMemberSeq&);

  protected:

    _proxy_ExceptionDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return ExceptionDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_ExceptionDef (const _proxy_ExceptionDef&);
    _proxy_ExceptionDef &operator=(const _proxy_ExceptionDef&);
  };

  class _nil_ExceptionDef :  public virtual _nil_Contained,  public virtual _nil_Container,   public virtual ExceptionDef {
  public:
    _nil_ExceptionDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_ExceptionDef() {}
    CORBA::TypeCode_ptr type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    StructMemberSeq* members() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      StructMemberSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void members(const StructMemberSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return ExceptionDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class ExceptionDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    ExceptionDef_proxyObjectFactory () {}
    virtual ~ExceptionDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static ExceptionDef_ptr _nil() {
      if (!__nil_ExceptionDef) {
        __nil_ExceptionDef = new _nil_ExceptionDef;
      }
      return __nil_ExceptionDef;
    }
  private:
    static ExceptionDef_ptr __nil_ExceptionDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ExceptionDef;

  struct ExceptionDescription {
    CORBA::String_member name;
    CORBA::String_member id;
    CORBA::String_member defined_in;
    CORBA::String_member version;
    CORBA::TypeCode_member type;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<ExceptionDescription> ExceptionDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ExceptionDescription;

  enum AttributeMode { ATTR_NORMAL, ATTR_READONLY };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_AttributeMode;

#ifndef __CORBA_mAttributeDef__
#define __CORBA_mAttributeDef__
  class   AttributeDef;
  typedef AttributeDef* AttributeDef_ptr;
  typedef AttributeDef_ptr AttributeDefRef;

  class AttributeDef_Helper {
    public:
    static AttributeDef_ptr _nil();
    static CORBA::Boolean is_nil(AttributeDef_ptr p);
    static void release(AttributeDef_ptr p);
    static void duplicate(AttributeDef_ptr p);
    static size_t NP_alignedSize(AttributeDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(AttributeDef_ptr obj,NetBufferedStream &s);
    static AttributeDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(AttributeDef_ptr obj,MemBufferedStream &s);
    static AttributeDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<AttributeDef,AttributeDef_Helper> AttributeDef_var;

#endif
#define CORBA_AttributeDef_IntfRepoID "IDL:omg.org/CORBA/AttributeDef:1.0"

  class AttributeDef :  public virtual Contained {
  public:

    virtual CORBA::TypeCode_ptr type() = 0;
    virtual IDLType_ptr type_def() = 0;
    virtual void type_def(IDLType_ptr) = 0;
    virtual AttributeMode mode() = 0;
    virtual void mode(AttributeMode) = 0;
    static AttributeDef_ptr _duplicate(AttributeDef_ptr);
    static AttributeDef_ptr _narrow(CORBA::Object_ptr);
    static AttributeDef_ptr _nil();

    static inline size_t NP_alignedSize(AttributeDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_AttributeDef_IntfRepoID,35,initialoffset);
    }

    static inline void marshalObjRef(AttributeDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_AttributeDef_IntfRepoID,35,s);
    }

    static inline AttributeDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_AttributeDef_IntfRepoID,s);
      AttributeDef_ptr _result = CORBA::AttributeDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(AttributeDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_AttributeDef_IntfRepoID,35,s);
    }

    static inline AttributeDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_AttributeDef_IntfRepoID,s);
      AttributeDef_ptr _result = CORBA::AttributeDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    AttributeDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_AttributeDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~AttributeDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    AttributeDef(const AttributeDef&);
    AttributeDef &operator=(const AttributeDef&);
  };

  class _sk_AttributeDef :  public virtual _sk_Contained, public virtual AttributeDef {
  public:

    _sk_AttributeDef() {}
    _sk_AttributeDef(const omniORB::objectKey& k);
    virtual ~_sk_AttributeDef() {}
    AttributeDef_ptr _this() { return AttributeDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::TypeCode_ptr type() = 0;
    virtual IDLType_ptr type_def() = 0;
    virtual void type_def(IDLType_ptr) = 0;
    virtual AttributeMode mode() = 0;
    virtual void mode(AttributeMode) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return AttributeDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_AttributeDef (const _sk_AttributeDef&);
    _sk_AttributeDef &operator=(const _sk_AttributeDef&);
  };

  class _proxy_AttributeDef :  public virtual _proxy_Contained, public virtual AttributeDef {
  public:

    _proxy_AttributeDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_AttributeDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_AttributeDef() {}
    virtual CORBA::TypeCode_ptr type();
    virtual IDLType_ptr type_def();
    virtual void type_def(IDLType_ptr);
    virtual AttributeMode mode();
    virtual void mode(AttributeMode);

  protected:

    _proxy_AttributeDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return AttributeDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_AttributeDef (const _proxy_AttributeDef&);
    _proxy_AttributeDef &operator=(const _proxy_AttributeDef&);
  };

  class _nil_AttributeDef :  public virtual _nil_Contained,   public virtual AttributeDef {
  public:
    _nil_AttributeDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_AttributeDef() {}
    CORBA::TypeCode_ptr type() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    IDLType_ptr type_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void type_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    AttributeMode mode() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      AttributeMode _0RL_result = ATTR_NORMAL;
      return _0RL_result;
#endif
    }

    void mode(AttributeMode _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return AttributeDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class AttributeDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    AttributeDef_proxyObjectFactory () {}
    virtual ~AttributeDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static AttributeDef_ptr _nil() {
      if (!__nil_AttributeDef) {
        __nil_AttributeDef = new _nil_AttributeDef;
      }
      return __nil_AttributeDef;
    }
  private:
    static AttributeDef_ptr __nil_AttributeDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_AttributeDef;

  struct AttributeDescription {
    CORBA::String_member name;
    CORBA::String_member id;
    CORBA::String_member defined_in;
    CORBA::String_member version;
    CORBA::TypeCode_member type;
    AttributeMode mode;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<AttributeDescription> AttributeDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_AttributeDescription;

  enum OperationMode { OP_NORMAL, OP_ONEWAY };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_OperationMode;

  enum ParameterMode { PARAM_IN, PARAM_OUT, PARAM_INOUT };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ParameterMode;

  struct ParameterDescription {
    CORBA::String_member name;
    CORBA::TypeCode_member type;
    _CORBA_ObjRef_Member<IDLType,IDLType_Helper> type_def;
    ParameterMode mode;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<ParameterDescription> ParameterDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ParameterDescription;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ParDescriptionSeq;
  typedef _CORBA_Unbounded_Sequence<ParameterDescription > ParDescriptionSeq;
  typedef _CORBA_Sequence_Var<ParDescriptionSeq, ParameterDescription > ParDescriptionSeq_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ContextIdentifier;
  typedef char* ContextIdentifier;
  typedef CORBA::String_var ContextIdentifier_var;
  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ContextIdSeq;
  typedef _CORBA_Unbounded_Sequence<CORBA::String_member > ContextIdSeq;
  typedef _CORBA_Sequence_Var<ContextIdSeq, CORBA::String_member > ContextIdSeq_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ExceptionDefSeq;
  typedef _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<ExceptionDef,ExceptionDef_Helper> > ExceptionDefSeq;
  typedef _CORBA_Sequence_Var<ExceptionDefSeq, _CORBA_ObjRef_Member<ExceptionDef,ExceptionDef_Helper> > ExceptionDefSeq_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_ExcDescriptionSeq;
  typedef _CORBA_Unbounded_Sequence<ExceptionDescription > ExcDescriptionSeq;
  typedef _CORBA_Sequence_Var<ExcDescriptionSeq, ExceptionDescription > ExcDescriptionSeq_var;

#ifndef __CORBA_mOperationDef__
#define __CORBA_mOperationDef__
  class   OperationDef;
  typedef OperationDef* OperationDef_ptr;
  typedef OperationDef_ptr OperationDefRef;

  class OperationDef_Helper {
    public:
    static OperationDef_ptr _nil();
    static CORBA::Boolean is_nil(OperationDef_ptr p);
    static void release(OperationDef_ptr p);
    static void duplicate(OperationDef_ptr p);
    static size_t NP_alignedSize(OperationDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(OperationDef_ptr obj,NetBufferedStream &s);
    static OperationDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(OperationDef_ptr obj,MemBufferedStream &s);
    static OperationDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<OperationDef,OperationDef_Helper> OperationDef_var;

#endif
#define CORBA_OperationDef_IntfRepoID "IDL:omg.org/CORBA/OperationDef:1.0"

  class OperationDef :  public virtual Contained {
  public:

    virtual CORBA::TypeCode_ptr result() = 0;
    virtual IDLType_ptr result_def() = 0;
    virtual void result_def(IDLType_ptr) = 0;
    virtual ParDescriptionSeq* params() = 0;
    virtual void params(const ParDescriptionSeq&) = 0;
    virtual OperationMode mode() = 0;
    virtual void mode(OperationMode) = 0;
    virtual ContextIdSeq* contexts() = 0;
    virtual void contexts(const ContextIdSeq&) = 0;
    virtual ExceptionDefSeq* exceptions() = 0;
    virtual void exceptions(const ExceptionDefSeq&) = 0;
    static OperationDef_ptr _duplicate(OperationDef_ptr);
    static OperationDef_ptr _narrow(CORBA::Object_ptr);
    static OperationDef_ptr _nil();

    static inline size_t NP_alignedSize(OperationDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_OperationDef_IntfRepoID,35,initialoffset);
    }

    static inline void marshalObjRef(OperationDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_OperationDef_IntfRepoID,35,s);
    }

    static inline OperationDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_OperationDef_IntfRepoID,s);
      OperationDef_ptr _result = CORBA::OperationDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(OperationDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_OperationDef_IntfRepoID,35,s);
    }

    static inline OperationDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_OperationDef_IntfRepoID,s);
      OperationDef_ptr _result = CORBA::OperationDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    OperationDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_OperationDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~OperationDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    OperationDef(const OperationDef&);
    OperationDef &operator=(const OperationDef&);
  };

  class _sk_OperationDef :  public virtual _sk_Contained, public virtual OperationDef {
  public:

    _sk_OperationDef() {}
    _sk_OperationDef(const omniORB::objectKey& k);
    virtual ~_sk_OperationDef() {}
    OperationDef_ptr _this() { return OperationDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::TypeCode_ptr result() = 0;
    virtual IDLType_ptr result_def() = 0;
    virtual void result_def(IDLType_ptr) = 0;
    virtual ParDescriptionSeq* params() = 0;
    virtual void params(const ParDescriptionSeq&) = 0;
    virtual OperationMode mode() = 0;
    virtual void mode(OperationMode) = 0;
    virtual ContextIdSeq* contexts() = 0;
    virtual void contexts(const ContextIdSeq&) = 0;
    virtual ExceptionDefSeq* exceptions() = 0;
    virtual void exceptions(const ExceptionDefSeq&) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return OperationDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_OperationDef (const _sk_OperationDef&);
    _sk_OperationDef &operator=(const _sk_OperationDef&);
  };

  class _proxy_OperationDef :  public virtual _proxy_Contained, public virtual OperationDef {
  public:

    _proxy_OperationDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_OperationDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_OperationDef() {}
    virtual CORBA::TypeCode_ptr result();
    virtual IDLType_ptr result_def();
    virtual void result_def(IDLType_ptr);
    virtual ParDescriptionSeq* params();
    virtual void params(const ParDescriptionSeq&);
    virtual OperationMode mode();
    virtual void mode(OperationMode);
    virtual ContextIdSeq* contexts();
    virtual void contexts(const ContextIdSeq&);
    virtual ExceptionDefSeq* exceptions();
    virtual void exceptions(const ExceptionDefSeq&);

  protected:

    _proxy_OperationDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return OperationDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_OperationDef (const _proxy_OperationDef&);
    _proxy_OperationDef &operator=(const _proxy_OperationDef&);
  };

  class _nil_OperationDef :  public virtual _nil_Contained,   public virtual OperationDef {
  public:
    _nil_OperationDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_OperationDef() {}
    CORBA::TypeCode_ptr result() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::TypeCode_ptr _0RL_result = CORBA::TypeCode::_nil();
      return _0RL_result;
#endif
    }

    IDLType_ptr result_def() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      IDLType_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void result_def(IDLType_ptr _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    ParDescriptionSeq* params() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ParDescriptionSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void params(const ParDescriptionSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    OperationMode mode() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      OperationMode _0RL_result = OP_NORMAL;
      return _0RL_result;
#endif
    }

    void mode(OperationMode _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    ContextIdSeq* contexts() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ContextIdSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void contexts(const ContextIdSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    ExceptionDefSeq* exceptions() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      ExceptionDefSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void exceptions(const ExceptionDefSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return OperationDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class OperationDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    OperationDef_proxyObjectFactory () {}
    virtual ~OperationDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static OperationDef_ptr _nil() {
      if (!__nil_OperationDef) {
        __nil_OperationDef = new _nil_OperationDef;
      }
      return __nil_OperationDef;
    }
  private:
    static OperationDef_ptr __nil_OperationDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_OperationDef;

  struct OperationDescription {
    CORBA::String_member name;
    CORBA::String_member id;
    CORBA::String_member defined_in;
    CORBA::String_member version;
    CORBA::TypeCode_member result;
    OperationMode mode;
    ContextIdSeq contexts;
    ParDescriptionSeq parameters;
    ExcDescriptionSeq exceptions;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<OperationDescription> OperationDescription_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_OperationDescription;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_RepositoryIdSeq;
  typedef _CORBA_Unbounded_Sequence<CORBA::String_member > RepositoryIdSeq;
  typedef _CORBA_Sequence_Var<RepositoryIdSeq, CORBA::String_member > RepositoryIdSeq_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_OpDescriptionSeq;
  typedef _CORBA_Unbounded_Sequence<OperationDescription > OpDescriptionSeq;
  typedef _CORBA_Sequence_Var<OpDescriptionSeq, OperationDescription > OpDescriptionSeq_var;

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_AttrDescriptionSeq;
  typedef _CORBA_Unbounded_Sequence<AttributeDescription > AttrDescriptionSeq;
  typedef _CORBA_Sequence_Var<AttrDescriptionSeq, AttributeDescription > AttrDescriptionSeq_var;

#ifndef __CORBA_mInterfaceDef__
#define __CORBA_mInterfaceDef__
  class   InterfaceDef;
  typedef InterfaceDef* InterfaceDef_ptr;
  typedef InterfaceDef_ptr InterfaceDefRef;

  class InterfaceDef_Helper {
    public:
    static InterfaceDef_ptr _nil();
    static CORBA::Boolean is_nil(InterfaceDef_ptr p);
    static void release(InterfaceDef_ptr p);
    static void duplicate(InterfaceDef_ptr p);
    static size_t NP_alignedSize(InterfaceDef_ptr obj,size_t initialoffset);
    static void marshalObjRef(InterfaceDef_ptr obj,NetBufferedStream &s);
    static InterfaceDef_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(InterfaceDef_ptr obj,MemBufferedStream &s);
    static InterfaceDef_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<InterfaceDef,InterfaceDef_Helper> InterfaceDef_var;

#endif
#define CORBA_InterfaceDef_IntfRepoID "IDL:omg.org/CORBA/InterfaceDef:1.0"

  class InterfaceDef :  public virtual Container, public virtual Contained, public virtual IDLType {
  public:

    struct FullInterfaceDescription {
      CORBA::String_member name;
      CORBA::String_member id;
      CORBA::String_member defined_in;
      CORBA::String_member version;
      OpDescriptionSeq operations;
      AttrDescriptionSeq attributes;
      RepositoryIdSeq base_interfaces;
      CORBA::TypeCode_member type;
      
      size_t NP_alignedSize(size_t initialoffset) const;
      void operator>>= (NetBufferedStream &) const;
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &) const;
      void operator<<= (MemBufferedStream &);
    };

    typedef _CORBA_ConstrType_Variable_Var<FullInterfaceDescription> FullInterfaceDescription_var;

    static _LC_attr const CORBA::TypeCode_ptr _tc_FullInterfaceDescription;

    struct InterfaceDescription {
      CORBA::String_member name;
      CORBA::String_member id;
      CORBA::String_member defined_in;
      CORBA::String_member version;
      RepositoryIdSeq base_interfaces;
      
      size_t NP_alignedSize(size_t initialoffset) const;
      void operator>>= (NetBufferedStream &) const;
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &) const;
      void operator<<= (MemBufferedStream &);
    };

    typedef _CORBA_ConstrType_Variable_Var<InterfaceDescription> InterfaceDescription_var;

    static _LC_attr const CORBA::TypeCode_ptr _tc_InterfaceDescription;

    virtual InterfaceDefSeq* base_interfaces() = 0;
    virtual void base_interfaces(const InterfaceDefSeq&) = 0;
    virtual CORBA::Boolean  is_a(const char*  interface_id) = 0;
    virtual FullInterfaceDescription * describe_interface() = 0;
    virtual AttributeDef_ptr  create_attribute(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, AttributeMode  mode) = 0;
    virtual OperationDef_ptr  create_operation(const char*  id, const char*  name, const char*  version, IDLType_ptr  result, OperationMode  mode, const ParDescriptionSeq & params, const ExceptionDefSeq & exceptions, const ContextIdSeq & contexts) = 0;
    static InterfaceDef_ptr _duplicate(InterfaceDef_ptr);
    static InterfaceDef_ptr _narrow(CORBA::Object_ptr);
    static InterfaceDef_ptr _nil();

    static inline size_t NP_alignedSize(InterfaceDef_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CORBA_InterfaceDef_IntfRepoID,35,initialoffset);
    }

    static inline void marshalObjRef(InterfaceDef_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_InterfaceDef_IntfRepoID,35,s);
    }

    static inline InterfaceDef_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_InterfaceDef_IntfRepoID,s);
      InterfaceDef_ptr _result = CORBA::InterfaceDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(InterfaceDef_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CORBA_InterfaceDef_IntfRepoID,35,s);
    }

    static inline InterfaceDef_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CORBA_InterfaceDef_IntfRepoID,s);
      InterfaceDef_ptr _result = CORBA::InterfaceDef::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    InterfaceDef() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CORBA_InterfaceDef_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~InterfaceDef() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    InterfaceDef(const InterfaceDef&);
    InterfaceDef &operator=(const InterfaceDef&);
  };

  class _sk_InterfaceDef :  public virtual _sk_Container, public virtual _sk_Contained, public virtual _sk_IDLType, public virtual InterfaceDef {
  public:

    _sk_InterfaceDef() {}
    _sk_InterfaceDef(const omniORB::objectKey& k);
    virtual ~_sk_InterfaceDef() {}
    InterfaceDef_ptr _this() { return InterfaceDef::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual InterfaceDefSeq* base_interfaces() = 0;
    virtual void base_interfaces(const InterfaceDefSeq&) = 0;
    virtual CORBA::Boolean  is_a(const char*  interface_id) = 0;
    virtual FullInterfaceDescription * describe_interface() = 0;
    virtual AttributeDef_ptr  create_attribute(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, AttributeMode  mode) = 0;
    virtual OperationDef_ptr  create_operation(const char*  id, const char*  name, const char*  version, IDLType_ptr  result, OperationMode  mode, const ParDescriptionSeq & params, const ExceptionDefSeq & exceptions, const ContextIdSeq & contexts) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return InterfaceDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_InterfaceDef (const _sk_InterfaceDef&);
    _sk_InterfaceDef &operator=(const _sk_InterfaceDef&);
  };

  class _proxy_InterfaceDef :  public virtual _proxy_Container, public virtual _proxy_Contained, public virtual _proxy_IDLType, public virtual InterfaceDef {
  public:

    _proxy_InterfaceDef (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CORBA_InterfaceDef_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_InterfaceDef() {}
    virtual InterfaceDefSeq* base_interfaces();
    virtual void base_interfaces(const InterfaceDefSeq&);
    virtual CORBA::Boolean  is_a(const char*  interface_id);
    virtual FullInterfaceDescription * describe_interface();
    virtual AttributeDef_ptr  create_attribute(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, AttributeMode  mode);
    virtual OperationDef_ptr  create_operation(const char*  id, const char*  name, const char*  version, IDLType_ptr  result, OperationMode  mode, const ParDescriptionSeq & params, const ExceptionDefSeq & exceptions, const ContextIdSeq & contexts);

  protected:

    _proxy_InterfaceDef () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return InterfaceDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_InterfaceDef (const _proxy_InterfaceDef&);
    _proxy_InterfaceDef &operator=(const _proxy_InterfaceDef&);
  };

  class _nil_InterfaceDef :  public virtual _nil_Container,  public virtual _nil_Contained,  public virtual _nil_IDLType,   public virtual InterfaceDef {
  public:
    _nil_InterfaceDef() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_InterfaceDef() {}
    InterfaceDefSeq* base_interfaces() {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      InterfaceDefSeq * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void base_interfaces(const InterfaceDefSeq& _value) {
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
    }

    CORBA::Boolean  is_a(const char*  interface_id){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::Boolean _0RL_result = 0;
      return _0RL_result;
#endif
    }

    FullInterfaceDescription * describe_interface(){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      FullInterfaceDescription * _0RL_result = 0;
      return _0RL_result;
#endif
    }

    AttributeDef_ptr  create_attribute(const char*  id, const char*  name, const char*  version, IDLType_ptr  type, AttributeMode  mode){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      AttributeDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    OperationDef_ptr  create_operation(const char*  id, const char*  name, const char*  version, IDLType_ptr  result, OperationMode  mode, const ParDescriptionSeq & params, const ExceptionDefSeq & exceptions, const ContextIdSeq & contexts){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      OperationDef_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return InterfaceDef::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class InterfaceDef_proxyObjectFactory : public proxyObjectFactory {
  public:
    InterfaceDef_proxyObjectFactory () {}
    virtual ~InterfaceDef_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static InterfaceDef_ptr _nil() {
      if (!__nil_InterfaceDef) {
        __nil_InterfaceDef = new _nil_InterfaceDef;
      }
      return __nil_InterfaceDef;
    }
  private:
    static InterfaceDef_ptr __nil_InterfaceDef;
  };

  _CORBA_MODULE_VAR const CORBA::TypeCode_ptr _tc_InterfaceDef;


_CORBA_MODULE_END

inline void operator >>=(CORBA::DefinitionKind _e, NetBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e, s);
}

inline void operator <<= (CORBA::DefinitionKind& _e, NetBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::dk_none:
    case CORBA::dk_all:
    case CORBA::dk_Attribute:
    case CORBA::dk_Constant:
    case CORBA::dk_Exception:
    case CORBA::dk_Interface:
    case CORBA::dk_Module:
    case CORBA::dk_Operation:
    case CORBA::dk_Typedef:
    case CORBA::dk_Alias:
    case CORBA::dk_Struct:
    case CORBA::dk_Union:
    case CORBA::dk_Enum:
    case CORBA::dk_Primitive:
    case CORBA::dk_String:
    case CORBA::dk_Sequence:
    case CORBA::dk_Array:
    case CORBA::dk_Repository:
    case CORBA::dk_Wstring:
    case CORBA::dk_Fixed:
      _e = (CORBA::DefinitionKind) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

inline void operator>>= (CORBA::DefinitionKind _e, MemBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e,s);
}

inline void operator<<= (CORBA::DefinitionKind& _e,MemBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::dk_none:
    case CORBA::dk_all:
    case CORBA::dk_Attribute:
    case CORBA::dk_Constant:
    case CORBA::dk_Exception:
    case CORBA::dk_Interface:
    case CORBA::dk_Module:
    case CORBA::dk_Operation:
    case CORBA::dk_Typedef:
    case CORBA::dk_Alias:
    case CORBA::dk_Struct:
    case CORBA::dk_Union:
    case CORBA::dk_Enum:
    case CORBA::dk_Primitive:
    case CORBA::dk_String:
    case CORBA::dk_Sequence:
    case CORBA::dk_Array:
    case CORBA::dk_Repository:
    case CORBA::dk_Wstring:
    case CORBA::dk_Fixed:
      _e = (CORBA::DefinitionKind) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

void operator<<=(CORBA::Any& _a, CORBA::DefinitionKind _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::DefinitionKind& _s);


void operator<<=(CORBA::Any& _a, CORBA::IRObject_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::IRObject_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::IRObject_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::Contained::Description& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::Contained::Description* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::Contained::Description*& _sp);


void operator<<=(CORBA::Any& _a, CORBA::Contained_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::Contained_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::Contained_ptr& _s);

#ifndef __0RL_seq_any_s0_cCORBA_mInterfaceDef__
#define __0RL_seq_any_s0_cCORBA_mInterfaceDef__
#define __0RL_seq_anyimpl_CORBA_mInterfaceDefSeq__
extern void _0RL_seq_anyinsert_CORBA_mInterfaceDefSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::InterfaceDef,CORBA::InterfaceDef_Helper> >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::InterfaceDef,CORBA::InterfaceDef_Helper> >& s)
{
  _0RL_seq_anyinsert_CORBA_mInterfaceDefSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::InterfaceDef,CORBA::InterfaceDef_Helper> >* sp)
{
  _0RL_seq_anyinsert_CORBA_mInterfaceDefSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mInterfaceDefSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::InterfaceDef,CORBA::InterfaceDef_Helper> >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::InterfaceDef,CORBA::InterfaceDef_Helper> >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mInterfaceDefSeq(a, sp);
}

#endif

#ifndef __0RL_seq_any_s0_cCORBA_mContained__
#define __0RL_seq_any_s0_cCORBA_mContained__
#define __0RL_seq_anyimpl_CORBA_mContainedSeq__
extern void _0RL_seq_anyinsert_CORBA_mContainedSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::Contained,CORBA::Contained_Helper> >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::Contained,CORBA::Contained_Helper> >& s)
{
  _0RL_seq_anyinsert_CORBA_mContainedSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::Contained,CORBA::Contained_Helper> >* sp)
{
  _0RL_seq_anyinsert_CORBA_mContainedSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mContainedSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::Contained,CORBA::Contained_Helper> >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::Contained,CORBA::Contained_Helper> >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mContainedSeq(a, sp);
}

#endif

extern void operator<<=(CORBA::Any& _a, const CORBA::Container::Description& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::Container::Description* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::Container::Description*& _sp);

#ifndef __0RL_seq_any_s0_cCORBA_mContainer_mDescription__
#define __0RL_seq_any_s0_cCORBA_mContainer_mDescription__
#define __0RL_seq_anyimpl_CORBA_mContainer_mDescriptionSeq__
extern void _0RL_seq_anyinsert_CORBA_mContainer_mDescriptionSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::Container::Description >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::Container::Description >& s)
{
  _0RL_seq_anyinsert_CORBA_mContainer_mDescriptionSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::Container::Description >* sp)
{
  _0RL_seq_anyinsert_CORBA_mContainer_mDescriptionSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mContainer_mDescriptionSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::Container::Description >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::Container::Description >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mContainer_mDescriptionSeq(a, sp);
}

#endif


void operator<<=(CORBA::Any& _a, CORBA::Container_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::Container_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::Container_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::IDLType_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::IDLType_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::IDLType_ptr& _s);

inline void operator >>=(CORBA::PrimitiveKind _e, NetBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e, s);
}

inline void operator <<= (CORBA::PrimitiveKind& _e, NetBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::pk_null:
    case CORBA::pk_void:
    case CORBA::pk_short:
    case CORBA::pk_long:
    case CORBA::pk_ushort:
    case CORBA::pk_ulong:
    case CORBA::pk_float:
    case CORBA::pk_double:
    case CORBA::pk_boolean:
    case CORBA::pk_char:
    case CORBA::pk_octet:
    case CORBA::pk_any:
    case CORBA::pk_TypeCode:
    case CORBA::pk_Principal:
    case CORBA::pk_string:
    case CORBA::pk_objref:
    case CORBA::pk_longlong:
    case CORBA::pk_ulonglong:
    case CORBA::pk_longdouble:
    case CORBA::pk_wchar:
    case CORBA::pk_wstring:
      _e = (CORBA::PrimitiveKind) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

inline void operator>>= (CORBA::PrimitiveKind _e, MemBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e,s);
}

inline void operator<<= (CORBA::PrimitiveKind& _e,MemBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::pk_null:
    case CORBA::pk_void:
    case CORBA::pk_short:
    case CORBA::pk_long:
    case CORBA::pk_ushort:
    case CORBA::pk_ulong:
    case CORBA::pk_float:
    case CORBA::pk_double:
    case CORBA::pk_boolean:
    case CORBA::pk_char:
    case CORBA::pk_octet:
    case CORBA::pk_any:
    case CORBA::pk_TypeCode:
    case CORBA::pk_Principal:
    case CORBA::pk_string:
    case CORBA::pk_objref:
    case CORBA::pk_longlong:
    case CORBA::pk_ulonglong:
    case CORBA::pk_longdouble:
    case CORBA::pk_wchar:
    case CORBA::pk_wstring:
      _e = (CORBA::PrimitiveKind) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

void operator<<=(CORBA::Any& _a, CORBA::PrimitiveKind _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::PrimitiveKind& _s);


void operator<<=(CORBA::Any& _a, CORBA::Repository_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::Repository_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::Repository_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::ModuleDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::ModuleDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ModuleDef_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::ModuleDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::ModuleDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ModuleDescription*& _sp);


void operator<<=(CORBA::Any& _a, CORBA::ConstantDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::ConstantDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ConstantDef_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::ConstantDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::ConstantDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ConstantDescription*& _sp);


void operator<<=(CORBA::Any& _a, CORBA::TypedefDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::TypedefDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::TypedefDef_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::TypeDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::TypeDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::TypeDescription*& _sp);


void operator<<=(CORBA::Any& _a, CORBA::StructDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::StructDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::StructDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::UnionDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::UnionDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::UnionDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::EnumDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::EnumDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::EnumDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::AliasDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::AliasDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::AliasDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::PrimitiveDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::PrimitiveDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::PrimitiveDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::StringDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::StringDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::StringDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::WstringDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::WstringDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::WstringDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::FixedDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::FixedDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::FixedDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::SequenceDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::SequenceDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::SequenceDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::ArrayDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::ArrayDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ArrayDef_ptr& _s);


void operator<<=(CORBA::Any& _a, CORBA::ExceptionDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::ExceptionDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ExceptionDef_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::ExceptionDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::ExceptionDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ExceptionDescription*& _sp);

inline void operator >>=(CORBA::AttributeMode _e, NetBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e, s);
}

inline void operator <<= (CORBA::AttributeMode& _e, NetBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::ATTR_NORMAL:
    case CORBA::ATTR_READONLY:
      _e = (CORBA::AttributeMode) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

inline void operator>>= (CORBA::AttributeMode _e, MemBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e,s);
}

inline void operator<<= (CORBA::AttributeMode& _e,MemBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::ATTR_NORMAL:
    case CORBA::ATTR_READONLY:
      _e = (CORBA::AttributeMode) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

void operator<<=(CORBA::Any& _a, CORBA::AttributeMode _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::AttributeMode& _s);


void operator<<=(CORBA::Any& _a, CORBA::AttributeDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::AttributeDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::AttributeDef_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::AttributeDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::AttributeDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::AttributeDescription*& _sp);

inline void operator >>=(CORBA::OperationMode _e, NetBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e, s);
}

inline void operator <<= (CORBA::OperationMode& _e, NetBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::OP_NORMAL:
    case CORBA::OP_ONEWAY:
      _e = (CORBA::OperationMode) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

inline void operator>>= (CORBA::OperationMode _e, MemBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e,s);
}

inline void operator<<= (CORBA::OperationMode& _e,MemBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::OP_NORMAL:
    case CORBA::OP_ONEWAY:
      _e = (CORBA::OperationMode) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

void operator<<=(CORBA::Any& _a, CORBA::OperationMode _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::OperationMode& _s);

inline void operator >>=(CORBA::ParameterMode _e, NetBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e, s);
}

inline void operator <<= (CORBA::ParameterMode& _e, NetBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::PARAM_IN:
    case CORBA::PARAM_OUT:
    case CORBA::PARAM_INOUT:
      _e = (CORBA::ParameterMode) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

inline void operator>>= (CORBA::ParameterMode _e, MemBufferedStream& s) {
  ::operator>>=((CORBA::ULong)_e,s);
}

inline void operator<<= (CORBA::ParameterMode& _e,MemBufferedStream& s) {
  CORBA::ULong _0RL_e;
  ::operator<<=(_0RL_e,s);
  switch (_0RL_e) {
    case CORBA::PARAM_IN:
    case CORBA::PARAM_OUT:
    case CORBA::PARAM_INOUT:
      _e = (CORBA::ParameterMode) _0RL_e;
      break;
    default:
      _CORBA_marshal_error();
  }
}

void operator<<=(CORBA::Any& _a, CORBA::ParameterMode _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ParameterMode& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::ParameterDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::ParameterDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::ParameterDescription*& _sp);

#ifndef __0RL_seq_any_s0_cCORBA_mParameterDescription__
#define __0RL_seq_any_s0_cCORBA_mParameterDescription__
#define __0RL_seq_anyimpl_CORBA_mParDescriptionSeq__
extern void _0RL_seq_anyinsert_CORBA_mParDescriptionSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::ParameterDescription >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::ParameterDescription >& s)
{
  _0RL_seq_anyinsert_CORBA_mParDescriptionSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::ParameterDescription >* sp)
{
  _0RL_seq_anyinsert_CORBA_mParDescriptionSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mParDescriptionSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::ParameterDescription >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::ParameterDescription >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mParDescriptionSeq(a, sp);
}

#endif

#ifndef __0RL_seq_any_s0_cstring__
#define __0RL_seq_any_s0_cstring__
#define __0RL_seq_anyimpl_CORBA_mContextIdSeq__
extern void _0RL_seq_anyinsert_CORBA_mContextIdSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::String_member >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::String_member >& s)
{
  _0RL_seq_anyinsert_CORBA_mContextIdSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::String_member >* sp)
{
  _0RL_seq_anyinsert_CORBA_mContextIdSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mContextIdSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::String_member >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::String_member >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mContextIdSeq(a, sp);
}

#endif

#ifndef __0RL_seq_any_s0_cCORBA_mExceptionDef__
#define __0RL_seq_any_s0_cCORBA_mExceptionDef__
#define __0RL_seq_anyimpl_CORBA_mExceptionDefSeq__
extern void _0RL_seq_anyinsert_CORBA_mExceptionDefSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::ExceptionDef,CORBA::ExceptionDef_Helper> >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::ExceptionDef,CORBA::ExceptionDef_Helper> >& s)
{
  _0RL_seq_anyinsert_CORBA_mExceptionDefSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::ExceptionDef,CORBA::ExceptionDef_Helper> >* sp)
{
  _0RL_seq_anyinsert_CORBA_mExceptionDefSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mExceptionDefSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::ExceptionDef,CORBA::ExceptionDef_Helper> >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<_CORBA_ObjRef_Member<CORBA::ExceptionDef,CORBA::ExceptionDef_Helper> >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mExceptionDefSeq(a, sp);
}

#endif

#ifndef __0RL_seq_any_s0_cCORBA_mExceptionDescription__
#define __0RL_seq_any_s0_cCORBA_mExceptionDescription__
#define __0RL_seq_anyimpl_CORBA_mExcDescriptionSeq__
extern void _0RL_seq_anyinsert_CORBA_mExcDescriptionSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::ExceptionDescription >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::ExceptionDescription >& s)
{
  _0RL_seq_anyinsert_CORBA_mExcDescriptionSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::ExceptionDescription >* sp)
{
  _0RL_seq_anyinsert_CORBA_mExcDescriptionSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mExcDescriptionSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::ExceptionDescription >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::ExceptionDescription >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mExcDescriptionSeq(a, sp);
}

#endif


void operator<<=(CORBA::Any& _a, CORBA::OperationDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::OperationDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::OperationDef_ptr& _s);

extern void operator<<=(CORBA::Any& _a, const CORBA::OperationDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::OperationDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::OperationDescription*& _sp);

#ifndef __0RL_seq_any_s0_cstring__
#define __0RL_seq_any_s0_cstring__
#define __0RL_seq_anyimpl_CORBA_mRepositoryIdSeq__
extern void _0RL_seq_anyinsert_CORBA_mRepositoryIdSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::String_member >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::String_member >& s)
{
  _0RL_seq_anyinsert_CORBA_mRepositoryIdSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::String_member >* sp)
{
  _0RL_seq_anyinsert_CORBA_mRepositoryIdSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mRepositoryIdSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::String_member >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::String_member >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mRepositoryIdSeq(a, sp);
}

#endif

#ifndef __0RL_seq_any_s0_cCORBA_mOperationDescription__
#define __0RL_seq_any_s0_cCORBA_mOperationDescription__
#define __0RL_seq_anyimpl_CORBA_mOpDescriptionSeq__
extern void _0RL_seq_anyinsert_CORBA_mOpDescriptionSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::OperationDescription >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::OperationDescription >& s)
{
  _0RL_seq_anyinsert_CORBA_mOpDescriptionSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::OperationDescription >* sp)
{
  _0RL_seq_anyinsert_CORBA_mOpDescriptionSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mOpDescriptionSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::OperationDescription >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::OperationDescription >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mOpDescriptionSeq(a, sp);
}

#endif

#ifndef __0RL_seq_any_s0_cCORBA_mAttributeDescription__
#define __0RL_seq_any_s0_cCORBA_mAttributeDescription__
#define __0RL_seq_anyimpl_CORBA_mAttrDescriptionSeq__
extern void _0RL_seq_anyinsert_CORBA_mAttrDescriptionSeq(CORBA::Any&, const _CORBA_Unbounded_Sequence<CORBA::AttributeDescription >&);

inline void operator<<=(CORBA::Any& a, const _CORBA_Unbounded_Sequence<CORBA::AttributeDescription >& s)
{
  _0RL_seq_anyinsert_CORBA_mAttrDescriptionSeq(a, s);
}

inline void operator<<=(CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::AttributeDescription >* sp)
{
  _0RL_seq_anyinsert_CORBA_mAttrDescriptionSeq(a, *sp);
  delete sp;
}

extern CORBA::Boolean _0RL_seq_anyextract_CORBA_mAttrDescriptionSeq(const CORBA::Any&, _CORBA_Unbounded_Sequence<CORBA::AttributeDescription >*&);

inline CORBA::Boolean operator>>=(const CORBA::Any& a, _CORBA_Unbounded_Sequence<CORBA::AttributeDescription >*& sp)
{
  return _0RL_seq_anyextract_CORBA_mAttrDescriptionSeq(a, sp);
}

#endif

extern void operator<<=(CORBA::Any& _a, const CORBA::InterfaceDef::FullInterfaceDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::InterfaceDef::FullInterfaceDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::InterfaceDef::FullInterfaceDescription*& _sp);

extern void operator<<=(CORBA::Any& _a, const CORBA::InterfaceDef::InterfaceDescription& _s);
extern void operator<<=(CORBA::Any& _a, CORBA::InterfaceDef::InterfaceDescription* _sp);
extern CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::InterfaceDef::InterfaceDescription*& _sp);


void operator<<=(CORBA::Any& _a, CORBA::InterfaceDef_ptr _s);
void operator<<=(CORBA::Any& _a, CORBA::InterfaceDef_ptr* _s);
CORBA::Boolean operator>>=(const CORBA::Any& _a, CORBA::InterfaceDef_ptr& _s);


#undef _LC_attr

#endif // __ir_hh__
