################################################################################
# [.src.lib.omniORB2]dir.mms
################################################################################

CONFIG_DEFAULT_LOCATION = omniCFG:omniORB.cfg

DIR_CPPMACROS = "CONFIG_DEFAULT_LOCATION=""$(CONFIG_DEFAULT_LOCATION)""",\
"USE_omniORB_logStream"
  
# search local directory first for include file to avoid superfluous builds:
.ifdef cxx6
DIR_CPPFLAGS = /Nested_include=primary/Quiet
.else
DIR_CPPFLAGS = /Nested_include=primary
.endif

################################################################################
# MMS initiali[sz]ation
################################################################################

.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) relStream .obj .cc
	@ $(CreateMms) tcpSocket .obj .cc
	@ $(CreateMms) tcpSocketMTfactory .obj .cc
	@ $(CreateMms) constants .obj .cc
	@ $(CreateMms) corbaBoa .obj .cc
	@ $(CreateMms) corbaObject .obj .cc
	@ $(CreateMms) corbaOrb .obj .cc
	@ $(CreateMms) corbaString .obj .cc
	@ $(CreateMms) exception .obj .cc
	@ $(CreateMms) giopClient .obj .cc
	@ $(CreateMms) giopServer .obj .cc
	@ $(CreateMms) initFile .obj .cc
	@ $(CreateMms) ior .obj .cc
	@ $(CreateMms) libcWrapper .obj .cc
	@ $(CreateMms) mbufferedStream .obj .cc
	@ $(CreateMms) nbufferedStream .obj .cc
	@ $(CreateMms) object .obj .cc
	@ $(CreateMms) objectKey .obj .cc
	@ $(CreateMms) objectRef .obj .cc
	@ $(CreateMms) ropeFactory .obj .cc
	@ $(CreateMms) strand .obj .cc
	@ $(CreateMms) scavenger .obj .cc
	@ $(CreateMms) bootstrapSk .obj .cc
	@ $(CreateMms) bootstrap_i .obj .cc
	@ $(CreateMms) NamingSK .obj .cc
	@ $(CreateMms) omniLifeCycle .obj .cc
	@ $(CreateMms) omniLifeCycleSK .obj .cc
	@ $(CreateMms) reDirect .obj .cc
	@ $(CreateMms) typecode .obj .cc
	@ $(CreateMms) any .obj .cc
	@ $(CreateMms) tcParseEngine .obj .cc
	@ $(CreateMms) dynAny .obj .cc
	@ $(CreateMms) dynAnyP .obj .cc
	@ $(CreateMms) logIOstream .obj .cc
	@ $(CreateMms) corbaDFloat .obj .cc corbaFloat
	@ $(CreateMms) corbaGFloat .obj .cc corbaFloat
	@ $(CreateMms) corbaIEEEFloat .obj .cc corbaFloat

################################################################################
# all rule
################################################################################

.else

lib = omniORB2$(DebugSuffix).olb
lclib = omniLC$(DebugSuffix).olb
DFloatLib = omniORB2DFloat$(DebugSuffix).olb
GFloatLib = omniORB2GFloat$(DebugSuffix).olb

.IFDEF ALPHA
IEEEFloatLib = omniORB2IEEEFloat$(DebugSuffix).olb
.ENDIF

NETLIBOBJS = $(lib)(relStream) \
	$(lib)(tcpSocket) \
	$(lib)(tcpSocketMTfactory) \
	$(lib)(gatekeeper.obj)

# apparently, the compiler uses the source file name in identifying the module
# name rather than the object file name:

DFLOAT_OBJS = $(DFloatLib)(corbaFloat=corbaDFloat.obj)
GFLOAT_OBJS = $(GFloatLib)(corbaFloat=corbaGFloat.obj)

.IFDEF ALPHA
IEEEFLOAT_OBJS = $(IEEEFloatLib)(corbaFloat=corbaIEEEFloat.obj)
.ENDIF

ORB2_OBJS = $(NETLIBOBJS) \
	$(lib)(constants) \
	$(lib)(corbaBoa) \
	$(lib)(corbaObject) \
	$(lib)(corbaOrb) \
	$(lib)(corbaString) \
	$(lib)(exception) \
	$(lib)(giopClient) \
	$(lib)(giopServer) \
	$(lib)(initFile) \
	$(lib)(ior) \
	$(lib)(libcWrapper) \
	$(lib)(mbufferedStream) \
	$(lib)(nbufferedStream) \
	$(lib)(object) \
	$(lib)(objectKey) \
	$(lib)(objectRef) \
	$(lib)(ropeFactory) \
	$(lib)(strand) \
	$(lib)(scavenger) \
	$(lib)(NamingSK) \
	$(lib)(bootstrapSK) \
	$(lib)(bootstrap_i) \
	$(lib)(typecode) \
	$(lib)(any) \
	$(lib)(tcParseEngine) \
	$(lib)(dynAny) \
	$(lib)(dynAnyP) \
	$(lib)(logIOstream)

LC_OBJS = $(lclib)(omniLifeCycle) $(lclib)(reDirect) $(lclib)(omniLifeCycleSK)

# put dependency on the idl headers first to force the idl compiles to occur
# first.

.ifdef ALPHA
all ::	Naming.hh bootstrap.hh omniLifeCycle.hh $(ORB2_OBJS) $(LC_OBJS) \
$(DFLOAT_OBJS) $(GFLOAT_OBJS) $(IEEEFLOAT_OBJS)
.else
all ::	Naming.hh bootstrap.hh omniLifeCycle.hh $(ORB2_OBJS) $(LC_OBJS) \
$(DFLOAT_OBJS) $(GFLOAT_OBJS)
.endif
  
Naming.hh, NamingSK.cc : Naming.idl
	omniidl2 -a "Naming.idl"
  
bootstrap.hh, bootstrapSK.cc : bootstrap.idl
	omniidl2 -a "bootstrap.idl"

omniLifeCycle.hh, omniLifeCycleSK.cc : omniLifeCycle.idl
	omniidl2 -a "omniLifeCycle.idl"

.include relStream.mms
.include tcpSocket.mms
.include tcpSocketMTfactory.mms
.include constants.mms
.include corbaBoa.mms
.include corbaObject.mms
.include corbaOrb.mms
.include corbaString.mms
.include exception.mms
.include giopClient.mms
.include giopServer.mms
.include initFile.mms
.include ior.mms
.include libcWrapper.mms
.include mbufferedStream.mms
.include nbufferedStream.mms
.include object.mms
.include objectKey.mms
.include objectRef.mms
.include ropeFactory.mms
.include strand.mms
.include scavenger.mms
.include NamingSK.mms
.include bootstrapSK.mms
.include bootstrap_i.mms
.include typecode.mms
.include any.mms
.include tcParseEngine.mms
.include dynAny.mms
.include dynAnyP.mms
.include logIOstream.mms
.include corbaDFloat.mms
.include corbaGFloat.mms
.include corbaIEEEFloat.mms

# see comments under Win32Platform in dir.mk

gatekeeper.obj : [.gatekeepers.dummystub]gatekeeper.cc

################################################################################
# export rule
################################################################################

export :: all

export :: $(lib)
	@ $(ExportLibrary)

export :: $(lclib)
	@ $(ExportLibrary)

export :: $(DFloatLib)
	@ $(ExportLibrary)

export :: $(GFloatLib)
	@ $(ExportLibrary)

.IFDEF ALPHA
export :: $(IEEEFloatLib)
	@ $(ExportLibrary)
.ENDIF

BOOTSTRAP_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]bootstrap.hh
NAMING_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]Naming.hh
LIFECYCLE_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]omniLifeCycle.hh
export :: $(NAMING_HDR) $(BOOTSTRAP_HDR) $(LIFECYCLE_HDR)

$(BOOTSTRAP_HDR) : bootstrap.hh
	$(ExportHeader)

$(NAMING_HDR) : naming.hh
	$(ExportHeader)

$(LIFECYCLE_HDR) : omniLifeCycle.hh
	$(ExportHeader)

clean ::
	$(RM) $(lib) NamingSK.cc bootstrapSK.cc omniLifeCycleSK.cc

corbaDFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=D_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS

corbaGFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=G_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS

.ifdef ALPHA
corbaIEEEFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=IEEE_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS
.endif
.endif
