// $Id: Weatherman.java,v 1.4 1998/01/21 20:32:44 bjh Exp $

/*
$Log: Weatherman.java,v $
# Revision 1.4  1998/01/21  20:32:44  bjh
# Modified for omniORB release.
# .
#
# Revision 1.3  1998/01/21  17:32:43  bjh
# Moved into UK.co.orl.weather.
#
# Revision 1.2  1997/09/05  15:25:06  bjh
# *** empty log message ***
#
# Revision 1.1  1997/09/02  15:08:44  bjh
# Initial revision
#
*/

package UK.co.orl.weather;
import java.applet.*;
import java.awt.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import java.util.Date;

public class Weatherman extends Applet {

  public Weatherman() {};
  /** This constructor is called by main when the weatherman is
   * running as as an application.  */
  public Weatherman(String[] args) {
    standalone = true;
    this.args = args;
    // Ooh!  Inner classes!  Of course, this means it won't compile
    // with JDK 1.0.2, but I can live with that.
    frame = new Frame("Java Weatherman") {
      public boolean handleEvent(Event evt) {
	switch (evt.id) {
	case Event.WINDOW_DESTROY:
	  stop();
	  destroy();
	  System.exit(0);
	  return true;
	default:
	  return super.handleEvent(evt);
	}
      }
    };
    frame.setLayout(new BorderLayout());
    frame.add("Center", this);
    frame.resize(860, 170);
    frame.show();
    init();
    start();
  }
  public void init(){

    // CORBA Initialisation.

    if (standalone) {
      orb = org.omg.CORBA.ORB.init(args, null);
    } else {
      orb = org.omg.CORBA.ORB.init(Weatherman.this,
				   new java.util.Properties());
    }
    /*    NamingContext ctx;
    try {
      org.omg.CORBA.Object initServ;
      try {
	initServ = orb.resolve_initial_references("NameService");
      } catch (org.omg.CORBA.COMM_FAILURE x) {
	if (x.minor == 6)
	  // We probably haven't got a bootstrap server running.  Try
	  // doing what omniORB would do...
	  initServ =
	    UK.co.orl.omniorb.OmniOrbConfig.
	    resolve_omniorb_initial_references("NameService",
					       orb);
	else
	  throw x.fillInStackTrace();
      }
      System.err.println("Got IOR " + orb.object_to_string(initServ));
      ctx = NamingContextHelper.narrow(initServ);
    } catch (org.omg.CORBA.ORBPackage.InvalidName x) {
      System.err.println("Service required is invalid [does not exist].");
      if (standalone) System.exit(1);      
      return;
    } catch (Throwable x) {
      System.err.println("Caught a system exception finding the name " +
			 "service:");
      System.err.println(x);
      if (standalone) System.exit(1);
      return;
    }
    NameComponent[] name = {
      new NameComponent("project", ""),
      new NameComponent("misc", ""),
      new NameComponent("weather", ""),
      new NameComponent("WeatherInfo", "Object")};
    try {
      wi = weatherInfoHelper.narrow(ctx.resolve(name));
    } catch (org.omg.CORBA.UserException x) {
      System.err.println("Problem resolving or narrowing name:");
      System.err.println(x);
      if (standalone) System.exit(1);
      return;
    }*/
    wi = weatherInfoHelper.narrow(orb.string_to_object(args[0]));


    // Display initialisation.

    setBackground(Color.cyan);
    setLayout(new BorderLayout());
    {
      Label title = new Label("ORL Rooftop Weather Readings", Label.CENTER);
      Font currentFont = title.getFont();
      title.setFont(new Font("Helvetica", // I'd like to get the current font
			     Font.BOLD,   // and just turn it bold, but that
			     12));        // causes the AWT runtime to die.
      add("North", title);
    }
    {
      Panel dials;
      add("Center", dials = new Panel());
      dials.setFont(new Font("Helvetica", Font.PLAIN, 10));
      dials.add(clock         = new Clock(Color.red));
      dials.add(tempGauge     = new Gauge(-10,   35, 1, 10,
					  "Temp", "\u00B0C", Color.red));
      dials.add(pressGauge    = new Gauge(950, 1050, 5, 50,
					  "Pressure", "mB",
					  new Color(0xdd, 0xa0, 0xdd)));
      dials.add(humidGauge    = new Gauge(  0,  100, 5, 50, "Humidity", "%",
					  Color.cyan.darker()));
      dials.add(dewpointGauge = new Gauge(-10,   30, 1, 10,
					  "Dew point", "\u00B0C",
					  Color.cyan.darker()));
      dials.add(wdirGauge     = new Compass("Wind Direction", Color.green));
      dials.add(wspdGauge     = new Gauge(  0,  100, 5, 50,
					  "Wind speed", "knots",
					  Color.orange));
      dials.add(sunGauge      = new Gauge(  0,   24, 1, 12, "Sun", "hours",
					  Color.yellow));
      dials.add(rainGauge     = new Gauge(  0,  100, 5, 50, "Rain", "mm",
					  Color.cyan.darker()));
    }
  }
  public void start() {
    // Hmm.  Shall I make this an inner class too?  I like inner
    // classes.
    if (wi != null) {
      thing = new Thread(new Runnable() {
	public void run() {
	  for (;;) {
	    immediateWeatherInfo now = wi.immediate();
	    tempGauge.setValue(now.temperature);
	    pressGauge.setValue(now.pressure);
	    humidGauge.setValue(now.humidity);
	    dewpointGauge.setValue(now.dewpoint);
	    wdirGauge.setValue(now.windDirection);
	    wspdGauge.setValue(now.windSpeed);
	    cumulativeWeatherInfo sofar = wi.cumulative();
	    clock.setValue(new Date((long)sofar.end * 1000));
	    sunGauge.setValue(sofar.sunshine);
	    rainGauge.setValue(sofar.rainfall);
	    try {Thread.sleep(3000);} catch (InterruptedException x) {}
	  }
	}
      } , "Poller");
      thing.start();
    }
  }
  public void stop() {
    if (thing != null) {
      thing.stop();
    }
  }
  public String[][] getParameterInfo() {
    String[][] pinfo = {
      {"defaultContext", "ior", "The IOR of the default naming context"}
    };
    return pinfo;
  }
  public String getAppletInfo() {
    return "Java Weatherman $Revision: 1.4 $\n" +
      "Copyright \u00A9 Olivetti and Oracle Research Laboratory, 1997";
  }
  public static void main(String[] args) {
    Weatherman me = new Weatherman(args);
  }

  boolean standalone = false; // Are we running as an application?
  String[] args; // Command-line arguments in standalone mode.
  Frame frame; // Our frame in standalone mode.
  org.omg.CORBA.ORB orb; // Our ORB.
  weatherInfo wi; // The server.
  Clock clock;
  Gauge tempGauge;  // The various gauges.
  Gauge pressGauge;
  Gauge humidGauge;
  Gauge dewpointGauge;
  Gauge wdirGauge;
  Gauge wspdGauge;
  Gauge sunGauge;
  Gauge rainGauge;
  Thread thing; // The poller thread.
}


  
