// $Id: Gauge.java,v 1.2 1998/01/21 17:31:19 bjh Exp $

/*
$Log: Gauge.java,v $
# Revision 1.2  1998/01/21  17:31:19  bjh
# Moved into UK.co.orl.weather.
#
# Revision 1.1  1997/09/02  15:08:26  bjh
# Initial revision
#
*/

// Gauge.java -- a general class for drawing dials.

package UK.co.orl.weather;

import java.awt.*;

public class Gauge extends Dial {
  public Gauge(float min, float max, float tick, float label, 
	       String title, String units, Color pointerColor) {
    this.minValue = min;
    this.maxValue = max;
    this.tickEvery = tick;
    this.labelEvery = label;
    this.title = title;
    this.unit = units;
    this.pointerAngle = new float[1];
    this.pointerAngle[0] = angle(0);
    this.pointerColor = new Color[1];
    this.pointerColor[0] = pointerColor;
    this.pointerStyle = new Pointer[1];
    this.pointerStyle[0] = new TrianglePointer();
  }

  public void setValue(float newValue) {
    if (currentValue != newValue) {
      currentValue = newValue;
      pointerAngle[0] = angle(newValue);
      repaint();
    }
  }

  public void paint(Graphics g) {
    super.paint(g);
    ticks(g, tickEvery, tickLength, false);
    ticks(g, labelEvery, labelTickLength, true);
    centreText(g, currentValue + " " + unit, new Point(0,(int)(radius * numPos)));
    centreText(g, title, new Point(0, (int)(radius * titlePos)));
  }

  protected void ticks (Graphics g, float every, int len, boolean label) {
    int firstTick = (int)Math.ceil(minValue / every);
    int lastTick = (int)Math.floor(maxValue / every);
    for (int i = firstTick; i <= lastTick; i++) {
      tick(g, radius, angle(i * every), len);
      if (label) {
	centreText(g, this.getLabel(i*every),
		   polar(radius - labelIndent, angle(i * every)));
      }
    }
  }

  protected String getLabel(float value) {
    if (labelEvery >= 1)
      return Integer.toString((int)value);
    else
      return Float.toString(value);
  }
      
  protected float angle(float value) {
    value = Math.max(value, minValue);
    value = Math.min(value, maxValue);
    return startAngle - (value-minValue) / (maxValue-minValue) * angleRange;
  }

  protected float currentValue;
  protected float minValue = 0;
  protected float maxValue = 100;
  protected float tickEvery = 5;
  protected int tickLength = 5;
  protected float labelEvery = 50;
  protected int labelTickLength = 7;
  protected int labelIndent = 15;
  protected String title;
  protected String unit;
  protected float startAngle = (float)(Math.PI * (7.0/6.0));
  protected float angleRange = (float)(Math.PI * (4.0/3.0));
  protected float titlePos = (float)-0.5;
  protected float numPos = (float)0.6;
}
