// $Id: Dial.java,v 1.2 1998/01/21 17:30:57 bjh Exp $

/*
$Log: Dial.java,v $
# Revision 1.2  1998/01/21  17:30:57  bjh
# Moved into UK.co.orl.weather.
#
# Revision 1.1  1997/09/02  15:08:34  bjh
# Initial revision
#
*/

// Dial.java -- a general class for drawing dials.

package UK.co.orl.weather;

import java.awt.*;

public class Dial extends Canvas {
  public Dial () {};

  public void paint (Graphics g) {
    g.translate(radius, radius);
    g.setColor(fillColor);
    g.fillOval(-radius, -radius,
	       radius*2, radius*2);
    g.setColor(getForeground());
    g.drawOval(-radius, -radius,
	       radius*2, radius*2);
    for (int i = 0; i < pointerAngle.length; i++) {
      g.setColor(pointerColor[i]);
      pointerStyle[i].paint(g, this.radius, this.pointerAngle[i]);
    }
    g.setColor(getForeground());
    g.fillOval(-hubRadius, -hubRadius,
	       hubRadius*2, hubRadius*2);
  }

  public Dimension preferredSize() {
    return new Dimension(radius*2+1, radius*2+1);
  }

  public void update(Graphics g) {
    // No need to clear background since the fill colour will splat whatever
    // was there before anyway.
    g.setColor(getForeground());
    paint(g);
  }

  protected void pointer(Graphics g, float theta) {
    tick(g, radius, theta, radius);
  }

  protected Point polar(int r, float theta) {
    return new Point ((int)(r * Math.cos(theta)), -(int)(r * Math.sin(theta)));
  }

  protected void tick(Graphics g, int r, float t, int len) {
    Point start = polar(r, t);
    Point end = polar(r-len, t);
    g.drawLine(start.x, start.y, end.x, end.y);
  }

  protected void centreText(Graphics g, String text, Point p) {
    FontMetrics fm = g.getFontMetrics();
    g.drawString(text,
		 p.x - fm.stringWidth(text) / 2,
		 p.y + fm.getAscent() / 2);
  }

  protected Color fillColor = Color.white;
  protected int radius = 50;
  protected int hubRadius = 5;
  protected float[] pointerAngle;
  protected Color[] pointerColor;
  protected Pointer[] pointerStyle;
}
