package UK.co.orl.omniorb;

import java.io.StreamTokenizer;
import org.omg.CORBA.*;


public class OmniOrbConfig {
  public static org.omg.CORBA.Object
    resolve_omniorb_initial_references(String name, ORB orb)
       throws org.omg.CORBA.ORBPackage.InvalidName {
    // resolve an initial reference the way omniORB would.
    try {
      if (!name.equals("NameService"))
	throw new org.omg.CORBA.ORBPackage.InvalidName();
      String config_file_name;
      try {
        config_file_name = System.getenv("OMNIORB_CONFIG");
      } catch (Error x) {
	// Grr.  Newer JDKs stop us using System.getenv.
	config_file_name = null;
      }
      config_file_name = System.getProperty("UK.co.orl.omniorb.configFile",
					    config_file_name);
      if (config_file_name == null)
	config_file_name = "/project/omni/var/omniORB.cfg";
      java.io.File config_file = new java.io.File(config_file_name);
      java.io.BufferedReader reader =
	new java.io.BufferedReader(new java.io.FileReader(config_file));
      java.io.StreamTokenizer tok = new StreamTokenizer(reader);
      tok.eolIsSignificant(true);
      tok.commentChar('#');
      tok.wordChars('\u0021','\u00FF'); // So no numbers, just letters & spaces
      do {
	switch(tok.nextToken()) {
	case StreamTokenizer.TT_EOF:
	  break;
	case StreamTokenizer.TT_WORD:
	  if (tok.sval.equals("NAMESERVICE")) {
	    if (tok.nextToken() == StreamTokenizer.TT_WORD)
	      return orb.string_to_object(tok.sval);
	    else
	      throw new org.omg.CORBA.ORBPackage.InvalidName();
	  }
	default: 
	  while (tok.nextToken() != StreamTokenizer.TT_EOL);
	}
      } while (tok.ttype != StreamTokenizer.TT_EOF);
    } catch (java.io.IOException x) {
      throw new org.omg.CORBA.ORBPackage.InvalidName();
    }
    throw new org.omg.CORBA.ORBPackage.InvalidName();
  }     
}
