################################################################################
# [.src.lib.omniORB2]dir.mms
################################################################################

CONFIG_DEFAULT_LOCATION = omniCFG:omniORB.cfg

DIR_CPPFLAGS = /Include=([],omni:)-
/Define=("CONFIG_DEFAULT_LOCATION=""$(CONFIG_DEFAULT_LOCATION)""")-
/Nested_include=primary
# search local directory first for include file first to avoid superfluous
# builds.

################################################################################
# MMS initiali[sz]ation
################################################################################

.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) relStream .obj .cc
	@ $(CreateMms) tcpSocket .obj .cc
	@ $(CreateMms) tcpSocketMTfactory .obj .cc
	@ $(CreateMms) constants .obj .cc
	@ $(CreateMms) corbaBoa .obj .cc
	@ $(CreateMms) corbaObject .obj .cc
	@ $(CreateMms) corbaOrb .obj .cc
	@ $(CreateMms) corbaString .obj .cc
	@ $(CreateMms) exception .obj .cc
	@ $(CreateMms) giopClient .obj .cc
	@ $(CreateMms) giopServer .obj .cc
	@ $(CreateMms) initFile .obj .cc
	@ $(CreateMms) ior .obj .cc
	@ $(CreateMms) libcWrapper .obj .cc
	@ $(CreateMms) mbufferedStream .obj .cc
	@ $(CreateMms) nbufferedStream .obj .cc
	@ $(CreateMms) object .obj .cc
	@ $(CreateMms) objectKey .obj .cc
	@ $(CreateMms) objectRef .obj .cc
	@ $(CreateMms) ropeFactory .obj .cc
	@ $(CreateMms) strand .obj .cc
	@ $(CreateMms) scavenger .obj .cc
	@ $(CreateMms) NamingSK .obj .cc
	@ $(CreateMms) omniLifeCycle .obj .cc
	@ $(CreateMms) omniLifeCycleSK .obj .cc
	@ $(CreateMms) reDirect .obj .cc
	@ $(CreateMms) typecode .obj .cc
	@ $(CreateMms) any .obj .cc
	@ $(CreateMms) tcParseEngine .obj .cc

################################################################################
# all rule
################################################################################

.else

lib = omniORB2$(DebugSuffix).olb
lclib = omniLC$(DebugSuffix).olb

NETLIBOBJS = $(lib)(relStream) \
	$(lib)(tcpSocket) \
	$(lib)(tcpSocketMTfactory) \
	$(lib)(gatekeeper.obj)

ORB2_OBJS = $(NETLIBOBJS) \
	$(lib)(constants) \
	$(lib)(corbaBoa) \
	$(lib)(corbaObject) \
	$(lib)(corbaOrb) \
	$(lib)(corbaString) \
	$(lib)(exception) \
	$(lib)(giopClient) \
	$(lib)(giopServer) \
	$(lib)(initFile) \
	$(lib)(ior) \
	$(lib)(libcWrapper) \
	$(lib)(mbufferedStream) \
	$(lib)(nbufferedStream) \
	$(lib)(object) \
	$(lib)(objectKey) \
	$(lib)(objectRef) \
	$(lib)(ropeFactory) \
	$(lib)(strand) \
	$(lib)(scavenger) \
	$(lib)(NamingSK) \
	$(lib)(typecode) \
	$(lib)(any) \
	$(lib)(tcParseEngine)

LC_OBJS = $(lclib)(omniLifeCycle) $(lclib)(reDirect) $(lclib)(omniLifeCycleSK)

# put dependency on the idl headers first to force the idl compiles to occur
# first.

all ::	Naming.hh omniLifeCycle.hh $(ORB2_OBJS) $(LC_OBJS)

Naming.hh, NamingSK.cc : Naming.idl
	omniidl2 -a "Naming.idl"

omniLifeCycle.hh, omniLifeCycleSK.cc : omniLifeCycle.idl
	omniidl2 -a "omniLifeCycle.idl"

.include relStream.mms
.include tcpSocket.mms
.include tcpSocketMTfactory.mms
.include constants.mms
.include corbaBoa.mms
.include corbaObject.mms
.include corbaOrb.mms
.include corbaString.mms
.include exception.mms
.include giopClient.mms
.include giopServer.mms
.include initFile.mms
.include ior.mms
.include libcWrapper.mms
.include mbufferedStream.mms
.include nbufferedStream.mms
.include object.mms
.include objectKey.mms
.include objectRef.mms
.include ropeFactory.mms
.include strand.mms
.include scavenger.mms
.include NamingSK.mms
.include typecode.mms
.include any.mms
.include tcParseEngine.mms

# see comments under Win32Platform in dir.mk

gatekeeper.obj : [.gatekeepers.dummystub]gatekeeper.cc

################################################################################
# export rule
################################################################################

export :: all

export :: $(lib)
	@ $(ExportLibrary)

export :: $(lclib)
	@ $(ExportLibrary)

NAMING_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]Naming.hh
LIFECYCLE_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]omniLifeCycle.hh
export :: $(NAMING_HDR) $(LIFECYCLE_HDR)

$(NAMING_HDR) : naming.hh
	$(ExportHeader)

$(LIFECYCLE_HDR) : omniLifeCycle.hh
	$(ExportHeader)

clean ::
	$(RM) $(lib) NamingSK.cc omniLifeCycleSK.cc

.endif
