// -*- Mode: C++; -*-
//                            Package   : omniORB2
// tcpMTSocket.h              Created on: 24/11/97
//                            Author    : Ben Harris (bjh)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:

#ifndef __TCPMTSOCKET_H__
#define __TCPMTSOCKET_H__

#if defined(__WIN32__)

#include <winsock.h>
#include <sys/types.h>

#define RC_INADDR_NONE     INADDR_NONE
#define RC_INVALID_SOCKET  INVALID_SOCKET
#define RC_SOCKET_ERROR    SOCKET_ERROR
#define INETSOCKET         PF_INET
#define CLOSESOCKET(sock)  closesocket(sock)
#define SHUTDOWNSOCKET(sock) ::shutdown(sock,2)
#else

#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#if defined(__sunos__) && defined(__sparc__) && __OSVERSION__ >= 5
#include <sys/types.h>
#include <fcntl.h>
#endif

#define RC_INADDR_NONE     ((CORBA::ULong)-1)
#define RC_INVALID_SOCKET  (-1)
#define RC_SOCKET_ERROR    (-1)
#define INETSOCKET         AF_INET
#define CLOSEINETSOCKET(socket)        			\
{                                               	\
   if((socket).ssl) {                               	\
     SSL_free((socket).ssl);                        	\
     (socket).ssl = NULL;                           	\
   }                                            	\
   close((socket).sock);                            	\
}
#if defined(__sunsos__) && defined(__sparc__) && __OSVERSION__ >= 5
#define SHUTDOWNINETSOCKET(sock)  ::shutdown(sock,2)
#elif defined(__osf1__) && defined(__alpha__)
#define SHUTDOWNINETSOCKET(sock)  ::shutdown(sock,2)
#else
  // XXX none of the above, calling shutdown() may not have the
  // desired effect.
#define SHUTDOWNINETSOCKET(socket)  ::shutdown((socket).sock,2)
#endif
#endif

#include <sys/types.h>
#include <errno.h>
#include <stdio.h>

#include <libcWrapper.h>

#ifdef NEED_GETHOSTNAME_PROTOTYPE
extern "C" int gethostname(char *name, int namelen);
#endif

class tcpSocketStrand;
class tcpSocketIncomingRope;
class tcpSocketOutgoingRope;

inetSocketHandle_t tcpRealConnect(tcpSocketStrand* s, inetSocketEndpoint* r);


class tcpSocketStrand : public inetSocketStrand {
public:

  static const unsigned int buffer_size;

  tcpSocketStrand(tcpSocketOutgoingRope *r,
		  inetSocketEndpoint *remote,
		  _CORBA_Boolean heapAllocated = 0);

  tcpSocketStrand(tcpSocketIncomingRope *r,
		  inetSocketHandle_t sock,
		  _CORBA_Boolean heapAllocated = 0);

  virtual ~tcpSocketStrand();

  void shutdown();
  virtual void ll_send(void* buf,size_t sz);
  virtual size_t ll_recv(void* buf,size_t sz);
  virtual CORBA::Boolean ll_connect();
  virtual CORBA::Boolean ll_shutdown();

  _CORBA_Boolean controlStrand(command_type type, char* buf, int size);
};

class tcpSocketIncomingRope : public inetSocketIncomingRope {
public:

  tcpSocketIncomingRope(inetSocketMTincomingFactory* f,
			unsigned int maxStrands,
			inetSocketEndpoint *e,
			CORBA::Boolean export);

  virtual ~tcpSocketIncomingRope();

  friend class inetSocketMTincomingFactory;
  friend class tcpSocketRendezvouser;

protected:

  virtual void cancelThreads();

private:

  tcpSocketRendezvouser *rendezvouser;
};

class tcpSocketOutgoingRope : public inetSocketOutgoingRope {
public:

  tcpSocketOutgoingRope(inetSocketMToutgoingFactory* f,
			unsigned int maxStrands,
			inetSocketEndpoint *e);

  virtual CORBA::Boolean remote_is(Endpoint *&e);

  virtual Strand *newStrand();

  friend class inetSocketMToutgoingFactory;
};

class tcpSocketRendezvouser : public omni_thread {
public:
  tcpSocketRendezvouser(tcpSocketIncomingRope *r) : omni_thread(r) {
    start_undetached();
  }
  virtual ~tcpSocketRendezvouser() { }
  virtual void* run_undetached(void *arg);

private:
  tcpSocketRendezvouser();
};

class tcpSocketWorker : public omni_thread {
public:
  tcpSocketWorker(tcpSocketStrand* s) : omni_thread(s), pd_sync(s,0,0) {
    s->decrRefCount();
    start();
  }
  virtual ~tcpSocketWorker() { };
  virtual void run(void *arg);
  static void _realRun(void* arg);

private:
  Strand::Sync    pd_sync;
};

#endif __TCPMTSOCKET_H__
