// -*- Mode: C++; -*-
//                            Package   : omniORB2
// tcpContext.cc              Created on: 12/11/98
//                            Author    : Tatsuo Nakajima (tatsuo)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//

#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <ropeFactory.h>
#include <objectManager.h>
#include <gatekeeper.h>

//
// Context Object for IIOP
//

tcpContext* tcpContext::singleton = 0;
CORBA::Boolean tcpContext::iiop_only = 0;

tcpContext::tcpContext()
{
  pd_connection_interceptor_factory = NULL;
}

void
tcpContext::initContext()
{
  if (singleton) {
     return;
  }
  singleton = new tcpContext();

  //
  // Set a factory object for default connection interceptor
  //
  singleton->setConnectionInterceptorFactory((ConnectionInterceptorFactory *)
			new DefaultConnectionInterceptorFactory());
}

static init_flag = 0;

void
tcpContext::initContext(int &argc, char **argv)
{
  //
  // If the method is already called, an exception is raised.
  //
  if (init_flag) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }
  if (!singleton) {
    singleton = new tcpContext();
  } 
  init_flag = 1;

  //
  // If the method is called before BOA is initialized, 
  // an exception is raised.
  //
  CORBA::BOA_ptr boa;
  try {
    boa = CORBA::BOA::getBOA();
  } catch(CORBA::OBJ_ADAPTER& ex) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  CORBA::release(boa);

  //
  // Set a factory object for the Default connection interceptor.
  //
  singleton->setConnectionInterceptorFactory((ConnectionInterceptorFactory *)
			new DefaultConnectionInterceptorFactory());
}

tcpContext *
tcpContext::getContext()
{
  if(singleton) {
    return singleton;
  }
    
  initContext();

  return singleton;
}

void
tcpContext::setIIOPOnly()
{
  iiop_only = 1;
}

CORBA::Boolean
tcpContext::checkIIOPOnly()
{
  return iiop_only;
}

void
tcpContext::setConnectionInterceptorFactory(ConnectionInterceptorFactory *factory)
{
  if(pd_connection_interceptor_factory) {
    delete pd_connection_interceptor_factory;
  }

  pd_connection_interceptor_factory = factory;
}

ConnectionInterceptorFactory *
tcpContext::getConnectionInterceptorFactory()
{
  return pd_connection_interceptor_factory;
}

//
// Connection State Object for IIOP and SSL.
//
inetConnectionControl::inetConnectionControl(Strand *s)
			: ConnectionControl(s)
{
}

CORBA::Boolean
inetConnectionControl::enableDelayedAck()
{
  int one = 1;

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(SetDelayedAck, (char *) &one, sizeof(one));

  return 1;
}

CORBA::Boolean
inetConnectionControl::disableDelayedAck()
{
  int zero = 0;

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(SetDelayedAck, (char *) &zero, sizeof(zero));

  return 1;
}

CORBA::Boolean
inetConnectionControl::checkPeerAddress()
{
  CORBA::Boolean ok = 0;

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(CheckPeerAddress, (char *) &ok , sizeof(ok));

  return ok;
}

char *
inetConnectionControl::getPeerAddress()
{
  char buf[100];

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(GetPeerAddress, buf, 100);

  return CORBA::string_dup(buf);
}

//
// Connection State Object for IIOP
//
IIOPConnectionState::IIOPConnectionState(Strand *s)
			: ConnectionState(s)
{
  s_connection_control = (IIOPConnectionControl *)new IIOPConnectionControl(s);
  s_type = TRANS_IIOP;
}

//
// Connection Control Object for IIOP
//
IIOPConnectionControl::IIOPConnectionControl(Strand *s)
			: inetConnectionControl(s)
{
  s_type = TRANS_IIOP;
}
