// -*- Mode: C++; -*-
//                            Package   : omniORB2
// sslMTSocket.h              Created on: 24/11/97
//                            Author    : Ben Harris (bjh)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
#ifndef __SSLMTSOCKET_H__
#define __SSLMTSOCKET_H__

#include <stdlib.h>
#include <ssl/rsa.h>
#include <ssl/crypto.h>
#include <ssl/x509.h>
#include <ssl/pem.h>
#include <ssl/ssl.h>
#include <ssl/err.h>

#if defined(__WIN32__)

#include <winsock.h>
#include <sys/types.h>

#define RC_INADDR_NONE     INADDR_NONE
#define RC_INVALID_SOCKET  INVALID_SOCKET
#define RC_SOCKET_ERROR    SOCKET_ERROR
#define INETSOCKET         PF_INET
#define CLOSESOCKET(sock)  closesocket(sock)
#define SHUTDOWNSOCKET(sock) ::shutdown(sock,2)
#else

#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#if defined(__sunos__) && defined(__sparc__) && __OSVERSION__ >= 5
#include <sys/types.h>
#include <fcntl.h>
#endif

#define RC_INADDR_NONE     ((CORBA::ULong)-1)
#define RC_INVALID_SOCKET  (-1)
#define RC_SOCKET_ERROR    (-1)
#define INETSOCKET         AF_INET
#define CLOSEINETSOCKET(socket)       			\
{                                               	\
   if((socket).ssl) {                               	\
     SSL_free((socket).ssl);                        	\
     (socket).ssl = NULL;                           	\
   }                                            	\
   close((socket).sock);                            	\
}
#if defined(__sunsos__) && defined(__sparc__) && __OSVERSION__ >= 5
#define SHUTDOWNSOCKET(sock)  ::shutdown(sock,2)
#elif defined(__osf1__) && defined(__alpha__)
#define SHUTDOWNSOCKET(sock)  ::shutdown(sock,2)
#else
  // XXX none of the above, calling shutdown() may not have the
  // desired effect.
#define SHUTDOWNSOCKET(socket)  ::shutdown((socket).sock,2)
#endif
#endif

#include <sys/types.h>
#include <errno.h>
#include <stdio.h>

#include <libcWrapper.h>

#ifdef NEED_GETHOSTNAME_PROTOTYPE
extern "C" int gethostname(char *name, int namelen);
#endif

class sslSocketStrand;
class sslSocketIncomingRope;
class sslSocketOutgoingRope;

inetSocketHandle_t sslRealConnect(sslSocketStrand* s, inetSocketEndpoint* r);

class sslSocketStrand : public inetSocketStrand
{
public:

  static const unsigned int buffer_size;

  sslSocketStrand(sslSocketOutgoingRope *r,
		  inetSocketEndpoint *remote,
		  _CORBA_Boolean heapAllocated = 0);

  sslSocketStrand(sslSocketIncomingRope *r,
		  inetSocketHandle_t sock,
		  _CORBA_Boolean heapAllocated = 0);

  virtual ~sslSocketStrand();

  void shutdown();
  virtual void ll_send(void* buf,size_t sz);
  virtual size_t ll_recv(void* buf,size_t sz);
  virtual CORBA::Boolean ll_connect();
  virtual CORBA::Boolean ll_shutdown();

  _CORBA_Boolean controlStrand(command_type type, char* buf, int size);
};

class sslSocketIncomingRope : public inetSocketIncomingRope {
public:

  sslSocketIncomingRope(inetSocketMTincomingFactory* f,
			unsigned int maxStrands,
			inetSocketEndpoint *e,
			CORBA::Boolean export);

  virtual ~sslSocketIncomingRope();

  friend class inetSocketMTincomingFactory;
  friend class sslSocketRendezvouser;

protected:

  virtual void cancelThreads();

private:

  sslSocketRendezvouser *rendezvouser;
};

class sslSocketOutgoingRope : public inetSocketOutgoingRope {
public:

  sslSocketOutgoingRope(inetSocketMToutgoingFactory* f,
			unsigned int maxStrands,
			inetSocketEndpoint *e);

  virtual Strand *newStrand();

  friend class inetSocketMToutgoingFactory;
};

class sslSocketRendezvouser : public omni_thread {
public:
  sslSocketRendezvouser(sslSocketIncomingRope *r) : omni_thread(r) {
    start_undetached();
  }
  virtual ~sslSocketRendezvouser() { }
  virtual void* run_undetached(void *arg);

private:
  sslSocketRendezvouser();
};

class sslSocketWorker : public omni_thread {
public:
  sslSocketWorker(sslSocketStrand* s) : omni_thread(s), pd_sync(s,0,0) {
    s->decrRefCount();
    start();
  }
  virtual ~sslSocketWorker() { }
  virtual void run(void *arg);
  static void _realRun(void* arg);

private:
  Strand::Sync    pd_sync;
};

#endif __SSLMTSOCKET_H__
