# dir.mk for omniORB2
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <major version no.> is always 2 for omniORB2.
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# 
VERSION = 2.5.0

major_version = $(word 1,$(subst ., ,$(VERSION)))
minor_version = $(word 2,$(subst ., ,$(VERSION)))
micro_version = $(word 3,$(subst ., ,$(VERSION)))

#
# Life cycle run time library version
LC_VERSION = 1.2.0

lc_major_version = $(word 1,$(subst ., ,$(LC_VERSION)))
lc_minor_version = $(word 2,$(subst ., ,$(LC_VERSION)))
lc_micro_version = $(word 3,$(subst ., ,$(LC_VERSION)))
#
#
# For each source tree we want to search the parent directory to get source
# files so we put these on VPATH.  However we can't put the parent build
# directory ('..') on VPATH otherwise the .o files in there are used.  So we
# need to do that as a special case with the vpath directive:
#

override VPATH := $(patsubst %,%/..,$(VPATH))

ifndef BuildWin32DebugLibraries

vpath %.cc ..

else

vpath %.cc ../..

endif

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################
ifdef UnixPlatform
ifdef OMNIORB_CONFIG_DEFAULT_LOCATION
CONFIG_DEFAULT_LOCATION = $(OMNIORB_CONFIG_DEFAULT_LOCATION)
else
CONFIG_DEFAULT_LOCATION = \"/project/omni/var/omniORB_NEW.cfg\"
endif

NETLIBSRCS = relStream.cc inetSocketFactory.cc inetSocket.cc		\
	     tcpContext.cc tcpSocket.cc tcpMTSocket.cc			\
	     sslContext.cc sslMTSocket.cc
NETLIBOBJS = relStream.o inetSocketFactory.o inetSocket.o		\
	     tcpContext.o tcpSocket.o tcpMTSocket.o			\
	     sslContext.o sslMTSocket.o
DIR_CPPFLAGS += -DUnixArchitecture -g
DIR_CPPFLAGS += -DCONFIG_DEFAULT_LOCATION=$(CONFIG_DEFAULT_LOCATION)

#
# Added for SSL support
#
DIR_CPPFLAGS += $(patsubst %,-I%/ssl/include,$(IMPORT_TREES))

endif

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform
NETLIBSRCS = relStream.cc tcpSocket.cc tcpSocketMTfactory.cc
NETLIBOBJS = relStream.o tcpSocket.o tcpSocketMTfactory.o  gatekeeper.o
# See the extra comments on gatekeeper.o at the end of this file

DIR_CPPFLAGS += -DNTArchitecture -D_OMNIORB2_DLL

ifndef BuildWin32DebugLibraries

implib = $(patsubst %,$(DLLPattern),omniORB2$(minor_version))
staticlib = ../$(patsubst %,$(LibPattern),omniORB2)
lcimplib = $(patsubst %,$(DLLPattern),omniLC$(lc_minor_version))
lcstaticlib = ../$(patsubst %,$(LibPattern),omniLC)
CXXOPTIONS  = $(MSVC_CXXNODEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_CXXLINKNODEBUGOPTIONS)

SUBDIRS = debug

else

# Building the debug version of the library in the debug subdirectory.
# Notice that this dir.mk is recursively used in the debug directory to build
# this library. The BuildWin32DebugLibraries make variable is set to 1 in
# the dir.mk generated in the debug directory.
#
implib = $(patsubst %,$(DLLDebugPattern),omniORB2$(minor_version))
staticlib = ../../debug/$(patsubst %,$(LibDebugPattern),omniORB2)
lcimplib = $(patsubst %,$(DLLDebugPattern),omniLC$(lc_minor_version))
lcstaticlib = ../../debug/$(patsubst %,$(LibDebugPattern),omniLC)
CXXDEBUGFLAGS = 
CXXOPTIONS = $(MSVC_CXXDEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_CXXLINKDEBUGOPTIONS)

tempvar := $(OMNITHREAD_LIB)
OMNITHREAD_LIB = $(patsubst $(DLLNoDebugSearchPattern),$(DLLDebugSearchPattern),$(tempvar))

DIR_CPPFLAGS += -I./../.. -I./../../..

SUBDIRS =

endif

lib = $(patsubst %.lib,%.dll,$(implib))
libname = $(patsubst %.dll,%,$(lib))
lclib = $(patsubst %.lib,%.dll,$(lcimplib))
lclibname = $(patsubst %.dll,%,$(lclib))

# Extra libraries required by NT
NT_EXTRA_LIBS = wsock32.lib advapi32.lib
endif

#############################################################################
#   Make variables for ATMos                                                #
#############################################################################

ifdef ATMos
NETLIBSRCS = relStream.cc tcpATMos.cc tcpATMosMTfactory.cc
NETLIBOBJS = relStream.o tcpATMos.o tcpATMosMTfactory.o
DIR_CPPFLAGS = -DATMosArchitecture
endif


#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

ORB2_SRCS = constants.cc corbaBoa.cc corbaObject.cc corbaOrb.cc \
            corbaString.cc \
            exception.cc giopClient.cc giopServer.cc initFile.cc ior.cc \
            libcWrapper.cc mbufferedStream.cc nbufferedStream.cc \
            object.cc objectKey.cc objectRef.cc ropeFactory.cc \
            strand.cc scavenger.cc \
	    typecode.cc any.cc tcParseEngine.cc bind.cc connectionSet.cc \
	    QOS.cc redirectPolicy.cc selectionPolicy.cc \
            $(NETLIBSRCS) $(LOG_SRCS) NamingSK.cc

ORB2_OBJS = constants.o corbaBoa.o corbaObject.o corbaOrb.o \
            corbaString.o \
            exception.o giopClient.o giopServer.o initFile.o ior.o \
            libcWrapper.o mbufferedStream.o nbufferedStream.o \
            object.o objectRef.o objectKey.o ropeFactory.o \
            strand.o scavenger.o \
	    typecode.o any.o tcParseEngine.o bind.o connectionSet.o \
	    QOS.o redirectPolicy.o selectionPolicy.o \
            $(NETLIBOBJS) $(LOG_OBJS) NamingSK.o

LC_SRCS = omniLifeCycle.cc reDirect.cc omniLifeCycleSK.cc
LC_OBJS = omniLifeCycle.o reDirect.o omniLifeCycleSK.o

DIR_CPPFLAGS += $(OMNITHREAD_CPPFLAGS)
DIR_CPPFLAGS += -I./.. -I./../.. 

CXXSRCS = $(ORB2_SRCS)

#############################################################################
#   Make rules for Solaris 2.x                                              #
#############################################################################

ifdef SunOS
ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -Kpic

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -o $@ -h $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -o $@ -h $(lcsoname) $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$(LC_OBJS)) $(OMNITHREAD_LIB) $(lib); \
       )


clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

endif
endif

#############################################################################
#   Make rules for Digital Unix                                             #
#############################################################################

ifdef OSF1
ifeq ($(notdir $(CXX)),cxx)

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(rpath="$(RPATH)"; \
         for arg in $(OMNITHREAD_LIB) /usr/lib/cmplrs/cxx; do \
         if expr "$$arg" : "-L" >/dev/null; then \
               rpath="$$rpath$${rpath+:}`expr $$arg : '-L\(.*\)'"; \
         fi; \
         done; \set -x; \
         $(RM) $@; \
         ld -shared -soname $(soname) -set_version $(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         -expect_unresolved denyFile__10gateKeeper \
         -expect_unresolved allowFile__10gateKeeper \
         -expect_unresolved checkConnect__10gateKeeperXP15tcpSocketStrand \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) -lcxxstd -lcxx -lexc -lots -lc -rpath $$rpath; \
        )

$(lclib): $(LC_OBJS)
	(rpath="$(RPATH)"; \
         for arg in $(OMNITHREAD_LIB) /usr/lib/cmplrs/cxx; do \
         if expr "$$arg" : "-L" >/dev/null; then \
               rpath="$$rpath$${rpath+:}`expr $$arg : '-L\(.*\)'"; \
         fi; \
         done; \set -x; \
         $(RM) $@; \
         ld -shared -soname $(lcsoname) -set_version $(lcsoname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib) -lcxxstd -lcxx -lexc -lots -lc -rpath $$rpath; \
        )


clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

endif
endif


#############################################################################
#   Make rules for  IBM AIX                                                 #
#############################################################################

ifdef AIX

libname = libomniORB$(major_version)$(minor_version).a
soname = libomniORB$(major_version).so.$(minor_version).$(micro_version)
lib = $(libname).$(micro_version)

lclibname  = libomniLC$(lc_minor_version).a
lcsoname  = libomniLC.so.$(lc_minor_version).$(lc_micro_version)
lclib = $(lclibname).$(lc_micro_version)

# We have a bootstrapping problem with building gatekeepers and this shared 
# library. This library is built before gatekeeprs. Until we have 
# how to tell the linker it is safe to have some undefined symbols, we
# have to disable the gatekeeper feature.

NETLIBOBJS += gatekeeper.o

all:: $(lib)

all:: $(lclib)

ifeq ($(notdir $(CXX)),xlC_r)

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        /usr/lpp/xlC/bin/makeC++SharedLib \
             -o $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) \
         -lC -lc_r -lc -p 40; \
         ar cq $(lib) $(soname); \
         $(RM) $(soname); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
        $(RM) $@; \
        /usr/lpp/xlC/bin/makeC++SharedLib \
             -o $(lcsoname) $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib) \
         -lC -lc_r -lc -p 40; \
         ar cq $(lclib) $(lcsoname); \
         $(RM) $(lcsoname); \
       )

endif

ifeq ($(notdir $(CXX)),g++)

$(lib): $(ORB2_OBJS)
	(set -x; \
         $(RM) $@; \
         $(CXXLINK) -shared -mthreads \
              -o $(soname) $(IMPORT_LIBRARY_FLAGS) \
          $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) ; \
         ar cq $(lib) $(soname); \
         $(RM) $(soname); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
         $(RM) $@; \
         $(CXXLINK) -shared -mthreads \
              -o $(lcsoname) $(IMPORT_LIBRARY_FLAGS) \
          $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib); \
         ar cq $(lclib) $(lcsoname); \
         $(RM) $(lcsoname); \
       )

endif

clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(libname); \
          ln -s $(lib) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lclibname); \
          ln -s $(lclib) $(lclibname); \
         )


gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -o$@ $<

endif

#############################################################################
#   Make rules for Win32 platforms                                          #
#############################################################################

ifdef Win32Platform

ifndef BuildWin32DebugLibraries
# Prepare a debug directory for building the debug version of the library.
# Essentially, we create a debug directory in the current directory, create
# a dir.mk and optionally a GNUmakefile in that directory and then calling
# omake (GNU make) in that directory.
# The confusing bit is that this dir.mk is recursively used in the debug 
# directory to build this library. The BuildWin32DebugLibraries make variable,
# which is set to 1 in the dir.mk generated in the debug directory,
# is used to identify this case.
#
all:: mkdebugdir

mkdebugdir:
	@(if [ ! -f debug/dir.mk ]; then \
            file=dir.mk; dirs='. $(VPATH:/..=)'; $(FindFileInDirs); \
            case "$$fullfile" in /*) ;; *) fullfile=../$$fullfile;; esac; \
            dir=debug; $(CreateDir); \
            echo 'BuildWin32DebugLibraries = 1' > debug/dir.mk; \
            echo 'override VPATH := $$(VPATH:/debug=)' >> debug/dir.mk; \
            echo include $$fullfile >> debug/dir.mk; \
            if [ -f GNUmakefile ]; then \
               echo 'TOP=../../../../..' > debug/GNUmakefile; \
               echo 'CURRENT=src/lib/omniORB2/sharedlib/debug' >> debug/GNUmakefile; \
               echo 'include $$(TOP)/config/config.mk' >> debug/GNUmakefile; \
            fi \
          fi \
         )

export:: mkdebugdir

endif

all:: $(lib)

all:: $(lclib)

all::
	@$(MakeSubdirs)

$(lib): $(ORB2_OBJS) omniORB2.def
	(libs="$(NT_EXTRA_LIBS) $(OMNITHREAD_LIB)"; \
         $(RM) $@; \
         $(CXXLINK) -out:$@ -DLL $(CXXLINKOPTIONS) -def:omniORB2.def -IMPLIB:$(implib) $(IMPORT_LIBRARY_FLAGS) $(ORB2_OBJS) $(UNSHARED_OBJS) $$libs; \
        )

$(lclib): $(LC_OBJS) omniLC.def
	(libs="$(NT_EXTRA_LIBS) $(OMNITHREAD_LIB) $(implib)"; \
         $(RM) $@; \
         $(CXXLINK) -out:$@ -DLL $(CXXLINKOPTIONS) -def:omniLC.def -IMPLIB:$(lcimplib) $(IMPORT_LIBRARY_FLAGS) $(LC_OBJS) $$libs; \
        )

# omniORB2.def
#  - This file contains all the functions and static class variables
#    exported by the DLL. The symbols are extracted from the output of
#    dumpbin.
#
#    The function symbols are extracted using the following template:
#    ... ........ SECT..  notype ()     External      | ?..................
#
#    The static class variable symbols are extracted using the following
#    template:
#    ... ........ SECT..  notype        External      | ?[^?]..............
#
#    Default destructors generated by the compiler are excluded.
#
#    It looks like class variable and function symbols start with two ??
#    and class static variable and static function symbols start with one ?.
#                                                             - SLL
#
omniORB2.def: $(staticlib)
	(set -x; \
         echo "LIBRARY $(libname)" > omniORB2.def; \
         echo "VERSION $(minor_version).$(micro_version)" >> omniORB2.def; \
         echo "EXPORTS" >> omniORB2.def; \
         DUMPBIN /SYMBOLS $(staticlib) | \
         egrep '^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +\(\) +External +\| +\?[^ ]*|^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +External +\| +\?[^?][^ ]*'|\
         egrep -v 'deleting destructor[^(]+\(unsigned int\)' | \
         cut -d'|' -f2 | \
         cut -d' ' -f2 | /bin/sort -u >> omniORB2.def; )

omniLC.def: $(lcstaticlib)
	(set -x; \
         echo "LIBRARY $(lclibname)" > omniLC.def; \
         echo "VERSION $(minor_version).$(micro_version)" >> omniLC.def; \
         echo "EXPORTS" >> omniLC.def; \
         DUMPBIN /SYMBOLS $(lcstaticlib) | \
         egrep '^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +\(\) +External +\| +\?[^ ]*|^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +External +\| +\?[^?][^ ]*'|\
         egrep -v 'deleting destructor[^(]+\(unsigned int\)' | \
         cut -d'|' -f2 | \
         cut -d' ' -f2 | /bin/sort -u >> omniLC.def; )

clean::
	$(RM) *.lib *.def *.dll *.exp

# NT treats DLLs more like executables -- the .dll file needs to go in the
# bin/x86... directory so that it's on your PATH:
export:: $(lib)
	@$(ExportExecutable)

export:: $(implib)
	@$(ExportLibrary)

export:: $(lclib)
	@$(ExportExecutable)

export:: $(lcimplib)
	@$(ExportLibrary)

export::
	@$(MakeSubdirs)

# Ideally, we would like to build the dummy gatekeeper stub just like other
# platforms, i.e. as a separate static library. However, it proves to be quite
# tricky because the omniORB2 DLL needs the symbols provided by gatekeeper.o
# to be resolved when the DLL is build. For the moment, just workaround the
# problem by building the stub directly into the library.
#
gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -Fo$@ $<

endif



#############################################################################
#   Make rules for HPUX                                                     #
#############################################################################

ifdef HPUX
ifeq ($(notdir $(CXX)),aCC)

DIR_CPPFLAGS += +z

libname = libomniORB$(major_version).sl
soname  = $(libname).$(minor_version)
lib     = $(soname).$(micro_version)

lclibname = libomniLC.sl
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

# For the moment, disable the use of gatekeeper in shared library.  Other
# platforms have a bootstrapping problem with building gatekeepers and this
# shared library. This library is built before gatekeepers so the linker
# may complain about undefined symbols when it tries to link the shared
# libaries below. Further testing is needed. 
#
NETLIBOBJS +=  gatekeeper.o

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(set -x; \
         $(RM) $@; \
         aCC -b -Wl,+h$(soname) -o $@  $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-L %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^)  -ldce -loodce -lcma ; \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
         $(RM) $@; \
         aCC -b -Wl,+h$(lcsoname) -o $@  $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-L %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib) -ldce -loodce -lcma ; \
       )

clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -o$@ $<

endif
endif
