
#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <omniORB2/SelectionPolicy.h>
#include <ropeFactory.h>

void
StaticSelectionPolicy::runSelectionPolicy()
{
}

void
DynamicSelectionPolicy::runSelectionPolicy()
{
  ConnectionType 	type = getConnectionType();
  ConnectionState 	*cs;
  ConnectionControl	*cc;
  CORBA::Boolean 	status;

  switch(transport_hint) {

  case HighThroughput:
    if(type != TRANS_ATM) {
      changeCurrentTransport(TRANS_ATM);
    }

    break;

  case LowThroughput:
    cs = getConnectionState(TRANS_ATM);
    cc = cs->getConnectionControl();
    status = cc->getConnectionStatus();
    deleteConnectionState(cs);

    if(type != TRANS_ATM) {
      if(status) {
        changeCurrentTransport(TRANS_ATM);
      }
    } else {
      if(!status) {
        changeCurrentTransport(TRANS_IIOP);
      }
    }

    break;

  default:
    break;

  }

  sslContext *ssl = ssl->getContext();

  if(ssl && ssl->checkInitializedByUser()) {
    if(type != TRANS_SSL) {
      changeCurrentTransport(TRANS_SSL);
    }
  }
}

void
DynamicSelectionPolicy::setTransportHint(hint_t hint)
{
  transport_hint = hint;
}

void
ExplicitSelectionPolicy::runSelectionPolicy()
{
}

CORBA::Boolean
ExplicitSelectionPolicy::selectTransport(ConnectionType type)
{
  if((type != TRANS_IIOP) && tcpContext::checkIIOPOnly()) {
    return 0;
  }

  return changeCurrentTransport(type);
}

CORBA::Boolean
SelectionPolicy::changeCurrentTransport(ConnectionType type)
{
  omniRopeAndKey rk;
  Rope *cur_r, *new_r;
  ConnectionSet *con_set;

  //
  // Get the current rope
  //
  pd_obj->getRopeAndKey(rk);
  cur_r = rk.rope();

  //
  // Get a Rope specified by the argument.
  //
  con_set = cur_r->getConnectionSet();
  new_r = con_set->getRope(type);
  if(new_r == NULL) {
    return 0;
  }

  rk.rope(new_r);
  cur_r->incrRefCount(1);
  new_r->decrRefCount(1);

  //
  // Set a new Rope as a current rope
  //
  pd_obj->setRopeAndKey(rk);
  pd_obj->setConnectionType(type);

  return 1;
}

ConnectionState*
SelectionPolicy::getConnectionState()
{
  omniRopeAndKey	rk;
  CORBA::Boolean 	secondHand = 0;
  CORBA::Boolean  	status;
  ConnectionState 	*cs;

  pd_obj->getRopeAndKey(rk);

  Rope *r = rk.rope();
  if(r == NULL) {
    return NULL;
  }

  Strand *s = r->getStrand(secondHand);
  if(s == NULL) {
    return NULL;
  }

  status = s->controlStrand(GetConnectionState, (char *) &cs, sizeof(cs));
  if(status) {
    return cs;
  } else {
    return NULL;
  }
}

ConnectionState*
SelectionPolicy::getConnectionState(ConnectionType type)
{
  omniRopeAndKey	rk;
  CORBA::Boolean 	secondHand = 0;
  CORBA::Boolean  	status;
  ConnectionState 	*cs;
  ConnectionSet		*con_set;

  pd_obj->getRopeAndKey(rk);
  Rope *r = rk.rope();
  if(r == NULL) {
    return NULL;
  }

  con_set = r->getConnectionSet();
  Rope *new_r = con_set->getRope(type);

  Strand *s = new_r->getStrand(secondHand);
  if(s == NULL) {
    return NULL;
  }

  status = s->controlStrand(GetConnectionState, (char *) &cs, sizeof(cs));
  if(status) {
    return cs;
  } else {
    return NULL;
  }
}

omniObject *
SelectionPolicy::createObjectReference(const char *repoId, ConnectionType type)
{
  omniObject *new_obj = omni::createObjRef(pd_obj->NP_IRRepositoryId(),
					repoId, pd_obj->iopProfiles(), 0);
  if(!new_obj) {
    return NULL;
  }

  //
  // Selection policy is inherited from the old object.
  //
  SelectionPolicy *policy = pd_obj->getSelectionPolicy();
  policy = policy->copySelectionPolicy();
  new_obj->setSelectionPolicy(policy);
  policy->setObject(new_obj);

  //
  // In this case, pd_qos_enable
  // member is inherited from the old object. But, in other cases,
  // newly created object references will be QOS enable object.
  //
  if(repoId) {
    new_obj->pd_qos_enable = pd_obj->pd_qos_enable;
  } else {
    new_obj->pd_qos_enable = 1;
  }

  //
  // Change the transport for the new object.
  //
  policy->changeCurrentTransport(type);

  return new_obj;
}
