
#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <omniORB2/RedirectionPolicy.h>
#include <omniORB2/ConnectionInfo.h>
#include <ropeFactory.h>
#include <objectManager.h>
#include <inetSocket.h>
#include <inetSocketFactory.h>

CORBA::Boolean
RedirectionPolicy::runRedirectionPolicy(ConnectionType &type,
			ConnectionState *cs, CORBA::ULong& throughput)
{
  int request, info;
  ConnectionType ctype = cs->getConnectionType();

  if(type == TRANS_SSL_ATM) {
    switch(ctype) {
    case TRANS_SSL:
      type = TRANS_SSL;
      break;

    case TRANS_ATM:
      type = TRANS_ATM;
      break;
    }
  }

  throughput = 0;
  cs->getConnectionInfo(request, info);
  ConnectionControl *cc = cs->getConnectionControl();

  switch(type) {

  case TRANS_SSL:
    // 
    // If the client and the server can be connected by a safe network,
    // SSL is not necessary.
    //
    SSLConnectionControl *ssl_cc;

    if(cc->getConnectionType() == TRANS_SSL) {
      ssl_cc = (SSLConnectionControl *)cc;
    } else {
      break;
    }

    if(request == SSL_REJECT) {
      switch (type) {
      case TRANS_SSL:
        type = TRANS_IIOP;
   	break;

      case TRANS_SSL_ATM:
        type = TRANS_ATM;
   	break;

      default:
    	break;
      }
      return 1;
    }

    if(request == SSL_UNNECESSARY) {
      if((request == SSL_UNNECESSARY) && (info == 1)) {
        break;
      } else {
        cs->setConnectionInfo(SSL_UNNECESSARY, 1);
        return 1;
      }
    }

    break;

  case TRANS_ATM:

    switch (request) {
    case ATM_REJECT:
      //
      // If the use of ATM is rejected, the IOR that does not contain
      // ATM tag is returned.
      //
      switch (type) {
      case TRANS_ATM:
        type = TRANS_IIOP;
	break;

      case TRANS_SSL_ATM:
        type = TRANS_SSL;
	break;

      default:
	break;
      }

      return 1;

    case  ATM_REDUCE_REQUEST:
      //
      // In this case, the same IOR that the client uses is returned.
      // The server expects that the client will reduce the bandwidth
      // or use IIOP instead. 
      //
      throughput = info;
      cs->setConnectionInfo(NO_REQUEST, 0);

      return 1;
    }

    break;
  }

  return 0;
}

Endpoint *
RedirectionPolicy::createEndpoint(ConnectionType& type)
{
  omniObjectManager* rootObjectManager = omniObjectManager::root(0);
  ropeFactory_iterator iter(*rootObjectManager->incomingRopeFactories());
  incomingRopeFactory* factory;
  inetSocketEndpoint *e;

  while ((factory = (incomingRopeFactory*)iter())) {
    if (factory->getType()->is_protocol(inetSocketEndpoint::protocol_name)) {
      e = (inetSocketEndpoint *)
		((inetSocketMTincomingFactory *)factory)->getIncomingEndpoint();
      type = e->status();
    }
  }
  
  return e;
}

void 
RedirectionPolicy::marshalRedirectionObject(omniObject *obj,
		Endpoint *e, NetBufferedStream &s,
		ConnectionType type, CORBA::ULong throughput)
{
  omniRopeAndKey rk;
  const char *repoId;
  int  repoIdSize;
  IOP::TaggedProfileList_var pl(new IOP::TaggedProfileList);

  obj->getRopeAndKey(rk);

  ((inetSocketEndpoint *)e)->status(type);
  ((inetSocketEndpoint *)e)->throughput(throughput);

  omniObjectManager* rootObjectManager = omniObjectManager::root(0);
  ropeFactory_iterator iter(*rootObjectManager->incomingRopeFactories());
  incomingRopeFactory* factory;

  while ((factory = (incomingRopeFactory*)iter())) {
    if (factory->getType()->is_protocol(inetSocketEndpoint::protocol_name)) {
      ((inetSocketMTincomingFactory *)factory)->getIOPprofiles(rk.key(),
				rk.keysize(), *(pl.operator->()), e);
    }
  }

  // Marshalling repository ID.
  repoId = obj->NP_IRRepositoryId();
  repoIdSize = strlen(repoId) + 1;

  ::operator>>= ((CORBA::ULong) repoIdSize,s);
  s.put_char_array((CORBA::Char *)repoId,repoIdSize);

  // Marshalling profile.
  *pl._ptr >>= s;

  pl._ptr = 0;
}
