// -*- Mode: C++; -*-
//                            Package   : omniORB2
// sinetScketFactory.h        Created on: 30/9/97
//                            Author    : Sai Lai Lo (sll)
//                                      : Tatsuo Nakajima (tatsuo)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	*** PROPRIETORY INTERFACE ***
// 

/*
 $Log: tcpSocket.h,v $
 Revision 1.2  1998/03/19 19:52:03  sll
 Added delay connect to tcpSocketStrand.

 Revision 1.1  1997/12/09 18:43:15  sll
 Initial revision

*/

#ifndef __INETSOCKETFACTORY_H__
#define __INETSOCKETFACTORY_H__

// The following defines all the derived classes to implement the transport
// over TCP/IP using a BSD socket style interface.
//
//                                      Abstract class
//    inetSocketFactoryType             ropeFactoryType
//    inetSocketMTincomingFactory       incomingRopeFactory
//    inetSocketMToutgoingFactory       outgoingRopeFactory
//
//    ropeFactory.h and rope.h contains the definition of these classes and
//    a description of each methods.
//

#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <relStream.h>

#include <stdlib.h>
#include <ssl/rsa.h>
#include <ssl/crypto.h>
#include <ssl/x509.h>
#include <ssl/pem.h>
#include <ssl/ssl.h>
#include <ssl/err.h>

struct Socket {
	int	sock;
	SSL*	ssl;	
};

#if defined(__WIN32__)
typedef SOCKET inetSocketHandle_t;
#elif defined(__atmos__)
typedef FILE*  inetSocketHandle_t;
#else
typedef struct Socket    inetSocketHandle_t;
#endif

class nobody;  // dummy class defined to silent gcc warning about
               // a private destructor without any friend 

class inetSocketFactoryType : public ropeFactoryType {
public:
  // This is a singleton class.

  CORBA::Boolean is_IOPprofileId(IOP::ProfileId tag) const;
  CORBA::Boolean is_protocol(const char* name) const;
  CORBA::Boolean decodeIOPprofile(const IOP::TaggedProfile& profile,
					  // return values:
					  Endpoint*&     addr,
					  CORBA::Octet*& objkey,
					  size_t&        objkeysize) const;
  void encodeIOPprofile(const Endpoint* addr,
			const CORBA::Octet* objkey,
			const size_t objkeysize,
			IOP::TaggedProfile& profile) const;

  static inetSocketFactoryType* singleton;
  static void init();

  friend class nobody;

private:
  inetSocketFactoryType();
  ~inetSocketFactoryType() {}  // Cannot delete a factory type instance
};

class inetSocketMTincomingFactory : public incomingRopeFactory {
public:
  inetSocketMTincomingFactory();

  const ropeFactoryType* getType() const { 
    return inetSocketFactoryType::singleton;
  }

  CORBA::Boolean isIncoming(Endpoint* addr) const;
  void instantiateIncoming(Endpoint* addr, CORBA::Boolean export);
  void startIncoming();
  void stopIncoming();
  void removeIncoming();
  Rope* findIncoming(Endpoint* addr) const;
  void getIncomingIOPprofiles(const CORBA::Octet*     objkey,
			      const size_t            objkeysize,
			      IOP::TaggedProfileList& profilelist) const;
  Endpoint *getIncomingEndpoint();
  void getIOPprofiles(const CORBA::Octet* objkey,
			      const size_t objkeysize,
                              IOP::TaggedProfileList& profilelist,
                              Endpoint *e);


  friend class nobody;

private:
  enum { IDLE, ACTIVE, ZOMBIE } pd_state;

  ~inetSocketMTincomingFactory() {} // Cannot delete a factory instance

};


class inetSocketMToutgoingFactory : public outgoingRopeFactory {
public:
  inetSocketMToutgoingFactory();

  const ropeFactoryType* getType() const { 
    return inetSocketFactoryType::singleton;
  }

  CORBA::Boolean isOutgoing(Endpoint* addr) const;
  Rope*  findOrCreateOutgoing(Endpoint* addr);

  friend class nobody;

private:
  ~inetSocketMToutgoingFactory() {} // Cannot delete a factory instance
};

#endif // __INETSOCKETFACTORY_H__
