// -*- Mode: C++; -*-
//                            Package   : omniORB2
// inetSocketFactory.cc       Created on: 18/3/96
//                            Author    : Sai Lai Lo (sll)
//                                      : Tatsuo Nakajima (tatsuo)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	

/*
  $Log: tcpSocket.cc,v $
  Revision 1.4  1998/04/07 19:39:24  sll
  Replace cerr with omniORB::log.

  Revision 1.3  1998/03/13 17:34:16  sll
  Bug fix. No longer reject an IOR with zero length object key.

  Revision 1.2  1997/12/12 18:45:33  sll
  Added call to print out the version of gatekeeper.

  Revision 1.1  1997/12/09 18:43:12  sll
  Initial revision

  */

#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <omniORB2/ConnectionInfo.h>
#include <ropeFactory.h>
#include <objectManager.h>
#include <inetSocket.h>
#include <inetSocketFactory.h>
#include <tcpMTSocket.h>
#include <sslMTSocket.h>

const char* inetSocketEndpoint::protocol_name = "TCPIP";

inetSocketStrand::inetSocketStrand(inetSocketOutgoingRope *r,
                  		   inetSocketEndpoint *addr,
				   size_t buffer_size,
                  		   CORBA::Boolean heapAllocated)
  : reliableStreamStrand(buffer_size,r,heapAllocated),
    pd_send_giop_closeConnection(0), pd_delay_connect(0),
    pd_connect(0), pd_request(NO_REQUEST), pd_info(0)
{
}

inetSocketStrand::inetSocketStrand(inetSocketIncomingRope *r,
                  		   inetSocketHandle_t sock,
				   size_t buffer_size,
                                   CORBA::Boolean heapAllocated)
  : reliableStreamStrand(buffer_size,r,heapAllocated),
    pd_socket(sock), pd_send_giop_closeConnection(1),
    pd_delay_connect(0), pd_connect(0), pd_request(NO_REQUEST), pd_info(0)
{
}

inetSocketIncomingRope::inetSocketIncomingRope(inetSocketMTincomingFactory* f,
                        		       unsigned int maxStrands,
                        		       inetSocketEndpoint *e,
                        		       CORBA::Boolean export)
  : Rope(f->anchor(),maxStrands,1), pd_export(export),
    pd_shutdown(NO_THREAD)
{
}

CORBA::Boolean
inetSocketIncomingRope::this_is(Endpoint *&e)
{
  if (e) {
    inetSocketEndpoint *te = inetSocketEndpoint::castup(e);
    if (!te)
      return 0;
    if (*te == me)
      return 1;
    else
      return 0;
  }
  else {
    e = new inetSocketEndpoint(me);
    if (!e)
      throw CORBA::NO_MEMORY(0,CORBA::COMPLETED_NO);
    return 1;
  }
}

Strand *
inetSocketIncomingRope::newStrand()
{
  throw omniORB::fatalException(__FILE__,__LINE__,
				"newStrand should not be called.");
#ifdef NEED_DUMMY_RETURN
  return 0; // dummy return to keep some compilers happy
#endif
}

ConnectionType
inetSocketIncomingRope::getConnectionType()
{
  return(me->status());
}

inetSocketOutgoingRope::inetSocketOutgoingRope(inetSocketMToutgoingFactory* f,
                        		       unsigned int maxStrands,
                        		       inetSocketEndpoint *e)
  : Rope(f->anchor(),maxStrands,1), pd_terminate(0)
{
  remote = new inetSocketEndpoint(e);
}

inetSocketOutgoingRope::~inetSocketOutgoingRope()
{
  if (omniORB::traceLevel >= 15) {
    cerr << "inetSocketOutgoingRope::~inetSocketOutgoingRope: called." << endl;
  }
  if (remote) {
    delete remote;
    remote = 0;
  }

  //
  // Discard all ropes associated with the rope.
  //
  if(pd_terminate == 0) {
    ConnectionSet *rh = getConnectionSet();
    Rope *r;

    if(rh) {
      while(r = rh->getRope()) {
        if(r != this) {
 	  r->setConnectionSet(NULL);
          r->decrRefCount(1);
        }
      }
    }
  }
}

CORBA::ULong 
inetSocketOutgoingRope::getThroughput()
{
  return remote->throughput();
}

void
inetSocketOutgoingRope::setThroughput(CORBA::ULong throughput)
{
  remote->throughput(throughput);
}

CORBA::Boolean
inetSocketOutgoingRope::remote_is(Endpoint *&e)
{
  Rope *r = getConnectionSet()->getRope(TRANS_IIOP);

  return r->remote_is(e);
}

ConnectionType
inetSocketOutgoingRope::getConnectionType()
{
  return(remote->status());
}

////////////////////// Class inetSocketEndpoint /////////////////////////////

inetSocketEndpoint::inetSocketEndpoint()
    : Endpoint((CORBA::Char *)inetSocketEndpoint::protocol_name) 
{
  pd_inet_host = 0;
  pd_atm_host = 0;
  pd_tcp_port = 0;
  pd_ssl_port = 0;
  pd_atm_port = 0;

  pd_status = TRANS_IIOP;
  pd_throughput = 0;
}

inetSocketEndpoint::inetSocketEndpoint(const inetSocketEndpoint *e)
    : Endpoint((CORBA::Char *)inetSocketEndpoint::protocol_name)
{
  pd_inet_host = 0;
  pd_atm_host = 0;
  pd_tcp_port = 0;
  pd_ssl_port = 0;
  pd_atm_port = 0;
  pd_status = TRANS_IIOP;
  pd_throughput = 0;

  inetHost(e->inetHost());
  atmHost(e->atmHost());
  tcpPort(e->tcpPort());
  sslPort(e->sslPort());
  atmPort(e->atmPort());
  status(e->status());
  throughput(e->throughput());
}

inetSocketEndpoint&
inetSocketEndpoint::operator=(const inetSocketEndpoint &e) 
{
  inetHost(e.inetHost());
  atmHost(e.atmHost());
  tcpPort(e.tcpPort());
  sslPort(e.sslPort());
  atmPort(e.atmPort());
  status(e.status());

  pd_throughput = 0;

  return *this;
}
  
CORBA::Boolean
inetSocketEndpoint::operator==(const inetSocketEndpoint *e)
{
  if ((strcmp((const char *)pd_inet_host, (const char *)e->inetHost())==0)
	       			&& (pd_tcp_port == e->tcpPort())) {
    return 1;
  } else {
    return 0;
  }
}
 
inetSocketEndpoint::~inetSocketEndpoint()
{
  if (pd_inet_host) delete [] pd_inet_host;
  if (pd_atm_host) delete [] pd_atm_host;
}

void
inetSocketEndpoint::inetHost(const CORBA::Char *p)
{
  if (pd_inet_host) delete [] pd_inet_host;
  if (p) {
    pd_inet_host = new CORBA::Char [strlen((char *)p) + 1];
    strcpy((char *)pd_inet_host,(char *)p);
  } else {
    pd_inet_host = new CORBA::Char [1];
    pd_inet_host[0] = '\0';
  }
  return;
}

CORBA::Char*
inetSocketEndpoint::inetHost() const
{
  return pd_inet_host;
}

void
inetSocketEndpoint::atmHost(const CORBA::Char *p)
{
  if (pd_atm_host) delete [] pd_atm_host;
  if (p) {
    pd_atm_host = new CORBA::Char [strlen((char *)p) + 1];
    strcpy((char *)pd_atm_host,(char *)p);
  } else {
    pd_atm_host = new CORBA::Char [1];
    pd_atm_host[0] = '\0';
  }
  return;
}

CORBA::Char*
inetSocketEndpoint::atmHost() const
{
  return pd_atm_host;
}

CORBA::UShort
inetSocketEndpoint::tcpPort() const
{
  return pd_tcp_port;
}

void
inetSocketEndpoint::tcpPort(const CORBA::UShort p)
{
  pd_tcp_port = p;
}

CORBA::UShort
inetSocketEndpoint::sslPort() const
{
  return pd_ssl_port;
}

void
inetSocketEndpoint::sslPort(const CORBA::UShort p)
{
  pd_ssl_port = p;
}

CORBA::UShort
inetSocketEndpoint::atmPort() const
{
  return pd_atm_port;
}

void
inetSocketEndpoint::atmPort(const CORBA::UShort p)
{
  pd_atm_port = p;
}

ConnectionType
inetSocketEndpoint::status() const
{ 
  return pd_status;
}

void
inetSocketEndpoint::status(const ConnectionType ts) 
{ 
  pd_status = ts;
}

CORBA::ULong
inetSocketEndpoint::throughput() const
{
  return pd_throughput;
}

void
inetSocketEndpoint::throughput(const CORBA::ULong throughput)
{
  pd_throughput = throughput;
}

inetSocketEndpoint *
inetSocketEndpoint::castup(const Endpoint *e) 
{
  if (e->is_protocol((CORBA::Char *)inetSocketEndpoint::protocol_name)) {
    return (inetSocketEndpoint *)e;
  }
  else {
    return 0;
  }
}

