// -*- Mode: C++; -*-
//                            Package   : omniORB2
// ConnectionSet.cc           Created on: 12/11/98
//                            Author    : Tatsuo Nakajima (tatsuo)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//

#include <omniORB2/CORBA.h>
#include <omniORB2/rope.h>

ConnectionSet::ConnectionSet()
{
  rope_list = NULL;
}

ConnectionSet::~ConnectionSet()
{
}

Rope *
ConnectionSet::getRope(ConnectionType type)
{
  ConnectionEntry *re;

  for(re = rope_list; ; re = re->r_next) {
    if(re->r_type == type) {
      return re->r_rope;
    }
    if(re->r_next == rope_list) {
      break;
    }
  }

  return NULL;
}

Rope *
ConnectionSet::getRope()
{
  ConnectionEntry *re;
  Rope *r;

  if(rope_list == NULL) {
    return NULL;
  }

  re = rope_list;

  if(re->r_next == rope_list) {
    rope_list = NULL;
  } else {
    re->r_next->r_prev = re->r_prev;
    re->r_prev->r_next = re->r_next;
    rope_list = re->r_next;
  }

  r = re->r_rope;
  delete re;

  return r;
}

void
ConnectionSet::removeRope(Rope *rope)
{
  ConnectionEntry *re;

  if(rope_list == NULL) {
    return;
  }

  re = rope_list;

  for(re = rope_list; ; re = re->r_next) {
    if(re->r_rope == rope) {
      break;
    }
    if(re->r_next == rope_list) {
      return;
    }
  }

  if((re->r_next == rope_list) && (rope_list == re)) {
    rope_list = NULL;
  } else {
    if(rope_list == re) {
      rope_list = re->r_next;
    }
    re->r_next->r_prev = re->r_prev;
    re->r_prev->r_next = re->r_next;
  }

  delete re;

  return;
}

void
ConnectionSet::insertRope(Rope *r, ConnectionType type)
{
  ConnectionEntry *re = new ConnectionEntry(); 
  re->r_rope = r;
  re->r_type = type;

  if(rope_list == NULL) {
    rope_list = re;
    re->r_next = re;
    re->r_prev = re;
    return;
  }

  re->r_next = rope_list;
  re->r_prev = rope_list->r_prev;

  rope_list->r_prev->r_next = re;
  rope_list->r_prev = re;

  rope_list = re;
}

