// -*- Mode: C++; -*-
//                            Package   : omniORB2
// bind.cc                    Created on: 12/11/98
//                            Author    : Tatsuo Nakajima (tatsuo)
//
//    Copyright (C) 1996, 1997 Olivetti & Oracle Research Laboratory
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//

#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <omniORB2/ConnectionInfo.h>
#include <ropeFactory.h>
#include <relStream.h>

//
// ConnectionInterceptor determines the life time of connection, and
// enables the user to call functions that he defined
// when a connection is connected ot disconnected.
// The connection management policy should be determined
// by both the strategy of users and transport.
//

ConnectionInterceptor*
DefaultConnectionInterceptorFactory::create()
{
  return (ConnectionInterceptor *)new DefaultConnectionInterceptor();
}

void
DefaultConnectionInterceptor::beforeConnect(ConnectionState& cs)
{
}

userRequest_t
DefaultConnectionInterceptor::afterConnect(ConnectionState& cs)
{
  return Accept;
}

void
DefaultConnectionInterceptor::beforeAccept()
{
}

userRequest_t
DefaultConnectionInterceptor::afterAccept(ConnectionState& cs)
{
  return Accept;
}

userRequest_t
DefaultConnectionInterceptor::beforeDisconnect(ConnectionState& cs)
{
  return Accept;
}

void
DefaultConnectionInterceptor::afterDisconnect(ConnectionState& cs)
{
}

void
DefaultConnectionInterceptor::changeTransport(ConnectionState& cs)
{
}

//
// The definiction of Connection State object.
//
ConnectionState::~ConnectionState()
{
  delete s_connection_control;
}

ConnectionType
ConnectionState::getConnectionType()
{
  return s_type;
}

ConnectionControl *
ConnectionState::getConnectionControl()
{
  return s_connection_control;
}

void
ConnectionState::setConnectionInfo(int request, int info)
{
  ConnectionInfo c_info;

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  c_info.con_request = request;
  c_info.con_info = info;

  s_strand->controlStrand(SetConnectionInfo, (char *)&c_info, sizeof(c_info));
}

void
ConnectionState::getConnectionInfo(int& request, int& info)
{
  ConnectionInfo c_info = {0, 0};

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(GetConnectionInfo, (char *)&c_info, sizeof(c_info));

  request = c_info.con_request;
  info = c_info.con_info;
}

//
// ConnectionControl Object
//
ConnectionType
ConnectionControl::getConnectionType()
{
  return s_type;
}

CORBA::Boolean
ConnectionControl::getConnectionStatus()
{
  CORBA::Boolean status = 0;

  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(GetConnectionStatus, (char *)&status, sizeof(status));

  return status;
}

CORBA::Boolean
ConnectionControl::openConnection()
{
  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  return s_strand->openConnection();
}

CORBA::Boolean
ConnectionControl::closeConnection()
{
  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  return s_strand->closeConnection();
}

CORBA::Boolean
ConnectionControl::insertConnectionInterceptor(ConnectionInterceptor *i)
{
  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(SetConnectionInterceptor,
			(char *) &i , sizeof(ConnectionInterceptor *)); 

  return 1;
}

CORBA::Boolean
ConnectionControl::notifyTransportChange(ConnectionState *cs)
{
  if(s_strand == NULL) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s_strand->controlStrand(NotifyChangeTransport, (char *) &cs, sizeof(cs));

  return 1;
}
