
#include <omniORB2/CORBA.h>
#include <omniORB2/QOS.h>
#include <omniORB2/SelectionPolicy.h>
#include <ropeFactory.h>

//
// Rebind makes a new object reference which is QOS enable.
// The method returns NULL if an error occurs.
//
CORBA::Object_ptr
omniQOS::rebind(CORBA::Object_ptr op, ConnectionType type)
{
  if(CORBA::is_nil(op)) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  omniObject	*obj = op->PR_getobj();
  omniObject	*new_obj;

  // 
  // The rebind operation can be applied to non QOS enabled object,
  // which is not created by the rebind operation.
  // If a narrow method is called with an QOS enabled object,
  // a new object refrenece returned by the narrow is also 
  // an QOS enable object.
  //
  if(obj->pd_qos_enable) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  } 

  SelectionPolicy *policy = obj->getSelectionPolicy();
  new_obj = policy->createObjectReference(0, type);
  if(!new_obj) {
    return NULL;
  }

  return (CORBA::Object_ptr)(new_obj->_widenFromTheMostDerivedIntf(0));
}

//
// openConnection sets up a connection explicitly. The method returns 0,
// if the connection is already setup.
// The method return NULL if an error occurs, and an exception is raised
// if the method is applied to no qos enable object.
//
CORBA::Boolean
omniQOS::openConnection(CORBA::Object_ptr op)
{
  if(CORBA::is_nil(op)) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  omniRopeAndKey	rk;
  Rope 			*r;
  Strand 		*s;
  CORBA::Boolean	secondHand = 0;
  omniObject		*obj = op->PR_getobj();

  if(!obj->pd_qos_enable) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  } 

  obj->assertObjectExistent();

  obj->getRopeAndKey(rk);
  r = rk.rope();
  if(r == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s = r->getStrand(secondHand);
  if(s == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  return s->openConnection();
}

//
// closeConnection tears down a connection explicitly. The method returns 0,
// if the connection is already tear down.
//
CORBA::Boolean
omniQOS::closeConnection(CORBA::Object_ptr op)
{
  if(CORBA::is_nil(op)) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  omniRopeAndKey	rk;
  Rope			*r;
  Strand 		*s;
  CORBA::Boolean 	secondHand = 0;
  omniObject		*obj = op->PR_getobj();

  if(!obj->pd_qos_enable) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  } 

  obj->getRopeAndKey(rk);

  r = rk.rope();
  if(r == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s = r->getStrand(secondHand);
  if(s == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  obj->assertObjectExistent();

  return s->closeConnection();
}

//
// Insert a new connection interceptor. The method removes the 
// previously inserted connection interceptor.
//
CORBA::Boolean
omniQOS::insertInterceptor(CORBA::Object_ptr op, ConnectionInterceptor *i)
{
  if(CORBA::is_nil(op)) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  omniRopeAndKey	rk;
  Rope  		*r;
  Strand  		*s;
  CORBA::Boolean 	secondHand = 0;
  omniObject		*obj = op->PR_getobj();

  if(!obj->pd_qos_enable) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  } 

  obj->getRopeAndKey(rk);

  r = rk.rope();
  if(r == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s = r->getStrand(secondHand);
  if(s == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  return s->controlStrand(SetConnectionInterceptor, (char *) &i, sizeof(i));
}

//
// get a connection state object from a strand.
//
ConnectionState*
omniQOS::getConnectionState(CORBA::Object_ptr op)
{
  if(CORBA::is_nil(op)) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  omniRopeAndKey	rk;
  Rope			*r;
  Strand		*s;
  CORBA::Boolean 	secondHand = 0;
  CORBA::Boolean  	status;
  ConnectionState 	*cs;
  omniObject		*obj = op->PR_getobj();

  if(!obj->pd_qos_enable) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  } 

  obj->getRopeAndKey(rk);

  r = rk.rope();
  if(r == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  s = r->getStrand(secondHand);
  if(s == NULL) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  status = s->controlStrand(GetConnectionState, (char *) &cs, sizeof(cs));
  if(status) {
    return cs;
  } else {
    return NULL;
  }
}

//
// Set Transport Selection Policy.
//
void
omniQOS::setTransportSelectionPolicy(CORBA::Object_ptr op, SelectionPolicy *p)
{
  if(CORBA::is_nil(op)) {
    CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }

  omniObject	*obj = op->PR_getobj();

  if(!obj->pd_qos_enable) {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  } 

  if(p) {
    obj->setSelectionPolicy(p);

    //
    // Set a pointer to object in the policy. Also the setObject method sets
    // a policy type. 
    //
    p->setObject(obj);
  } else {
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  }
}
