// greeting.cc - This source code demonstrates the use of an object
//               reference by a client to perform an operation on an 
//               object. It is part of the three examples used
//               in Chapter 2 "The Basics" of the omniORB2 user guide.
//
#include <iostream.h>
#include <omniORB2/QOS.h>
#include "echo.hh"

class MyConnectionInterceptor : ConnectionInterceptor {
public:
  virtual userRequest_t afterConnect(ConnectionState& cs);
  virtual void changeTransport(ConnectionState& cs);
};

userRequest_t
MyConnectionInterceptor::afterConnect(ConnectionState& cs)
{
  char *str;

  cout << "MyBindStrategy::afterConnect is called" << endl;

  if(cs.getConnectionType() == TRANS_SSL) {
    SSLConnectionState *ssl_cs = (SSLConnectionState *) &cs;

    str = ssl_cs->getChipher();
    cout << "Chipher : " << str << endl;
    CORBA::string_free(str);

    str = ssl_cs->getIssuer();
    cout << "Issuer : " << str << endl;
    CORBA::string_free(str);

    str = ssl_cs->getSubject();
    cout << "Subject : " << str << endl;
    CORBA::string_free(str);
  }

  return Accept;
}

void
MyConnectionInterceptor::changeTransport(ConnectionState& cs)
{
  switch(cs.getConnectionType()) {
  case TRANS_IIOP:
    cerr << "Current Transport is IIOP" << endl;
    break;

  case TRANS_SSL:
    cerr << "Current Transport is SSL" << endl;
    break;

  case TRANS_ATM:
    cerr << "Current Transport is ATM" << endl;
    break;

  default:
    break;
  }

  cout << "Transport chnage to IIOP" << endl;
}

void
hello(CORBA::Object_ptr obj)
{
  MyConnectionInterceptor *interceptor = new MyConnectionInterceptor();

  Object_ptr new_obj = omniQOS::rebind(obj, TRANS_SSL);

  Echo_var e = Echo::_narrow(new_obj);

  if (CORBA::is_nil(e)) {
    cerr << "hello: cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  omniQOS::insertInterceptor(e, (ConnectionInterceptor *)interceptor);

  omniQOS::openConnection(e);

  CORBA::String_var src = (const char*) "Hello!"; // String literals are not
                                                  // const char*. Must do
                                                  // explicit casting to 
                                                  // force the use of the copy
                                                  // operator=(). 
  CORBA::String_var dest;

  dest = e->echoString(src);

  cerr << "I said,\"" << (char*)src << "\"."
       << " The Object said,\"" << (char*)dest <<"\"" << endl;
 
  omniQOS::closeConnection(e);
}
