// greeting.cc - This source code demonstrates the use of an object
//               reference by a client to perform an operation on an 
//               object. It is part of the three examples used
//               in Chapter 2 "The Basics" of the omniORB2 user guide.
//
#include <iostream.h>
#include <omniORB2/QOS.h>
#include "echo.hh"

class MyConnectionInterceptor : ConnectionInterceptor {
public:
  virtual userRequest_t afterConnect(ConnectionState& cs);
  virtual void changeTransport(ConnectionState& cs);
};

userRequest_t
MyConnectionInterceptor::afterConnect(ConnectionState& cs)
{
  cout << "MyConnectionInterceptor::afterConnect is called" << endl;

  ConnectionControl *cc = cs.getConnectionControl();
  if(cc->getConnectionType() != TRANS_IIOP) {
    cerr << "Connection State is not for IIOP" << endl;

    if(cc->getConnectionType() == TRANS_SSL) {
      cerr << "Connection State is for SSL" << endl;
    } else {
      return Reject;
    }
  }

  IIOPConnectionControl *iiop_cc = (IIOPConnectionControl *)cc;
  char *ipaddr = iiop_cc->getPeerAddress();
  cerr << "Server's IP Address : " << ipaddr << endl;
  CORBA::string_free(ipaddr);

  return Accept;
}

void
MyConnectionInterceptor::changeTransport(ConnectionState& cs)
{
  cout << "Transport chnage to IIOP" << endl;
}

void
hello(CORBA::Object_ptr obj)
{
  MyConnectionInterceptor *interceptor = new MyConnectionInterceptor();

  Object_ptr new_obj = omniQOS::rebind(obj, TRANS_IIOP);

  Echo_var e = Echo::_narrow(new_obj);

  if (CORBA::is_nil(e)) {
    cerr << "hello: cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  omniQOS::insertInterceptor(e, (ConnectionInterceptor *)interceptor);

  omniQOS::openConnection(e);

  CORBA::String_var src = (const char*) "Hello!"; // String literals are not
                                                  // const char*. Must do
                                                  // explicit casting to 
                                                  // force the use of the copy
                                                  // operator=(). 
  CORBA::String_var dest;

  dest = e->echoString(src);

  cerr << "I said,\"" << (char*)src << "\"."
       << " The Object said,\"" << (char*)dest <<"\"" << endl;

  omniQOS::closeConnection(e);
}
