#
# sun4_sosV_5.5.mk - make variables and rules specific to Solaris 2.5.
#

SunOS = 1
SparcProcessor = 1


#
# Include general unix things
#

include $(THIS_IMPORT_TREE)/mk/unix.mk


#
# C preprocessor macro definitions for this architecture
#

IMPORT_CPPFLAGS += -D__sparc__ -D__sunos__ -D__OSVERSION__=5


#
# Standard programs
#

AR = ar cq

MKDIRHIER = mkdirhier
INSTALL           = $(TOP)/$(BINDIR)/installbsd -c 

CPP = /usr/ccs/lib/cpp

CXX = CC
CXXMAKEDEPEND = $(TOP)/$(BINDIR)/omkdepend -D__SUNPRO_CC -D__cplusplus
CXXDEBUGFLAGS = -O2 -fsimple
CXXMTFLAG     = -mt

CXXLINK		= $(CXX)
CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS)

# CXXLINKOPTIONS += $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS))
# Note: the -R linker option in CXXLINKOPTIONS instruct the Sun linker to
# record the pathname of the shared libraries in the executable.

#
# To use gcc uncomment the following lines:
#
#CPP = gcc
#
#CXX = g++
#CXXMAKEDEPEND = $(TOP)/$(BINDIR)/omkdepend -D__cplusplus -D__GNUG__ -D__GNUC__
#CXXDEBUGFLAGS = 
#CXXOPTIONS    =  -fhandle-exceptions -Wall -Wno-unused
#CXXMTFLAG     =
#
#CXXLINK		= $(CXX)
#CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS)
#
# CXXLINKOPTIONS += $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS))
# Note: the -R linker option in CXXLINKOPTIONS instruct the Sun linker to
# record the pathname of the shared libraries in the executable.

CC                = gcc
CMAKEDEPEND       = $(TOP)/$(BINDIR)/omkdepend -D__GNUC__
CDEBUGFLAGS       = -O
COPTIONS	  = -fpcc-struct-return

CLINK             = $(CC)


#
# Socket library
#

SOCKET_LIB = -lsocket -lnsl
THREAD_LIB = -lthread $(CXXMTFLAG)

# SSL extras
# Libraries from SSLeay-0.9.0 to link with omniORB2
SSL_LIB = -L$(TOP)/ssl/lib -lssl -lcrypto

OMNIORB2_LIB += $(SSL_LIB)

#
# CORBA stuff
#

ORBIX2_ROOT = /usr/local/Orbix2
ORBIX2_IDL = idl -c C.cc -s S.cc -B -minterOp
ORBIX2_CPPFLAGS = -D__ORBIX__ -D__ORBIX_2_1 -DORBIX_MT -D_REENTRANT \
                  -DUSE_IIOP -I$(ORBIX2_ROOT)/include -I$(CORBA_STUB_DIR)
ORBIX2_LIB = -L$(ORBIX2_ROOT)/lib -R $(ORBIX2_ROOT)/lib \
                   -liiopmt -lorbixmt -lIRcltmt -lITinimt $(SOCKET_LIB) $(THREAD_LIB)
ORBIX2_STUB_HDR_PATTERN = $(CORBA_STUB_DIR)/%.hh
ORBIX2_STUB_SRC_PATTERN = $(CORBA_STUB_DIR)/%S.cc
ORBIX2_STUB_OBJ_PATTERN = $(CORBA_STUB_DIR)/%S.o
ORBIX2_EXTRA_STUB_FILES = $(CORBA_INTERFACES:%=$(CORBA_STUB_DIR)/%C.cc)

omniORB2GatekeeperImplementation = OMNIORB2_TCPWRAPGK
CorbaImplementation = OMNIORB2

#
# OMNI thread stuff
#

Solaris_OMNITHREAD_LIB = $(patsubst %,$(LibSearchPattern),omnithread) \
			 -lthread -lposix4 $(CXXMTFLAG)
Solaris_OMNITHREAD_CPPFLAGS = -D_REENTRANT $(CXXMTFLAG)

Posix_OMNITHREAD_LIB = $(patsubst %,$(LibSearchPattern),omnithread) -lpthread \
		 -lposix4 $(CXXMTFLAG)
Posix_OMNITHREAD_CPPFLAGS = -DUsePthread -D_REENTRANT $(CXXMTFLAG)
OMNITHREAD_POSIX_CPPFLAGS = -DPthreadDraftVersion=10 \
			    -DPthreadSupportThreadPriority

OMNITHREAD_LIB = $($(ThreadSystem)_OMNITHREAD_LIB)
OMNITHREAD_CPPFLAGS = $($(ThreadSystem)_OMNITHREAD_CPPFLAGS)

ThreadSystem = Posix

lib_depend := $(patsubst %,$(LibPattern),omnithread)
OMNITHREAD_LIB_DEPEND := $(GENERATE_LIB_DEPEND)


#
# OMNI ParTcl stuff
#

TCLTK_CPPFLAGS = -I/usr/local/include/Tcl7.4Tk4.0
TCLTK_LIB = -L/usr/local/lib -ltk4.0 -ltcl7.4 -lm -R /usr/local/lib
X11_CPPFLAGS = -I/usr/openwin/include
X11_LIB = -L/usr/openwin/lib -lX11 -R /usr/openwin/lib
WISH4 = /usr/local/bin/wish4.0

OMNIPARTCL_CPPFLAGS = $(TCLTK_CPPFLAGS) $(X11_CPPFLAGS) $(OMNITHREAD_CPPFLAGS)
OMNIPARTCL_LIB = $(patsubst %,$(LibSearchPattern),omniParTcl) $(TCLTK_LIB) \
		 $(X11_LIB) $(OMNITHREAD_LIB)
lib_depend := $(patsubst %,$(LibPattern),omniParTcl)
OMNIPARTCL_LIB_DEPEND := $(GENERATE_LIB_DEPEND) $(OMNITHREAD_LIB_DEPEND)

#
# Java and Java/CORBA stuff
#

JAVA_ROOT = /usr/local/java-1.1.4
JAVAIDL_ROOT = /usr/local/javaIDL

# Default location of the omniORB2 configuration file [falls back to this if
# the environment variable OMNIORB_CONFIG is not set] :

OMNIORB_CONFIG_DEFAULT_LOCATION = \"/etc/omniORB.cfg\"

# Default directory for the omniNames log files.
OMNINAMES_LOG_DEFAULT_LOCATION = \"/var/omninames\"
