
#ifndef _TCP_CONTEXT_
#define	_TCP_CONTEXT_

//
// Context Object for IIOP
//
class tcpContext {
public:
  tcpContext();
  static void initContext();
  static void initContext(int &argc, char **argv);
  static tcpContext *getContext();
  static void setIIOPOnly();
  static CORBA::Boolean checkIIOPOnly();
  void setConnectionInterceptorFactory(ConnectionInterceptorFactory *factory);
  ConnectionInterceptorFactory *getConnectionInterceptorFactory();

  static tcpContext* singleton;
  static CORBA::Boolean iiop_only;

private:
  ConnectionInterceptorFactory *pd_connection_interceptor_factory;
};

//
// Connection Control Object for IIOP and SSL
//
class inetConnectionControl : public ConnectionControl {
public:

  CORBA::Boolean enableDelayedAck();
  CORBA::Boolean disableDelayedAck();
  CORBA::Boolean checkPeerAddress();
  char *getPeerAddress();

protected:

  inetConnectionControl(Strand *s);
  inetConnectionControl() {};
};

class IIOPConnectionState : public ConnectionState {

private:
  
  IIOPConnectionState(Strand *s);
  IIOPConnectionState() {};

  friend class tcpSocketStrand;
  friend class tcpSocketRendezvouser;
};

class IIOPConnectionControl : public inetConnectionControl {
public:
  
  friend class IIOPConnectionState;

private:

  IIOPConnectionControl(Strand *s);
  IIOPConnectionControl() {};
};

#endif _TCP_CONTEXT_
