
#ifndef _SSL_CONTEXT_
#define	_SSL_CONTEXT_

#include <stdlib.h>
#include <stdio.h>
#include <ssl/rsa.h>
#include <ssl/crypto.h>
#include <ssl/x509.h>
#include <ssl/pem.h>
#include <ssl/ssl.h>
#include <ssl/err.h>

//
// Context Object for SSL
//
class sslContext {
public:
  sslContext();
  static void initContext(int &argc, char **argv);
  static void initContext();
  static void setVBCompat();
  static CORBA::Boolean checkVBCompat();
  static void setUseSSL();
  static CORBA::Boolean checkUseSSL();
  static SSL_CTX* getSSLContext();
  static sslContext* getContext();
  static void setContext();
  static void initContextInternal(CORBA::Boolean flag);

  void setConnectionInterceptorFactory(ConnectionInterceptorFactory *factory);
  ConnectionInterceptorFactory *getConnectionInterceptorFactory();
  void setCertificateFile(char *);
  void setCertificateAuthorityFile(char *);
  void setKeyFile(char *);
  void setVerify();
  void terminateSSLContext();
  CORBA::Boolean checkInitializedByUser();

  static CORBA::Boolean	ssl_only;
  static CORBA::Boolean ssl_vbcompat;
  static int		ssl_verify;
  static SSL_CTX*	sslCtx;
  static sslContext* singleton;

private:
  ConnectionInterceptorFactory *pd_connection_interceptor_factory;
  CORBA::Boolean pd_status;
};

//
// Connection State object for SSL
//
class SSLConnectionState : public ConnectionState {
public:

  char *getChipher();
  char *getIssuer();
  char *getSubject();

  friend class sslSocketStrand;
  friend class sslSocketRendezvouser;

private:

  SSLConnectionState::SSLConnectionState();
  SSLConnectionState::SSLConnectionState(Strand *s);
};

//
// Connection Control Object for SSL
//
class SSLConnectionControl : public inetConnectionControl {
public:

  friend class SSLConnectionState;

private:

  SSLConnectionControl::SSLConnectionControl();
  SSLConnectionControl::SSLConnectionControl(Strand *s);
};

#endif _SSL_CONTEXT_
