
#ifndef _SELECTION_POLICY_
#define	_SELECTION_POLICY_

class SelectionPolicy {
public:

  virtual void runSelectionPolicy() = 0;
  virtual CORBA::Boolean isStaticPolicy() = 0;

  friend class omniObject;
  friend class omniQOS;

protected:
  //
  // Change the current rope to the rope whose connetion type is 
  // specified by the argument.
  //
  CORBA::Boolean changeCurrentTransport(ConnectionType type);

  //
  // Get a connection state object for the object specified in
  // the argument.
  //
  ConnectionState *getConnectionState();
  ConnectionState *getConnectionState(ConnectionType type);
  void deleteConnectionState(ConnectionState *cs) { delete cs; }

  ConnectionType getConnectionType() { return pd_obj->getConnectionType(); }

  virtual SelectionPolicy* copySelectionPolicy() = 0;

  void setObject(omniObject *obj) { pd_obj = obj; }

  omniObject *createObjectReference(const char *repoId, ConnectionType type);

private:

  omniObject *pd_obj;
};

//
// Static Transport Selection Policy
//
// The policy is used when the transport protocol for the specified
// object reference is not changed. In the current implementation,
// the policy is used as a default policy. 
//
class StaticSelectionPolicy : public SelectionPolicy {
public: 
  virtual void runSelectionPolicy();
  virtual CORBA::Boolean isStaticPolicy() { return 1; }

protected:
  virtual SelectionPolicy* copySelectionPolicy()
  {
    return new StaticSelectionPolicy();
  }
};

//
// Dynamic Transport Selection Policy
//
// The policy change the current transport protocol according to
// the current condition of the operational environments. Users
// can give hints to runtime.
//
typedef enum { HighThroughput, LowThroughput } hint_t;

class DynamicSelectionPolicy : public SelectionPolicy {

public:
  virtual void runSelectionPolicy();
  virtual CORBA::Boolean isStaticPolicy() { return 0; }

  //
  // Policy specific method for DynamicSelectionPolicy.
  //
  void setTransportHint(hint_t hint);

protected:

  virtual SelectionPolicy* copySelectionPolicy()
  {
    return new DynamicSelectionPolicy();
  }

private:

  hint_t transport_hint;
};

//
// Explicit Transport Selection Policy
//
// The policy enables users to change the current transport
// protocol used by an object reference.
//
class ExplicitSelectionPolicy : public SelectionPolicy {

public:
  virtual void runSelectionPolicy();
  virtual CORBA::Boolean isStaticPolicy() { return 0; }

  //
  // Policy specific method for ExplicitSelectionPolicy.
  //
  CORBA::Boolean selectTransport(ConnectionType trans);

protected:
  virtual SelectionPolicy* copySelectionPolicy()
  {
    return new ExplicitSelectionPolicy();
  }
};

#endif _SELECTION_POLICY_
