
#ifndef _REDIRECTION_POLICY_H_
#define	_REDIRECTION_POLICY_H_

class RedirectionPolicy {
public:
  //
  // The method is called whenever a locate request is received,
  // and return 1 if location forward is required. The method
  // can be overwritten by users with insertRedirectionPolicy method.
  //
  CORBA::Boolean runRedirectionPolicy(ConnectionType& type,
			ConnectionState *cs, CORBA::ULong& throughput);

  //
  // The method creates a IOR for the object that is passed
  // as an argument.
  // 
  static Endpoint* createEndpoint(ConnectionType& type);

  //
  // marshalling an object reference determined by a redirection policy
  // object in a net buffer stream. 
  //
  static void marshalRedirectionObject(omniObject *o,
		Endpoint *e, NetBufferedStream &s,
		ConnectionType type, CORBA::ULong throughput);

  static void deleteConnectionState(ConnectionState *cs) { delete cs; }
};

//
// Default policy for redirection policy.
//
class DefaultRedirectionPolicy {
public:
  void runRedirectionPolicy(Endpoint *e, ConnectionState *cs);
};

#endif _REDIRECTION_POLICY_H_
