
#ifndef _omniQOS_H_
#define	_omniQOS_H_

typedef enum { Accept, Reject } userRequest_t;

class ConnectionInterceptor;

class omniQOS {
public:
  static CORBA::Object_ptr rebind(CORBA::Object_ptr op, ConnectionType type);
  static CORBA::Boolean openConnection(CORBA::Object_ptr op);
  static CORBA::Boolean closeConnection(CORBA::Object_ptr op);
  static CORBA::Boolean insertInterceptor(CORBA::Object_ptr op,
                                        ConnectionInterceptor *i);
  static ConnectionState* getConnectionState(CORBA::Object_ptr op);
  static void setTransportSelectionPolicy(CORBA::Object_ptr op,
                                        SelectionPolicy *p);
};

//
// Connection Interceptor
//
class ConnectionInterceptor;

class ConnectionInterceptorFactory {
public:
  virtual ConnectionInterceptor *create() = 0;
};

class ConnectionInterceptor {
public:
  virtual void beforeConnect(ConnectionState& cs) {}
  virtual userRequest_t afterConnect(ConnectionState& cs) { return Accept; }
  virtual void beforeAccept() {}
  virtual userRequest_t afterAccept(ConnectionState& cs) { return Accept; }
  virtual userRequest_t beforeDisconnect(ConnectionState& cs) { return Accept; }
  virtual void afterDisconnect(ConnectionState& cs) {}
  virtual void changeTransport(ConnectionState& cs) {}
};

class DefaultConnectionInterceptorFactory
		: public ConnectionInterceptorFactory {
public:
  virtual ConnectionInterceptor *create();
};

class DefaultConnectionInterceptor : public ConnectionInterceptor {
public:
  virtual void beforeConnect(ConnectionState& cs);
  virtual userRequest_t afterConnect(ConnectionState& cs);
  virtual void beforeAccept();
  virtual userRequest_t afterAccept(ConnectionState& cs);
  virtual userRequest_t beforeDisconnect(ConnectionState& cs);
  virtual void afterDisconnect(ConnectionState& cs);
  virtual void changeTransport(ConnectionState& cs);
};

//
// Connection State object
//

class ConnectionState {
public:

  ConnectionType getConnectionType();
  ConnectionControl *getConnectionControl();
  void setConnectionInfo(int request, int info);
  void getConnectionInfo(int& request, int& info);

  friend class GIOP_S;
  friend class SelectionPolicy;
  friend class RedirectionPolicy;
  friend class omniObject;

protected:
  ConnectionState(Strand *s) { s_strand = s; }
  ConnectionState() {}
  ~ConnectionState();

  Strand 		*s_strand;
  ConnectionType 	s_type;
  ConnectionControl	*s_connection_control;
};

class ConnectionControl {
public:

  ConnectionType getConnectionType();
  CORBA::Boolean getConnectionStatus();

  CORBA::Boolean openConnection();
  CORBA::Boolean closeConnection();

  CORBA::Boolean insertConnectionInterceptor(ConnectionInterceptor
			*interceptor);
  CORBA::Boolean notifyTransportChange(ConnectionState *cs);
  ~ConnectionControl() {};

  friend class ConnectionState;

protected:
  ConnectionControl() {};
  ConnectionControl(Strand *s) { s_strand = s; }

  Strand 		*s_strand;
  ConnectionType 	s_type;
};

#include <omniORB2/tcpContext.h>
#include <omniORB2/sslContext.h>

#endif	_omniQOS_H_
