.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) eg1 .obj .cc
	@ $(CreateMms) eg2_impl .obj .cc
	@ $(CreateMms) eg2_clt .obj .cc
	@ $(CreateMms) eg3_impl .obj .cc
	@ $(CreateMms) eg3_clt .obj .cc

.else

CXXSRCS = greeting.cc eg1.cc -
          eg2_impl.cc eg2_clt.cc -
          eg3_impl.cc eg3_clt.cc

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) /Include=([],omni:,$(CORBA_STUB_DIR))

CORBA_INTERFACES = echo
CORBA_STUB_OBJS = $(CORBA_STUB_DIR)echoSK.obj

eg1        = eg1$(DebugSuffix).exe
eg2_impl   = eg2_impl$(DebugSuffix).exe
eg2_clt    = eg2_clt$(DebugSuffix).exe
eg3_impl   = eg3_impl$(DebugSuffix).exe
eg3_clt    = eg3_clt$(DebugSuffix).exe

all :: $(CORBA_STUB_OBJS) $(eg1) $(eg2_impl) $(eg2_clt)  $(eg3_impl) $(eg3_clt)

clean ::
	$(RM) $(eg1) $(eg2_impl) $(eg2_clt) $(eg3_impl) $(eg3_clt)

$(CORBA_STUB_OBJS) ::
	$(BuildCorbaStubs)

export :: $(CORBA_STUB_OBJS)

export :: $(eg1)
	@ $(ExportExecutable)
export :: $(eg2_impl) 
	@ $(ExportExecutable)
export :: $(eg2_clt) 
	@ $(ExportExecutable)
export :: $(eg3_impl) 
	@ $(ExportExecutable)
export :: $(eg3_clt)
	@ $(ExportExecutable)

OBJ_LIBS = $(CORBA_STUB_OBJS) $(CORBA_LIB)
OBJ_LIB_DEPEND = $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)

$(eg1) : eg1.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg2_impl) : eg2_impl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg2_clt) : eg2_clt.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_impl) : eg3_impl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_clt) : eg3_clt.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

.include eg1.mms
.include eg2_impl.mms
.include eg2_clt.mms
.include eg3_impl.mms
.include eg3_clt.mms

.endif
