#
# Standard make variables and rules for all Win32 platforms.
#

Win32Platform = 1

#
# Standard "unix" programs.  Anything here not provided by the GNU-WIN32
# system is likely to need a wrapper around it to perform filename translation.
#

MKDIRHIER	= mkdir -p

INSTALL		= install -c
INSTLIBFLAGS	= -m 0644
INSTEXEFLAGS	= -m 0755

CP = cp
MV = mv -f

AR = $(TOP)/$(BINDIR)/libwrapper

CXX = $(TOP)/$(BINDIR)/clwrapper
CXXMAKEDEPEND = $(TOP)/$(BINDIR)/omkdepend -D__cplusplus -D_MSC_VER
CXXLINK	= $(TOP)/$(BINDIR)/linkwrapper

CC = $(TOP)/$(BINDIR)/clwrapper
CMAKEDEPEND = $(TOP)/$(BINDIR)/omkdepend -D_MSC_VER
CLINK = $(TOP)/$(BINDIR)/linkwrapper

MSVC_CXXNODEBUGFLAGS       = -MD -GX
MSVC_CXXLINKNODEBUGOPTIONS = 
MSVC_CNODEBUGFLAGS         = -MD
MSVC_CLINKNODEBUGOPTIONS   = 

MSVC_CXXDEBUGFLAGS         = -MDd -GX -Z7 -Od 
MSVC_CXXLINKDEBUGOPTIONS   = -debug -PDB:NONE
MSVC_CDEBUGFLAGS           = -MDd -Z7 -Od
MSVC_CLINKDEBUGOPTIONS     = -debug -PDB:NONE

ifdef BuildDebugBinary

CXXLINKOPTIONS = $(MSVC_CXXLINKDEBUGOPTIONS)
CXXDEBUGFLAGS  = 
CXXOPTIONS     = $(MSVC_CXXDEBUGFLAGS)
CLINKOPTIONS   = $(MSVC_CLINKDEBUGOPTIONS)
CDEBUGFLAGS    = $(MSVC_CDEBUGFLAGS)

else

CXXLINKOPTIONS = $(MSVC_CXXLINKNODEBUGOPTIONS)
CXXDEBUGFLAGS  = -O2
CXXOPTIONS     = $(MSVC_CXXNODEBUGFLAGS)
CLINKOPTIONS   = $(MSVC_CLINKNODEBUGOPTIONS)
CDEBUGFLAGS    = -O2
COPTIONS       = $(MSVC_CNODEBUGFLAGS)

endif

IMPORT_CPPFLAGS += -D__WIN32__

SOCKET_LIB = wsock32.lib


#
# Replacements for implicit rules
#

%.o: %.c
	$(CC) -c $(CFLAGS) -Fo$@ $<

%.o: %.cc
	$(CXX) -c $(CXXFLAGS) -Fo$@ $<


#
# General rule for cleaning.
#

define CleanRule
$(RM) *.o *.lib
endef

define VeryCleanRule
$(RM) *.d
$(RM) $(CORBA_STUB_FILES)
endef


#
# Patterns for various file types
#

LibNoDebugPattern = %.lib
LibDebugPattern = %d.lib
DLLNoDebugPattern = %_rt.lib
DLLDebugPattern = %_rtd.lib
LibNoDebugSearchPattern = %.lib
LibDebugSearchPattern = %d.lib
DLLNoDebugSearchPattern = %_rt.lib
DLLDebugSearchPattern = %_rtd.lib


ifndef BuildDebugBinary

LibPattern = $(LibNoDebugPattern)
DLLPattern = $(DLLNoDebugPattern)
LibSearchPattern = $(LibNoDebugSearchPattern)
DLLSearchPattern = $(DLLNoDebugSearchPattern)

else

LibPattern = $(LibDebugPattern)
DLLPattern = $(DLLDebugPattern)
LibSearchPattern = $(LibDebugSearchPattern)
DLLSearchPattern = $(DLLDebugSearchPattern)

endif

BinPattern = %.exe


#
# Stuff to generate statically-linked libraries.
#

define StaticLinkLibrary
(set -x; \
 $(RM) $@; \
 $(AR) $@ $^; \
)
endef

ifdef EXPORT_TREE
define ExportLibrary
(dir="$(EXPORT_TREE)/$(LIBDIR)"; \
 files="$^"; \
 for file in $$files; do \
   $(ExportFileToDir); \
 done; \
)
endef
endif


#
# Stuff to generate executable binaries.
#

IMPORT_LIBRARY_FLAGS = $(patsubst %,-libpath:%/$(LIBDIR),$(IMPORT_TREES))

define CXXExecutable
(set -x; \
 $(RM) $@; \
 $(CXXLINK) -out:$@ $(CXXLINKOPTIONS) $(IMPORT_LIBRARY_FLAGS) $^ $$libs; \
)
endef

define CExecutable
(set -x; \
 $(RM) $@; \
 $(CLINK) -out:$@ $(CLINKOPTIONS) $(IMPORT_LIBRARY_FLAGS) $^ $$libs; \
)
endef

ifdef EXPORT_TREE
define ExportExecutable
(dir="$(EXPORT_TREE)/$(BINDIR)"; \
 files="$^"; \
 for file in $$files; do \
   $(ExportExecutableFileToDir); \
 done; \
)
endef
endif


#
# CORBA stuff
#

# Note that the DLL version is being used, so link to omniorb2_rt.lib

OMNIORB2_IDL_ONLY = omniidl2 -h .hh -s SK.cc
OMNIORB2_IDL_ANY_FLAGS = -a
OMNIORB2_IDL = $(OMNIORB2_IDL_ONLY) $(OMNIORB2_IDL_ANY_FLAGS)
OMNIORB2_CPPFLAGS = -D__OMNIORB2__ -I$(CORBA_STUB_DIR) $(OMNITHREAD_CPPFLAGS)
OMNIORB2_LIB = $(patsubst %,$(DLLSearchPattern),omniORB25) $(OMNITHREAD_LIB) \
		wsock32.lib advapi32.lib
lib_depend := $(patsubst %,$(DLLPattern),omniORB25)
OMNIORB2_LIB_DEPEND := $(GENERATE_LIB_DEPEND) $(OMNITHREAD_LIB_DEPEND)
OMNIORB2_STUB_HDR_PATTERN = $(CORBA_STUB_DIR)/%.hh
OMNIORB2_STUB_SRC_PATTERN = $(CORBA_STUB_DIR)/%SK.cc
OMNIORB2_STUB_OBJ_PATTERN = $(CORBA_STUB_DIR)/%SK.o

# LifeCycle stuff

OMNIORB2_IDL_LC_FLAGS = -l
OMNIORB2_LC_LIB = $(patsubst %,$(DLLSearchPattern),omniLC2)


ORBIX2_ROOT = /win32app/x86/ORBIX
ORBIX2_IDL = idl -c C.cc -s S.cc -B
ORBIX2_CPPFLAGS = -D__ORBIX__ -D__ORBIX_2_1 -DORBIX_MT -D_REENTRANT \
		 -I$(ORBIX2_ROOT)/include -I$(CORBA_STUB_DIR)
ORBIX2_LIB = $(ORBIX2_ROOT)/LIB/ITSRVM.LIB WSOCK32.LIB ADVAPI32.LIB \
		OLDNAMES.LIB
ORBIX2_STUB_HDR_PATTERN = $(CORBA_STUB_DIR)/%.hh
ORBIX2_STUB_SRC_PATTERN = $(CORBA_STUB_DIR)/%S.cc
ORBIX2_STUB_OBJ_PATTERN = $(CORBA_STUB_DIR)/%S.o
ORBIX2_EXTRA_STUB_FILES = $(CORBA_INTERFACES:%=$(CORBA_STUB_DIR)/%C.cc)

CorbaImplementation = OMNIORB2
#
# OMNI thread stuff
#
# Note that the DLL version is being used, so link to omnithread_rt.lib

ThreadSystem = NT
OMNITHREAD_LIB = $(patsubst %,$(DLLSearchPattern),omnithread2)
lib_depend := $(patsubst %,$(DLLPattern),omnithread2)
OMNITHREAD_LIB_DEPEND := $(GENERATE_LIB_DEPEND)
