#ifndef __Naming_hh__
#define __Naming_hh__

#include <omniORB2/CORBA.h>

_CORBA_MODULE CosNaming {
_CORBA_MODULE_PUBLIC

  static const CORBA::TypeCode_ptr _tc_Istring;
  typedef char* Istring;
  typedef CORBA::String_var Istring_var;
  struct NameComponent {
    CORBA::String_member id;
    CORBA::String_member kind;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<NameComponent> NameComponent_var;

  static const CORBA::TypeCode_ptr _tc_NameComponent;

  friend inline void operator<<=(CORBA::Any& _a, const NameComponent& _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_NameComponent->NP_fillInit(_0RL_mbuf);
    _s >>= _0RL_mbuf;
    _a.NP_replaceData(_tc_NameComponent,_0RL_mbuf);
  }

  friend inline void operator<<=(CORBA::Any& _a, NameComponent* _sp) {
    ::operator<<=(_a,*_sp);
    delete _sp;
  }

  friend CORBA::Boolean operator>>=(const CORBA::Any& _a, NameComponent*& _sp);

  static const CORBA::TypeCode_ptr _tc_Name;
  typedef _CORBA_Unbounded_Sequence<NameComponent > Name;
  typedef _CORBA_Sequence_Var<Name, NameComponent > Name_var;

#ifndef __04RL__IDL_SEQUENCE_CosNaming_NameComponent__
#define __04RL__IDL_SEQUENCE_CosNaming_NameComponent__

  friend inline void operator<<=(CORBA::Any& _a, const Name& _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_Name->NP_fillInit(_0RL_mbuf);
    _s >>= _0RL_mbuf;
    _a.NP_replaceData(_tc_Name,_0RL_mbuf);
  }

  friend inline void operator<<=(CORBA::Any& _a, Name* _sp) {
    ::operator<<=(_a,*_sp);
    delete _sp;
  }

  friend inline void _03RL_CosNaming_Name_delete(void* _data) {
    Name* _0RL_t = (Name*) _data;
    delete _0RL_t;
  }

  friend inline CORBA::Boolean operator>>=(const CORBA::Any& _a, Name*& _sp) {
    CORBA::TypeCode_var _0RL_any_tc = _a.type();
    if (!_0RL_any_tc->NP_expandEqual(_tc_Name,1)) {
      _sp = 0;
      return 0;
    }
    else {
      void* _0RL_data = _a.NP_data();

      if (!_0RL_data) {
        MemBufferedStream _0RL_tmp_mbuf;
        _a.NP_getBuffer(_0RL_tmp_mbuf);
        Name* _0RL_tmp = new Name;
        *_0RL_tmp <<= _0RL_tmp_mbuf;
        _0RL_data = (void*) _0RL_tmp;
        _a.NP_holdData(_0RL_data,_03RL_CosNaming_Name_delete);
      }

      _sp = (Name*) _0RL_data;
      return 1;
    }
  }

#endif

  enum BindingType { nobject, ncontext };

  friend inline void operator>>= (BindingType _e,NetBufferedStream &s) {
    ::operator>>=((CORBA::ULong)_e,s);
  }

  friend inline void operator<<= (BindingType &_e,NetBufferedStream &s) {
    CORBA::ULong __e;
    __e <<= s;
    switch (__e) {
      case nobject:
      case ncontext:
        _e = (BindingType) __e;
        break;
      default:
        _CORBA_marshal_error();
    }
  }

  friend inline void operator>>= (BindingType _e,MemBufferedStream &s) {
    ::operator>>=((CORBA::ULong)_e,s);
  }

  friend inline void operator<<= (BindingType &_e,MemBufferedStream &s) {
    CORBA::ULong __e;
    __e <<= s;
    switch (__e) {
      case nobject:
      case ncontext:
        _e = (BindingType) __e;
        break;
      default:
        _CORBA_marshal_error();
    }
  }

  static const CORBA::TypeCode_ptr _tc_BindingType;

  friend inline void operator<<=(CORBA::Any& _a, BindingType _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_BindingType->NP_fillInit(_0RL_mbuf);
    _s >>= _0RL_mbuf;
    _a.NP_replaceData(_tc_BindingType,_0RL_mbuf);
  }

  friend CORBA::Boolean operator>>=(const CORBA::Any& _a, BindingType& _s);

  struct Binding {
    Name binding_name;
    BindingType binding_type;
    
    size_t NP_alignedSize(size_t initialoffset) const;
    void operator>>= (NetBufferedStream &) const;
    void operator<<= (NetBufferedStream &);
    void operator>>= (MemBufferedStream &) const;
    void operator<<= (MemBufferedStream &);
  };

  typedef _CORBA_ConstrType_Variable_Var<Binding> Binding_var;

  static const CORBA::TypeCode_ptr _tc_Binding;

  friend inline void operator<<=(CORBA::Any& _a, const Binding& _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_Binding->NP_fillInit(_0RL_mbuf);
    _s >>= _0RL_mbuf;
    _a.NP_replaceData(_tc_Binding,_0RL_mbuf);
  }

  friend inline void operator<<=(CORBA::Any& _a, Binding* _sp) {
    ::operator<<=(_a,*_sp);
    delete _sp;
  }

  friend CORBA::Boolean operator>>=(const CORBA::Any& _a, Binding*& _sp);

  static const CORBA::TypeCode_ptr _tc_BindingList;
  typedef _CORBA_Unbounded_Sequence<Binding > BindingList;
  typedef _CORBA_Sequence_Var<BindingList, Binding > BindingList_var;

#ifndef __04RL__IDL_SEQUENCE_CosNaming_Binding__
#define __04RL__IDL_SEQUENCE_CosNaming_Binding__

  friend inline void operator<<=(CORBA::Any& _a, const BindingList& _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_BindingList->NP_fillInit(_0RL_mbuf);
    _s >>= _0RL_mbuf;
    _a.NP_replaceData(_tc_BindingList,_0RL_mbuf);
  }

  friend inline void operator<<=(CORBA::Any& _a, BindingList* _sp) {
    ::operator<<=(_a,*_sp);
    delete _sp;
  }

  friend inline void _03RL_CosNaming_BindingList_delete(void* _data) {
    BindingList* _0RL_t = (BindingList*) _data;
    delete _0RL_t;
  }

  friend inline CORBA::Boolean operator>>=(const CORBA::Any& _a, BindingList*& _sp) {
    CORBA::TypeCode_var _0RL_any_tc = _a.type();
    if (!_0RL_any_tc->NP_expandEqual(_tc_BindingList,1)) {
      _sp = 0;
      return 0;
    }
    else {
      void* _0RL_data = _a.NP_data();

      if (!_0RL_data) {
        MemBufferedStream _0RL_tmp_mbuf;
        _a.NP_getBuffer(_0RL_tmp_mbuf);
        BindingList* _0RL_tmp = new BindingList;
        *_0RL_tmp <<= _0RL_tmp_mbuf;
        _0RL_data = (void*) _0RL_tmp;
        _a.NP_holdData(_0RL_data,_03RL_CosNaming_BindingList_delete);
      }

      _sp = (BindingList*) _0RL_data;
      return 1;
    }
  }

#endif

#ifndef __CosNaming_BindingIterator__
#define __CosNaming_BindingIterator__
  class   BindingIterator;
  typedef BindingIterator* BindingIterator_ptr;
  typedef BindingIterator_ptr BindingIteratorRef;
  class _proxy_BindingIterator;
  class _sk_BindingIterator;
  class _nil_BindingIterator;

  class BindingIterator_Helper {
    public:
    static BindingIterator_ptr _nil();
    static CORBA::Boolean is_nil(BindingIterator_ptr p);
    static void release(BindingIterator_ptr p);
    static void duplicate(BindingIterator_ptr p);
    static size_t NP_alignedSize(BindingIterator_ptr obj,size_t initialoffset);
    static void marshalObjRef(BindingIterator_ptr obj,NetBufferedStream &s);
    static BindingIterator_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(BindingIterator_ptr obj,MemBufferedStream &s);
    static BindingIterator_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<BindingIterator,BindingIterator_Helper> BindingIterator_var;

#endif
#ifndef __CosNaming_NamingContext__
#define __CosNaming_NamingContext__
  class   NamingContext;
  typedef NamingContext* NamingContext_ptr;
  typedef NamingContext_ptr NamingContextRef;
  class _proxy_NamingContext;
  class _sk_NamingContext;
  class _nil_NamingContext;

  class NamingContext_Helper {
    public:
    static NamingContext_ptr _nil();
    static CORBA::Boolean is_nil(NamingContext_ptr p);
    static void release(NamingContext_ptr p);
    static void duplicate(NamingContext_ptr p);
    static size_t NP_alignedSize(NamingContext_ptr obj,size_t initialoffset);
    static void marshalObjRef(NamingContext_ptr obj,NetBufferedStream &s);
    static NamingContext_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(NamingContext_ptr obj,MemBufferedStream &s);
    static NamingContext_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<NamingContext,NamingContext_Helper> NamingContext_var;

#endif
#ifndef __CosNaming_NamingContext__
#define __CosNaming_NamingContext__
  class   NamingContext;
  typedef NamingContext* NamingContext_ptr;
  typedef NamingContext_ptr NamingContextRef;

  class NamingContext_Helper {
    public:
    static NamingContext_ptr _nil();
    static CORBA::Boolean is_nil(NamingContext_ptr p);
    static void release(NamingContext_ptr p);
    static void duplicate(NamingContext_ptr p);
    static size_t NP_alignedSize(NamingContext_ptr obj,size_t initialoffset);
    static void marshalObjRef(NamingContext_ptr obj,NetBufferedStream &s);
    static NamingContext_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(NamingContext_ptr obj,MemBufferedStream &s);
    static NamingContext_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<NamingContext,NamingContext_Helper> NamingContext_var;

#endif
#define CosNaming_NamingContext_IntfRepoID "IDL:omg.org/CosNaming/NamingContext:1.0"

  class NamingContext : public virtual omniObject, public virtual CORBA::Object {
  public:

    enum NotFoundReason { missing_node, not_context, not_object };

    friend inline void operator>>= (NotFoundReason _e,NetBufferedStream &s) {
      ::operator>>=((CORBA::ULong)_e,s);
    }

    friend inline void operator<<= (NotFoundReason &_e,NetBufferedStream &s) {
      CORBA::ULong __e;
      __e <<= s;
      switch (__e) {
        case missing_node:
        case not_context:
        case not_object:
          _e = (NotFoundReason) __e;
          break;
        default:
          _CORBA_marshal_error();
      }
    }

    friend inline void operator>>= (NotFoundReason _e,MemBufferedStream &s) {
      ::operator>>=((CORBA::ULong)_e,s);
    }

    friend inline void operator<<= (NotFoundReason &_e,MemBufferedStream &s) {
      CORBA::ULong __e;
      __e <<= s;
      switch (__e) {
        case missing_node:
        case not_context:
        case not_object:
          _e = (NotFoundReason) __e;
          break;
        default:
          _CORBA_marshal_error();
      }
    }

    static const CORBA::TypeCode_ptr _tc_NotFoundReason;

    friend inline void operator<<=(CORBA::Any& _a, NotFoundReason _s) {
      MemBufferedStream _0RL_mbuf;
      _tc_NotFoundReason->NP_fillInit(_0RL_mbuf);
      _s >>= _0RL_mbuf;
      _a.NP_replaceData(_tc_NotFoundReason,_0RL_mbuf);
    }

    friend CORBA::Boolean operator>>=(const CORBA::Any& _a, NotFoundReason& _s);

#define CosNaming_NamingContext_NotFound_IntfRepoID "IDL:omg.org/CosNaming/NamingContext/NotFound:1.0"

    class NotFound : public CORBA::UserException {
    public:

      NotFoundReason why;
      Name rest_of_name;
      
      NotFound() {};
      NotFound(const NotFound &);
      NotFound(NotFoundReason  _why, const Name _rest_of_name);
      NotFound & operator=(const NotFound &);
      virtual ~NotFound() {};
      size_t NP_alignedSize(size_t initialoffset);
      void operator>>= (NetBufferedStream &);
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &);
      void operator<<= (MemBufferedStream &);
    };

    static const CORBA::TypeCode_ptr _tc_NotFound;

    friend inline void operator<<=(CORBA::Any& _a, const NotFound& _s) {
      MemBufferedStream _0RL_mbuf;
      _tc_NotFound->NP_fillInit(_0RL_mbuf);
      NotFound _0RL_s = _s;
      _0RL_s >>= _0RL_mbuf;
      _a.NP_replaceData(_tc_NotFound,_0RL_mbuf);
    }

    friend inline void operator<<=(CORBA::Any& _a, NotFound* _sp) {
      ::operator<<=(_a,*_sp);
      delete _sp;
    }

    friend CORBA::Boolean operator>>=(const CORBA::Any& _a, NotFound*& _sp);

#define CosNaming_NamingContext_CannotProceed_IntfRepoID "IDL:omg.org/CosNaming/NamingContext/CannotProceed:1.0"

    class CannotProceed : public CORBA::UserException {
    public:

      _CORBA_ObjRef_Member<NamingContext,NamingContext_Helper> cxt;
      Name rest_of_name;
      
      CannotProceed() {};
      CannotProceed(const CannotProceed &);
      CannotProceed(NamingContext_ptr _cxt, const Name _rest_of_name);
      CannotProceed & operator=(const CannotProceed &);
      virtual ~CannotProceed() {};
      size_t NP_alignedSize(size_t initialoffset);
      void operator>>= (NetBufferedStream &);
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &);
      void operator<<= (MemBufferedStream &);
    };

    static const CORBA::TypeCode_ptr _tc_CannotProceed;

    friend inline void operator<<=(CORBA::Any& _a, const CannotProceed& _s) {
      MemBufferedStream _0RL_mbuf;
      _tc_CannotProceed->NP_fillInit(_0RL_mbuf);
      CannotProceed _0RL_s = _s;
      _0RL_s >>= _0RL_mbuf;
      _a.NP_replaceData(_tc_CannotProceed,_0RL_mbuf);
    }

    friend inline void operator<<=(CORBA::Any& _a, CannotProceed* _sp) {
      ::operator<<=(_a,*_sp);
      delete _sp;
    }

    friend CORBA::Boolean operator>>=(const CORBA::Any& _a, CannotProceed*& _sp);

#define CosNaming_NamingContext_InvalidName_IntfRepoID "IDL:omg.org/CosNaming/NamingContext/InvalidName:1.0"

    class InvalidName : public CORBA::UserException {
    public:

      
      InvalidName() {};
      InvalidName(const InvalidName &);
      InvalidName & operator=(const InvalidName &);
      virtual ~InvalidName() {};
      size_t NP_alignedSize(size_t initialoffset);
      void operator>>= (NetBufferedStream &);
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &);
      void operator<<= (MemBufferedStream &);
    };

    static const CORBA::TypeCode_ptr _tc_InvalidName;

    friend inline void operator<<=(CORBA::Any& _a, const InvalidName& _s) {
      MemBufferedStream _0RL_mbuf;
      _tc_InvalidName->NP_fillInit(_0RL_mbuf);
      InvalidName _0RL_s = _s;
      _0RL_s >>= _0RL_mbuf;
      _a.NP_replaceData(_tc_InvalidName,_0RL_mbuf);
    }

    friend inline void operator<<=(CORBA::Any& _a, InvalidName* _sp) {
      ::operator<<=(_a,*_sp);
      delete _sp;
    }

    friend CORBA::Boolean operator>>=(const CORBA::Any& _a, InvalidName*& _sp);

#define CosNaming_NamingContext_AlreadyBound_IntfRepoID "IDL:omg.org/CosNaming/NamingContext/AlreadyBound:1.0"

    class AlreadyBound : public CORBA::UserException {
    public:

      
      AlreadyBound() {};
      AlreadyBound(const AlreadyBound &);
      AlreadyBound & operator=(const AlreadyBound &);
      virtual ~AlreadyBound() {};
      size_t NP_alignedSize(size_t initialoffset);
      void operator>>= (NetBufferedStream &);
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &);
      void operator<<= (MemBufferedStream &);
    };

    static const CORBA::TypeCode_ptr _tc_AlreadyBound;

    friend inline void operator<<=(CORBA::Any& _a, const AlreadyBound& _s) {
      MemBufferedStream _0RL_mbuf;
      _tc_AlreadyBound->NP_fillInit(_0RL_mbuf);
      AlreadyBound _0RL_s = _s;
      _0RL_s >>= _0RL_mbuf;
      _a.NP_replaceData(_tc_AlreadyBound,_0RL_mbuf);
    }

    friend inline void operator<<=(CORBA::Any& _a, AlreadyBound* _sp) {
      ::operator<<=(_a,*_sp);
      delete _sp;
    }

    friend CORBA::Boolean operator>>=(const CORBA::Any& _a, AlreadyBound*& _sp);

#define CosNaming_NamingContext_NotEmpty_IntfRepoID "IDL:omg.org/CosNaming/NamingContext/NotEmpty:1.0"

    class NotEmpty : public CORBA::UserException {
    public:

      
      NotEmpty() {};
      NotEmpty(const NotEmpty &);
      NotEmpty & operator=(const NotEmpty &);
      virtual ~NotEmpty() {};
      size_t NP_alignedSize(size_t initialoffset);
      void operator>>= (NetBufferedStream &);
      void operator<<= (NetBufferedStream &);
      void operator>>= (MemBufferedStream &);
      void operator<<= (MemBufferedStream &);
    };

    static const CORBA::TypeCode_ptr _tc_NotEmpty;

    friend inline void operator<<=(CORBA::Any& _a, const NotEmpty& _s) {
      MemBufferedStream _0RL_mbuf;
      _tc_NotEmpty->NP_fillInit(_0RL_mbuf);
      NotEmpty _0RL_s = _s;
      _0RL_s >>= _0RL_mbuf;
      _a.NP_replaceData(_tc_NotEmpty,_0RL_mbuf);
    }

    friend inline void operator<<=(CORBA::Any& _a, NotEmpty* _sp) {
      ::operator<<=(_a,*_sp);
      delete _sp;
    }

    friend CORBA::Boolean operator>>=(const CORBA::Any& _a, NotEmpty*& _sp);

    virtual void bind ( const Name & n, CORBA::Object_ptr  obj ) = 0;
    virtual void rebind ( const Name & n, CORBA::Object_ptr  obj ) = 0;
    virtual void bind_context ( const Name & n, NamingContext_ptr  nc ) = 0;
    virtual void rebind_context ( const Name & n, NamingContext_ptr  nc ) = 0;
    virtual CORBA::Object_ptr  resolve ( const Name & n ) = 0;
    virtual void unbind ( const Name & n ) = 0;
    virtual NamingContext_ptr  new_context (  ) = 0;
    virtual NamingContext_ptr  bind_new_context ( const Name & n ) = 0;
    virtual void destroy (  ) = 0;
    virtual void _0RL__list ( CORBA::ULong  how_many, BindingList *& bl, BindingIterator_ptr & bi ) = 0;
    void list ( CORBA::ULong  how_many,
                      _CORBA_Sequence_OUT_arg<BindingList,BindingList_var >  bl,
                      _CORBA_ObjRef_OUT_arg<BindingIterator,BindingIterator_var,_CORBA_ObjRef_Member<BindingIterator,BindingIterator_Helper>,BindingIterator_Helper >  bi )
    {
      _0RL__list ( how_many, bl._data, bi._data );
    }
    static NamingContext_ptr _duplicate(NamingContext_ptr);
    static NamingContext_ptr _narrow(CORBA::Object_ptr);
    static NamingContext_ptr _nil();

    static inline size_t NP_alignedSize(NamingContext_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CosNaming_NamingContext_IntfRepoID,40,initialoffset);
    }

    static inline void marshalObjRef(NamingContext_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CosNaming_NamingContext_IntfRepoID,40,s);
    }

    static inline NamingContext_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CosNaming_NamingContext_IntfRepoID,s);
      NamingContext_ptr _result = CosNaming::NamingContext::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(NamingContext_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CosNaming_NamingContext_IntfRepoID,40,s);
    }

    static inline NamingContext_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CosNaming_NamingContext_IntfRepoID,s);
      NamingContext_ptr _result = CosNaming::NamingContext::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    NamingContext() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CosNaming_NamingContext_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~NamingContext() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    NamingContext(const NamingContext&);
    NamingContext &operator=(const NamingContext&);
  };

  class _sk_NamingContext :  public virtual NamingContext {
  public:

    _sk_NamingContext() {}
    _sk_NamingContext(const omniORB::objectKey& k);
    virtual ~_sk_NamingContext() {}
    NamingContext_ptr _this() { return NamingContext::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual void bind ( const Name & n, CORBA::Object_ptr  obj ) = 0;
    virtual void rebind ( const Name & n, CORBA::Object_ptr  obj ) = 0;
    virtual void bind_context ( const Name & n, NamingContext_ptr  nc ) = 0;
    virtual void rebind_context ( const Name & n, NamingContext_ptr  nc ) = 0;
    virtual CORBA::Object_ptr  resolve ( const Name & n ) = 0;
    virtual void unbind ( const Name & n ) = 0;
    virtual NamingContext_ptr  new_context (  ) = 0;
    virtual NamingContext_ptr  bind_new_context ( const Name & n ) = 0;
    virtual void destroy (  ) = 0;
    virtual void list ( CORBA::ULong  how_many, BindingList *& bl, BindingIterator_ptr & bi ) = 0;
    virtual void _0RL__list ( CORBA::ULong  how_many, BindingList *& bl, BindingIterator_ptr & bi ) {
      list ( how_many, bl, bi );
    }
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return NamingContext::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_NamingContext (const _sk_NamingContext&);
    _sk_NamingContext &operator=(const _sk_NamingContext&);
  };

  class _proxy_NamingContext :  public virtual NamingContext {
  public:

    _proxy_NamingContext (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CosNaming_NamingContext_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_NamingContext() {}
    virtual void bind ( const Name & n, CORBA::Object_ptr  obj );
    virtual void rebind ( const Name & n, CORBA::Object_ptr  obj );
    virtual void bind_context ( const Name & n, NamingContext_ptr  nc );
    virtual void rebind_context ( const Name & n, NamingContext_ptr  nc );
    virtual CORBA::Object_ptr  resolve ( const Name & n );
    virtual void unbind ( const Name & n );
    virtual NamingContext_ptr  new_context (  );
    virtual NamingContext_ptr  bind_new_context ( const Name & n );
    virtual void destroy (  );
    virtual void _0RL__list ( CORBA::ULong  how_many, BindingList *& bl, BindingIterator_ptr & bi );

  protected:

    _proxy_NamingContext () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return NamingContext::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_NamingContext (const _proxy_NamingContext&);
    _proxy_NamingContext &operator=(const _proxy_NamingContext&);
  };

  class _nil_NamingContext :   public virtual NamingContext {
  public:
    _nil_NamingContext() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_NamingContext() {}
    void bind ( const Name & n, CORBA::Object_ptr  obj ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

    void rebind ( const Name & n, CORBA::Object_ptr  obj ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

    void bind_context ( const Name & n, NamingContext_ptr  nc ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

    void rebind_context ( const Name & n, NamingContext_ptr  nc ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

    CORBA::Object_ptr  resolve ( const Name & n ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::Object_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void unbind ( const Name & n ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

    NamingContext_ptr  new_context (  ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      NamingContext_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    NamingContext_ptr  bind_new_context ( const Name & n ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      NamingContext_ptr _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void destroy (  ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

    void _0RL__list ( CORBA::ULong  how_many, BindingList *& bl, BindingIterator_ptr & bi ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return NamingContext::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class NamingContext_proxyObjectFactory : public proxyObjectFactory {
  public:
    NamingContext_proxyObjectFactory () {}
    virtual ~NamingContext_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static NamingContext_ptr _nil() {
      if (!__nil_NamingContext) {
        __nil_NamingContext = new _nil_NamingContext;
      }
      return __nil_NamingContext;
    }
  private:
    static NamingContext_ptr __nil_NamingContext;
  };

  static const CORBA::TypeCode_ptr _tc_NamingContext;

  friend inline void operator<<=(CORBA::Any& _a, NamingContext_ptr _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_NamingContext->NP_fillInit(_0RL_mbuf);
    NamingContext::marshalObjRef(_s,_0RL_mbuf);
    _a.NP_replaceData(_tc_NamingContext,_0RL_mbuf);
  }

  friend inline void operator<<=(CORBA::Any& _a, NamingContext_ptr* _sp) {
    ::operator<<=(_a,*_sp);
    CORBA::release(*_sp);
  }

  friend CORBA::Boolean operator>>=(const CORBA::Any& _a, NamingContext_ptr& _s);

#ifndef __CosNaming_BindingIterator__
#define __CosNaming_BindingIterator__
  class   BindingIterator;
  typedef BindingIterator* BindingIterator_ptr;
  typedef BindingIterator_ptr BindingIteratorRef;

  class BindingIterator_Helper {
    public:
    static BindingIterator_ptr _nil();
    static CORBA::Boolean is_nil(BindingIterator_ptr p);
    static void release(BindingIterator_ptr p);
    static void duplicate(BindingIterator_ptr p);
    static size_t NP_alignedSize(BindingIterator_ptr obj,size_t initialoffset);
    static void marshalObjRef(BindingIterator_ptr obj,NetBufferedStream &s);
    static BindingIterator_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(BindingIterator_ptr obj,MemBufferedStream &s);
    static BindingIterator_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<BindingIterator,BindingIterator_Helper> BindingIterator_var;

#endif
#define CosNaming_BindingIterator_IntfRepoID "IDL:omg.org/CosNaming/BindingIterator:1.0"

  class BindingIterator : public virtual omniObject, public virtual CORBA::Object {
  public:

    virtual CORBA::Boolean  _0RL__next_one ( Binding *& b ) = 0;
    CORBA::Boolean  next_one ( _CORBA_ConstrType_Variable_OUT_arg<Binding,Binding_var>  b )
    {
      return _0RL__next_one ( b._data );
    }
    virtual CORBA::Boolean  _0RL__next_n ( CORBA::ULong  how_many, BindingList *& bl ) = 0;
    CORBA::Boolean  next_n ( CORBA::ULong  how_many,
                                   _CORBA_Sequence_OUT_arg<BindingList,BindingList_var >  bl )
    {
      return _0RL__next_n ( how_many, bl._data );
    }
    virtual void destroy (  ) = 0;
    static BindingIterator_ptr _duplicate(BindingIterator_ptr);
    static BindingIterator_ptr _narrow(CORBA::Object_ptr);
    static BindingIterator_ptr _nil();

    static inline size_t NP_alignedSize(BindingIterator_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,CosNaming_BindingIterator_IntfRepoID,42,initialoffset);
    }

    static inline void marshalObjRef(BindingIterator_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CosNaming_BindingIterator_IntfRepoID,42,s);
    }

    static inline BindingIterator_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CosNaming_BindingIterator_IntfRepoID,s);
      BindingIterator_ptr _result = CosNaming::BindingIterator::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(BindingIterator_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,CosNaming_BindingIterator_IntfRepoID,42,s);
    }

    static inline BindingIterator_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(CosNaming_BindingIterator_IntfRepoID,s);
      BindingIterator_ptr _result = CosNaming::BindingIterator::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _0RL_is_a(const char *base_repoId);

  protected:

    BindingIterator() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(CosNaming_BindingIterator_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~BindingIterator() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id=0);

  private:

    BindingIterator(const BindingIterator&);
    BindingIterator &operator=(const BindingIterator&);
  };

  class _sk_BindingIterator :  public virtual BindingIterator {
  public:

    _sk_BindingIterator() {}
    _sk_BindingIterator(const omniORB::objectKey& k);
    virtual ~_sk_BindingIterator() {}
    BindingIterator_ptr _this() { return BindingIterator::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual CORBA::Boolean  next_one ( Binding *& b ) = 0;
    virtual CORBA::Boolean  _0RL__next_one ( Binding *& b ) {
      return next_one ( b );
    }
    virtual CORBA::Boolean  next_n ( CORBA::ULong  how_many, BindingList *& bl ) = 0;
    virtual CORBA::Boolean  _0RL__next_n ( CORBA::ULong  how_many, BindingList *& bl ) {
      return next_n ( how_many, bl );
    }
    virtual void destroy (  ) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return BindingIterator::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  private:
    _sk_BindingIterator (const _sk_BindingIterator&);
    _sk_BindingIterator &operator=(const _sk_BindingIterator&);
  };

  class _proxy_BindingIterator :  public virtual BindingIterator {
  public:

    _proxy_BindingIterator (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(CosNaming_BindingIterator_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_BindingIterator() {}
    virtual CORBA::Boolean  _0RL__next_one ( Binding *& b );
    virtual CORBA::Boolean  _0RL__next_n ( CORBA::ULong  how_many, BindingList *& bl );
    virtual void destroy (  );

  protected:

    _proxy_BindingIterator () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type) {
      return BindingIterator::_widenFromTheMostDerivedIntf(repoId,is_cxx_type);
    }
  private:

    _proxy_BindingIterator (const _proxy_BindingIterator&);
    _proxy_BindingIterator &operator=(const _proxy_BindingIterator&);
  };

  class _nil_BindingIterator :   public virtual BindingIterator {
  public:
    _nil_BindingIterator() : omniObject(omniObject::nilObjectManager()) { this->PR_setobj(0); }
    virtual ~_nil_BindingIterator() {}
    CORBA::Boolean  _0RL__next_one ( Binding *& b ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::Boolean _0RL_result = 0;
      return _0RL_result;
#endif
    }

    CORBA::Boolean  _0RL__next_n ( CORBA::ULong  how_many, BindingList *& bl ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      CORBA::Boolean _0RL_result = 0;
      return _0RL_result;
#endif
    }

    void destroy (  ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
#ifdef NEED_DUMMY_RETURN
      // never reach here! Dummy return to keep some compilers happy.
      return;
#endif
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id) {
      return BindingIterator::_widenFromTheMostDerivedIntf(repoId,is_cxx_type_id);
    }
  };

  class BindingIterator_proxyObjectFactory : public proxyObjectFactory {
  public:
    BindingIterator_proxyObjectFactory () {}
    virtual ~BindingIterator_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static BindingIterator_ptr _nil() {
      if (!__nil_BindingIterator) {
        __nil_BindingIterator = new _nil_BindingIterator;
      }
      return __nil_BindingIterator;
    }
  private:
    static BindingIterator_ptr __nil_BindingIterator;
  };

  static const CORBA::TypeCode_ptr _tc_BindingIterator;

  friend inline void operator<<=(CORBA::Any& _a, BindingIterator_ptr _s) {
    MemBufferedStream _0RL_mbuf;
    _tc_BindingIterator->NP_fillInit(_0RL_mbuf);
    BindingIterator::marshalObjRef(_s,_0RL_mbuf);
    _a.NP_replaceData(_tc_BindingIterator,_0RL_mbuf);
  }

  friend inline void operator<<=(CORBA::Any& _a, BindingIterator_ptr* _sp) {
    ::operator<<=(_a,*_sp);
    CORBA::release(*_sp);
  }

  friend CORBA::Boolean operator>>=(const CORBA::Any& _a, BindingIterator_ptr& _s);

};

#endif // __Naming_hh__
