# -*- python -*-
#                           Package   : omniidl
# __init__.py               Created on: 1999/11/11
#			    Author    : David Scott (djs)
#
#    Copyright (C) 1999 AT&T Laboratories Cambridge
#
#  This file is part of omniidl.
#
#  omniidl is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA.
#
# Description:
#
#   Entrypoint to skeleton generation code

# $Id: __init__.py,v 1.5.2.4 2000/06/26 16:24:16 djs Exp $
# $Log: __init__.py,v $
# Revision 1.5.2.4  2000/06/26 16:24:16  djs
# Refactoring of configuration state mechanism.
#
# Revision 1.5.2.3  2000/05/31 18:03:38  djs
# Better output indenting (and preprocessor directives now correctly output at
# the beginning of lines)
# Calling an exception "e" resulted in a name clash (and resultant C++
# compile failure)
#
# Revision 1.5.2.2  2000/03/20 11:50:25  djs
# Removed excess buffering- output templates have code attached which is
# lazily evaluated when required.
#
# Revision 1.5.2.1  2000/02/14 18:34:54  dpg1
# New omniidl merged in.
#
# Revision 1.5  2000/01/13 15:56:43  djs
# Factored out private identifier prefix rather than hard coding it all through
# the code.
#
# Revision 1.4  2000/01/13 14:16:34  djs
# Properly clears state between processing separate IDL input files
#
# Revision 1.3  2000/01/11 11:34:49  djs
# Added support for fragment generation (-F) mode
#
# Revision 1.2  1999/11/19 20:10:13  djs
# Now runs the poa generating code after the main code
#
# Revision 1.1  1999/11/12 17:18:57  djs
# Struct skeleton code added
#

# -----------------------------
# Configuration data
from omniidl_be.cxx import config

# -----------------------------
# Utility functions
from omniidl_be.cxx import tyutil, util

from omniidl_be.cxx.skel import main
from omniidl_be.cxx.skel import poa
from omniidl_be.cxx.skel import mangler

def monolithic(stream, tree):
    """Creates one large skeleton with all code inside"""
    stream.out("""\
// This file is generated by @program@- @library@. Do not edit.

#include "@basename@@hh@"
#include <omniORB3/callDescriptor.h>

static const char* @prefix@_library_version = @library@;


""",
               program = config.state['Program Name'],
               library = config.state['Library Version'],
               basename = config.state['Basename'],
               hh = config.state['HH Suffix'],
               prefix = config.state['Private Prefix'])

    skel = main.__init__(stream)
    tree.accept(skel)

    poa_skel = poa.__init__(stream)
    tree.accept(poa_skel)

def fragment(stream, tree):
    """Used in fragment mode"""

    stream.out("""\
// This file is generated by @program@- @library@. Do not edit.
""",
               program = config.state['Program Name'],
               library = config.state['Library Version'])
    
    skel = main.__init__(stream)
    tree.accept(skel)

    poa_skel = poa.__init__(stream)
    tree.accept(poa_skel)


def run(tree):
    # create somewhere to put the output
    skel_filename = config.state['Basename'] +\
                    config.state['SK Suffix']
    stream = util.Stream(open(skel_filename, "w"), 2)

    # clear all state
    mangler.__init__()

    if config.state['Fragment']:
        fragment(stream, tree)
    else:
        # generate one big chunk of code
        monolithic(stream, tree)





