// -*- Mode: C++; -*-
//                            Package   : omniORB3
// idlfloat_vax.cc            Created on: 2001-04-05 12:16:07
//                            Author    : Bruce Visscher (visschb@rjrt.com)
//
//    Copyright (C) 2001 AT&T Laboratories Cambridge
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	Float and Double conversion operators for OpenVMS on the VAX platform.
//	This file is specific to OpenVMS.
//

/* 
   $Log: idlfloat_vax.cc,v $

   Revision 1.0  2001/04/05 12:14:50  bcv
   Created from src/lib/omniorb2/orbcore/corbagfloat.cc

*/

#include <errno.h>
#include <idlerr.h>
#include <idlsysdep.h>
#include <omniORB3/CORBA_sysdep.h>
#include <omniORB3/CORBA_basetypes.h>

extern char* currentFile;
extern int   yylineno;

#ifdef HAS_pch
#pragma hdrstop
#endif

#if !defined(__VAX) 
#error "This module is intended only for VAX/VMS"
#endif

#if !__G_FLOAT
#error "This module must be compiled with /Float=G"
#endif

#include <cvtdef.h>
extern "C" unsigned int cvt$convert_float(...);

static void dataConversionError(int status) {
  vaxc$errno=status;
  errno=EVMSERR;

  IdlError(currentFile, yylineno, "Floating point conversion error.");

} // dataConversionError


void _CORBA_Float::cvt_(float f) {
  int status(
    cvt$convert_float(
      &f,
      CVT$K_VAX_F,
      &pd_f,
      CVT$K_IEEE_S,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1)
    dataConversionError(status);
}

float _CORBA_Float::cvt_() const {
  float f;
  int status(
    cvt$convert_float(
      &pd_f,
      CVT$K_IEEE_S,
      &f,
      CVT$K_VAX_F,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1) {
    dataConversionError(status);
    f=0;
  }
  return f;
}

void _CORBA_Double::cvt_(double d) {
  int status(
    cvt$convert_float(
      &d,
      CVT$K_VAX_G,
      &pd_d,
      CVT$K_IEEE_T,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1)
    dataConversionError(status);
}

double _CORBA_Double::cvt_() const {
  double d;
  int status(
    cvt$convert_float(
      &pd_d,
      CVT$K_IEEE_T,
      &d,
      CVT$K_VAX_G,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1) {
    dataConversionError(status);
    d=0;
  }
  return d;
}
