################################################################################
# afterdir.mms - standard make stuff to go after dir.mms
################################################################################

#
# Macro used in rules for building subdirectories
#
MakeSubdirs=@[mk]makesubdirs.dcl "$(MMSQUALIFIERS)" $(MMS$TARGET) \
"$(SUBDIRS)"

#
# Rules for cleaning.  Note that the /exclude qualifier is an anachronism
# retained for safety.
#
RM_FLAGS = /Exclude=(DESCRIP.MMS,DIR.MMS)/Log
RM = @[mk]rm.dcl "$(RM_FLAGS)"
RemoveCorbaStubs = @[mk]RemoveCorbaStubs.dcl "@omniMk:rm.dcl" \
"$(RM_FLAGS)" "$(CORBA_INTERFACES)" "omnistubs:"

clean ::
	@ purge
	@ $(RM) *.obj *.exe *.olb
	@ $(RM) *.obj *.lis *.dia *.olb *.map
	@ $(RM) [.cxx_repository]*.* cxx_repository.dir cxx_repository.opt

veryclean :: clean
	@ @[mk]removedir.dcl "$(dir_initialized)"
	@ $(RM) *.d
	@ $(RemoveCorbaStubs)
	@ $(MakeSubDirs)

################################################################################
#
# rules for exporting.
#
# Note that unlike other platforms, EXPORT_TREE is not defined by default.
# Thus it expands to the empty string unless overridden.  If overridden then it
# must be defined as a device name or as a concealed, rooted logical, including
# a trailing colon (':')
#
# By following the above, $(EXPORT_TREE) can then be prepended to an absolute
# (first character '[', second character is not '.') directory name.  E.g.:
#
#	$(EXPORT_TREE)[BIN.OPENVMS_ALPHA_7_1]omninames.exe
#
# If not overridden then this is effectively the same as:
#
#	SYS$DISK:[BIN.OPENVMS_ALPHA_7_1]omninames.exe
#
# Otherwise, suppose we have:
#
#	DIR_FIRSTACTIONS=\
#		DEFINE OMNIEVENTSROOT OMNIROOT:[SRC.CONTRIB.OMNIEVENTS.]\
#		/TRANS=CONC
#
#	EXPORT_TREE=OMNIEVENTSROOT:
#
# In that case the above becomes:
#
#	OMNIEVENTSROOT:[BIN.OPENVMS_ALPHA_7_1]omninames.exe
#

Export = @[mk]Export.dcl

# ExportHeader differs from other Export rules in that you give the full path of
# the target only.

## ExportHeader = @[mk]ExportHeader.dcl \
## 'f$parse("$@","","","name")''f$parse("$@","","","type")' \
## 'f$parse("$@","","","device")''f$parse("$@","","","directory")'
## ??? what was I thinking???

ExportHeader = @[mk]ExportHeader.dcl \
"$<" 'f$parse("$@","","","device")''f$parse("$@","","","directory")'

ExportExecutable = $(Export) $(MMS$SOURCE) $(BINPATH)
ExportLibrary = $(Export) $(MMS$SOURCE) $(libpath)
ExportShareable = @[mk]ExportShareable.dcl $(MMS$SOURCE)\
	$(libpath) $(DebugSuffix)

# Rule to export python files.
#
# Note that while other platforms will copy files one at a time, the VMS rule
# does this in a single step.
#

ExportPythonFiles = @[mk]ExportPythonFiles.dcl $(EXPORT_TREE)[LIB.PYTHON]

# Note that this is roughly equivalent to:
#
#	ExportPythonFiles =\
#	backup [...]*.py; $(EXPORT_TREE)[LIB.PYTHON...]*.*; /log
#
# with dependency checking.
#
# This could be improved by doing something like:
#
#	dir.mms
#	=======
#	pysrcs=foo.py bar.py
#
#	export :: $(pytargets)
#
# and have [mk]premake.mms create the pytargets macro and individual dependency
# rules.

################################################################################
#
# C++ compiling and linking.
#
.IFDEF DEBUG
DEBUG_CXXFLAGS=/Debug/Noopt
DEBUG_CXXLINKFLAGS=/Debug
.ELSE
DEBUG_CXXFLAGS=$(RELEASE_DEBUG)
.ENDIF

.IFDEF CXX6
# 6.0 compiler warns about idl generated code.
COMPILER_CXXFLAGS = /Quiet
.ELSE
# The namespace hack causes %CXX-W-CANTCOMPLETE warnings with Compaq C++ 5.6
COMPILER_CXXFLAGS = /Warning=(Disable=CANTCOMPLETE)
.ENDIF

OMNIORB_CXXFLAGS = /Mms=file=.d/Except/Diag\
$(OMNIORB_CXXFLOAT)$(DEBUG_CXXFLAGS)$(COMPILER_CXXFLAGS)

OMNIORB_CXXLINKFLAGS=$(DEBUG_CXXLINKFLAGS)/NoTemplate_prelink
OMNIORB_CXXREPOSITORIES=$(OMNIORB_LIB_REPOSITORY)

# Miscellaneous qualifiers for the cxx compiler.
CXXFLAGS = $(PLATFORM_CXXFLAGS) $(OMNIORB_CXXFLAGS) $(DIR_CXXFLAGS)

# list of macro definitions.
CXXMACROS = $(OMNIORB_CXXMACROS) $(DIR_CXXMACROS)

.ifdef CORBA_INTERFACES
STUB_INCLUDE=$(UTOP)/STUB
.endif

# list of include directories for the /include qualifier
CXXINCLUDES = $(STUB_INCLUDE) $(OMNIORB_CXXINCLUDES) $(DIR_CXXINCLUDES)

# List of repository directories for the /repository
# qualifier.  Note that DIR_CXXREPOSITORIES will always be defined in order to
# ensure that user instantiations don't wind up in the library repository.  This
# is also why DIR_CXXREPOSITORIES is first (the writable repository).

.ifdef DIR_CXXREPOSITORIES
.else
DIR_CXXREPOSITORIES=[.CXX_REPOSITORY]
.endif

CXXREPOSITORIES=$(DIR_CXXREPOSITORIES) $(OMNIORB_CXXREPOSITORIES)

CXXCompile=@[mk]CXXCompile.dcl "$(CXXFLAGS)" "$(CXXMACROS)" "$(CXXINCLUDES)"\
	"$(CXXREPOSITORIES)" $(MMS$SOURCE) $(MMS$TARGET)

.CC.OBJ :
	@ $(CXXCompile)

.cc.obj :
	@ $(CXXCompile)

CXXExecutable = @[mk]CXXExecutable.dcl "$(MMS$TARGET)" "$(MMS$SOURCE)"\
	"$(OBJ_LIBS)"\
	"$(PLATFORM_CXXLINKFLAGS)$(OMNIORB_CXXLINKFLAGS)$(DIR_CXXLINKFLAGS)"\
	"$(CXXREPOSITORIES)"

CXXShareableImage = @[mk]CXXShareableImage.dcl "$(MMS$TARGET)"\
	"$(MMS$SOURCE)" "$(OBJ_LIBS)"\
	"$(PLATFORM_CXXLINKFLAGS)$(OMNIORB_CXXLINKFLAGS)$(DIR_CXXLINKFLAGS)"\
	"$(VERSION)" "$(CXXREPOSITORIES)"
#
################################################################################

################################################################################
#
# C compiling
#

.ifdef DECC
OMNIORB_CFLAGS=/MMS=file=.d/Diag
.endif

CFLAGS = $(OMNIORB_CFLAGS) $(DIR_CFLAGS)

# list of macro definitions.
CMACROS = $(OMNIORB_CMACROS) $(DIR_CMACROS)

# list of include directories for the /include qualifier
CINCLUDES = $(OMNIORB_CINCLUDES) $(DIR_CINCLUDES)

CCompile=@[mk]CCompile.dcl "$(CFLAGS)" "$(CMACROS)" "$(CINCLUDES)"\
	$(MMS$SOURCE) $(MMS$TARGET)

.C.OBJ :
	@ $(CCompile)

.c.obj :
	@ $(CCompile)

CExecutable = @[mk]CLinkCommand.dcl "/Exec=$(MMS$TARGET)" "$(MMS$SOURCE)"\
	"$(OBJ_LIBS)"\
	"$(PLATFORM_CLINKFLAGS)$(OMNIORB_CLINKFLAGS)$(DIR_CLINKFLAGS)"\
	"$(CXXREPOSITORIES)"
#
################################################################################

################################################################################
# reconfigure rule							       #
################################################################################

.ifdef autoconfig

reconfigure ::
	@ $(RM) [mk]platform.mms
	@ $(CONFIGURE_PLATFORM)

.endif


FIRSTACTIONS = @[mk]firstactions.dcl "$(BINPATH)" "$(PLATFORM)" "$(LIBPATH)"

OMNIIDL_CXX = omniidl ""-bcxx""
BuildCorbaStubs = @[mk]BuildCorbaStubs.dcl "$(CORBA_INTERFACES)"\
	"$(OMNIIDL_CXX)"\
	"$(CXXFLAGS)" "$(CXXMACROS)" "$(CXXINCLUDES)" "$(CXXREPOSITORIES)"\
	"$(OMNIORB_IDL_FLAGS) $(DIR_IDLFLAGS)"

.ifdef autoconfig

CONFIGURE_PLATFORM=if f$search("[mk]platform.mms") .eqs. "" then\
	@[mk]autoconfig.dcl

.endif

.ifdef COMPILE_VERIFY
.else
COMPILE_VERIFY=0
.endif

.ifdef $(dir_initialized)

.ifdef CORBA_INTERFACES

.first
	@ $(FIRSTACTIONS)
	@ $(DIR_FIRSTACTIONS)
	@ COMPILE_VERIFY==$(COMPILE_VERIFY)
	@ nocleantarget=f$locate("CLEAN",F$EDIT("$(mmstargets)","UPCASE"))\
		.EQ. F$LENGTH("$(mmstargets)")
	@ if nocleantarget THEN $(BuildCorbaStubs)

.else	# corba_interfaces not defined

.first
	@ $(FIRSTACTIONS)
	@ $(DIR_FIRSTACTIONS)
	@ COMPILE_VERIFY==$(COMPILE_VERIFY)

.endif	# corba_interfaces

.endif	# $(dir_initialized)
