.suffixes
# dir.mms for omniDynamic shared library
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# (Note that this is backwards from dir.mk since MMS has no $(word...).

major_version = 3
minor_version = 0
micro_version = 0

VERSION = $(major_version).$(minor_version).$(micro_version)

# assume that the parent directory is built and that therefore
# $(libpath)omniDynamic3$(DebugSuffix).olb exists.

staticlib=[-]omniDynamic3$(DebugSuffix).olb
shareableimage=omniDynamic3$(ShareableImageSuffix).exe
exportshareableimage=$(libpath)$(shareableimage)

# specifying the shareable image library on the link command line causes the
# linker to include this library again (on vax anyway...) even though we specify
# which shareable images we want via the /include statement!
#
# Therefore, don't use the shareabe image library, but list the shareable images
# explicitly (requires an options file).
#
# OBJ_LIBS = \
# omnilib:omni_share$(DebugSuffix).olb/include=(omnithread_rt$(DebugSuffix),\
# omniORB3_rt$(DebugSuffix))

OBJ_LIBS_DEPEND = \
$(libpath)omni_share$(DebugSuffix).olb(omnithread_rt$(DebugSuffix)) \
$(libpath)omni_share$(DebugSuffix).olb(omniORB3_rt$(DebugSuffix))

DIR_FIRSTACTIONS = pipe ( echo "omnilib:omnithread_rt$(DebugSuffix).exe/share"\
	; echo "omnilib:omniORB3_rt$(DebugSuffix).exe/share"\
	) | type sys$input > share$(DebugSuffix).opt

DIR_CXXLINKFLAGS = /MAP/FULL

all :: $(shareableimage)

$(shareableimage) : $(staticlib) $(OBJ_LIBS_DEPEND)
	$(CxxShareableImage) sys$disk:[]share$(DebugSuffix).opt/opt

export :: all
export :: $(exportshareableimage)

$(exportshareableimage) : $(shareableimage)
	$(ExportShareable)

veryclean ::
	@- $(RM) $(shareableimage)
	@- $(RM) *.opt *.dat *.mar
