# dir.mms for omniORB
#

SUBDIRS = orbcore dynamic

STUBHEADERS = [.omniORB3]Naming.hh \
              [.omniORB3]bootstrap.hh \
              [.omniORB3]corbaidl_defs.hh \
              [.omniORB3]corbaidl_operators.hh \
              [.omniORB3]corbaidl_poa.hh \
              [.omniORB3]ir_defs.hh \
              [.omniORB3]ir_operators.hh \
              [.omniORB3]ir_poa.hh \
              [.omniORB3]omniLifeCycle.hh

all :: $(STUBHEADERS)

clean ::
	@ $(MakeSubdirs)

omniORBInclude=[include.omniORB3]

Naming_header = $(omniORBInclude)Naming.hh
bootstrap_header = $(omniORBInclude)bootstrap.hh
ir_defs_header = $(omniORBInclude)ir_defs.hh
ir_operators_header = $(omniORBInclude)ir_operators.hh
ir_poa_header = $(omniORBInclude)ir_poa.hh
corbaidl_defs_header = $(omniORBInclude)corbaidl_defs.hh
corbaidl_operators_header = $(omniORBInclude)corbaidl_operators.hh
corbaidl_poa_header = $(omniORBInclude)corbaidl_poa.hh
omniLifeCycle_header = $(omniORBInclude)omniLifeCycle.hh

export :: $(STUBHEADERS) $(Naming_header) $(bootstrap_header) $(ir_defs_header)\
	$(ir_operators_header) $(ir_poa_header) $(corbaidl_defs_header)\
	$(corbaidl_operators_header) $(corbaidl_poa_header)\
	$(omniLifeCycle_header)
	@ $(ExportPythonFiles)
	@ $(MakeSubdirs)

veryclean ::
	$(RM)	[.omniORB3]*.hh [.omniORB3]*SK.cc omniORB3.dir
	$(RM)	Naming.idl bootstrap.idl ir.idl corbaidl.idl omniLifeCycle.idl

######################################################################
# Make rules for Stubs                                               #
######################################################################

DIR_FIRSTACTIONS =-
	IF F$SEARCH("omniORB3.dir") .EQS. "" THEN CREATE/DIRECTORY [.OMNIORB3]

.IFDEF VAX
OMNIORB_VAX_FLAGS="-DOMNIORB_NO_IR_CLIENT"
.ENDIF

OMNIORB_IDL_FPATH = $(OMNIORB_IDL) -p$(BASE_OMNI_TREE)/src/lib/omniORB2\
	$(OMNIORB_VAX_FLAGS) "-C./omniORB3"

[.omniORB3]Naming.hh [.omniORB3]NamingSK.cc [.omniORB3]NamingDynSK.cc : Naming.idl
	$(OMNIORB_IDL_FPATH) "Naming.idl"

[.omniORB3]bootstrap.hh [.omniORB3]bootstrapSK.cc [.omniORB3]bootstrapDynSK.cc : bootstrap.idl
	$(OMNIORB_IDL_FPATH) "bootstrap.idl"

[.omniORB3]ir_defs.hh [.omniORB3]ir_operators.hh [.omniORB3]ir_poa.hh : ir.idl [.omniORB3]corbaidl_defs.hh
	$(OMNIORB_IDL_FPATH) "-WbF" "-I." ir.idl

[.omniORB3]corbaidl_defs.hh [.omniORB3]corbaidl_operators.hh [.omniORB3]corbaidl_poa.hh : corbaidl.idl
	$(OMNIORB_IDL_FPATH) "-WbF" corbaidl.idl

[.omniORB3]omniLifeCycle.hh : omniLifeCycle.idl
	$(OMNIORB_IDL_FPATH) omniLifeCycle.idl

# Make rules to import idls from ['top'.idl]

Naming.idl : [idl]Naming.idl
	copy $(mms$source) $(mms$target)

bootstrap.idl : [idl]bootstrap.idl
	copy $(mms$source) $(mms$target)

ir.idl : [idl]ir.idl
	copy $(mms$source) $(mms$target)

corbaidl.idl : [idl]corbaidl.idl
	copy $(mms$source) $(mms$target)

omniLifeCycle.idl : [idl]omniLifeCycle.idl
	copy $(mms$source) $(mms$target)

######################################################################
# Make rules for Exporting headers                                   #
######################################################################
$(Naming_header) : [.omniORB3]Naming.hh
	@ $(ExportHeader)

$(bootstrap_header) : [.omniORB3]bootstrap.hh
	@ $(ExportHeader)

$(ir_defs_header) : [.omniORB3]ir_defs.hh
	@ $(ExportHeader)

$(ir_operators_header) : [.omniORB3]ir_operators.hh
	@ $(ExportHeader)

$(ir_poa_header) : [.omniORB3]ir_poa.hh
	@ $(ExportHeader)

$(corbaidl_defs_header) : [.omniORB3]corbaidl_defs.hh
	@ $(ExportHeader)

$(corbaidl_operators_header) : [.omniORB3]corbaidl_operators.hh
	@ $(ExportHeader)

$(corbaidl_poa_header) : [.omniORB3]corbaidl_poa.hh
	@ $(ExportHeader)

$(omniLifeCycle_header) : [.omniORB3]omniLifeCycle.hh
	@ $(ExportHeader)

