# [.MK]OpenVMS.MMS.  This file is .included from [.platform]'platform'.mms
# (where 'platform' is OpenVMS_Alpha_n_m or OpenVms_VAX_n_m).  The platform
# specific file sets the macro, $(POSIX_LIB_DEPEND) used below.

OMNIORB_IDL_LC_FLAGS = -l
OMNIORB_IDL_ANY_FLAGS = "-Wba"
OMNIORB_IDL_ONLY = omniidl -bcxx
OMNIORB_IDL = $(OMNIORB_IDL_ONLY) $(OMNIORB_IDL_ANY_FLAGS)

OMNIORB_SHAREDLIB=omnilib:omni_share$(DebugSuffix).olb
OMNIORB_SHAREDLIB_DEPEND=$(libpath)omni_share$(DebugSuffix).olb\
	$(POSIX_LIB_DEPEND)

OMNITHREAD_SHAREDLIB_DEPEND = $(libpath)omnithread$(ShareableImageSuffix).exe\
	$(POSIX_LIB)
OMNITHREAD_STATICLIB_DEPEND = $(libpath)omnithread$(DebugSuffix).olb $(POSIX_LIB_DEPEND)
OMNITHREAD_STATICLIB = omnilib:omnithread$(DebugSuffix).olb

.ifdef USE_SHAREABLE_IMAGES
OMNITHREAD_LIB_DEPEND	= $(OMNITHREAD_SHAREDLIB_DEPEND)
OMNITHREAD_LIB		= $(OMNIORB_SHAREDLIB)
.else
OMNITHREAD_LIB_DEPEND	= $(OMNITHREAD_STATICLIB_DEPEND)
OMNITHREAD_LIB		= $(OMNITHREAD_STATICLIB)
.endif

# set compiler switch and library for floating point option.

# enforce mutual exclusion of D_FLOAT|G_FLOAT|IEEE_FLOAT:
.IFDEF D_FLOAT
FloatType = D
.ENDIF

.IFDEF G_FLOAT
FloatType = G
.ENDIF

.IFDEF IEEE_FLOAT
FloatType = IEEE
.ENDIF

# handle default case:
.IFDEF D_FLOAT
.ELSE
# ifndef D_FLOAT
.IFDEF G_FLOAT
.ELSE
# ifndef G_FLOAT
.IFDEF IEEE_FLOAT
.ELSE
# ifndef IEEE_FLOAT

.IFDEF ALPHA
# Alpha default
FloatType = G
.ELSE
# VAX default
FloatType = D
.ENDIF	! Alpha vs VAX

.ENDIF	! IEEE_FLOAT else clause
.ENDIF	! G_FLOAT else clause
.ENDIF	! D_FLOAT else clause

OMNIORB_CXXFLOAT = /Float=$(FloatType)_Float

.IFDEF USE_SHAREABLE_IMAGES
CORBA_LIB_DEPEND = $(OMNIORB_SHAREDLIB_DEPEND)
CORBA_LIB = $(OMNIORB_SHAREDLIB)
.ELSE
CORBA_LIB_DEPEND = omnilib:omniDynamic3$(DebugSuffix).olb\
 omnilib:omniORB3$(DebugSuffix).olb\
 $(OMNITHREAD_LIB_DEPEND)
CORBA_LIB = omnilib:omniDynamic3$(DebugSuffix).olb\
 omnilib:omniORB3$(DebugSuffix).olb\
 $(OMNITHREAD_LIB)
.ENDIF

OMNIORB_LIB_REPOSITORY=$(libpath)
OMNIORB_LIB_CXXFLAGS = $(PLATFORM_LIB_CXXFLAGS)
OMNIORB_CXXINCLUDES = ./ /omni_include/
OMNIORB_IDL_FLAGS = -IomniIdls: $(OMNIORB_IDL_PLATFORM)

# Note that this is backwards from other platforms.
OMNIORB_MAJOR_VERSION = 3
OMNIORB_MINOR_VERSION = 0
OMNIORB_MICRO_VERSION = 0
OMNIORB_VERSION = \
  $(OMNIORB_MAJOR_VERSION).$(OMNIORB_MINOR_VERSION).$(OMNIORB_MICRO_VERSION)

# Since we can't say "ifeq" in MMS, we need these too:
OMNIORB_3 = 1
OMNIORB_3_0 = 1
OMNIORB_3_0_0= 1
