// -*- Mode: C++; -*-
//                            Package   : omniEvents
//   pushcons.cc              Created on: 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//    Push Model consumer implementation
//	

/*
  $Log:	pushcons.cc,v $
Revision 1.1  98/04/02  16:15:37  16:15:37  naderp (Paul Nader)
Initial revision

 */

//
//
#include <iostream.h>
#include "CosEvent_i.h"

static omni_mutex mutex;
static omni_condition connect_cond(&mutex);
static void usage();

class Consumer_i : virtual public CosEventComm::_sk_PushConsumer {
public:
  Consumer_i (long disconnect = 0) : _disconnect(disconnect) {}

  void push (const CORBA::Any& data);
  void disconnect_push_consumer ();

private:
  long _disconnect;
};

void Consumer_i::push (const CORBA::Any& data) {
  CORBA::ULong l;
  static int i = 0;

  i++;
  data >>= l;
  cout << "Push Consumer: push () called. Data : "
       << l
       << endl;

  // Exersize Disconnect
  if (i == _disconnect) {
     i = 0;
     // NOTE : The proxy_supplier object is disposed at the server
     //        during the disconnect_push_supplier call. Do NOT
     //        use the proxy_supplier reference after disconnecting.

     // Unlock mutex and signal main thread to re-connect.
     mutex.unlock();
     connect_cond.signal();
  }
}

void Consumer_i::disconnect_push_consumer () {
  cout << "Push Consumer: disconnected." << endl;
}

int
main(int argc, char **argv)
{
  //
  // Start orb and boa.
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  // Process Options
  int c;
  int discnum = 0;
  char *channelName = (char *) "EventChannel";
  char *channelKind = (char *) "EventChannel";

  while ((c = getopt(argc,argv,"hd:n:k:")) != EOF)
  {
     switch (c)
     {
        case 'd': discnum = atoi(optarg);
                  cout << "discnum = " << discnum;
                  break;

        case 'n': channelName = optarg;
                  break;

        case 'k': channelKind = optarg;
                  break;

        case 'h':
        default : usage();
                  exit(-1);
                  break;
     }
  }

  Consumer_i* consumer = new Consumer_i (discnum);
  consumer->_obj_is_ready(boa);

  // Let the BOA know we are ready.
  boa->impl_is_ready(0,1);

  //
  // Obtain and narrow reference to Name Service.
  CosNaming::NamingContext_ptr rootContext;
  try {

     // Get initial reference.
     CORBA::Object_var initServ;
     initServ = orb->resolve_initial_references("NameService");
     if (CORBA::is_nil(initServ))
     {
        cerr << "Failed to resolve NameService initial reference !" << endl;
        exit(1);
     }

     // Narrow the object returned by resolve_initial_references()
     // to a CosNaming::NamingContext object:
     rootContext = CosNaming::NamingContext::_narrow(initServ);
     if (CORBA::is_nil(rootContext))
     {
        cerr << "Failed to narrow naming context !" << endl;
        exit(1);
     }
  }
  catch(CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]. !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE !"
          << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Caught a system exception while resolving the naming service !"
          << endl;
     exit(1);
  }

  //
  // Obtain Event Channel Object.
  CosEventChannelAdmin::EventChannel_var channel;
  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup (channelName);
  name[0].kind = CORBA::string_dup (channelKind);

  try {
    CORBA::Object_var obj = rootContext->resolve(name);
    channel = CosEventChannelAdmin::EventChannel::_narrow(obj);
    if (CORBA::is_nil(channel))
    {
       cerr << "Failed to narrow Event Channel reference !" << endl;
       exit(1);
    }

  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the "
          << "naming service !" << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Cannot find event channel ! [\""
          << channelName << "\", \"" << channelKind << "\"]"
          << endl;
     exit (1);
  }

  //
  // Get Consumer admin interface.
  CosEventChannelAdmin::ConsumerAdmin_var consumer_admin;
  try {
     consumer_admin = channel->for_consumers ();
     if (CORBA::is_nil (consumer_admin))
     {
        cerr << "Consumer Admin returned consumer_admin nil reference !"
             << endl;
        exit (1);
     }
  }
  catch (...) {
     cerr << "Failed to obtain ConsumerAdmin !" << endl;
     exit (1);
  }
  cerr << "Obtained ConsumerAdmin." << endl;

  CosEventChannelAdmin::ProxyPushSupplier_var proxy_supplier;
  while (1) {
     //
     // Get supplier admin interface.
     try {
        proxy_supplier = consumer_admin->obtain_push_supplier ();
        if (CORBA::is_nil (proxy_supplier))
        {
           cerr << "Consumer Admin returned proxy_supplier nil reference !"
                << endl;
           exit (1);
        }
     }
     catch (...) {
        cerr << "Failed to obtain Proxy Supplier !" << endl;
        exit (1);
     }
     cerr << "Obtained ProxyPushSupplier." << endl;
   
     //
     // Connect Push Consumer
     try {
        proxy_supplier->connect_push_consumer(CosEventComm::PushConsumer::_duplicate(consumer));
     }
     catch (CORBA::BAD_PARAM& ex) {
        cerr << "Caught BAD_PARAM Exception while connecting Push Consumer !"
             << endl;
        exit (1);
     }
     catch (CosEventChannelAdmin::AlreadyConnected& ex) {
        cerr << "Push Consumer already connected !" 
             << endl;
     }
     catch (...) {
        cerr << "Failed to connect Push Consumer !" << endl;
        exit (1);
     }
     cerr << "Connected Push Consumer." << endl;

     // Wait for indication to disconnect before re-connecting.
     mutex.lock();
     connect_cond.wait();

     proxy_supplier->disconnect_push_supplier();
     cerr << "Disconnected from ProxyPushSupplier." << endl;
  }

  // Destory Channel
  channel->destroy();
  cerr << "Destroyed channel !" << endl;

  return 0;
}

static void
usage()
{
   cerr << "\nusage: pushcons [-d n] [-h]\n" << endl;
   cerr << "         -d n   disconnect after n pushes" << endl;
   cerr << "         -n name specify channel name [\"EventChannel\"]" << endl;
   cerr << "         -k kind specify channel kind [\"EventChannel\"]" << endl;
   cerr << "         -h     display usage" << endl;
   cerr << endl;
}
