// -*- Mode: C++; -*-
//                            Package   : omniEvents
// pullcons.cc                Created on: 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//    Pull Model consumer implementation.
//	

/*
  $Log:	pullcons.cc,v $
Revision 1.1  98/04/02  16:15:37  16:15:37  naderp (Paul Nader)
Initial revision

*/

//
//
#include <iostream.h>
#include "CosEvent_i.h"

static void usage();

class Consumer_i : virtual public CosEventComm::_sk_PullConsumer {
public:
  Consumer_i () {};
  void disconnect_pull_consumer ();
};

void Consumer_i::disconnect_pull_consumer () {
  cout << "EventConsumer: disconnected." << endl;
}

int
main(int argc, char **argv)
{
  //
  // Start orb and boa.
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  // Process Options
  int c;
  int trymode = false;
  int discnum = 0;
  char *channelName = (char *) "EventChannel";
  char *channelKind = (char *) "EventChannel";
  while ((c = getopt(argc,argv,"td:n:k:h")) != EOF)
  {
     switch (c)
     {
        case 't': trymode = true;
                  break;

        case 'd': discnum = atoi(optarg);
                  break;

        case 'n': channelName = optarg;
                  break;

        case 'k': channelKind = optarg;
                  break;

        case 'h':
        default : usage();
                  exit(-1);
                  break;
     }
  }
  
  Consumer_i* consumer = new Consumer_i ();
  consumer->_obj_is_ready(boa);

  // Let the BOA know we are ready.
  boa->impl_is_ready(0,1);

  //
  // Obtain and narrow reference to Name Service.
  CosNaming::NamingContext_ptr rootContext;
  try {

     // Get initial reference.
     CORBA::Object_var initServ;
     initServ = orb->resolve_initial_references("NameService");
     if (CORBA::is_nil(initServ))
     {
        cerr << "Failed to resolve NameService initial reference !" << endl;
        exit(1);
     }

     // Narrow the object returned by resolve_initial_references()
     // to a CosNaming::NamingContext object:
     rootContext = CosNaming::NamingContext::_narrow(initServ);
     if (CORBA::is_nil(rootContext))
     {
        cerr << "Failed to narrow naming context !" << endl;
        exit(1);
     }
  }
  catch(CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]. !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the naming service."
          << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Caught a system exception while resolving the naming service !"
          << endl;
     exit(1);
  }

  // Obtain Event Channel Object.
  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup (channelName);
  name[0].kind = CORBA::string_dup (channelKind);

  cout << "Looking for EventChannel" << endl;
  CosEventChannelAdmin::EventChannel_var channel;
  try {
    CORBA::Object_var obj = rootContext->resolve(name);
    channel = CosEventChannelAdmin::EventChannel::_narrow(obj);
    if (CORBA::is_nil(channel))
    {
       cerr << "Failed to narrow Event Channel reference !" << endl;
       exit(1);
    }
  }
  catch (CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]. !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the "
          << "naming service !" << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Cannot find event channel ! [\""
          << channelName << "\", \"" << channelKind << "\"]"
          << endl;
     exit (1);
  }

  //
  // Get Consumer admin interface.
  CosEventChannelAdmin::ConsumerAdmin_var consumer_admin;
  try {
     consumer_admin = channel->for_consumers ();
     if (CORBA::is_nil (consumer_admin))
     {
        cerr << "Consumer Admin returned consumer_admin nil reference !"
             << endl;
        exit (1);
     }
  }
  catch (...) {
     cerr << "Failed to obtain ConsumerAdmin !" << endl;
     exit (1);
  }
  cerr << "Obtained ConsumerAdmin." << endl;

  CosEventChannelAdmin::ProxyPullSupplier_var proxy_supplier;
  while (1)
  {
     //
     // Get proxy supplier interface.
     try {
        proxy_supplier = consumer_admin->obtain_pull_supplier ();
        if (CORBA::is_nil (proxy_supplier))
        {
           cerr << "Consumer Admin returned proxy_supplier nil reference !"
                << endl;
           exit (1);
        }
     }
     catch (...) {
        cerr << "Failed to obtain Proxy Supplier !" << endl;
        exit (1);
     }
     cerr << "Obtained ProxyPullSupplier." << endl;
   
     //
     // Connect Pull Consumer
     try {
        proxy_supplier->connect_pull_consumer(CosEventComm::PullConsumer::_duplicate(consumer));
     }
     catch (CORBA::BAD_PARAM& ex) {
        cerr << "Caught BAD_PARAM Exception while connecting Pull Consumer !"
             << endl;
        exit (1);
     }
     catch (CosEventChannelAdmin::AlreadyConnected& ex) {
        cerr << "Pull Consumer already connected !" 
             << endl;
     }
     catch (...) {
        cerr << "Failed to connect Pull Consumer !" << endl;
        exit (1);
     }
     cerr << "Connected Pull Consumer." << endl;

     // Pull data.
     CORBA::Any *data;
     CORBA::ULong l = 0;
     for (int i=0; (discnum == 0) || (i < discnum); i++)
     {
        if (!trymode)
        {
           try {
               cout << "Pull Consumer: pull () called. ";
               data = proxy_supplier->pull();
               l = 0;
               *data >>= l;
               cout << "Data : " << l << endl;
               delete data;
           }
           catch (...)
           {
               cerr << "Failed !" << endl;
           }
        }
        else
        {
           try {
               CORBA::Boolean has_event;
               data = proxy_supplier->try_pull(has_event);
               cout << "Consumer: try_pull () called. Data : " << flush;
               if (has_event)
               {
                  l = 0;
                  *data >>= l;
                  cout << l << endl;
                  delete data;
               }
               else
               {
                  cout << "No Data" << endl;
   
               }
           }
           catch (...)
           {
               cerr << "Failed !" << endl;
           }
        }
     }

     try {
        proxy_supplier->disconnect_pull_supplier();
     }
     catch (...) {
        cerr << "Failed to disconnect ProxyPushConsumer !" << endl;
        exit(1);
     }
     cerr << "Disconnected from ProxyPullSupplier." << endl;
  }

  return 0;
}

static void
usage()
{
   cerr << "\nusage: pullcons [-t] [-d n] [-n name] [-k kind] [-h]\n" << endl;
   cerr << "         -t      enable try_pull mode" << endl;
   cerr << "         -d n    disconnect after n pulls" << endl;
   cerr << "         -n name specify channel name [\"EventChannel\"]" << endl;
   cerr << "         -k kind specify channel kind [\"EventChannel\"]" << endl;
   cerr << "         -h     display usage" << endl;
   cerr << endl;
}
