CXXSRCS = CosEvent_i.cc \
          eventc.cc \
          eventd.cc \
          pushcons.cc \
          pushsupp.cc \
          pullsupp.cc \
          pullcons.cc

EVENTDOBJS = CosEvent_i.o \
             eventd.o

EVENTCOBJS = CosEvent_i.o \
             eventc.o

PUSHSUPPOBJS = CosEvent_i.o \
             pushsupp.o

PUSHCONSUMOBJS = CosEvent_i.o \
             pushcons.o

PULLCONSOBJS = CosEvent_i.o \
             pullcons.o

PULLSUPPOBJS = CosEvent_i.o \
             pullsupp.o

DIR_CPPFLAGS = -v $(CORBA_CPPFLAGS) 

AUXLIBS =

CORBA_INTERFACES = Naming CosLifeCycle CosEventComm CosEventChannelAdmin 

eventd    = $(patsubst %,$(BinPattern),eventd)
eventc    = $(patsubst %,$(BinPattern),eventc)
pushsupp  = $(patsubst %,$(BinPattern),pushsupp)
pushcons  = $(patsubst %,$(BinPattern),pushcons)
pullcons  = $(patsubst %,$(BinPattern),pullcons)
pullsupp  = $(patsubst %,$(BinPattern),pullsupp)

EXECS     = $(eventd) $(eventc) $(pushsupp) $(pushcons) $(pullcons) $(pullsupp)

all:: $(EXECS)

clean::
	$(RM) $(EXECS) *.d

export:: $(eventd)
	@(module="as"; $(ExportExecutable))

$(eventd): $(EVENTDOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB) $(AUXLIBS)"; $(CXXExecutable))

$(eventc): $(EVENTCOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB) $(AUXLIBS)"; $(CXXExecutable))

$(pushsupp): $(PUSHSUPPOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB) $(AUXLIBS)"; $(CXXExecutable))

$(pushcons): $(PUSHCONSUMOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB) $(AUXLIBS)"; $(CXXExecutable))

$(pullcons): $(PULLCONSOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB) $(AUXLIBS)"; $(CXXExecutable))

$(pullsupp): $(PULLSUPPOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB) $(AUXLIBS)"; $(CXXExecutable))
