// -*- Mode: C++; -*-
//                            Package   : omniEvents
// CosEvent_i.h               Created on: 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader
//
//    This file is part of omniEvents
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	

/*
  $Log:	CosEvent_i.h,v $
 * Revision 1.1  98/04/02  16:14:47  16:14:47  naderp (Paul Nader)
 * Initial revision
 * 
*/

#ifndef CosEvent_i_h_
#define CosEvent_i_h_

#include "CosEventComm.hh"
#include "CosEventChannelAdmin.hh"
#include <list>
#include <set>

class EventChannel_i;

class stamp_t {

public:
    stamp_t() {sec = 0; nsec = 0;};
    int operator<=(const stamp_t& lhs) const {return (sec <= lhs.sec);}; 
    void get_time (void) { omni_thread::get_time(&sec, &nsec, 0, 0);};

public:
    unsigned long sec;
    unsigned long nsec;
};

typedef struct {CORBA::Any data;
                stamp_t stamp;} event_t;

// PUSH

//------------------------------------------------------------------------
class ProxyPushConsumer_i :
  virtual public CosEventComm::_sk_PushConsumer,
  virtual public CosEventChannelAdmin::_sk_ProxyPushConsumer {
public:
    ProxyPushConsumer_i (EventChannel_i* impl);

    void connect_push_supplier (CosEventComm::PushSupplier_ptr push_supplier);
    void push (const CORBA::Any& data);
    void disconnect_push_consumer ();

private:
    omni_mutex      _lock;
    EventChannel_i* _channel;
    CosEventComm::PushSupplier_ptr _supplier;
    enum {notConnected, connected, disconnected} _proxyState;
};

//------------------------------------------------------------------------

class ProxyPushSupplier_i :
  virtual public CosEventComm::_sk_PushSupplier,
  virtual public CosEventChannelAdmin::_sk_ProxyPushSupplier {

public:
    ProxyPushSupplier_i (EventChannel_i* impl);
    ~ProxyPushSupplier_i();
    void connect_push_consumer (CosEventComm::PushConsumer_ptr push_consumer);
    void disconnect_push_supplier ();

private:
    void addEvent (const event_t &event);
    friend class EventChannel_i;

private:
    void _dispatch(void);
    stamp_t                        _stamp;
    omni_mutex                     _lock;
    omni_mutex                     _headLock;
    omni_thread                   *_dispatcher;
    omni_condition                 _nonEmpty;
    list<event_t>                  _events;
    EventChannel_i                *_channel;
    CosEventComm::PushConsumer_ptr _consumer;
    enum {notConnected, connected, disconnected} _proxyState;
};


class ProxyPushSupplierWorker : public omni_thread {

public:
    typedef void (ProxyPushSupplier_i::*Method)(void);
    ProxyPushSupplierWorker(ProxyPushSupplier_i *object,
                            Method method,
                            priority_t priority = PRIORITY_NORMAL);
    void* run_undetached(void *);
    ~ProxyPushSupplierWorker();

private:
    ProxyPushSupplier_i* _object;
    Method _method;
    ProxyPushSupplierWorker();
};

//------------------------------------------------------------------------
// PULL

class ProxyPullSupplier_i :
  virtual public CosEventChannelAdmin::_sk_ProxyPullSupplier {

public:
    ProxyPullSupplier_i (EventChannel_i *impl);
    void connect_pull_consumer (CosEventComm::PullConsumer_ptr pull_consumer);
    void disconnect_pull_supplier ();
    CORBA::Any* pull ();
    CORBA::Any* try_pull (CORBA::Boolean &has_event);

private:
    void addEvent (const event_t &event);
    friend class EventChannel_i;

private:
    stamp_t                        _stamp;
    omni_mutex                     _lock;
    omni_mutex                     _headLock;
    omni_condition                 _nonEmpty;
    list<event_t>                  _events;
    EventChannel_i                 *_channel;
    CosEventComm::PullConsumer_ptr _consumer;
    enum {notConnected, connected, disconnected} _proxyState;
};


//------------------------------------------------------------------------
class ProxyPullConsumer_i :
  virtual public CosEventComm::_sk_PullConsumer,
  virtual public CosEventChannelAdmin::_sk_ProxyPullConsumer {

public:
    ProxyPullConsumer_i (EventChannel_i *impl);
    void connect_pull_supplier (CosEventComm::PullSupplier_ptr pull_supplier);
    void disconnect_pull_consumer ();

private:
    CORBA::Any *getEvent(CORBA::Boolean &has_event);
    friend class EventChannel_i;

private:
    omni_mutex      _lock;
    EventChannel_i* _channel;
    CosEventComm::PullSupplier_ptr _supplier;
    enum {notConnected, connected, disconnected} _proxyState;
};

//------------------------------------------------------------------------
// ADMIN

class ConsumerAdmin_i :
  public CosEventChannelAdmin::_sk_ConsumerAdmin {

public: 
    ConsumerAdmin_i (EventChannel_i *channel);
    ~ConsumerAdmin_i ();
    CosEventChannelAdmin::ProxyPushSupplier_ptr obtain_push_supplier ();
    CosEventChannelAdmin::ProxyPullSupplier_ptr obtain_pull_supplier ();

private:
    EventChannel_i* event_channel;
};

//------------------------------------------------------------------------
class SupplierAdmin_i :
  public CosEventChannelAdmin::_sk_SupplierAdmin {

public: 
    SupplierAdmin_i (EventChannel_i *channel);
    ~SupplierAdmin_i ();
    CosEventChannelAdmin::ProxyPushConsumer_ptr obtain_push_consumer ();
    CosEventChannelAdmin::ProxyPullConsumer_ptr obtain_pull_consumer ();

private:
    EventChannel_i* event_channel;
};

// EVENT CHANNEL

class EventChannel_i :
  public CosEventChannelAdmin::_sk_EventChannel {

public:
    EventChannel_i (unsigned long pullRetryPeriod = 1);
    ~EventChannel_i ();

    CosEventChannelAdmin::ConsumerAdmin_ptr for_consumers ();
    CosEventChannelAdmin::SupplierAdmin_ptr for_suppliers ();

    void destroy ();
    CORBA::Boolean _save_object ();

private:
    // Proxy Registration
    void _reg_pxy_push_consumer (ProxyPushConsumer_i *);
    void _reg_pxy_push_supplier (ProxyPushSupplier_i *);
    void _reg_pxy_pull_consumer (ProxyPullConsumer_i *);
    void _reg_pxy_pull_supplier (ProxyPullSupplier_i *);

    // Proxy De-Registration
    void _drg_pxy_push_consumer (ProxyPushConsumer_i *);
    void _drg_pxy_push_supplier (ProxyPushSupplier_i *);
    void _drg_pxy_pull_consumer (ProxyPullConsumer_i *);
    void _drg_pxy_pull_supplier (ProxyPullSupplier_i *);

    void disconnect ();

    void addEvent (const CORBA::Any &any);
    void reqEvent (void);

    friend class EventChannelWorker;
    friend class ProxyPushConsumer_i;
    friend class ProxyPullConsumer_i;
    friend class ProxyPushSupplier_i;
    friend class ProxyPullSupplier_i;

private:

  int  _empty;
  unsigned long _pullRetryPeriod;
  void _pull(void);
  void _dispatch(void);
  omni_mutex _lock;
  omni_mutex _headLock;
  omni_mutex _pullLock;
  omni_condition *_nonEmpty;
  omni_condition *_pullEvent;
  omni_thread *_dispatcher;
  omni_thread *_pullWorker;

  list<event_t> _events;

  // List of Proxies
  set<ProxyPushSupplier_i *> _pxy_push_supp;
  set<ProxyPushConsumer_i *> _pxy_push_cons;
  set<ProxyPullSupplier_i *> _pxy_pull_supp;
  set<ProxyPullConsumer_i *> _pxy_pull_cons;

  SupplierAdmin_i *supplier_admin;
  ConsumerAdmin_i *consumer_admin;
};

class EventChannelWorker : public omni_thread {

public:
   typedef void (EventChannel_i::*Method)(void);
 
public:
   EventChannelWorker(EventChannel_i &object,
                      Method method,
                      priority_t priority = PRIORITY_NORMAL);
   void run(void *);

private:
   EventChannel_i* _object;
   Method _method;
   EventChannelWorker() {};
};

// FACTORY

class EventChannelFactory_i :
  public EventChannelAdmin::_sk_EventChannelFactory {

public:
    EventChannelFactory_i ();
    CORBA::Boolean supports (const CosLifeCycle::Key &k);
    CORBA::Object_ptr create_object(const CosLifeCycle::Key &k,
                                    const CosLifeCycle::Criteria &the_criteria);
};

#endif
