#
# checkmounts.sh - check that GNUWIN32 mounts are OK
#

if [ $# != 1 -o -z "$1" ]; then
    echo "usage: checkmounts <directory>"
    exit
fi

if [ ! -f /bin/sh.exe ]; then
    echo "no /bin/sh.exe, mounting $1\\bin as /bin"
    mount "$1\\bin" /bin
    if [ ! -f /bin/sh.exe ]; then
	echo "mounting /bin failed or $1\\bin doesn't contain sh.exe"
	exit
    fi
fi

if [ ! -d /tmp ]; then
    echo "no /tmp, mounting $1\\tmp as /tmp"
    mount "$1\\tmp" /tmp
    if [ ! -d /tmp ]; then
	echo "mounting /tmp failed"
	exit
    fi
fi

echo Completed successfully.
