// -*- Mode: C++; -*-
//                            Package   : omniProperties
// omniProperties.cc          Created on: 2/5/1999
//                            Author    : Ted Byrd (tbyrd@idiom.com)
//
//    Copyright (C) 1999 Ted Byrd
//    All Rights Reserved.
//
//    This file is part of omniProperties
//
//    omniProperties is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//
//    Main server entry point.
//
// Revision History:
//
// $Log: omniProperties.cc,v $
// Revision 1.2  1999/02/06 05:39:52  tbyrd
// Changed exits to returns, add try block to impl_is_ready call.
//
// Revision 1.1  1999/02/06 03:58:23  tbyrd
// Initial check in
//
//	

#include <iostream>
#include "CosPropertyService_i.h"

static void usage();

#ifdef __WIN32__
extern int getopt(int,char**,char*);
extern char* optarg;
#endif

int
main(int argc, char **argv)
{
  //
  // Start orb and boa.
  //

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  //
  // Process Options
  //

  int c;
  char *factoryName = (char *) "PropertySetDefFactory";
  char *factoryKind = (char *) "PropertySetDefFactory";

  while ((c = getopt(argc,argv,"N:K:h")) != EOF)
  {
     switch (c)
     {
        case 'N': factoryName = optarg; break; 
        case 'K': factoryKind = optarg; break;

        case 'h':
        default : 
          usage();
          return -1;
          break;
     }
  }

  //
  // Obtain and narrow reference to Name Service.
  //

  CosNaming::NamingContext_ptr rootContext;
  try {

     // Get initial reference.
     CORBA::Object_var initServ;
     initServ = orb->resolve_initial_references("NameService");

     // Narrow the object returned by resolve_initial_references()
     // to a CosNaming::NamingContext object:
     rootContext = CosNaming::NamingContext::_narrow(initServ);
     if (CORBA::is_nil(rootContext))
     {
        cerr << "Failed to narrow naming context." << endl;
        return 1;
     }
  }
  catch(CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]." << endl;
     return 1;
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE."
          << endl;
     return 1;
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception" << endl;
     throw;
  }
  catch (...) {
     cerr << "Caught a system exception while resolving the naming service."
          << endl;
     return 1;
  }

  //
  // Create an instance of a property set def factories and bind it to a name
  //

  PropertySetDefFactory_i* factory = new PropertySetDefFactory_i();

  CosNaming::Name name;
  name.length(1);

  name[0].id = CORBA::string_dup(factoryName);
  name[0].kind = CORBA::string_dup(factoryKind);

  try {
    rootContext->bind(name, factory);
  }
  catch(CosNaming::NamingContext::AlreadyBound& ex) {
    // overwrite previously bound object
    rootContext->rebind(name, factory);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the "
          << "naming service." << endl;
     return 1;
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception" << endl;
     throw;
  }
  catch (...) {
     cerr << "Cannot register event channel factory ! [\""
          << factoryName << "\", \"" << factoryKind << "\"]"
          << endl;
     return 1;
  }

  factory->_obj_is_ready(boa);

  //
  // Start implementation, blocking.
  //

  try
  {
    boa->impl_is_ready();
  }
  catch (CORBA::SystemException&)
  {
    cerr << "CORBA system exception while processing requests" << endl;
    return 1;
  }
  catch (...)
  {
    cerr << "Unknown exception while processing requests" << endl;
    return 1;
  }

  return 0;
}

static void
usage()
{
   cerr << endl 
        << "Usage: omniProperties [-N name] [-K kind] [-h]" << endl 
        << endl
        << "  -N name specify factory name [\"PropertySetDefFactory\"]" << endl
        << "  -K kind specify factory kind [\"PropertySetDefFactory\"]" << endl
	<< "  -h display usage message" << endl
        << endl;
}

