// -*- Mode: C++; -*-
//                            Package   : omniProperties
// CosPropertyService_i.h     Created on: 2/5/1999
//                            Author    : Ted Byrd (tbyrd@idiom.com)
//
//    Copyright (C) 1999 Ted Byrd
//    All Rights Reserved.
//
//    This file is part of omniProperties
//
//    omniProperties is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//
//    Implementation of COSS Property Service.  For more information
//    see the OMG's Property Service Specification.
//
//
// Revision History:
//
// $Log: CosPropertyService_i.h,v $
// Revision 1.3  1999/02/06 06:21:59  tbyrd
// Code cleanup
//
// Revision 1.2  1999/02/06 04:30:03  tbyrd
// Completed Linux port
//
// Revision 1.1  1999/02/06 03:58:23  tbyrd
// Initial check in
//
//

#ifndef __COSPROPERTYSERVICE_H__
#define __COSPROPERTYSERVICE_H__

#include <string>
#include <map>
#include <vector>
#include <iterator>
#include <iostream>

#include "omniProperties.hh"

#ifdef __WIN32__
using namespace std;
#endif

#ifndef min
#define min(a,b) ((a < b) ? a : b)
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef struct {
  string                                name;
  CORBA::Any                            value;
  CosPropertyService::PropertyModeType  mode;
} property_t;

struct ltstr
{
  bool operator()(const char* s1, const char* s2) const {
    return strcmp(s1, s2) < 0;
  }
};

typedef map<const char*,property_t,ltstr> property_map_t;
typedef map<const char*,property_t,ltstr>::iterator property_map_iterator_t;
typedef vector<CORBA::TCKind> property_types_t;
typedef vector<CORBA::TCKind>::iterator property_types_iterator_t;
typedef vector<property_t> properties_t;
typedef vector<property_t>::iterator properties_iterator_t;
typedef vector<CosPropertyService::PropertyException> property_exceptions_t;
typedef vector<CosPropertyService::PropertyException>::iterator
	property_exceptions_iterator_t;

class PropertySetFactory_i : public virtual _sk_PropertySetFactoryImpl
{
public:
  PropertySetFactory_i();
  virtual ~PropertySetFactory_i();

  virtual CosPropertyService::PropertySet_ptr create_propertyset();

  virtual CosPropertyService::PropertySet_ptr create_constrained_propertyset(
    const CosPropertyService::PropertyTypes & allowed_property_types,
    const CosPropertyService::Properties & allowed_properties);

  virtual CosPropertyService::PropertySet_ptr create_initial_propertyset(
    const CosPropertyService::Properties & initial_properties);

  virtual CosLifeCycle::LifeCycleObject_ptr  copy(
    CosLifeCycle::FactoryFinder_ptr  there,
    const CosLifeCycle::Criteria & the_criteria);

  virtual void move(
    CosLifeCycle::FactoryFinder_ptr  there,
    const CosLifeCycle::Criteria & the_criteria);

  virtual void remove();
};

class PropertySetDefFactory_i : public virtual _sk_PropertySetDefFactoryImpl
{
public:
  PropertySetDefFactory_i();
  virtual ~PropertySetDefFactory_i();

  virtual CosPropertyService::PropertySetDef_ptr create_propertysetdef();

  virtual CosPropertyService::PropertySetDef_ptr create_constrained_propertysetdef(
    const CosPropertyService::PropertyTypes & allowed_property_types,
    const CosPropertyService::PropertyDefs & allowed_property_defs);

  virtual CosPropertyService::PropertySetDef_ptr create_initial_propertysetdef(
    const CosPropertyService::PropertyDefs & initial_property_defs);

  virtual CosLifeCycle::LifeCycleObject_ptr  copy(
    CosLifeCycle::FactoryFinder_ptr  there,
    const CosLifeCycle::Criteria & the_criteria);

  virtual void move(CosLifeCycle::FactoryFinder_ptr  there,
    const CosLifeCycle::Criteria & the_criteria);

  virtual void remove();
};

class PropertySet_i : public virtual _sk_PropertySetImpl
{
public:
  PropertySet_i();
  PropertySet_i(
    const CosPropertyService::PropertyTypes& allowed_property_types,
    const CosPropertyService::Properties& allowed_properties);
  PropertySet_i(const CosPropertyService::Properties& initial_properties);
  virtual ~PropertySet_i();

  virtual void define_property(
    const char* property_name,
    const CORBA::Any& property_value);

  virtual void define_properties(
    const CosPropertyService::Properties& nproperties);

  virtual CORBA::ULong get_number_of_properties();

  virtual void get_all_property_names(
    CORBA::ULong how_many,
    CosPropertyService::PropertyNames*& property_names,
    CosPropertyService::PropertyNamesIterator_ptr& rest);

  virtual CORBA::Any* get_property_value(const char*  property_name);

  virtual CORBA::Boolean get_properties(
    const CosPropertyService::PropertyNames& property_names,
    CosPropertyService::Properties*& nproperties);

  virtual void get_all_properties(
    CORBA::ULong how_many,
    CosPropertyService::Properties*& nproperties,
    CosPropertyService::PropertiesIterator_ptr& rest);

  virtual void delete_property(const char* property_name);

  virtual void delete_properties(
    const CosPropertyService::PropertyNames & property_names);

  virtual CORBA::Boolean delete_all_properties();

  virtual CORBA::Boolean is_property_defined(const char*  property_name);

  virtual CosLifeCycle::LifeCycleObject_ptr  copy(
    CosLifeCycle::FactoryFinder_ptr  there,
    const CosLifeCycle::Criteria & the_criteria);

  virtual void move(
    CosLifeCycle::FactoryFinder_ptr  there,
    const CosLifeCycle::Criteria & the_criteria);

  virtual void remove();

protected:
  property_map_iterator_t find_property( const char* key );

protected:
  property_map_t    m_propmap;
  property_types_t  m_allowedTypes;
  properties_t      m_allowedProperties;
  omni_mutex        m_lock;
};

class PropertySetDef_i :
  public virtual _sk_PropertySetDefImpl,
  public virtual PropertySet_i
{
public:
  PropertySetDef_i();
  PropertySetDef_i( 
    const CosPropertyService::PropertyTypes& allowed_property_types,
    const CosPropertyService::PropertyDefs& allowed_property_defs);
  PropertySetDef_i(
    const CosPropertyService::PropertyDefs& initial_property_defs);
  virtual ~PropertySetDef_i();

  virtual void get_allowed_property_types(
    CosPropertyService::PropertyTypes *& property_types);

  virtual void get_allowed_properties(
    CosPropertyService::PropertyDefs *& property_defs);

  virtual void define_property_with_mode(
    const char*  property_name,
    const CORBA::Any & property_value,
    CosPropertyService::PropertyModeType  property_mode);

  virtual void define_properties_with_modes(
    const CosPropertyService::PropertyDefs & property_defs);

  virtual CosPropertyService::PropertyModeType  get_property_mode(
    const char*  property_name);

  virtual CORBA::Boolean  get_property_modes(
    const CosPropertyService::PropertyNames & property_names,
    CosPropertyService::PropertyModes *& property_modes);

  virtual void set_property_mode(
    const char*  property_name,
    CosPropertyService::PropertyModeType  property_mode);

  virtual void set_property_modes(
    const CosPropertyService::PropertyModes & property_modes);
};

class PropertyNamesIterator_i : public virtual CosPropertyService::_sk_PropertyNamesIterator
{
  PropertyNamesIterator_i() {}

public:
  PropertyNamesIterator_i(
    const property_map_iterator_t& iterCur,
    const property_map_iterator_t& iterBegin,
    const property_map_iterator_t& iterEnd);
  virtual ~PropertyNamesIterator_i();

  virtual void reset();
  virtual CORBA::Boolean next_one(char*& property_name);
  virtual CORBA::Boolean next_n(
    CORBA::ULong how_many,
    CosPropertyService::PropertyNames*& property_names);
  virtual void destroy();

private:
  property_map_iterator_t m_iterCur;
  property_map_iterator_t m_iterFirst;
  property_map_iterator_t m_iterLast;
  omni_mutex              m_lock;
};

class PropertiesIterator_i : public virtual CosPropertyService::_sk_PropertiesIterator
{
  PropertiesIterator_i() {}

public:
  PropertiesIterator_i(
    const property_map_iterator_t& iterCur, 
    const property_map_iterator_t& iterBegin, 
    const property_map_iterator_t& iterEnd);
  virtual ~PropertiesIterator_i();

  virtual void reset();
  virtual CORBA::Boolean next_one(CosPropertyService::Property*& aproperty);
  virtual CORBA::Boolean next_n(
    CORBA::ULong how_many,
    CosPropertyService::Properties*& nproperties);
  virtual void destroy();

private:
  property_map_iterator_t m_iterCur;
  property_map_iterator_t m_iterFirst;
  property_map_iterator_t m_iterLast;
  omni_mutex              m_lock;
};

#endif // __COSPROPERTYSERVICE_H__
