/* --------------------------------------------------
 * Porting to Borland's tools
 * 29.09.1998 -- Mikhail Soukhanov <mailto:mik@astra.relline.ru.>
 * 27.11.1998 -- modified to match omniORB 2.6.0
 *
 * tlinkwrapper.c - wrapper around Borland C++'s "TLINK" program to perform
 *                  file name translation (from unix-like to dos-like names).
 *
 * Both GNUWIN32 and OpenNT file names are supported - the first argument
 * to this program specifies which.
 *
 * The second optional argument may specify different command line formats:
 *     -msvc -- M$VC "link"
 *     -unix -- UNIX "ld"
 *
 * Compile this program with "bcc32 tlinkwrapper.c".
 *
 * --------------------------------------------------*/

#include "genwrapper.c"

char **WrapArgs_MSVCstyle(int argc, char **argv, char **wargv, char ***wargv_after);
char **WrapArgs_UNIXstyle(int argc, char **argv, char **wargv, char ***wargv_after);

int WrapArgs(int argc, char **argv, char ***wargv1, char ***wargv2)
{
  char **wargv = calloc(argc+2,sizeof(*wargv));
  int i, j;

  wargv[0] = "tlink32";

  if (argc > 0) {
  	if (strncmp(argv[0], "-msvc", 5) == 0) {
      *wargv1 = WrapArgs_MSVCstyle(argc-1, argv+1, wargv, wargv2);
	  return (argv[0][5] == '-');
    } else if (strncmp(argv[0], "-unix", 5) == 0) {
	  *wargv1 = WrapArgs_UNIXstyle(argc-1, argv+1, wargv, wargv2);
	  return (argv[0][5] == '-');
	}
  }

  j = 1;

  for (i = 0; i < argc; i++, j++) {
    if (argv[i][0] == '-') {
	  char op = argv[i][1];
	  char *fn = argv[i]+2;

	  switch (op) {

      case 'L': /* Specify library search paths */
      case 'j': /* Specify object search paths */
        if (*fn == '\0') fn = argv[++i];
        fn = TranslateFileName(fn,0);
        wargv[j] = malloc(strlen(fn) + 3);
        sprintf(wargv[j], "-%c%s", op, fn);
		free(fn);
		break;

      default:
		wargv[j] = strdup(argv[i]);
		break;

      }

    } else {

      /* just a file argument */

      wargv[j] = TranslateFileName(argv[i],0);
    }

  }
  wargv[j] = NULL;

  *wargv1 = wargv;
  *wargv2 = NULL;
  return 0;
}

char **WrapArgs_MSVCstyle(int argc, char **argv, char **wargv, char ***wargv_after)
{
  int i, j, n, iopt, iobj, ilib, ilibpaths;

  char **options, **libpaths, *c0obj, **objs, *out, **libs, *def, *implib;

  c0obj = "c0x32.obj";
  out = def = implib = NULL;

  options = calloc(argc+1,sizeof(*options));
  objs = calloc(argc+1,sizeof(*objs));
  libs = calloc(argc+1,sizeof(*libs));
  libpaths = calloc(argc+1,sizeof(*libpaths));

  n = iopt = iobj = ilib = ilibpaths = 0;

  for (i = 0; i < argc; i++) {
    if (argv[i][0] == '-') {

      if (strnicmp(argv[i], "-out:", 5) == 0) {

        out = TranslateFileName(argv[i]+5,0);

      } else if (strnicmp(argv[i], "-implib:", 8) == 0) {

        implib = TranslateFileName(argv[i]+8,0);

      } else if (strnicmp(argv[i], "-def:", 5) == 0) {

        def = TranslateFileName(argv[i]+5,0);

      } else if (strnicmp(argv[i], "-libpath:", 9) == 0) {

		libpaths[ilibpaths++] = TranslateFileName(argv[i]+9,0);

	  } else if (strnicmp(argv[i], "-dll", 4) == 0) {

		options[iopt++] = strdup("-Tpd");
		c0obj = strdup("c0d32.obj sysinit.obj");

	  } else {

		options[iopt++] = strdup(argv[i]);

      }

    } else {

      /* just a file argument */

	  if ( strstr(argv[i], ".lib") ) {
		libs[ilib++] = TranslateFileName(argv[i],0);
	  } else {
		objs[iobj++] = TranslateFileName(argv[i],0);
	  }

    }

	n++;
  }

  wargv = realloc(wargv, (n+5)*sizeof(*wargv));
  j = 0;

  /* options go first */
  for (i = 0; i < iopt; i++) wargv[++j] = options[i];
  free(options);

  /* concatenate library paths -- otherwise the latest overrides all */
  n = 0;
  for (i = 0; i < ilibpaths; i++) n += strlen(libpaths[i]) + 1;
  wargv[++j] = calloc(n+2, sizeof(**wargv));
  strcpy(wargv[j], "-L");
  for (i = 0; i < ilibpaths; i++) {
  	strcat(strcat(wargv[j], libpaths[i]), ";");
	free(libpaths[i]);
  }
  free(libpaths);

  /* duplicate library paths -- as paths to object files */
  wargv[j+1] = strdup(wargv[j]);
  wargv[++j][1] = 'j';

  /* c0xxx.obj */
  if ( c0obj ) wargv[++j] = c0obj;

  /* and all other object files follow */
  for (i = 0; i < iobj; i++) wargv[++j] = objs[i];
  free(objs);

  wargv[j] = realloc(wargv[j], strlen(wargv[j])+2);
  strcat( wargv[j], "," );

  /* with Borland, implib is called separately */
  *wargv_after = NULL;
  if (implib) {
	char **wargv2 = calloc(4,sizeof(*wargv2));

    wargv2[0] = "implib";
	wargv2[1] = implib;
	wargv2[2] = strdup(out);
	wargv2[3] = NULL;

	*wargv_after = wargv2;
  }

  /* outout file */
  wargv[++j] = realloc(out, strlen(out)+2);
  strcat( wargv[j], "," );

  /* map file -- we do not want it */
  wargv[++j] = "nul,";

  /* libraries... */
  for (i = 0; i < ilib; i++) wargv[++j] = libs[i];
  free(libs);

  /* and finally DEF file -- if there is one */
  if ( def ) {
    wargv[j] = realloc(wargv[j], strlen(wargv[j])+2);
    strcat( wargv[j], "," );

	wargv[++j] = def;
  }

  wargv[++j] = NULL;

  return wargv;
}

char **WrapArgs_UNIXstyle(int argc, char **argv, char **wargv, char ***wargv_after)
{
  int i, j, n, iopt, iobj, ilib;

  char **options, *c0obj, **objs, *out, **libs, *def, *implib;

  c0obj = "c0x32.obj";
  out = def = implib = NULL;

  options = calloc(argc+1,sizeof(*options));
  objs = calloc(argc+1,sizeof(*objs));
  libs = calloc(argc+1,sizeof(*libs));

  n = iopt = iobj = ilib = 0;

  for (i = 0; i < argc; i++) {
    if (argv[i][0] == '-') {

      if (strcmp(argv[i], "-o") == 0) {

        out = TranslateFileName(argv[++i],5);

      } else if (strcmp(argv[i], "-L") == 0) {

        char *fn = TranslateFileName(argv[++i],0);

		options[iopt] = malloc(strlen(fn) + 3);
        sprintf(options[iopt++], "-L%s", fn);
        options[iopt] = malloc(strlen(fn) + 3);
        sprintf(options[iopt++], "-j%s", fn);
		n++;

		free(fn);

	  } else {

		options[iopt++] = strdup(argv[i]);

      }

    } else {

      /* just a file argument */

	  if ( strstr(argv[i], ".lib") ) {
		libs[ilib++] = TranslateFileName(argv[i],0);
	  } else {
		objs[iobj++] = TranslateFileName(argv[i],0);
	  }

    }

	n++;
  }

  wargv = realloc(wargv, (n+4)*sizeof(*wargv));
  j = 0;

  for (i = 0; i < iopt; i++) wargv[++j] = options[i];
  free(options);

  if ( c0obj ) wargv[++j] = c0obj;

  for (i = 0; i < iobj; i++) wargv[++j] = objs[i];
  free(objs);

  wargv[j] = realloc( wargv[j], strlen(wargv[j])+2 );
  strcat( wargv[j], "," );

  wargv[++j] = realloc( out, strlen(out)+2 );
  strcat( wargv[j], "," );

  wargv[++j] = "nul,";

  for (i = 0; i < ilib; i++) wargv[++j] = libs[i];
  free(libs);

  if ( def ) {
    wargv[j] = realloc( wargv[j], strlen(wargv[j])+2 );
    strcat( wargv[j], "," );

	wargv[++j] = def;
  }

  wargv[++j] = NULL;

  *wargv_after = NULL;
  return wargv;;
}