/* --------------------------------------------------
 * Porting to Borland's tools
 * 29.09.1998 -- Mikhail Soukhanov <mailto:mik@astra.relline.ru.>
 * 27.11.1998 -- modified to match omniORB 2.6.0
 *
 * tlibwrapper.c - wrapper around Borland C++'s "TLIB" program to perform
 *                 file name translation (from unix-like to dos-like names).
 *
 * Both GNUWIN32 and OpenNT file names are supported - the first argument
 * to this program specifies which.
 *
 * The second optional argument may specify different command line formats:
 *     -msvc -- M$VC "lib"
 *     -unix -- UNIX "ar"
 *
 * Compile this program with "bcc32 tlibwrapper.c".
 *
 * --------------------------------------------------*/

#include "genwrapper.c"

char **WrapArgs_MSVCstyle(int argc, char **argv, char **wargv, char ***wargv_after);
char **WrapArgs_UNIXstyle(int argc, char **argv, char **wargv, char ***wargv_after);

int WrapArgs(int argc, char **argv, char ***wargv1, char ***wargv2)
{
  char **wargv = calloc(argc+3,sizeof(*wargv));
  int i, j;

  wargv[0] = "tlib";

  if (argc > 0) {
  	if (strncmp(argv[0], "-msvc", 5) == 0) {
      *wargv1 = WrapArgs_MSVCstyle(argc-1, argv+1, wargv, wargv2);
	  return (argv[0][5] == '-');
    } else if (strncmp(argv[0], "-unix", 5) == 0) {
	  *wargv1 = WrapArgs_UNIXstyle(argc-1, argv+1, wargv, wargv2);
	  return (argv[0][5] == '-');
	}
  }

  j = 1;

  for (i = 0; i < argc; i++, j++) {
    switch (argv[i][0]) {
	case '/':
      wargv[j] = strdup(argv[i]);
	  break;

    case '+':
    case '-':
    case '*':
      wargv[j] = TranslateFileName(argv[i],0);
	  break;

	default:
      wargv[j] = TranslateFileName(argv[i],0);
	  break;

	}

  }
  wargv[j] = NULL;

  *wargv1 = wargv;
  *wargv2 = NULL;
  return 0;
}

char **WrapArgs_MSVCstyle(int argc, char **argv, char **wargv, char ***wargv_after)
{
  int i, j, f;

  j = 1;
  f = 1;

  for (i = 0; i < argc; i++, j++) {
    switch (argv[i][0]) {
	case '/':
      /* ignore options for now */
	  break;

	default:
      if (f) {

        /* first arg is library name */

        wargv[j] = TranslateFileName(argv[i],0);
		f = 0;
		wargv[++j] = "/P256";

      } else {

        /* just a file argument */

        int len = strlen(argv[i]);

        wargv[j] = malloc(len + 2);

        sprintf(wargv[j], "+%s", TranslateFileName(argv[i],5));

      }
	  break;
    }

  }
  wargv[j] = NULL;

  *wargv_after = NULL;
  return wargv;
}

char **WrapArgs_UNIXstyle(int argc, char **argv, char **wargv, char ***wargv_after)
{
  int i, j, f;

  j = 1;
  f = 1;

  for (i = 0; i < argc; i++, j++) {
    switch (argv[i][0]) {
	case '-':
      /* ignore options for now */
	  break;

	default:
      if (f) {

        /* first arg is library name */

        wargv[j] = TranslateFileName(argv[i],0);
		f = 0;
		wargv[++j] = "/P256";

      } else {

        /* just a file argument */

        int len = strlen(argv[i]);

        wargv[j] = malloc(len + 2);

        sprintf(wargv[j], "+%s", TranslateFileName(argv[i],5));

      }
	  break;
    }

  }
  wargv[j] = NULL;

  *wargv_after = NULL;
  return wargv;
}