/* --------------------------------------------------
 * Porting to Borland's tools
 * 29.09.1998 -- Mikhail Soukhanov <mailto:mik@astra.relline.ru.>
 * 27.11.1998 -- modified to match omniORB 2.6.0
 *
 * bccwrapper.c - wrapper around Borland C++'s "BCC32" program to perform
 *                file name translation (from unix-like to dos-like names).
 *
 * Both GNUWIN32 and OpenNT file names are supported - the first argument
 * to this program specifies which.
 *
 * Compile this program with "bcc32 bccwrapper.c".
 *
 * --------------------------------------------------*/

#include "genwrapper.c"

int WrapArgs(int argc, char **argv, char ***wargv1, char ***wargv2)
{
  char** wargv = calloc(argc+2,sizeof(*wargv));
  int silent=0;
  int i, j;

  wargv[0] = "bcc32";
  j = 1;

  for (i = 0; i < argc; i++, j++) {
    if (argv[i][0] == '-') {
	  char op = argv[i][1];
	  char *fn = argv[i]+2;

	  if ( strncmp(argv[i], "-msvc", 5) == 0 ) {
		silent = (argv[i][5] == '-'); /* do not print substituted command line */
	  	--j;
		continue;
	  }

	  if (op == 'F' && *fn == 'o') { /* Specify object file name (M$VC) */
		op = 'o';
		++fn;
	  }

      switch (op) {

      case 'I': /* Specify include files search paths */
      case 'o': /* Specify object file name */
        if (*fn == '\0') fn = argv[++i];
        fn = TranslateFileName(fn,0);
        wargv[j] = malloc(strlen(fn) + 3);
        sprintf(wargv[j], "-%c%s", op, fn);
		free(fn);
	    break;

      case 'D': /* Define preprocessor symbol */
        if (*fn == '\0') fn = argv[++i];
        wargv[j] = malloc(strlen(fn) + 3);
        sprintf(wargv[j], "-%c%s", op, fn);

        if (strchr(wargv[j], '"')) {
          wargv[j] = EscapeDoubleQuotes(wargv[j]);
        }

	    break;

      default:
		wargv[j] = strdup(argv[i]);
		break;
      }

	} else {

	  /* just a file argument */

	  wargv[j] = TranslateFileName(argv[i],0);

	}

  }
  wargv[j] = NULL;

  *wargv1 = wargv;
  *wargv2 = NULL;
  return silent;
}