#include "naming.hh"
#include <omniORB2/proxyCall.h>

static const char* _0RL_library_version = omniORB_2_7;


size_t
CosNaming::NameComponent::NP_alignedSize(size_t _initialoffset) const
{
  CORBA::ULong _msgsize = _initialoffset;
  _msgsize = id.NP_alignedSize(_msgsize);
  _msgsize = kind.NP_alignedSize(_msgsize);
  return _msgsize;
}

void
CosNaming::NameComponent::operator>>= (NetBufferedStream &_n) const
{
  id >>= _n;
  kind >>= _n;
}

void
CosNaming::NameComponent::operator<<= (NetBufferedStream &_n)
{
  id <<= _n;
  kind <<= _n;
}

void
CosNaming::NameComponent::operator>>= (MemBufferedStream &_n) const
{
  id >>= _n;
  kind >>= _n;
}

void
CosNaming::NameComponent::operator<<= (MemBufferedStream &_n)
{
  id <<= _n;
  kind <<= _n;
}

size_t
CosNaming::Binding::NP_alignedSize(size_t _initialoffset) const
{
  CORBA::ULong _msgsize = _initialoffset;
  _msgsize = binding_name.NP_alignedSize(_msgsize);
  _msgsize = omni::align_to(_msgsize,omni::ALIGN_4);
  _msgsize += 4;
  return _msgsize;
}

void
CosNaming::Binding::operator>>= (NetBufferedStream &_n) const
{
  binding_name >>= _n;
  binding_type >>= _n;
}

void
CosNaming::Binding::operator<<= (NetBufferedStream &_n)
{
  binding_name <<= _n;
  binding_type <<= _n;
}

void
CosNaming::Binding::operator>>= (MemBufferedStream &_n) const
{
  binding_name >>= _n;
  binding_type >>= _n;
}

void
CosNaming::Binding::operator<<= (MemBufferedStream &_n)
{
  binding_name <<= _n;
  binding_type <<= _n;
}

CosNaming::NamingContext::NotFound::NotFound(const CosNaming::NamingContext::NotFound &_s)
{
  why = _s.why;
  rest_of_name = _s.rest_of_name;
}

CosNaming::NamingContext::NotFound::NotFound(NotFoundReason  _why, const Name _rest_of_name)
{
  why = _why;
  rest_of_name = _rest_of_name;
}

CosNaming::NamingContext::NotFound & CosNaming::NamingContext::NotFound::operator=(const CosNaming::NamingContext::NotFound &_s)
{
  why = _s.why;
  rest_of_name = _s.rest_of_name;
  return *this;
}

size_t
CosNaming::NamingContext::NotFound::NP_alignedSize(size_t _initialoffset) const
{
  size_t _msgsize = _initialoffset;
  _msgsize = omni::align_to(_msgsize,omni::ALIGN_4);
  _msgsize += 4;
  _msgsize = rest_of_name.NP_alignedSize(_msgsize);
  return _msgsize;
}

void
CosNaming::NamingContext::NotFound::operator>>= (NetBufferedStream &_n) const
{
  why >>= _n;
  rest_of_name >>= _n;
}

void
CosNaming::NamingContext::NotFound::operator<<= (NetBufferedStream &_n)
{
  why <<= _n;
  rest_of_name <<= _n;
}

void
CosNaming::NamingContext::NotFound::operator>>= (MemBufferedStream &_n) const
{
  why >>= _n;
  rest_of_name >>= _n;
}

void
CosNaming::NamingContext::NotFound::operator<<= (MemBufferedStream &_n)
{
  why <<= _n;
  rest_of_name <<= _n;
}

CosNaming::NamingContext::CannotProceed::CannotProceed(const CosNaming::NamingContext::CannotProceed &_s)
{
  cxt = _s.cxt;
  rest_of_name = _s.rest_of_name;
}

CosNaming::NamingContext::CannotProceed::CannotProceed(NamingContext_ptr _cxt, const Name _rest_of_name)
{
  cxt = _cxt;
  rest_of_name = _rest_of_name;
}

CosNaming::NamingContext::CannotProceed & CosNaming::NamingContext::CannotProceed::operator=(const CosNaming::NamingContext::CannotProceed &_s)
{
  cxt = _s.cxt;
  rest_of_name = _s.rest_of_name;
  return *this;
}

size_t
CosNaming::NamingContext::CannotProceed::NP_alignedSize(size_t _initialoffset) const
{
  size_t _msgsize = _initialoffset;
  _msgsize = CosNaming::NamingContext::NP_alignedSize(cxt,_msgsize);
  _msgsize = rest_of_name.NP_alignedSize(_msgsize);
  return _msgsize;
}

void
CosNaming::NamingContext::CannotProceed::operator>>= (NetBufferedStream &_n) const
{
  CosNaming::NamingContext::marshalObjRef(cxt,_n);
  rest_of_name >>= _n;
}

void
CosNaming::NamingContext::CannotProceed::operator<<= (NetBufferedStream &_n)
{
  cxt = CosNaming::NamingContext::unmarshalObjRef(_n);
  rest_of_name <<= _n;
}

void
CosNaming::NamingContext::CannotProceed::operator>>= (MemBufferedStream &_n) const
{
  CosNaming::NamingContext::marshalObjRef(cxt,_n);
  rest_of_name >>= _n;
}

void
CosNaming::NamingContext::CannotProceed::operator<<= (MemBufferedStream &_n)
{
  cxt = CosNaming::NamingContext::unmarshalObjRef(_n);
  rest_of_name <<= _n;
}

CosNaming::NamingContext::InvalidName::InvalidName(const CosNaming::NamingContext::InvalidName &_s)
{
}

CosNaming::NamingContext::InvalidName & CosNaming::NamingContext::InvalidName::operator=(const CosNaming::NamingContext::InvalidName &_s)
{
  return *this;
}

size_t
CosNaming::NamingContext::InvalidName::NP_alignedSize(size_t _initialoffset) const
{
  size_t _msgsize = _initialoffset;
  return _msgsize;
}

void
CosNaming::NamingContext::InvalidName::operator>>= (NetBufferedStream &_n) const
{
}

void
CosNaming::NamingContext::InvalidName::operator<<= (NetBufferedStream &_n)
{
}

void
CosNaming::NamingContext::InvalidName::operator>>= (MemBufferedStream &_n) const
{
}

void
CosNaming::NamingContext::InvalidName::operator<<= (MemBufferedStream &_n)
{
}

CosNaming::NamingContext::AlreadyBound::AlreadyBound(const CosNaming::NamingContext::AlreadyBound &_s)
{
}

CosNaming::NamingContext::AlreadyBound & CosNaming::NamingContext::AlreadyBound::operator=(const CosNaming::NamingContext::AlreadyBound &_s)
{
  return *this;
}

size_t
CosNaming::NamingContext::AlreadyBound::NP_alignedSize(size_t _initialoffset) const
{
  size_t _msgsize = _initialoffset;
  return _msgsize;
}

void
CosNaming::NamingContext::AlreadyBound::operator>>= (NetBufferedStream &_n) const
{
}

void
CosNaming::NamingContext::AlreadyBound::operator<<= (NetBufferedStream &_n)
{
}

void
CosNaming::NamingContext::AlreadyBound::operator>>= (MemBufferedStream &_n) const
{
}

void
CosNaming::NamingContext::AlreadyBound::operator<<= (MemBufferedStream &_n)
{
}

CosNaming::NamingContext::NotEmpty::NotEmpty(const CosNaming::NamingContext::NotEmpty &_s)
{
}

CosNaming::NamingContext::NotEmpty & CosNaming::NamingContext::NotEmpty::operator=(const CosNaming::NamingContext::NotEmpty &_s)
{
  return *this;
}

size_t
CosNaming::NamingContext::NotEmpty::NP_alignedSize(size_t _initialoffset) const
{
  size_t _msgsize = _initialoffset;
  return _msgsize;
}

void
CosNaming::NamingContext::NotEmpty::operator>>= (NetBufferedStream &_n) const
{
}

void
CosNaming::NamingContext::NotEmpty::operator<<= (NetBufferedStream &_n)
{
}

void
CosNaming::NamingContext::NotEmpty::operator>>= (MemBufferedStream &_n) const
{
}

void
CosNaming::NamingContext::NotEmpty::operator<<= (MemBufferedStream &_n)
{
}

// Proxy call descriptor class. Mangled signature:
//  void_i_s0_cCosNaming_mNameComponent_i_cCORBA_sObject_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName_e_cCosNaming_mNamingContext_mAlreadyBound
class _0RL_pc_69ceca6a39f685b5_00000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_00000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n, CORBA::Object_ptr _a_obj) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n),
    arg_obj(_a_obj)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);

private:
  const CosNaming::Name& arg_n;
  CORBA::Object_ptr arg_obj;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_00000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  msgsize = CORBA::Object::NP_alignedSize(arg_obj,msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_00000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
  CORBA::Object::marshalObjRef(arg_obj,giop_client);
}

void _0RL_pc_69ceca6a39f685b5_00000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_AlreadyBound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::AlreadyBound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

void CosNaming::_proxy_NamingContext::bind(const CosNaming::Name & n, CORBA::Object_ptr  obj)
{
  _0RL_pc_69ceca6a39f685b5_00000000 _call_desc("bind", 5, n, obj);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



// Proxy call descriptor class. Mangled signature:
//  void_i_s0_cCosNaming_mNameComponent_i_cCORBA_sObject_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName
class _0RL_pc_69ceca6a39f685b5_10000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_10000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n, CORBA::Object_ptr _a_obj) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n),
    arg_obj(_a_obj)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);

private:
  const CosNaming::Name& arg_n;
  CORBA::Object_ptr arg_obj;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_10000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  msgsize = CORBA::Object::NP_alignedSize(arg_obj,msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_10000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
  CORBA::Object::marshalObjRef(arg_obj,giop_client);
}

void _0RL_pc_69ceca6a39f685b5_10000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

void CosNaming::_proxy_NamingContext::rebind(const CosNaming::Name & n, CORBA::Object_ptr  obj)
{
  _0RL_pc_69ceca6a39f685b5_10000000 _call_desc("rebind", 7, n, obj);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



// Proxy call descriptor class. Mangled signature:
//  void_i_s0_cCosNaming_mNameComponent_i_cCosNaming_mNamingContext_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName_e_cCosNaming_mNamingContext_mAlreadyBound
class _0RL_pc_69ceca6a39f685b5_20000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_20000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n, CosNaming::NamingContext_ptr _a_nc) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n),
    arg_nc(_a_nc)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);

private:
  const CosNaming::Name& arg_n;
  CosNaming::NamingContext_ptr arg_nc;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_20000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  msgsize = CosNaming::NamingContext::NP_alignedSize(arg_nc,msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_20000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
  CosNaming::NamingContext::marshalObjRef(arg_nc,giop_client);
}

void _0RL_pc_69ceca6a39f685b5_20000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_AlreadyBound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::AlreadyBound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

void CosNaming::_proxy_NamingContext::bind_context(const CosNaming::Name & n, CosNaming::NamingContext_ptr  nc)
{
  _0RL_pc_69ceca6a39f685b5_20000000 _call_desc("bind_context", 13, n, nc);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



// Proxy call descriptor class. Mangled signature:
//  void_i_s0_cCosNaming_mNameComponent_i_cCosNaming_mNamingContext_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName
class _0RL_pc_69ceca6a39f685b5_30000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_30000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n, CosNaming::NamingContext_ptr _a_nc) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n),
    arg_nc(_a_nc)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);

private:
  const CosNaming::Name& arg_n;
  CosNaming::NamingContext_ptr arg_nc;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_30000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  msgsize = CosNaming::NamingContext::NP_alignedSize(arg_nc,msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_30000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
  CosNaming::NamingContext::marshalObjRef(arg_nc,giop_client);
}

void _0RL_pc_69ceca6a39f685b5_30000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

void CosNaming::_proxy_NamingContext::rebind_context(const CosNaming::Name & n, CosNaming::NamingContext_ptr  nc)
{
  _0RL_pc_69ceca6a39f685b5_30000000 _call_desc("rebind_context", 15, n, nc);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



// Proxy call descriptor class. Mangled signature:
//  _cCORBA_sObject_i_s0_cCosNaming_mNameComponent_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName
class _0RL_pc_69ceca6a39f685b5_40000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_40000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void unmarshalReturnedValues(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);
  inline CORBA::Object_ptr result() { return pd_result; }

private:
  const CosNaming::Name& arg_n;
  CORBA::Object_ptr pd_result;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_40000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_40000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
}

void _0RL_pc_69ceca6a39f685b5_40000000::unmarshalReturnedValues(GIOP_C& giop_client)
{
  pd_result = CORBA::Object::unmarshalObjRef(giop_client);
}

void _0RL_pc_69ceca6a39f685b5_40000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

CORBA::Object_ptr  CosNaming::_proxy_NamingContext::resolve(const CosNaming::Name & n)
{
  _0RL_pc_69ceca6a39f685b5_40000000 _call_desc("resolve", 8, n);

  OmniProxyCallWrapper::invoke(this, _call_desc);
  return _call_desc.result();
}



// Proxy call descriptor class. Mangled signature:
//  void_i_s0_cCosNaming_mNameComponent_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName
class _0RL_pc_69ceca6a39f685b5_50000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_50000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);

private:
  const CosNaming::Name& arg_n;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_50000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_50000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
}

void _0RL_pc_69ceca6a39f685b5_50000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

void CosNaming::_proxy_NamingContext::unbind(const CosNaming::Name & n)
{
  _0RL_pc_69ceca6a39f685b5_50000000 _call_desc("unbind", 7, n);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



// Proxy call descriptor class. Mangled signature:
//  _cCosNaming_mNamingContext
class _0RL_pc_69ceca6a39f685b5_60000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_60000000(const char* _op, size_t _op_len) :
    OmniProxyCallDesc(_op, _op_len)  {}

  virtual void unmarshalReturnedValues(GIOP_C&);
  inline CosNaming::NamingContext_ptr result() { return pd_result; }

private:
  CosNaming::NamingContext_ptr pd_result;
};

void _0RL_pc_69ceca6a39f685b5_60000000::unmarshalReturnedValues(GIOP_C& giop_client)
{
  pd_result = CosNaming::NamingContext::unmarshalObjRef(giop_client);
}

CosNaming::NamingContext_ptr  CosNaming::_proxy_NamingContext::new_context()
{
  _0RL_pc_69ceca6a39f685b5_60000000 _call_desc("new_context", 12);

  OmniProxyCallWrapper::invoke(this, _call_desc);
  return _call_desc.result();
}



// Proxy call descriptor class. Mangled signature:
//  _cCosNaming_mNamingContext_i_s0_cCosNaming_mNameComponent_e_cCosNaming_mNamingContext_mNotFound_e_cCosNaming_mNamingContext_mCannotProceed_e_cCosNaming_mNamingContext_mInvalidName_e_cCosNaming_mNamingContext_mAlreadyBound
class _0RL_pc_69ceca6a39f685b5_70000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_70000000(const char* _op, size_t _op_len, const CosNaming::Name& _a_n) :
    OmniProxyCallDesc(_op, _op_len, 1),
    arg_n(_a_n)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void unmarshalReturnedValues(GIOP_C&);
  virtual void userException(GIOP_C&, const char*);
  inline CosNaming::NamingContext_ptr result() { return pd_result; }

private:
  const CosNaming::Name& arg_n;
  CosNaming::NamingContext_ptr pd_result;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_70000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = arg_n.NP_alignedSize(msgsize);
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_70000000::marshalArguments(GIOP_C& giop_client)
{
  arg_n >>= giop_client;
}

void _0RL_pc_69ceca6a39f685b5_70000000::unmarshalReturnedValues(GIOP_C& giop_client)
{
  pd_result = CosNaming::NamingContext::unmarshalObjRef(giop_client);
}

void _0RL_pc_69ceca6a39f685b5_70000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotFound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotFound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_CannotProceed_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::CannotProceed _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_InvalidName_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::InvalidName _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else if( strcmp(repoId, CosNaming_NamingContext_AlreadyBound_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::AlreadyBound _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

CosNaming::NamingContext_ptr  CosNaming::_proxy_NamingContext::bind_new_context(const CosNaming::Name & n)
{
  _0RL_pc_69ceca6a39f685b5_70000000 _call_desc("bind_new_context", 17, n);

  OmniProxyCallWrapper::invoke(this, _call_desc);
  return _call_desc.result();
}



// Proxy call descriptor class. Mangled signature:
//  void_e_cCosNaming_mNamingContext_mNotEmpty
class _0RL_pc_69ceca6a39f685b5_80000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_80000000(const char* _op, size_t _op_len) :
    OmniProxyCallDesc(_op, _op_len, 1)  {}

  virtual void userException(GIOP_C&, const char*);

private:
};

void _0RL_pc_69ceca6a39f685b5_80000000::userException(GIOP_C& giop_client, const char* repoId)
{
  if( strcmp(repoId, CosNaming_NamingContext_NotEmpty_IntfRepoID) == 0 ) {
    CosNaming::NamingContext::NotEmpty _ex;
    _ex <<= giop_client;
    giop_client.RequestCompleted();
    throw _ex;
  }
  else {
    giop_client.RequestCompleted(1);
    throw CORBA::MARSHAL(0, CORBA::COMPLETED_MAYBE);
  }
}

void CosNaming::_proxy_NamingContext::destroy()
{
  _0RL_pc_69ceca6a39f685b5_80000000 _call_desc("destroy", 8);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



// Proxy call descriptor class. Mangled signature:
//  void_i_cunsigned_plong_o_s0_cCosNaming_mBinding_o_cCosNaming_mBindingIterator
class _0RL_pc_69ceca6a39f685b5_90000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_90000000(const char* _op, size_t _op_len, CORBA::ULong _a_how_many, CosNaming::BindingList*& _a_bl, CosNaming::BindingIterator_ptr& _a_bi) :
    OmniProxyCallDesc(_op, _op_len),
    arg_how_many(_a_how_many),
    arg_bl(_a_bl),
    arg_bi(_a_bi)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void unmarshalReturnedValues(GIOP_C&);

private:
  CORBA::ULong arg_how_many;
  CosNaming::BindingList*& arg_bl;
  CosNaming::BindingIterator_ptr& arg_bi;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_90000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = omni::align_to(msgsize,omni::ALIGN_4);
  msgsize += 4;
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_90000000::marshalArguments(GIOP_C& giop_client)
{
  arg_how_many >>= giop_client;
}

void _0RL_pc_69ceca6a39f685b5_90000000::unmarshalReturnedValues(GIOP_C& giop_client)
{
  CosNaming::BindingList* _arg_bl = new CosNaming::BindingList;
  CosNaming::BindingIterator_ptr _arg_bi = 0;
  *_arg_bl <<= giop_client;
  _arg_bi = CosNaming::BindingIterator::unmarshalObjRef(giop_client);
  arg_bl = _arg_bl;
  arg_bi = _arg_bi;
}

void CosNaming::_proxy_NamingContext::_0RL__list(CORBA::ULong  how_many, CosNaming::BindingList *& bl, CosNaming::BindingIterator_ptr & bi)
{
  _0RL_pc_69ceca6a39f685b5_90000000 _call_desc("list", 5, how_many, bl, bi);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}



CORBA::Boolean
CosNaming::_sk_NamingContext::dispatch(GIOP_S &_0RL_s,const char *_0RL_op,CORBA::Boolean _0RL_response_expected)
{
  if (strcmp(_0RL_op,"bind") == 0)
  {
    Name n;
    n <<= _0RL_s;
    CORBA::Object_var obj;
    obj = CORBA::Object::unmarshalObjRef(_0RL_s);
    _0RL_s.RequestReceived();
        try {
      bind(n, obj);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::AlreadyBound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 57;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 53;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_AlreadyBound_IntfRepoID,53);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"rebind") == 0)
  {
    Name n;
    n <<= _0RL_s;
    CORBA::Object_var obj;
    obj = CORBA::Object::unmarshalObjRef(_0RL_s);
    _0RL_s.RequestReceived();
        try {
      rebind(n, obj);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"bind_context") == 0)
  {
    Name n;
    n <<= _0RL_s;
    NamingContext_var nc;
    nc = CosNaming::NamingContext::unmarshalObjRef(_0RL_s);
    _0RL_s.RequestReceived();
        try {
      bind_context(n, nc);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::AlreadyBound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 57;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 53;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_AlreadyBound_IntfRepoID,53);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"rebind_context") == 0)
  {
    Name n;
    n <<= _0RL_s;
    NamingContext_var nc;
    nc = CosNaming::NamingContext::unmarshalObjRef(_0RL_s);
    _0RL_s.RequestReceived();
        try {
      rebind_context(n, nc);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"resolve") == 0)
  {
    Name n;
    n <<= _0RL_s;
    _0RL_s.RequestReceived();
    CORBA::Object_var _0RL_result;
    try {
      _0RL_result = resolve(n);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_msgsize = CORBA::Object::NP_alignedSize((_0RL_result.operator->()),_0RL_msgsize);
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    CORBA::Object::marshalObjRef((_0RL_result.operator->()),_0RL_s);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"unbind") == 0)
  {
    Name n;
    n <<= _0RL_s;
    _0RL_s.RequestReceived();
        try {
      unbind(n);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"new_context") == 0)
  {
    _0RL_s.RequestReceived();
    NamingContext_var _0RL_result;
    _0RL_result = new_context();
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_msgsize = CosNaming::NamingContext::NP_alignedSize((_0RL_result.operator->()),_0RL_msgsize);
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    CosNaming::NamingContext::marshalObjRef((_0RL_result.operator->()),_0RL_s);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"bind_new_context") == 0)
  {
    Name n;
    n <<= _0RL_s;
    _0RL_s.RequestReceived();
    NamingContext_var _0RL_result;
    try {
      _0RL_result = bind_new_context(n);
    }
    catch ( CosNaming::NamingContext::NotFound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotFound_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::CannotProceed &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 58;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 54;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_CannotProceed_IntfRepoID,54);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::InvalidName &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 56;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 52;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_InvalidName_IntfRepoID,52);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    catch ( CosNaming::NamingContext::AlreadyBound &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 57;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 53;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_AlreadyBound_IntfRepoID,53);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_msgsize = CosNaming::NamingContext::NP_alignedSize((_0RL_result.operator->()),_0RL_msgsize);
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    CosNaming::NamingContext::marshalObjRef((_0RL_result.operator->()),_0RL_s);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"destroy") == 0)
  {
    _0RL_s.RequestReceived();
        try {
      destroy();
    }
    catch ( CosNaming::NamingContext::NotEmpty &_0RL_ex) {
      size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
      _0RL_msgsize = omni::align_to(_0RL_msgsize,omni::ALIGN_4);
      _0RL_msgsize += 53;
      _0RL_msgsize = _0RL_ex.NP_alignedSize(_0RL_msgsize);
      _0RL_s.InitialiseReply(GIOP::USER_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
      CORBA::ULong _len = 49;
      _len >>= _0RL_s;
      _0RL_s.put_char_array((CORBA::Char *)CosNaming_NamingContext_NotEmpty_IntfRepoID,49);
      _0RL_ex >>= _0RL_s;
      _0RL_s.ReplyCompleted();
      return 1;
    }
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"list") == 0)
  {
    CORBA::ULong how_many;
    how_many <<= _0RL_s;
    BindingList_var bl;
    BindingIterator_var bi;
    _0RL_s.RequestReceived();
        NamingContext::list(how_many, bl, bi);
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_msgsize = (bl.operator->())->NP_alignedSize(_0RL_msgsize);
    _0RL_msgsize = CosNaming::BindingIterator::NP_alignedSize((bi.operator->()),_0RL_msgsize);
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    *(bl.operator->()) >>= _0RL_s;
    CosNaming::BindingIterator::marshalObjRef((bi.operator->()),_0RL_s);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else {
    return 0;
  }
}

CosNaming::_sk_NamingContext::_sk_NamingContext (const omniORB::objectKey& k)
{
  omniRopeAndKey l(0,(CORBA::Octet*)&k,(CORBA::ULong)sizeof(k));
  setRopeAndKey(l,0);
}

omniORB::objectKey
CosNaming::_sk_NamingContext::_key()
{
  omniRopeAndKey l;
  getRopeAndKey(l);
  return (*((omniORB::objectKey*)l.key()));
}

CosNaming::NamingContext_ptr
CosNaming::NamingContext::_duplicate(CosNaming::NamingContext_ptr obj)
{
  if (CORBA::is_nil(obj))
    return CosNaming::NamingContext::_nil();
  CORBA::Object::_duplicate(obj);
  return obj;
}

CosNaming::NamingContext_ptr
CosNaming::NamingContext::_narrow(CORBA::Object_ptr obj)
{
  if (CORBA::is_nil(obj))
    return CosNaming::NamingContext::_nil();
  CosNaming::NamingContext_ptr e = (CosNaming::NamingContext_ptr) (obj->PR_getobj()->_realNarrow(CosNaming_NamingContext_IntfRepoID));
  if (e)
    return e;
  else
    return CosNaming::NamingContext::_nil();
}

void *
CosNaming::NamingContext::_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id)
{
  if (is_cxx_type_id) return 0;
  if (!repoId)
    return (void *)((CORBA::Object_ptr)this);
  if (strcmp(CosNaming_NamingContext_IntfRepoID,repoId) == 0)
    return (void *)this;
  else {
    return 0;
  }
}

CORBA::Boolean
CosNaming::NamingContext::_0RL_is_a(const char *base_repoId) {
  if (strcmp(base_repoId,(const char *)CosNaming_NamingContext_IntfRepoID)==0)
    return 1;
  else
    return 0;
}

CosNaming::NamingContext_ptr
CosNaming::NamingContext_Helper::_nil() {
  return CosNaming::NamingContext::_nil();
}

CORBA::Boolean
CosNaming::NamingContext_Helper::is_nil(CosNaming::NamingContext_ptr p) {
  return CORBA::is_nil(p);
}

void
CosNaming::NamingContext_Helper::release(CosNaming::NamingContext_ptr p) {
  CORBA::release(p);
}

void
CosNaming::NamingContext_Helper::duplicate(CosNaming::NamingContext_ptr p) {
  CORBA::Object::_duplicate(p);
}

size_t
CosNaming::NamingContext_Helper::NP_alignedSize(CosNaming::NamingContext_ptr obj,size_t initialoffset) {
  return CosNaming::NamingContext::NP_alignedSize(obj,initialoffset);
}

void
CosNaming::NamingContext_Helper::marshalObjRef(CosNaming::NamingContext_ptr obj,NetBufferedStream &s) {
  CosNaming::NamingContext::marshalObjRef(obj,s);
}

CosNaming::NamingContext_ptr CosNaming::NamingContext_Helper::unmarshalObjRef(NetBufferedStream &s) {
  return CosNaming::NamingContext::unmarshalObjRef(s);
}

void
CosNaming::NamingContext_Helper::marshalObjRef(CosNaming::NamingContext_ptr obj,MemBufferedStream &s) {
  CosNaming::NamingContext::marshalObjRef(obj,s);
}

CosNaming::NamingContext_ptr CosNaming::NamingContext_Helper::unmarshalObjRef(MemBufferedStream &s) {
  return CosNaming::NamingContext::unmarshalObjRef(s);
}

const char *
CosNaming::NamingContext_proxyObjectFactory::irRepoId() const
{
  return (const char *)CosNaming_NamingContext_IntfRepoID;
}

CORBA::Object_ptr
CosNaming::NamingContext_proxyObjectFactory::newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release)
{
  CosNaming::_proxy_NamingContext *p = new CosNaming::_proxy_NamingContext(r,key,keysize,profiles,release);
  if (!p) {
    throw CORBA::NO_MEMORY(0,CORBA::COMPLETED_NO);
  }
  return (CORBA::Object_ptr) p;
}

CORBA::Boolean
CosNaming::NamingContext_proxyObjectFactory::is_a(const char *base_repoId) const
{
  return CosNaming::NamingContext::_0RL_is_a(base_repoId);

}

CosNaming::NamingContext_ptr
CosNaming::NamingContext::_nil() {
  return CosNaming::NamingContext_proxyObjectFactory::_nil();
}

static const CosNaming::NamingContext_proxyObjectFactory CosNaming_NamingContext_proxyObjectFactory;
CosNaming::NamingContext_ptr CosNaming::NamingContext_proxyObjectFactory::__nil_NamingContext = 0;

// Proxy call descriptor class. Mangled signature:
//  _cboolean_o_cCosNaming_mBinding
class _0RL_pc_69ceca6a39f685b5_a0000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_a0000000(const char* _op, size_t _op_len, CosNaming::Binding*& _a_b) :
    OmniProxyCallDesc(_op, _op_len),
    arg_b(_a_b)  {}

  virtual void unmarshalReturnedValues(GIOP_C&);
  inline CORBA::Boolean result() { return pd_result; }

private:
  CosNaming::Binding*& arg_b;
  CORBA::Boolean pd_result;
};

void _0RL_pc_69ceca6a39f685b5_a0000000::unmarshalReturnedValues(GIOP_C& giop_client)
{
  CosNaming::Binding* _arg_b = new CosNaming::Binding;
  pd_result <<= giop_client;
  *_arg_b <<= giop_client;
  arg_b = _arg_b;
}

CORBA::Boolean  CosNaming::_proxy_BindingIterator::_0RL__next_one(CosNaming::Binding *& b)
{
  _0RL_pc_69ceca6a39f685b5_a0000000 _call_desc("next_one", 9, b);

  OmniProxyCallWrapper::invoke(this, _call_desc);
  return _call_desc.result();
}


// Proxy call descriptor class. Mangled signature:
//  _cboolean_i_cunsigned_plong_o_s0_cCosNaming_mBinding
class _0RL_pc_69ceca6a39f685b5_b0000000
  : public OmniProxyCallDesc
{
public:
  inline _0RL_pc_69ceca6a39f685b5_b0000000(const char* _op, size_t _op_len, CORBA::ULong _a_how_many, CosNaming::BindingList*& _a_bl) :
    OmniProxyCallDesc(_op, _op_len),
    arg_how_many(_a_how_many),
    arg_bl(_a_bl)  {}

  virtual CORBA::ULong alignedSize(CORBA::ULong size_in);
  virtual void marshalArguments(GIOP_C&);
  virtual void unmarshalReturnedValues(GIOP_C&);
  inline CORBA::Boolean result() { return pd_result; }

private:
  CORBA::ULong arg_how_many;
  CosNaming::BindingList*& arg_bl;
  CORBA::Boolean pd_result;
};

CORBA::ULong _0RL_pc_69ceca6a39f685b5_b0000000::alignedSize(CORBA::ULong msgsize)
{
  msgsize = omni::align_to(msgsize,omni::ALIGN_4);
  msgsize += 4;
  return msgsize;
}

void _0RL_pc_69ceca6a39f685b5_b0000000::marshalArguments(GIOP_C& giop_client)
{
  arg_how_many >>= giop_client;
}

void _0RL_pc_69ceca6a39f685b5_b0000000::unmarshalReturnedValues(GIOP_C& giop_client)
{
  CosNaming::BindingList* _arg_bl = new CosNaming::BindingList;
  pd_result <<= giop_client;
  *_arg_bl <<= giop_client;
  arg_bl = _arg_bl;
}

CORBA::Boolean  CosNaming::_proxy_BindingIterator::_0RL__next_n(CORBA::ULong  how_many, CosNaming::BindingList *& bl)
{
  _0RL_pc_69ceca6a39f685b5_b0000000 _call_desc("next_n", 7, how_many, bl);

  OmniProxyCallWrapper::invoke(this, _call_desc);
  return _call_desc.result();
}


void CosNaming::_proxy_BindingIterator::destroy()
{
  OmniProxyCallWrapper::void_call _call_desc("destroy", 8);

  OmniProxyCallWrapper::invoke(this, _call_desc);
}




CORBA::Boolean
CosNaming::_sk_BindingIterator::dispatch(GIOP_S &_0RL_s,const char *_0RL_op,CORBA::Boolean _0RL_response_expected)
{
  if (strcmp(_0RL_op,"next_one") == 0)
  {
    Binding_var b;
    _0RL_s.RequestReceived();
    CORBA::Boolean _0RL_result;
    _0RL_result = BindingIterator::next_one(b);
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_msgsize += 1;
    _0RL_msgsize = (b.operator->())->NP_alignedSize(_0RL_msgsize);
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_result >>= _0RL_s;
    *(b.operator->()) >>= _0RL_s;
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"next_n") == 0)
  {
    CORBA::ULong how_many;
    how_many <<= _0RL_s;
    BindingList_var bl;
    _0RL_s.RequestReceived();
    CORBA::Boolean _0RL_result;
    _0RL_result = BindingIterator::next_n(how_many, bl);
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_msgsize += 1;
    _0RL_msgsize = (bl.operator->())->NP_alignedSize(_0RL_msgsize);
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_result >>= _0RL_s;
    *(bl.operator->()) >>= _0RL_s;
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else if (strcmp(_0RL_op,"destroy") == 0)
  {
    _0RL_s.RequestReceived();
        destroy();
    size_t _0RL_msgsize = (size_t) GIOP_S::ReplyHeaderSize();
    _0RL_s.InitialiseReply(GIOP::NO_EXCEPTION,(CORBA::ULong)_0RL_msgsize);
    _0RL_s.ReplyCompleted();
    return 1;
  }
  else {
    return 0;
  }
}

CosNaming::_sk_BindingIterator::_sk_BindingIterator (const omniORB::objectKey& k)
{
  omniRopeAndKey l(0,(CORBA::Octet*)&k,(CORBA::ULong)sizeof(k));
  setRopeAndKey(l,0);
}

omniORB::objectKey
CosNaming::_sk_BindingIterator::_key()
{
  omniRopeAndKey l;
  getRopeAndKey(l);
  return (*((omniORB::objectKey*)l.key()));
}

CosNaming::BindingIterator_ptr
CosNaming::BindingIterator::_duplicate(CosNaming::BindingIterator_ptr obj)
{
  if (CORBA::is_nil(obj))
    return CosNaming::BindingIterator::_nil();
  CORBA::Object::_duplicate(obj);
  return obj;
}

CosNaming::BindingIterator_ptr
CosNaming::BindingIterator::_narrow(CORBA::Object_ptr obj)
{
  if (CORBA::is_nil(obj))
    return CosNaming::BindingIterator::_nil();
  CosNaming::BindingIterator_ptr e = (CosNaming::BindingIterator_ptr) (obj->PR_getobj()->_realNarrow(CosNaming_BindingIterator_IntfRepoID));
  if (e)
    return e;
  else
    return CosNaming::BindingIterator::_nil();
}

void *
CosNaming::BindingIterator::_widenFromTheMostDerivedIntf(const char *repoId,CORBA::Boolean is_cxx_type_id)
{
  if (is_cxx_type_id) return 0;
  if (!repoId)
    return (void *)((CORBA::Object_ptr)this);
  if (strcmp(CosNaming_BindingIterator_IntfRepoID,repoId) == 0)
    return (void *)this;
  else {
    return 0;
  }
}

CORBA::Boolean
CosNaming::BindingIterator::_0RL_is_a(const char *base_repoId) {
  if (strcmp(base_repoId,(const char *)CosNaming_BindingIterator_IntfRepoID)==0)
    return 1;
  else
    return 0;
}

CosNaming::BindingIterator_ptr
CosNaming::BindingIterator_Helper::_nil() {
  return CosNaming::BindingIterator::_nil();
}

CORBA::Boolean
CosNaming::BindingIterator_Helper::is_nil(CosNaming::BindingIterator_ptr p) {
  return CORBA::is_nil(p);
}

void
CosNaming::BindingIterator_Helper::release(CosNaming::BindingIterator_ptr p) {
  CORBA::release(p);
}

void
CosNaming::BindingIterator_Helper::duplicate(CosNaming::BindingIterator_ptr p) {
  CORBA::Object::_duplicate(p);
}

size_t
CosNaming::BindingIterator_Helper::NP_alignedSize(CosNaming::BindingIterator_ptr obj,size_t initialoffset) {
  return CosNaming::BindingIterator::NP_alignedSize(obj,initialoffset);
}

void
CosNaming::BindingIterator_Helper::marshalObjRef(CosNaming::BindingIterator_ptr obj,NetBufferedStream &s) {
  CosNaming::BindingIterator::marshalObjRef(obj,s);
}

CosNaming::BindingIterator_ptr CosNaming::BindingIterator_Helper::unmarshalObjRef(NetBufferedStream &s) {
  return CosNaming::BindingIterator::unmarshalObjRef(s);
}

void
CosNaming::BindingIterator_Helper::marshalObjRef(CosNaming::BindingIterator_ptr obj,MemBufferedStream &s) {
  CosNaming::BindingIterator::marshalObjRef(obj,s);
}

CosNaming::BindingIterator_ptr CosNaming::BindingIterator_Helper::unmarshalObjRef(MemBufferedStream &s) {
  return CosNaming::BindingIterator::unmarshalObjRef(s);
}

const char *
CosNaming::BindingIterator_proxyObjectFactory::irRepoId() const
{
  return (const char *)CosNaming_BindingIterator_IntfRepoID;
}

CORBA::Object_ptr
CosNaming::BindingIterator_proxyObjectFactory::newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release)
{
  CosNaming::_proxy_BindingIterator *p = new CosNaming::_proxy_BindingIterator(r,key,keysize,profiles,release);
  if (!p) {
    throw CORBA::NO_MEMORY(0,CORBA::COMPLETED_NO);
  }
  return (CORBA::Object_ptr) p;
}

CORBA::Boolean
CosNaming::BindingIterator_proxyObjectFactory::is_a(const char *base_repoId) const
{
  return CosNaming::BindingIterator::_0RL_is_a(base_repoId);

}

CosNaming::BindingIterator_ptr
CosNaming::BindingIterator::_nil() {
  return CosNaming::BindingIterator_proxyObjectFactory::_nil();
}

static const CosNaming::BindingIterator_proxyObjectFactory CosNaming_BindingIterator_proxyObjectFactory;
CosNaming::BindingIterator_ptr CosNaming::BindingIterator_proxyObjectFactory::__nil_BindingIterator = 0;

