# dir.mk for omniORB2
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <major version no.> is always 2 for omniORB2.
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# 

# if you want to include is omniORB the HTTP layer:
IOP_HTTP = 1
# if you have the SSLToolkit - should be link with the HttpConnection
#HAS_SSL = 1
VERSION = 2.6.0

major_version = $(word 1,$(subst ., ,$(VERSION)))
minor_version = $(word 2,$(subst ., ,$(VERSION)))
micro_version = $(word 3,$(subst ., ,$(VERSION)))

#
# Life cycle run time library version
LC_VERSION = 1.2.2

lc_major_version = $(word 1,$(subst ., ,$(LC_VERSION)))
lc_minor_version = $(word 2,$(subst ., ,$(LC_VERSION)))
lc_micro_version = $(word 3,$(subst ., ,$(LC_VERSION)))
#
#
# For each source tree we want to search the parent directory to get source
# files so we put these on VPATH.  However we can't put the parent build
# directory ('..') on VPATH otherwise the .o files in there are used.  So we
# need to do that as a special case with the vpath directive:
#

override VPATH := $(patsubst %,%/..,$(VPATH))

ifndef BuildWin32DebugLibraries

vpath %.cc ..

else

vpath %.cc ../..

endif

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################
ifdef UnixPlatform
ifdef OMNIORB_CONFIG_DEFAULT_LOCATION
CONFIG_DEFAULT_LOCATION = $(OMNIORB_CONFIG_DEFAULT_LOCATION)
else
CONFIG_DEFAULT_LOCATION = \"/project/omni/var/omniORB_NEW.cfg\"
endif

NETLIBSRCS = relStream.cc tcpSocket.cc tcpSocketMTfactory.cc
NETLIBOBJS = relStream.o tcpSocket.o tcpSocketMTfactory.o
DIR_CPPFLAGS += -DUnixArchitecture
DIR_CPPFLAGS += -DCONFIG_DEFAULT_LOCATION=$(CONFIG_DEFAULT_LOCATION)
endif




#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform
NETLIBSRCS = relStream.cc tcpSocket.cc tcpSocketMTfactory.cc
NETLIBOBJS = relStream.o tcpSocket.o tcpSocketMTfactory.o  gatekeeper.o
# See the extra comments on gatekeeper.o at the end of this file

DIR_CPPFLAGS += -DNTArchitecture -D_OMNIORB2_DLL

ifndef BuildWin32DebugLibraries

# Temporary added micro version number to the name of the dll.
implib = $(patsubst %,$(DLLPattern),omniORB2$(minor_version)$(micro_version))
#implib = $(patsubst %,$(DLLPattern),omniORB2$(minor_version))

staticlib = ../$(patsubst %,$(LibPattern),omniORB2)

lcimplib = $(patsubst %,$(DLLPattern),omniLC$(lc_minor_version)$(lc_micro_version))
#lcimplib = $(patsubst %,$(DLLPattern),omniLC$(lc_minor_version))

lcstaticlib = ../$(patsubst %,$(LibPattern),omniLC)
CXXOPTIONS  = $(MSVC_DLL_CXXNODEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_DLL_CXXLINKNODEBUGOPTIONS)

SUBDIRS = debug

else

# Building the debug version of the library in the debug subdirectory.
# Notice that this dir.mk is recursively used in the debug directory to build
# this library. The BuildWin32DebugLibraries make variable is set to 1 in
# the dir.mk generated in the debug directory.
#

# Temporary added micro version number to the name of the dll.
implib = $(patsubst %,$(DLLDebugPattern),omniORB2$(minor_version)$(micro_version))

#implib = $(patsubst %,$(DLLDebugPattern),omniORB2$(minor_version))
staticlib = ../../debug/$(patsubst %,$(LibDebugPattern),omniORB2)

lcimplib = $(patsubst %,$(DLLDebugPattern),omniLC$(lc_minor_version)$(lc_micro_version))
#lcimplib = $(patsubst %,$(DLLDebugPattern),omniLC$(lc_minor_version))

lcstaticlib = ../../debug/$(patsubst %,$(LibDebugPattern),omniLC)
CXXDEBUGFLAGS = 
CXXOPTIONS = $(MSVC_DLL_CXXDEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_DLL_CXXLINKDEBUGOPTIONS)

tempvar := $(OMNITHREAD_LIB)
OMNITHREAD_LIB = $(patsubst $(DLLNoDebugSearchPattern),$(DLLDebugSearchPattern),$(tempvar))

DIR_CPPFLAGS += -I./../.. -I./../../..

SUBDIRS =

endif

lib = $(patsubst %.lib,%.dll,$(implib))
libname = $(patsubst %.dll,%,$(lib))
lclib = $(patsubst %.lib,%.dll,$(lcimplib))
lclibname = $(patsubst %.dll,%,$(lclib))

# Extra libraries required by NT
NT_EXTRA_LIBS = wsock32.lib advapi32.lib
endif

#############################################################################
#   Make variables for ATMos                                                #
#############################################################################

ifdef ATMos
NETLIBSRCS = relStream.cc tcpATMos.cc tcpATMosMTfactory.cc
NETLIBOBJS = relStream.o tcpATMos.o tcpATMosMTfactory.o
DIR_CPPFLAGS = -DATMosArchitecture
endif


#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

ORB2_SRCS = bootstrap_i.cc bootstrapSK.cc \
            constants.cc corbaBoa.cc corbaObject.cc corbaOrb.cc \
            corbaString.cc \
            exception.cc giopClient.cc giopServer.cc initFile.cc ior.cc \
            libcWrapper.cc mbufferedStream.cc nbufferedStream.cc \
            object.cc objectKey.cc objectRef.cc ropeFactory.cc \
            strand.cc scavenger.cc \
			typecode.cc any.cc tcParseEngine.cc \
            dynAny.cc dynAnyP.cc \
            $(NETLIBSRCS) $(LOG_SRCS) NamingSK.cc

ORB2_OBJS = bootstrap_i.o bootstrapSK.o \
            constants.o corbaBoa.o corbaObject.o corbaOrb.o \
            corbaString.o \
            exception.o giopClient.o giopServer.o initFile.o ior.o \
            libcWrapper.o mbufferedStream.o nbufferedStream.o \
            object.o objectRef.o objectKey.o ropeFactory.o \
            strand.o scavenger.o \
			typecode.o any.o tcParseEngine.o \
            dynAny.o dynAnyP.o \
            $(NETLIBOBJS) $(LOG_OBJS) NamingSK.o

LOG_SRCS = logIOstream.cc
LOG_OBJS = logIOstream.o

LC_SRCS = omniLifeCycle.cc reDirect.cc omniLifeCycleSK.cc
LC_OBJS = omniLifeCycle.o reDirect.o omniLifeCycleSK.o

DIR_CPPFLAGS += $(OMNITHREAD_CPPFLAGS)
DIR_CPPFLAGS += -I./.. -I./../.. 
DIR_CPPFLAGS += -DUSE_omniORB_logStream 

CXXSRCS = $(ORB2_SRCS)


ifdef IOP_HTTP

# Specify here the path in order to compile with the HttpModule... 
ORB2_SRCS += ip_mapping_file.cc IOP_HTTP.cc
ORB2_OBJS += ip_mapping_file.o  IOP_HTTP.o
CXXFLAGS  += -DIOP_HTTP

DIR_CPPFLAGS += -I$(TOP)/../HttpConnection/Include $(HTTP_MODULE_PATH)

endif

ifdef HAS_SSL
DIR_CPPFLAGS += -DHAS_SSL
DIR_CPPFLAGS += -I$(TOP)/../SSL/Interface/Include
endif

#############################################################################
#   Make rules for Solaris 2.x                                              #
#############################################################################

ifdef SunOS
ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -Kpic

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -o $@ -h $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -o $@ -h $(lcsoname) $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$(LC_OBJS)) $(OMNITHREAD_LIB) $(lib); \
       )


clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )


endif
endif

#############################################################################
#   Make rules for Linux egcs
#
#############################################################################

ifdef Linux
ifdef EgcsMajorVersion

DIR_CPPFLAGS += -fPIC

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        $(CXX) -shared -Wl,-soname,$(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
        $(RM) $@; \
        $(CXX) -shared -Wl,-soname,$(lcsoname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$(LC_OBJS)) \
         $(OMNITHREAD_LIB) $(lib); \
       )


clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

endif
endif

#############################################################################
#   Make rules for Digital Unix                                             #
#############################################################################

ifdef OSF1
ifeq ($(notdir $(CXX)),cxx)

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(rpath="$(RPATH)"; \
         for arg in $(OMNITHREAD_LIB) /usr/lib/cmplrs/cxx; do \
         if expr "$$arg" : "-L" >/dev/null; then \
               rpath="$$rpath$${rpath+:}`expr $$arg : '-L\(.*\)'"; \
         fi; \
         done; \set -x; \
         $(RM) $@; \
         ld -shared -soname $(soname) -set_version $(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         -expect_unresolved denyFile__10gateKeeper \
         -expect_unresolved allowFile__10gateKeeper \
         -expect_unresolved checkConnect__10gateKeeperXP15tcpSocketStrand \
         -expect_unresolved version__10gateKeeperXv \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) -lcxxstd -lcxx -lexc -lots -lc -rpath $$rpath; \
        )

$(lclib): $(LC_OBJS)
	(rpath="$(RPATH)"; \
         for arg in $(OMNITHREAD_LIB) /usr/lib/cmplrs/cxx; do \
         if expr "$$arg" : "-L" >/dev/null; then \
               rpath="$$rpath$${rpath+:}`expr $$arg : '-L\(.*\)'"; \
         fi; \
         done; \set -x; \
         $(RM) $@; \
         ld -shared -soname $(lcsoname) -set_version $(lcsoname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib) -lcxxstd -lcxx -lexc -lots -lc -rpath $$rpath; \
        )


clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

endif
endif


#############################################################################
#   Make rules for  IBM AIX                                                 #
#############################################################################

ifdef AIX

libname = libomniORB$(major_version)$(minor_version).a
soname = libomniORB$(major_version).so.$(minor_version).$(micro_version)
lib = $(libname).$(micro_version)

lclibname  = libomniLC$(lc_minor_version).a
lcsoname  = libomniLC.so.$(lc_minor_version).$(lc_micro_version)
lclib = $(lclibname).$(lc_micro_version)

# We have a bootstrapping problem with building gatekeepers and this shared 
# library. This library is built before gatekeeprs. Until we have 
# how to tell the linker it is safe to have some undefined symbols, we
# have to disable the gatekeeper feature.

NETLIBOBJS += gatekeeper.o

all:: $(lib)

all:: $(lclib)

ifeq ($(notdir $(CXX)),xlC_r)

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        /usr/lpp/xlC/bin/makeC++SharedLib_r \
             -o $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) \
         -p 40; \
         ar cq $(lib) $(soname); \
         $(RM) $(soname); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
        $(RM) $@; \
        /usr/lpp/xlC/bin/makeC++SharedLib_r \
             -o $(lcsoname) $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib) \
         -p 40; \
         ar cq $(lclib) $(lcsoname); \
         $(RM) $(lcsoname); \
       )

endif

ifeq ($(notdir $(CXX)),g++)

$(lib): $(ORB2_OBJS)
	(set -x; \
         $(RM) $@; \
         $(CXXLINK) -shared -mthreads \
              -o $(soname) $(IMPORT_LIBRARY_FLAGS) \
          $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) ; \
         ar cq $(lib) $(soname); \
         $(RM) $(soname); \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
         $(RM) $@; \
         $(CXXLINK) -shared -mthreads \
              -o $(lcsoname) $(IMPORT_LIBRARY_FLAGS) \
          $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib); \
         ar cq $(lclib) $(lcsoname); \
         $(RM) $(lcsoname); \
       )

endif

clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(libname); \
          ln -s $(lib) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lclibname); \
          ln -s $(lclib) $(lclibname); \
         )


gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -o$@ $<

endif


#############################################################################
#   Make rules for Win32 platforms                                          #
#############################################################################

ifdef Win32Platform

# ??!!!! hard-code the Tumbleweed HTTP library; this should be replaced with another strategy altogether
# Yes, later.  After we ship.  This #^#*^@ shared library stuff won't build right now.

ifndef BuildWin32DebugLibraries
# Prepare a debug directory for building the debug version of the library.
# Essentially, we create a debug directory in the current directory, create
# a dir.mk and optionally a GNUmakefile in that directory and then calling
# omake (GNU make) in that directory.
# The confusing bit is that this dir.mk is recursively used in the debug 
# directory to build this library. The BuildWin32DebugLibraries make variable,
# which is set to 1 in the dir.mk generated in the debug directory,
# is used to identify this case.
#
all:: mkdebugdir

mkdebugdir:
	@(if [ ! -f debug/dir.mk ]; then \
            file=dir.mk; dirs='. $(VPATH:/..=)'; $(FindFileInDirs); \
            case "$$fullfile" in /*) ;; *) fullfile=../$$fullfile;; esac; \
            dir=debug; $(CreateDir); \
            echo 'BuildWin32DebugLibraries = 1' > debug/dir.mk; \
            echo 'override VPATH := $$(VPATH:/debug=)' >> debug/dir.mk; \
            echo include $$fullfile >> debug/dir.mk; \
            if [ -f GNUmakefile ]; then \
               echo 'TOP=../../../../..' > debug/GNUmakefile; \
               echo 'CURRENT=src/lib/omniORB2/sharedlib/debug' >> debug/GNUmakefile; \
               echo 'include $$(TOP)/config/config.mk' >> debug/GNUmakefile; \
            fi \
          fi \
         )

export:: mkdebugdir

OMNITHREAD_LIB +=$(TOP)/../../build/lib/PostaOptHttpConnectionRt.lib

else

OMNITHREAD_LIB +=$(TOP)/../../build/lib/PostaOptHttpConnectionRtDebug.lib

endif

all:: $(lib)

all:: $(lclib)

all::
	@$(MakeSubdirs)

$(lib): $(ORB2_OBJS) omniORB2.def
	(libs="$(NT_EXTRA_LIBS) $(OMNITHREAD_LIB)"; \
         $(RM) $@; \
         $(CXXLINK) -out:$@ -DLL $(CXXLINKOPTIONS) -def:omniORB2.def -IMPLIB:$(implib) $(IMPORT_LIBRARY_FLAGS) $(ORB2_OBJS) $(UNSHARED_OBJS) $$libs; \
        )

$(lclib): $(LC_OBJS) omniLC.def
	(libs="$(NT_EXTRA_LIBS) $(OMNITHREAD_LIB) $(implib)"; \
         $(RM) $@; \
         $(CXXLINK) -out:$@ -DLL $(CXXLINKOPTIONS) -def:omniLC.def -IMPLIB:$(lcimplib) $(IMPORT_LIBRARY_FLAGS) $(LC_OBJS) $$libs; \
        )

# omniORB2.def
#  - This file contains all the functions and static class variables
#    exported by the DLL. The symbols are extracted from the output of
#    dumpbin.
#
#    The function symbols are extracted using the following template:
#    ... ........ SECT..  notype ()     External      | ?..................
#
#    The static class variable symbols are extracted using the following
#    template:
#    ... ........ SECT..  notype        External      | ?[^?]..............
#
#    Default destructors generated by the compiler are excluded.
#
#    It looks like class variable and function symbols start with two ??
#    and class static variable and static function symbols start with one ?.
#                                                             - SLL
#
omniORB2.def: $(staticlib)
	(set -x; \
         echo "LIBRARY $(libname)" > omniORB2.def; \
         echo "VERSION $(minor_version).$(micro_version)" >> omniORB2.def; \
         echo "EXPORTS" >> omniORB2.def; \
         DUMPBIN.EXE /SYMBOLS $(staticlib) | \
         egrep '^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +\(\) +External +\| +\?[^ ]*|^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +External +\| +\?[^?][^ ]*'|\
         egrep -v 'deleting destructor[^(]+\(unsigned int\)' | \
         cut -d'|' -f2 | \
         cut -d' ' -f2 | $(SORT) -u >> omniORB2.def; )

omniLC.def: $(lcstaticlib)
	(set -x; \
         echo "LIBRARY $(lclibname)" > omniLC.def; \
         echo "VERSION $(minor_version).$(micro_version)" >> omniLC.def; \
         echo "EXPORTS" >> omniLC.def; \
         DUMPBIN.EXE /SYMBOLS $(lcstaticlib) | \
         egrep '^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +\(\) +External +\| +\?[^ ]*|^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +External +\| +\?[^?][^ ]*'|\
         egrep -v 'deleting destructor[^(]+\(unsigned int\)' | \
         cut -d'|' -f2 | \
         cut -d' ' -f2 | $(SORT) -u >> omniLC.def; )


clean::
	$(RM) *.lib *.def *.dll *.exp

# NT treats DLLs more like executables -- the .dll file needs to go in the
# bin/x86... directory so that it's on your PATH:
export:: $(lib)
	@$(ExportExecutable)

export:: $(implib)
	@$(ExportLibrary)

export:: $(lclib)
	@$(ExportExecutable)

export:: $(lcimplib)
	@$(ExportLibrary)

export::
	@$(MakeSubdirs)

# Ideally, we would like to build the dummy gatekeeper stub just like other
# platforms, i.e. as a separate static library. However, it proves to be quite
# tricky because the omniORB2 DLL needs the symbols provided by gatekeeper.o
# to be resolved when the DLL is build. For the moment, just workaround the
# problem by building the stub directly into the library.
#

gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -Fo$@ $<

endif



#############################################################################
#   Make rules for HPUX                                                     #
#############################################################################

ifdef HPUX
ifeq ($(notdir $(CXX)),aCC)

DIR_CPPFLAGS += +z

libname = libomniORB$(major_version).sl
soname  = $(libname).$(minor_version)
lib     = $(soname).$(micro_version)

lclibname = libomniLC.sl
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

# For the moment, disable the use of gatekeeper in shared library.  Other
# platforms have a bootstrapping problem with building gatekeepers and this
# shared library. This library is built before gatekeepers so the linker
# may complain about undefined symbols when it tries to link the shared
# libaries below. Further testing is needed. 
#
NETLIBOBJS +=  gatekeeper.o

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(set -x; \
         $(RM) $@; \
         aCC -b -Wl,+h$(soname) -o $@  $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-L %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^)  -ldce -loodce -lcma ; \
       )

$(lclib): $(LC_OBJS)
	(set -x; \
         $(RM) $@; \
         aCC -b -Wl,+h$(lcsoname) -o $@  $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-L %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) $(lib) -ldce -loodce -lcma ; \
       )

clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -o$@ $<

endif
endif

#############################################################################
#   Make rules for to Reliant Unix                                          #
#############################################################################

ifdef SINIX
ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -Kpic

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

# For the moment, disable the use of gatekeeper in shared library.  Other
# platforms have a bootstrapping problem with building gatekeepers and this
# shared library. This library is built before gatekeepers so the linker
# may complain about undefined symbols when it tries to link the shared
# libaries below. Further testing is needed. 
#
NETLIBOBJS +=  gatekeeper.o

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -z text -Kthread -KPIC -o $@ -h $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $($(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^); \
       )

$(lclib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -z text -Kthread -KPIC -o $@ -h $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $($(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) $(lib); \
       )


all:: $(lib)

all:: $(lcib)

clean::
	$(RM) $(lib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

gatekeeper.o: gatekeepers/dummystub/gatekeeper.cc
	$(CXX) -c $(CXXFLAGS) -o$@ $<
endif
endif

#############################################################################
#   Make rules for SGI Irix 6.2                                             #
#############################################################################

ifdef IRIX
ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -KPIC

ifdef IRIX_n32
ADD_CPPFLAGS = -n32
endif
ifdef IRIX_64
ADD_CPPFLAGS = -64
endif

libname = libomniORB$(major_version).so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

lclibname = libomniLC.so
lcsoname  = $(lclibname).$(lc_minor_version)
lclib = $(lcsoname).$(lc_micro_version)

all:: $(lib)

all:: $(lclib)

$(lib): $(ORB2_OBJS)
	(set -x; \
        $(RM) $@; \
        $(LINK.cc) -KPIC -shared -Wl,-h,$(libname) -Wl,-set_version,$(soname) -Wl,-rpath,$(LIBDIR) \
         -o $@ $(IMPORT_LIBRARY_FLAGS) $^ $(LDLIBS); \
       )

$(lclib): $(LC_OBJS)
	($(RM) $@; \
        $(LINK.cc) -KPIC -shared -Wl,-h,$(lclibname) -Wl,-set_version,$(lcsoname) -Wl,-rpath,$(LIBDIR) \
         -o $@ $(IMPORT_LIBRARY_FLAGS) $^ $(LDLIBS); \
       )


clean::
	$(RM) $(lib) $(lclib)

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(lclib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(lcsoname); \
          ln -s $(lclib) $(lcsoname); \
          $(RM) $(lclibname); \
          ln -s $(lcsoname) $(lclibname); \
         )

endif
endif

